/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.data.ChartModel;
import hec.gfx2d.swing.charts.data.ChartModelFactory;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.pie.PieChartPanel;
import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.pie.PieSliceRenderControls;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class PieOverTimeTest
extends JFrame {
    private boolean flip = false;

    public PieOverTimeTest() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        int numData = 12;
        int numHours = 90;
        TimeSeriesContainer[] data = new TimeSeriesContainer[numData];
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        int[] times = new int[numHours];
        for (int time = 0; time < times.length; ++time) {
            times[time] = time * 60 * 60;
        }
        for (int i = 0; i < numData; ++i) {
            TimeSeriesContainer itemData = new TimeSeriesContainer();
            itemData.fullName = "testData_" + i;
            itemData.times = times;
            itemData.values = new double[numHours];
            itemData.units = "ac-ft";
            int constant = rand.nextInt(51) + 50;
            for (int time = 0; time < numHours; ++time) {
                itemData.values[time] = rand.nextGaussian() * (double)constant;
            }
            data[i] = itemData;
        }
        ChartModel chartModel = ChartModelFactory.createChartModel(data);
        PieSliceRenderControls sliceData = new PieSliceRenderControls();
        sliceData.setSingleColor(false);
        sliceData.setShowLabel(false);
        sliceData.setShowValue(false);
        PieChartRenderControls chartControls = new PieChartRenderControls(chartModel.getId(), sliceData);
        chartControls.setShowThresholdText(false);
        chartControls.setFooterVisible(false);
        chartControls.setRadialSumTextVisible(false);
        chartControls.setShowRadialSum(false);
        chartControls.setRadialSumTextVisible(false);
        TestFiltering panel = new TestFiltering(chartModel, chartControls);
        this.add((Component)panel, "Center");
        JPanel sliderDlg = this.buildSlider(times, panel);
        this.add((Component)sliderDlg, "South");
        this.setSize(1200, 800);
        this.setVisible(true);
    }

    private JPanel buildSlider(int[] times, PieChartPanel panel) {
        JPanel output = new JPanel(new BorderLayout());
        JSlider slider = new JSlider();
        slider.setMinimum(times[0]);
        slider.setMaximum(times[times.length - 1]);
        slider.setMinorTickSpacing(3600);
        slider.setMajorTickSpacing(10800);
        slider.addChangeListener(change -> {
            int value = slider.getValue();
            HecTime time = new HecTime(value, 11);
            Date date = time.getJavaDate(0);
            panel.setTime(date);
            panel.repaint();
        });
        Timer tmr = new Timer(16, evt -> {
            int value = slider.getValue();
            int spacing = slider.getMinorTickSpacing();
            int max = slider.getMaximum();
            int min = slider.getMinimum();
            if (value + spacing >= max) {
                this.flip = true;
            } else if (value - spacing <= min) {
                this.flip = false;
            }
        });
        tmr.setRepeats(true);
        tmr.start();
        output.add(slider);
        return output;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PieOverTimeTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PieOverTimeTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PieOverTimeTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PieOverTimeTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PieOverTimeTest().setVisible(true);
            }
        });
    }

    private class TestFiltering
    extends PieChartPanel {
        public TestFiltering(ChartModel model, PieChartRenderControls controls) {
            super(model, controls);
        }

        @Override
        public boolean isSliceVisible(RmaDataId sliceId) {
            return sliceId.getName().endsWith("1") || sliceId.getName().endsWith("5") || sliceId.getName().endsWith("2");
        }
    }
}

