/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.color.ColorContourType;
import hec.gfx2d.swing.charts.data.ChartItemRenderControls;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import rma.util.BandedColorContour;
import rma.util.Clipping;
import rma.util.contour.ColorContourRecord;
import rma.util.contour.PieChartColorContourRecord;
import rma.xml.adapters.XmlColorContourRecordAdapter;

@XmlRootElement(name="PieSliceRenderControls")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PieSliceRenderControls
extends ChartItemRenderControls
implements Serializable {
    public static final String PROPERTY_SINGLE_COLOR = "rmaChartItemRenderControls.singleColor";
    public static final String PROPERTY_CONTOUR = "rmaChartItemRenderControls.contour";
    public static final String PROPERTY_CONTOUR_TYPE = "rmaChartItemRenderControls.contourType";
    @XmlElement(name="singleColor")
    private boolean _singleColor = true;
    @XmlElement(name="contour")
    @XmlJavaTypeAdapter(value=XmlColorContourRecordAdapter.class)
    private ColorContourRecord _contour;
    @XmlElement(name="contourType")
    private ColorContourType _contourType;

    public PieSliceRenderControls() {
        BandedColorContour defaultContour = BandedColorContour.buildSwtBandedColor();
        Clipping maxClipping = new Clipping();
        Clipping minClipping = new Clipping();
        maxClipping.setValue(100.0);
        minClipping.setValue(0.0);
        defaultContour.setMaxClipping(maxClipping);
        defaultContour.setMinClipping(minClipping);
        this._contour = new PieChartColorContourRecord(defaultContour, 1.0f, 10.0);
        this._contourType = ColorContourType.BANDED;
    }

    @Override
    public void copy(ChartItemRenderControls copy) {
        super.copy(copy);
        if (copy instanceof PieSliceRenderControls) {
            PieSliceRenderControls pieCopy = (PieSliceRenderControls)copy;
            this._singleColor = pieCopy.isSingleColor();
            this.setContour(pieCopy.getContour());
            this.setContourType(pieCopy.getContourType());
        }
    }

    public boolean isSingleColor() {
        return this._singleColor;
    }

    public void setSingleColor(boolean singleColor) {
        this._singleColor = singleColor;
    }

    public ColorContourRecord getContour() {
        return this._contour;
    }

    public void setContour(ColorContourRecord contour) {
        this._contour = contour;
    }

    public ColorContourType getContourType() {
        return this._contourType;
    }

    public void setContourType(ColorContourType contourType) {
        this._contourType = contourType;
    }
}

