/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.color.ColorContourType;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.pie.PieChartPanel;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import rma.util.BandedColorContour;
import rma.util.ColorContour;
import rma.util.FillPatternFactory;
import rma.util.contour.ColorContourRecord;

public class PieSliceView {
    private final RmaDataId _id;
    private Arc2D _displaySlice;
    private boolean _selected = false;
    private static final int RADIUS_LABEL_OFFSET = 10;
    private static final int LABEL_BOX_INSET = 4;

    public PieSliceView(RmaDataId id) {
        this._id = id;
        this._displaySlice = null;
    }

    public RmaDataId getId() {
        return this._id;
    }

    public boolean contains(Point2D point) {
        return this._displaySlice != null && this._displaySlice.contains(point);
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public boolean isSelected() {
        return this._selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSliceMask(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        Graphics2D graphics = (Graphics2D)g2d.create();
        try {
            if (controller.isSliceVisible(this.getId())) {
                double maxValue;
                double value = controller.getSliceValue(this.getId()) - controller.getSliceMinValue(this.getId());
                double fillRadius = Math.round(maxRadius * (value / (maxValue = controller.getSliceMaxValue(this.getId()) - controller.getSliceMinValue(this.getId()))));
                double d = fillRadius = fillRadius > maxRadius ? maxRadius : fillRadius;
                if (fillRadius > 0.0) {
                    double x = center.getX() - fillRadius;
                    double y = center.getY() - fillRadius;
                    this._displaySlice = new Arc2D.Double(x, y, fillRadius * 2.0, fillRadius * 2.0, startAngle, arcAngle, 2);
                }
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public void drawSlice(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        this.drawSliceMask(g2d, center, maxRadius, startAngle, arcAngle, controller);
        this.drawSliceColor(g2d, center, maxRadius, startAngle, arcAngle, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSliceLabel(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        Graphics2D graphics = (Graphics2D)g2d.create();
        try {
            graphics.setComposite(AlphaComposite.Src);
            if (controller.isSliceShowLabel(this.getId())) {
                Font chartFont = controller.getSliceLabelFont(this.getId());
                graphics.setFont(chartFont);
                FontMetrics fm = graphics.getFontMetrics();
                String labelStr = controller.getSliceLabelFormat(this.getId());
                Rectangle2D rc2d = fm.getStringBounds(labelStr, graphics);
                double halfAngle = startAngle + arcAngle / 2.0;
                halfAngle %= 360.0;
                if (halfAngle < 0.0) {
                    halfAngle += 360.0;
                }
                double x = center.getX() + (double)((float)((maxRadius + 10.0) * Math.cos(Math.toRadians(halfAngle))));
                double y = center.getY() - (double)((float)((maxRadius + 10.0) * Math.sin(Math.toRadians(halfAngle))));
                x = this.adjustXForHalfAngle(x, halfAngle, rc2d);
                y = this.adjustYForHalfAngle(y, halfAngle, rc2d);
                graphics.setColor(controller.getSliceLabelColor(this.getId()));
                graphics.drawString(labelStr, (float)Math.round(x), (float)Math.round(y));
            }
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSliceColor(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        Graphics2D graphics = (Graphics2D)g2d.create();
        try {
            if (controller.isSliceVisible(this.getId())) {
                double maxValue;
                double value = controller.getSliceValue(this.getId()) - controller.getSliceMinValue(this.getId());
                double fillRadius = maxRadius * (value / (maxValue = controller.getSliceMaxValue(this.getId()) - controller.getSliceMinValue(this.getId())));
                if (fillRadius > 0.0 && this._displaySlice != null) {
                    this.establishContour(graphics, center, fillRadius, maxRadius, controller);
                    graphics.setComposite(AlphaComposite.Src);
                    graphics.fill(this._displaySlice);
                }
            } else {
                this._displaySlice = null;
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public void drawRadialMarksAndLabels(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        if (controller.isSliceShowThresholds(this.getId())) {
            double markRadius;
            double relMax;
            double mark;
            double centerX = center.getX();
            double centerY = center.getY();
            for (Threshold radialMark : controller.getSliceThresholds(this.getId())) {
                if (!radialMark.isVisible()) continue;
                mark = radialMark.getValue();
                if (radialMark.getType() == Threshold.ThresholdType.UNIT) {
                    relMax = controller.getSliceMaxValue(this.getId()) - controller.getSliceMinValue(this.getId());
                    mark /= relMax;
                }
                markRadius = maxRadius * mark;
                Arc2D.Double markArc = new Arc2D.Double(centerX - markRadius, centerY - markRadius, markRadius * 2.0, markRadius * 2.0, startAngle, arcAngle, 2);
                this.drawThreshold(g2d, radialMark, center, maxRadius, startAngle, arcAngle, markArc);
            }
            for (Threshold radialMark : controller.getSliceThresholds(this.getId())) {
                if (!radialMark.isVisible()) continue;
                mark = radialMark.getValue();
                if (radialMark.getType() == Threshold.ThresholdType.UNIT) {
                    relMax = controller.getSliceMaxValue(this.getId()) - controller.getSliceMinValue(this.getId());
                    mark /= relMax;
                }
                markRadius = maxRadius * mark;
                String markString = radialMark.getLabelFormat(controller.getSliceMaxValue(this.getId()), controller);
                double halfAngle = startAngle + arcAngle / 2.0;
                if ((halfAngle %= 360.0) < 0.0) {
                    halfAngle += 360.0;
                }
                double labelX = center.getX() + markRadius * Math.cos(Math.toRadians(halfAngle));
                double labelY = center.getY() - markRadius * Math.sin(Math.toRadians(halfAngle));
                g2d.setFont(radialMark.getLabelFont());
                Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(markString, g2d);
                labelX = this.adjustXForHalfAngle(labelX, halfAngle, rc2d);
                labelY = this.adjustYForHalfAngle(labelY, halfAngle, rc2d);
                RoundRectangle2D.Double labelBox = new RoundRectangle2D.Double(labelX - 4.0, labelY - 4.0, rc2d.getWidth() + 8.0, rc2d.getHeight() + 8.0, 4.0, 4.0);
                g2d.setColor(Color.WHITE);
                g2d.fill(labelBox);
                g2d.setColor(radialMark.getLabelColor());
                g2d.drawString(markString, (float)Math.round(labelX), (float)Math.round(labelY));
            }
        }
    }

    public void drawValueMarksAndLabels(Graphics2D g2d, Point2D center, double maxRadius, double startAngle, double arcAngle, PieChartPanel controller) {
        if (controller.isSliceVisible(this.getId()) && controller.isSliceShowValue(this.getId()) && this._displaySlice != null) {
            float[] dash1 = new float[]{10.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f));
            g2d.setColor(Color.DARK_GRAY.brighter());
            g2d.draw(this._displaySlice);
            double value = controller.getSliceValue(this.getId()) - controller.getSliceMinValue(this.getId());
            double maxValue = controller.getSliceMaxValue(this.getId()) - controller.getSliceMinValue(this.getId());
            double valueRadius = maxRadius * (value / maxValue);
            valueRadius = valueRadius > maxRadius ? maxRadius : valueRadius;
            double markValue = controller.getSliceValue(this.getId());
            String valueString = controller.round(markValue) + " / " + controller.round(controller.getSliceMaxValue(this.getId())) + " " + controller.getSliceUnits(this.getId());
            double halfAngle = startAngle + arcAngle / 2.0;
            halfAngle %= 360.0;
            if (halfAngle < 0.0) {
                halfAngle += 360.0;
            }
            double labelX = center.getX() + valueRadius * Math.cos(Math.toRadians(halfAngle));
            double labelY = center.getY() - valueRadius * Math.sin(Math.toRadians(halfAngle));
            g2d.setFont(controller.getSliceLabelFont(this.getId()));
            Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(valueString, g2d);
            labelX = this.adjustXForHalfAngle(labelX, halfAngle, rc2d);
            labelY = this.adjustYForHalfAngle(labelY, halfAngle, rc2d);
            RoundRectangle2D.Double labelBox = new RoundRectangle2D.Double(labelX - 4.0, labelY - 4.0, rc2d.getWidth() + 8.0, rc2d.getHeight() + 8.0, 4.0, 4.0);
            g2d.setColor(Color.WHITE);
            g2d.fill(labelBox);
            g2d.setColor(Color.BLACK);
            g2d.drawString(valueString, (float)Math.round(labelX), (float)Math.round(labelY + rc2d.getHeight() - 4.0));
        }
    }

    public void drawThreshold(Graphics2D g2d, Threshold threshold, Point2D center, double maxRadius, double startAngle, double arcAngle, Arc2D markArc) {
        ThresholdLineStyle lineProperties = threshold.getLineProperties();
        Color lineColor = lineProperties.getLineColor();
        Color lineFColor = lineProperties.getFillColor();
        float[] linePattern = lineProperties.getLineStyle();
        if (linePattern.length == 1 && linePattern[0] == 50.0f) {
            linePattern = null;
        }
        float lineThickness = lineProperties.getLineWeight();
        Color oldColor = g2d.getColor();
        if (lineProperties.isDrawLine()) {
            int fillType = lineProperties.getFillPattern();
            if (fillType == 0) {
                g2d.setColor(new Color((float)lineFColor.getRed() / 255.0f, (float)lineFColor.getGreen() / 255.0f, (float)lineFColor.getBlue() / 255.0f, 0.75f));
                if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                    g2d.fill(markArc);
                } else if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                    Arc2D.Double maxArc = new Arc2D.Double(center.getX() - maxRadius, center.getY() - maxRadius, maxRadius * 2.0, maxRadius * 2.0, startAngle, arcAngle, 2);
                    Area markRing = new Area(maxArc);
                    markRing.subtract(new Area(markArc));
                    g2d.fill(markRing);
                }
            } else {
                Composite oldAc = g2d.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                Paint op = g2d.getPaint();
                Paint tp = FillPatternFactory.createFillPattern(fillType, lineFColor);
                g2d.setPaint(tp);
                g2d.setComposite(ac);
                if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                    g2d.fill(markArc);
                } else if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                    Arc2D.Double maxArc = new Arc2D.Double(center.getX() - maxRadius, center.getY() - maxRadius, maxRadius * 2.0, maxRadius * 2.0, startAngle, arcAngle, 2);
                    Area markRing = new Area(maxArc);
                    markRing.subtract(new Area(markArc));
                    g2d.fill(markRing);
                }
                g2d.setComposite(oldAc);
                g2d.setPaint(op);
            }
            g2d.setColor(lineColor);
            Stroke oldStroke = g2d.getStroke();
            BasicStroke bs = new BasicStroke(lineThickness, 0, 0, 10.0f, linePattern, 0.0f);
            g2d.setStroke(bs);
            g2d.draw(markArc);
            g2d.setStroke(oldStroke);
        }
        g2d.setColor(oldColor);
    }

    public void drawSelected(Graphics2D g2d, PieChartPanel controller) {
        if (this._selected && controller.isSliceVisible(this.getId()) && this._displaySlice != null) {
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.setColor(Color.BLACK);
            g2d.draw(this._displaySlice);
            g2d.setStroke(oldStroke);
            this.drawSelectionBox(g2d, controller);
        }
    }

    private void drawSelectionBox(Graphics2D g2d, PieChartPanel controller) {
        double boxX = this._displaySlice.getCenterX();
        double boxY = this._displaySlice.getCenterY();
        double boxMin = controller.getSliceMinValue(this.getId());
        double boxVal = controller.getSliceValue(this.getId());
        double boxMax = controller.getSliceMaxValue(this.getId());
        double boxRelMax = boxMax - boxMin;
        double boxRelVal = boxVal - boxMin;
        String boxLabel = this.getId().getName();
        String boxInfo1 = controller.round(boxMin) + " / " + controller.round(boxVal) + " / " + controller.round(boxMax) + " " + controller.getUnits();
        String boxInfo2 = controller.round(boxRelVal / boxRelMax * 100.0) + "%";
        String boxInfo3 = "Quality: " + controller.getSliceQuality(this.getId());
        g2d.setFont(controller.getSliceLabelFont(this.getId()));
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D label2d = fm.getStringBounds(boxLabel, g2d);
        Rectangle2D info12d = fm.getStringBounds(boxInfo1, g2d);
        Rectangle2D info22d = fm.getStringBounds(boxInfo2, g2d);
        Rectangle2D info32d = fm.getStringBounds(boxInfo3, g2d);
        double maxWidth = Math.max(label2d.getWidth(), info12d.getWidth());
        maxWidth = Math.max(maxWidth, info22d.getWidth());
        maxWidth = Math.max(maxWidth, info32d.getWidth());
        double totalHeight = label2d.getHeight() + info12d.getHeight() + info22d.getHeight() + info32d.getHeight() + 20.0;
        RoundRectangle2D.Double labelBox = new RoundRectangle2D.Double(boxX -= (maxWidth += 8.0) / 2.0, boxY -= totalHeight / 2.0, maxWidth, totalHeight, 4.0, 4.0);
        g2d.setColor(Color.WHITE);
        g2d.fill(labelBox);
        g2d.setColor(Color.BLACK);
        double centerX = labelBox.getCenterX();
        double labelX = centerX - label2d.getWidth() / 2.0;
        double labelY = boxY + label2d.getHeight();
        g2d.drawString(boxLabel, (float)Math.round(labelX), (float)Math.round(labelY));
        labelX = centerX - info12d.getWidth() / 2.0;
        g2d.drawString(boxInfo1, (float)Math.round(labelX), (float)Math.round(labelY += 4.0 + info12d.getHeight()));
        labelX = centerX - info22d.getWidth() / 2.0;
        g2d.drawString(boxInfo2, (float)Math.round(labelX), (float)Math.round(labelY += 4.0 + info22d.getHeight()));
        labelX = centerX - info32d.getWidth() / 2.0;
        g2d.drawString(boxInfo3, (float)Math.round(labelX), (float)Math.round(labelY += 4.0 + info32d.getHeight()));
    }

    private double adjustXForHalfAngle(double labelX, double halfAngle, Rectangle2D stringBounds) {
        if (halfAngle > 90.0 && halfAngle < 270.0) {
            labelX -= stringBounds.getWidth();
        } else if (halfAngle == 90.0 || halfAngle == 270.0) {
            labelX -= stringBounds.getWidth() / 2.0;
        }
        return labelX;
    }

    private double adjustYForHalfAngle(double labelY, double halfAngle, Rectangle2D stringBounds) {
        if (halfAngle > 180.0) {
            labelY += stringBounds.getHeight();
        } else if (halfAngle == 180.0) {
            labelY += stringBounds.getHeight() / 2.0;
        }
        return labelY;
    }

    protected double computePercentFull(double valueRadius, double maxRadius, PieChartPanel controller) {
        int minValue;
        int maxValue;
        ColorContourRecord record = controller.getSliceContour(this.getId());
        ColorContour contour = record.getColorContour();
        boolean singleColor = controller.isSliceSingleColor(this.getId());
        double percentFull = valueRadius / maxRadius * 100.0;
        if (controller.getSliceContourType(this.getId()) == ColorContourType.BANDED) {
            BandedColorContour bandedContour = (BandedColorContour)contour;
            maxValue = singleColor ? controller.getBandedContourMax(bandedContour) : 100;
            minValue = singleColor ? controller.getBandedContourMin(bandedContour) : 0;
        } else {
            maxValue = (int)contour.getMaxValue();
            minValue = (int)contour.getMinValue();
        }
        if (percentFull > (double)maxValue) {
            percentFull = maxValue;
        } else if (percentFull < (double)minValue) {
            percentFull = minValue;
        }
        return percentFull;
    }

    protected void establishContour(Graphics2D g2d, Point2D center, double fillRadius, double maxRadius, PieChartPanel controller) {
        ColorContourRecord contourRecord = controller.getSliceContour(this.getId());
        ColorContour contour = contourRecord.getColorContour();
        boolean singleColor = controller.isSliceSingleColor(this.getId());
        double percentFull = this.computePercentFull(fillRadius, maxRadius, controller);
        if (singleColor) {
            g2d.setColor(this.buildSingleColorFromContour(percentFull, contour, contourRecord));
        } else {
            g2d.setPaint(this.buildGradientFromContour(center, 100, maxRadius, contour, contourRecord));
        }
    }

    protected Color buildAlphaColor(Color color, ColorContourRecord record) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        return new Color(red, green, blue, record.getAlpha());
    }

    protected Color buildSingleColorFromContour(double percentFull, ColorContour contour, ColorContourRecord contourRecord) {
        Color radialColor = contour.getColor(percentFull);
        return this.buildAlphaColor(radialColor, contourRecord);
    }

    protected RadialGradientPaint buildGradientFromContour(Point2D center, int percentFull, double maxRadius, ColorContour contour, ColorContourRecord record) {
        int steps = percentFull;
        if (steps < 2) {
            steps = 2;
        } else if (steps > 100) {
            steps = 100;
        }
        double resolutionIncreaseForPrecision = 2.0;
        steps = (int)((double)steps * resolutionIncreaseForPrecision);
        Color[] contourColorsForDistances = new Color[steps];
        float[] distancesForContourColors = new float[steps];
        double currentDistance = 1.0;
        double distanceStep = 1.0 / (double)steps;
        for (int percentIdx = steps - 1; percentIdx >= 0; --percentIdx) {
            double percentIndexCorrected = percentIdx + 1;
            Color contourColor = contour.getColor(percentIndexCorrected / resolutionIncreaseForPrecision);
            contourColorsForDistances[percentIdx] = this.buildAlphaColor(contourColor, record);
            distancesForContourColors[percentIdx] = (float)currentDistance;
            currentDistance -= distanceStep;
        }
        return new RadialGradientPaint(center, (float)maxRadius, distancesForContourColors, contourColorsForDistances);
    }
}

