/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.swing.charts.options.TextOptionsPanel;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.thresholds.ThresholdLineStylePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;

class EditThresholdPanel
extends JPanel {
    private TextOptionsPanel _namePanel;
    private RmaJComboBox<Threshold.ThresholdType> _typeBox;
    private RmaJDecimalField _valueField;
    private ThresholdLineStylePanel _lineStylePanel;

    EditThresholdPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(Threshold threshold) {
        this._namePanel.setObjectText(threshold.getLabelFormat());
        this._namePanel.setObjectFont(threshold.getLabelFont());
        this._namePanel.setObjectColor(threshold.getLabelColor());
        this._typeBox.setSelectedItem((Object)threshold.getType());
        this._valueField.setValue(threshold.getValue());
        this._lineStylePanel.setData(threshold.getLineProperties());
    }

    public Threshold save() {
        Threshold threshold = new Threshold();
        threshold.setLabelFormat(this._namePanel.getObjectText());
        threshold.setLabelFont(this._namePanel.getObjectFont());
        threshold.setLabelColor(this._namePanel.getObjectColor());
        threshold.setType((Threshold.ThresholdType)((Object)this._typeBox.getItemAt(this._typeBox.getSelectedIndex())));
        threshold.setValue(this._valueField.getValue());
        threshold.setLineProperties(this._lineStylePanel.getData());
        return threshold;
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        JPanel leftPane = new JPanel();
        leftPane.setLayout(new GridBagLayout());
        this._namePanel = new TextOptionsPanel();
        this._namePanel.setObjectTitle("Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)this._namePanel, gbc);
        JPanel typeValuePanel = new JPanel();
        typeValuePanel.setLayout(new GridBagLayout());
        typeValuePanel.setBorder(BorderFactory.createTitledBorder("Type and Value"));
        this._typeBox = new RmaJComboBox();
        this._typeBox.setModel(new DefaultComboBoxModel<Threshold.ThresholdType>(Threshold.ThresholdType.values()));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        typeValuePanel.add(this._typeBox, gbc);
        this._valueField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        typeValuePanel.add((Component)this._valueField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)typeValuePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridheight = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)leftPane, gbc);
        this._lineStylePanel = new ThresholdLineStylePanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._lineStylePanel, gbc);
    }

    private void addListeners() {
    }
}

