/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.util.PropertyFireable;
import hec.gfx2d.swing.charts.util.Roundable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;
import rma.xml.adapters.XmlColorAdapter;
import rma.xml.adapters.XmlFontAdapter;

@XmlRootElement(name="Threshold")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Threshold
implements Serializable,
PropertyFireable {
    private transient SwingPropertyChangeSupport propChangeFirer = new SwingPropertyChangeSupport(this);
    public static final String PROPERTY_LABEL_FONT = "rmaThresholdProperties.labelFont";
    public static final String PROPERTY_LABEL_FORMAT = "rmaThresholdProperties.labelFormat";
    public static final String PROPERTY_LABEL_COLOR = "rmaThresholdProperties.labelColor";
    public static final String PROPERTY_LINE_STYLE = "rmaThresholdProperties.lineStyle";
    public static final String PROPERTY_VALUE = "rmaThresholdProperties.value";
    public static final String PROPERTY_VISIBLE = "rmaThresholdProperties.visible";
    public static final String PROPERTY_TYPE = "rmaThresholdProperties.type";
    public static final String PROPERTY_UPDATE = "rmaThresholdProperties.update";
    @XmlElement(name="labelFont")
    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    private Font _labelFont = new Font("SansSerif", 0, 14);
    @XmlElement(name="labelFormat")
    private String _labelFormat = "<%Portion%>";
    @XmlElement(name="labelColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _labelColor = Color.BLACK;
    @XmlElement(name="lineProperties")
    ThresholdLineStyle _lineProperties = new ThresholdLineStyle();
    @XmlElement(name="value")
    private double _value;
    @XmlElement(name="visible")
    private boolean _visible;
    @XmlElement(name="type")
    private ThresholdType _type;
    private static final String PORTION_FORMAT = "<%Portion%>";
    private static final String VALUE_FORMAT = "<%Value%>";

    public Threshold() {
        this._lineProperties.setLineStyle(G2dLineProperties.DASH_STYLE_PATTERN);
        this._visible = true;
        this._value = 0.0;
        this._type = ThresholdType.PORTION;
    }

    public Threshold(double value, ThresholdType type) {
        this();
        this._value = value;
        this._type = type;
        this._labelFormat = type == ThresholdType.PORTION ? PORTION_FORMAT : VALUE_FORMAT;
        this._visible = true;
    }

    public Threshold(Threshold copy) {
        this(copy._value, copy._type);
        this._labelFormat = copy._labelFormat;
        this._visible = copy._visible;
        this._labelFont = new Font(copy._labelFont.getFontName(), copy._labelFont.getStyle(), copy._labelFont.getSize());
        this._labelColor = new Color(copy._labelColor.getRGB());
        this._lineProperties = new ThresholdLineStyle(copy._lineProperties);
    }

    @Override
    public void fireUpdate(String propertyName, Object oldVal, Object newVal) {
        this.propChangeFirer.firePropertyChange(propertyName, oldVal, newVal);
    }

    @Override
    public void fireUpdate() {
        this.fireUpdate(PROPERTY_UPDATE, false, true);
    }

    public Font getLabelFont() {
        return this._labelFont;
    }

    public void setLabelFont(Font labelFont) {
        Font oldVal = this._labelFont;
        this._labelFont = labelFont;
        this.fireUpdate(PROPERTY_LABEL_FONT, oldVal, labelFont);
    }

    public String getLabelFormat() {
        return this._labelFormat;
    }

    public String getLabelFormat(double maxValue, Roundable context) {
        return this.replaceAttributeFormat(this._labelFormat, maxValue, context);
    }

    public void setLabelFormat(String labelFormat) {
        String oldVal = this._labelFormat;
        this._labelFormat = labelFormat;
        this.fireUpdate(PROPERTY_LABEL_FORMAT, oldVal, labelFormat);
    }

    public Color getLabelColor() {
        return this._labelColor;
    }

    public void setLabelColor(Color labelColor) {
        Color oldVal = this._labelColor;
        this._labelColor = labelColor;
        this.fireUpdate(PROPERTY_LABEL_COLOR, oldVal, labelColor);
    }

    public ThresholdLineStyle getLineProperties() {
        return this._lineProperties;
    }

    public void setLineProperties(ThresholdLineStyle lineProperties) {
        ThresholdLineStyle oldVal = this._lineProperties;
        this._lineProperties = lineProperties;
        this.fireUpdate(PROPERTY_LINE_STYLE, oldVal, lineProperties);
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVal = this._visible;
        this._visible = visible;
        this.fireUpdate(PROPERTY_VISIBLE, oldVal, visible);
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double value) {
        double oldVal = this._value;
        this._value = value;
        this.fireUpdate(PROPERTY_VALUE, oldVal, value);
    }

    public ThresholdType getType() {
        return this._type;
    }

    public void setType(ThresholdType type) {
        ThresholdType oldVal = this._type;
        this._type = type;
        this.fireUpdate(PROPERTY_TYPE, (Object)oldVal, (Object)type);
    }

    public String toString() {
        return this._labelFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Threshold threshold = (Threshold)o;
        return Double.compare(threshold.getValue(), this.getValue()) == 0 && this.getLabelFormat().equals(threshold.getLabelFormat()) && this.getType() == threshold.getType();
    }

    public int hashCode() {
        int result = this.getLabelFormat().hashCode();
        long temp = Double.doubleToLongBits(this.getValue());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    private String replaceAttributeFormat(String format, double maxValue, Roundable context) {
        String retStr = format;
        int replaceIndex = retStr.indexOf("<%");
        int endReplaceIndex = retStr.indexOf("%>", replaceIndex);
        while (replaceIndex != -1 && endReplaceIndex != -1) {
            String formatReplace;
            switch (formatReplace = retStr.substring(replaceIndex, endReplaceIndex + 2)) {
                case "<%Portion%>": {
                    retStr = this.doPortionFormat(retStr, maxValue, context);
                }
                case "<%Value%>": {
                    retStr = this.doValueFormat(retStr, maxValue, context);
                    break;
                }
            }
            replaceIndex = retStr.indexOf("<%", endReplaceIndex);
            endReplaceIndex = retStr.indexOf("%>", replaceIndex);
        }
        return retStr;
    }

    private String doPortionFormat(String format, double maxValue, Roundable context) {
        if (this._type == ThresholdType.PORTION) {
            return format.replaceAll(PORTION_FORMAT, String.valueOf(context.round(this._value * 100.0)) + "%");
        }
        double portion = this._value / maxValue;
        return format.replaceAll(VALUE_FORMAT, String.valueOf(context.round(portion * 100.0)) + "%");
    }

    private String doValueFormat(String format, double maxValue, Roundable context) {
        if (this._type == ThresholdType.UNIT) {
            return format.replaceAll(VALUE_FORMAT, String.valueOf(context.round(this._value)));
        }
        double value = this._value * maxValue;
        return format.replaceAll(VALUE_FORMAT, String.valueOf(context.round(value)));
    }

    public static enum ThresholdType {
        PORTION("Portion"),
        UNIT("Unit");

        private String _displayName;

        private ThresholdType(String displayName) {
            this._displayName = displayName;
        }

        public String toString() {
            return this._displayName;
        }
    }
}

