/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.G2dFillPatternRenderer;
import hec.gfx2d.G2dLinePatternRenderer;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinePropertiesPanel;
import hec.gfx2d.G2dLineWidthRenderer;
import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.thresholds.ThresholdLineStyleSamplePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;

class ThresholdLineStylePanel
extends JPanel {
    private ThresholdLineStyle _data;
    private final ComboBoxModel<float[]> _lineStyleComboModel = new DefaultComboBoxModel<float[]>((E[])new float[][]{G2dLinePropertiesPanel.SOLID_LINE, G2dLineProperties.DASH_STYLE_PATTERN, G2dLineProperties.DOT_STYLE_PATTERN, G2dLineProperties.DASHDOT_STYLE_PATTERN, G2dLineProperties.DASHDOTDOT_STYLE_PATTERN});
    private final ComboBoxModel<Float> _lineWeightComboModel = new DefaultComboBoxModel<Float>(new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f)});
    private final ComboBoxModel<Integer> _fillPatternComboModel = new DefaultComboBoxModel<Integer>(new Integer[]{0, 1, 2, 4, 3, 5, 6});
    private RmaJCheckBox _lineCheckBox;
    private RmaJLabel _colorLabel;
    private RmaJColorComboBox _lineColorComboBox;
    private RmaJLabel _styleLabel;
    private RmaJComboBox<float[]> _lineStyleComboBox;
    private RmaJLabel _weightLabel;
    private RmaJComboBox<Float> _lineWeightComboBox;
    private RmaJLabel _fillLabel;
    private RmaJRadioButton _fillNoneRButton;
    private RmaJRadioButton _fillBelowRButton;
    private RmaJRadioButton _fillAboveRButton;
    private RmaJLabel _fillColorLabel;
    private RmaJColorComboBox _fillColorComboBox;
    private RmaJLabel _patternLabel;
    private RmaJComboBox<Integer> _fillPatternComboBox;
    private ThresholdLineStyleSamplePanel _samplePanel;

    ThresholdLineStylePanel() {
        this.buildComponents();
        this.addListeners();
        this.setData(new ThresholdLineStyle());
    }

    void setData(ThresholdLineStyle data) {
        this._data = data;
        if (this._data != null) {
            this._lineCheckBox.setSelected(this._data.isDrawLine());
            this._colorLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineColorComboBox.setSelectedColor(this._data.getLineColor());
            this._lineColorComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._styleLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineStyleComboBox.setSelectedItem(this._data.getLineStyle());
            this._lineStyleComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._weightLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineWeightComboBox.setSelectedItem(Float.valueOf(this._data.getLineWeight()));
            this._lineWeightComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._fillLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillNoneRButton.setSelected(this._data.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.NONE);
            this._fillNoneRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillBelowRButton.setSelected(this._data.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW);
            this._fillBelowRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillAboveRButton.setSelected(this._data.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE);
            this._fillAboveRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillColorLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillColorComboBox.setSelectedColor(this._data.getFillColor());
            this._fillColorComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._patternLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillPatternComboBox.setSelectedItem(this._data.getFillPattern());
            this._fillPatternComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._samplePanel.setEnabled(this._lineCheckBox.isSelected());
            this._samplePanel.setData(this._data);
        }
    }

    ThresholdLineStyle getData() {
        return this._data;
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 320));
        this.setMinimumSize(this.getPreferredSize());
        this.setBorder(BorderFactory.createTitledBorder("Line"));
        this._lineCheckBox = new RmaJCheckBox();
        this._lineCheckBox.setText("Draw Line");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._lineCheckBox, gbc);
        this._colorLabel = new RmaJLabel();
        this._colorLabel.setText("Color:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._colorLabel, gbc);
        this._lineColorComboBox = new RmaJColorComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._lineColorComboBox, gbc);
        this._styleLabel = new RmaJLabel();
        this._styleLabel.setText("Style:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._styleLabel, gbc);
        this._lineStyleComboBox = new RmaJComboBox();
        this._lineStyleComboBox.setModel(this._lineStyleComboModel);
        this._lineStyleComboBox.setRenderer(new G2dLinePatternRenderer(Color.BLUE));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._lineStyleComboBox, gbc);
        this._weightLabel = new RmaJLabel();
        this._weightLabel.setText("Weight:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._weightLabel, gbc);
        this._lineWeightComboBox = new RmaJComboBox();
        this._lineWeightComboBox.setModel(this._lineWeightComboModel);
        this._lineWeightComboBox.setRenderer(new G2dLineWidthRenderer(Color.BLUE));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._lineWeightComboBox, gbc);
        this._fillLabel = new RmaJLabel();
        this._fillLabel.setText("Fill:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillLabel, gbc);
        this._fillNoneRButton = new RmaJRadioButton();
        this._fillNoneRButton.setText("None");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillNoneRButton, gbc);
        this._fillBelowRButton = new RmaJRadioButton();
        this._fillBelowRButton.setText("Below");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillBelowRButton, gbc);
        this._fillAboveRButton = new RmaJRadioButton();
        this._fillAboveRButton.setText("Above");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillAboveRButton, gbc);
        this._fillColorLabel = new RmaJLabel();
        this._fillColorLabel.setText("Fill Color:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillColorLabel, gbc);
        this._fillColorComboBox = new RmaJColorComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._fillColorComboBox, gbc);
        this._patternLabel = new RmaJLabel();
        this._patternLabel.setText("Fill Pattern:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._patternLabel, gbc);
        this._fillPatternComboBox = new RmaJComboBox();
        this._fillPatternComboBox.setModel(this._fillPatternComboModel);
        this._fillPatternComboBox.setRenderer(new G2dFillPatternRenderer());
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._fillPatternComboBox, gbc);
        this._samplePanel = new ThresholdLineStyleSamplePanel(this._data);
        this._samplePanel.setBorder(BorderFactory.createTitledBorder("Sample"));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.fill = 1;
        gbc.ipadx = 10;
        gbc.ipady = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._samplePanel, gbc);
    }

    private void addListeners() {
        this._lineCheckBox.addActionListener(e -> {
            this._data.setDrawLine(this._lineCheckBox.isSelected());
            this._colorLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineColorComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._styleLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineStyleComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._weightLabel.setEnabled(this._lineCheckBox.isSelected());
            this._lineWeightComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._fillLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillNoneRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillBelowRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillAboveRButton.setEnabled(this._lineCheckBox.isSelected());
            this._fillColorLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillColorComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._patternLabel.setEnabled(this._lineCheckBox.isSelected());
            this._fillPatternComboBox.setEnabled(this._lineCheckBox.isSelected());
            this._samplePanel.setEnabled(this._lineCheckBox.isSelected());
            this._samplePanel.repaint();
        });
        this._lineColorComboBox.addActionListener(e -> {
            this._data.setLineColor(this._lineColorComboBox.getSelectedColor());
            this._samplePanel.repaint();
        });
        this._lineStyleComboBox.addActionListener(e -> {
            this._data.setLineStyle((float[])this._lineStyleComboBox.getItemAt(this._lineStyleComboBox.getSelectedIndex()));
            this._samplePanel.repaint();
        });
        this._lineWeightComboBox.addActionListener(e -> {
            this._data.setLineWeight((Float)this._lineWeightComboBox.getItemAt(this._lineWeightComboBox.getSelectedIndex()));
            this._samplePanel.repaint();
        });
        this._fillNoneRButton.addActionListener(e -> {
            this._data.setFillStyle(ThresholdLineStyle.ThresholdFillStyle.NONE);
            this._fillNoneRButton.setSelected(true);
            this._fillBelowRButton.setSelected(false);
            this._fillAboveRButton.setSelected(false);
            this._samplePanel.repaint();
        });
        this._fillBelowRButton.addActionListener(e -> {
            this._data.setFillStyle(ThresholdLineStyle.ThresholdFillStyle.BELOW);
            this._fillNoneRButton.setSelected(false);
            this._fillBelowRButton.setSelected(true);
            this._fillAboveRButton.setSelected(false);
            this._samplePanel.repaint();
        });
        this._fillAboveRButton.addActionListener(e -> {
            this._data.setFillStyle(ThresholdLineStyle.ThresholdFillStyle.ABOVE);
            this._fillNoneRButton.setSelected(false);
            this._fillBelowRButton.setSelected(false);
            this._fillAboveRButton.setSelected(true);
            this._samplePanel.repaint();
        });
        this._fillColorComboBox.addActionListener(e -> {
            this._data.setFillColor(this._fillColorComboBox.getSelectedColor());
            this._samplePanel.repaint();
        });
        this._fillPatternComboBox.addActionListener(e -> {
            this._data.setFillPattern((Integer)this._fillPatternComboBox.getItemAt(this._fillPatternComboBox.getSelectedIndex()));
            this._samplePanel.repaint();
        });
    }
}

