/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JPanel;
import rma.util.FillPatternFactory;

class ThresholdLineStyleSamplePanel
extends JPanel {
    ThresholdLineStyle _lineStyle;

    ThresholdLineStyleSamplePanel(ThresholdLineStyle data) {
        this._lineStyle = data;
    }

    void setData(ThresholdLineStyle data) {
        this._lineStyle = data;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._lineStyle != null) {
            if (!this.isEnabled()) {
                return;
            }
            Color lineColor = this._lineStyle.getLineColor();
            Color lineFColor = this._lineStyle.getFillColor();
            float[] linePattern = this._lineStyle.getLineStyle();
            if (linePattern.length == 1 && linePattern[0] == 50.0f) {
                linePattern = null;
            }
            float lineThickness = this._lineStyle.getLineWeight();
            Dimension d = this.getSize();
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this._lineStyle.isDrawLine()) {
                int fillType = this._lineStyle.getFillPattern();
                if (fillType == 0) {
                    g2d.setColor(lineFColor);
                    if (this._lineStyle.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (this._lineStyle.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                } else {
                    Composite oldAc = ((Graphics2D)g).getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                    Paint op = g2d.getPaint();
                    Paint tp = FillPatternFactory.createFillPattern(fillType, lineFColor);
                    g2d.setPaint(tp);
                    ((Graphics2D)g).setComposite(ac);
                    if (this._lineStyle.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (this._lineStyle.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                    g2d.setComposite(oldAc);
                    g2d.setPaint(op);
                }
                g2d.setColor(lineColor);
                Stroke oldStroke = g2d.getStroke();
                BasicStroke bs = new BasicStroke(lineThickness, 0, 0, 10.0f, linePattern, 0.0f);
                g2d.setStroke(bs);
                g2d.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
                g2d.setStroke(oldStroke);
            }
            g.setColor(oldColor);
        }
    }
}

