/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.swing.charts.thresholds.EditThresholdPanel;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.thresholds.ThresholdsTable;
import hec.gfx2d.swing.charts.thresholds.ThresholdsTableModel;
import hec.gfx2d.swing.charts.util.PropertyFireable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class ThresholdOptionsPanel
extends JPanel {
    private PropertyFireable _firer;
    private RmaJCheckBox _showThresholdsBox;
    private JButton _addThresholdButton;
    private JButton _editThresholdButton;
    private JButton _removeThresholdButton;
    private ThresholdsTableModel _thresholdsTableModel;
    private ThresholdsTable _thresholdsTable;
    private Threshold _selectedThreshold = null;

    public ThresholdOptionsPanel() {
        this.buildComponents();
        this.addListeners();
        this.load(new ArrayList<Threshold>());
        this.setShowThresholds(true);
    }

    public void load(List<Threshold> thresholds) {
        this._thresholdsTableModel.fill(thresholds);
        this.updateSelectedEntry();
    }

    public List<Threshold> save() {
        return this._thresholdsTableModel.getAllEntries();
    }

    public void setShowThresholds(boolean showThresholds) {
        this._showThresholdsBox.setSelected(showThresholds);
        this._addThresholdButton.setEnabled(this._showThresholdsBox.isSelected());
        int selectedRow = this._thresholdsTable.getSelectedRow();
        boolean selected = selectedRow >= 0 && selectedRow < this._thresholdsTable.getRowCount();
        this._editThresholdButton.setEnabled(this._showThresholdsBox.isSelected() && selected);
        this._removeThresholdButton.setEnabled(this._showThresholdsBox.isSelected() && selected);
    }

    public boolean isShowThresholds() {
        return this._showThresholdsBox.isSelected();
    }

    public void setPropertyFirer(PropertyFireable firer) {
        this._firer = firer;
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Thresholds"));
        this._showThresholdsBox = new RmaJCheckBox();
        this._showThresholdsBox.setText("Show Thresholds");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._showThresholdsBox, gbc);
        this._thresholdsTableModel = new ThresholdsTableModel();
        this._thresholdsTable = new ThresholdsTable(this._thresholdsTableModel);
        JScrollPane tablePane = new JScrollPane(this._thresholdsTable, 20, 31);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)tablePane, gbc);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridBagLayout());
        this._addThresholdButton = new JButton();
        this._addThresholdButton.setText("New");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._addThresholdButton, gbc);
        this._editThresholdButton = new JButton();
        this._editThresholdButton.setText("Edit");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._editThresholdButton, gbc);
        this._removeThresholdButton = new JButton();
        this._removeThresholdButton.setText("Remove");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5555;
        rightPanel.add((Component)this._removeThresholdButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.fill = 3;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)rightPanel, gbc);
    }

    private void addListeners() {
        this._showThresholdsBox.addActionListener(e -> {
            this._addThresholdButton.setEnabled(this._showThresholdsBox.isSelected());
            this._thresholdsTable.setEnabled(this._showThresholdsBox.isSelected());
            int selectedRow = this._thresholdsTable.getSelectedRow();
            boolean selected = selectedRow >= 0 && selectedRow < this._thresholdsTable.getRowCount();
            this._editThresholdButton.setEnabled(this._showThresholdsBox.isSelected() && selected);
            this._removeThresholdButton.setEnabled(this._showThresholdsBox.isSelected() && selected);
        });
        this._addThresholdButton.addActionListener(e -> {
            EditThresholdPanel newThresholdPanel = new EditThresholdPanel();
            newThresholdPanel.load(new Threshold());
            int confirmResult = JOptionPane.showConfirmDialog(this, newThresholdPanel, "New Threshold", 2, -1);
            if (confirmResult == 0) {
                this._thresholdsTableModel.insertEntry(newThresholdPanel.save());
                if (this._firer != null) {
                    this._firer.fireUpdate();
                }
            }
        });
        this._editThresholdButton.addActionListener(e -> {
            EditThresholdPanel editThresholdPanel = new EditThresholdPanel();
            editThresholdPanel.load(this._selectedThreshold);
            int confirmResult = JOptionPane.showConfirmDialog(this, editThresholdPanel, "Modify Threshold Properties", 2, -1);
            if (confirmResult == 0) {
                Threshold newThreshold = editThresholdPanel.save();
                this._thresholdsTableModel.updateEntry(this._selectedThreshold, newThreshold);
                this.updateSelectedEntry();
                if (this._firer != null) {
                    this._firer.fireUpdate();
                }
            }
        });
        this._removeThresholdButton.addActionListener(e -> {
            int confirmResult = JOptionPane.showConfirmDialog(this, this._selectedThreshold.getLabelFormat(), "Confirm Delete Threshold", 2, -1);
            if (confirmResult == 0) {
                this._thresholdsTableModel.removeEntry(this._selectedThreshold);
                if (this._firer != null) {
                    this._firer.fireUpdate();
                }
            }
        });
        this._thresholdsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateSelectedEntry();
        });
    }

    private void updateSelectedEntry() {
        int selectedRow = this._thresholdsTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this._thresholdsTable.getRowCount()) {
            this._selectedThreshold = this._thresholdsTableModel.getEntryForRow(selectedRow);
            this._removeThresholdButton.setEnabled(true);
            this._editThresholdButton.setEnabled(true);
        } else {
            this._selectedThreshold = null;
            this._removeThresholdButton.setEnabled(false);
            this._editThresholdButton.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._showThresholdsBox.setEnabled(true);
        this._addThresholdButton.setEnabled(enabled);
        this._removeThresholdButton.setEnabled(enabled && this._selectedThreshold != null);
        this._editThresholdButton.setEnabled(enabled && this._selectedThreshold != null);
        this._thresholdsTable.setEnabled(enabled);
    }
}

