/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.thresholds.ThresholdLineStyleRenderer;
import hec.gfx2d.swing.charts.thresholds.ThresholdsTableModel;
import javax.swing.table.TableColumn;
import rma.swing.RmaJTable;

class ThresholdsTable
extends RmaJTable {
    private static final int[] columnWidths = new int[]{60, 125, 75, 75, 100};

    ThresholdsTable(ThresholdsTableModel model) {
        this.setModel(model);
        this.setCheckBoxCellEditor(ThresholdsTableModel.Column.VISIBLE_COL.getIndex());
        this.setDefaultRenderer(ThresholdLineStyle.class, new ThresholdLineStyleRenderer());
        this.setColumnWidths(columnWidths);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(3);
    }

    @Override
    public void setColumnWidths(int ... widths) {
        if (widths == null || widths.length == 0) {
            return;
        }
        for (int i = 0; i < widths.length; ++i) {
            this.setColumnWidth(i, widths[i]);
        }
    }

    @Override
    public void setColumnWidth(int column, int width) {
        if (column >= this.getColumnCount()) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(column);
        if (tc == null) {
            System.out.println("setColumnWidth(): TableColumn at col " + column + " is null");
            return;
        }
        if (width == -1) {
            Object obj = tc.getHeaderValue();
            if (obj instanceof String) {
                String st = (String)obj;
                int newWidth = st.length() * 5;
                tc.setPreferredWidth(newWidth);
            }
        } else {
            tc.setPreferredWidth(width);
        }
    }
}

