/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.thresholds;

import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import rma.swing.table.AbstractRmaTableModel;

class ThresholdsTableModel
extends AbstractRmaTableModel {
    private List<Threshold> _thresholds = new ArrayList<Threshold>();

    ThresholdsTableModel() {
    }

    void fill(List<Threshold> thresholds) {
        this._thresholds = thresholds;
        this.fireTableDataChanged();
    }

    void insertEntry(Threshold threshold) {
        this._thresholds.add(threshold);
        int rowIndex = this._thresholds.indexOf(threshold);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    void updateEntry(Threshold oldEntry, Threshold newEntry) {
        if (!this._thresholds.contains(oldEntry)) {
            this.insertEntry(newEntry);
        } else {
            int rowIndex = this._thresholds.indexOf(oldEntry);
            this._thresholds.remove(oldEntry);
            if (rowIndex >= 0 && rowIndex <= this._thresholds.size()) {
                this._thresholds.add(rowIndex, newEntry);
            } else {
                this._thresholds.add(newEntry);
            }
            this.fireTableRowsUpdated(this._thresholds.indexOf(newEntry), this._thresholds.indexOf(newEntry));
        }
    }

    void removeEntry(Threshold threshold) {
        int rowIndex = this._thresholds.indexOf(threshold);
        this._thresholds.remove(threshold);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    List<Threshold> getAllEntries() {
        return this._thresholds;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return Column.getColumnString(columnIndex);
    }

    Threshold getEntryForRow(int rowIndex) {
        return this._thresholds.get(rowIndex);
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return Column.getColumnClass(columnIndex);
    }

    Class getColumnClass(Column column) {
        return column.getDataClass();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public int getRowCount() {
        return this._thresholds.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean retVal = false;
        Optional<Column> column = Column.getColumn(columnIndex);
        if (column.isPresent()) {
            retVal = this.isCellEditable(rowIndex, column.get());
        }
        return retVal;
    }

    boolean isCellEditable(int rowIndex, Column column) {
        return column == Column.VISIBLE_COL;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retVal = null;
        Optional<Column> column = Column.getColumn(columnIndex);
        if (column.isPresent()) {
            retVal = this.getValueAt(rowIndex, column.get());
        }
        return retVal;
    }

    Object getValueAt(int rowIndex, Column column) {
        Threshold threshold = this.getEntryForRow(rowIndex);
        return this.getValueInColumn(threshold, column);
    }

    private Object getValueInColumn(Threshold threshold, Column column) {
        Object retVal = null;
        switch (column) {
            case VISIBLE_COL: {
                retVal = threshold.isVisible();
                break;
            }
            case NAME_COL: {
                retVal = threshold.getLabelFormat();
                break;
            }
            case TYPE_COL: {
                retVal = threshold.getType();
                break;
            }
            case VALUE_COL: {
                retVal = threshold.getValue();
                break;
            }
            case LINE_COL: {
                retVal = threshold.getLineProperties();
            }
        }
        return retVal;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Optional<Column> optionalCol = Column.getColumn(columnIndex);
        optionalCol.ifPresent(column -> this.setValueAt(aValue, rowIndex, (Column)((Object)column)));
    }

    void setValueAt(Object aValue, int rowIndex, Column column) {
        if (this.isCellEditable(rowIndex, column)) {
            Threshold threshold = this.getEntryForRow(rowIndex);
            this.setValueInColumn(aValue, threshold, column);
        }
    }

    private void setValueInColumn(Object aValue, Threshold threshold, Column column) {
        switch (column) {
            case VISIBLE_COL: {
                threshold.setVisible((Boolean)aValue);
            }
        }
    }

    static enum Column {
        VISIBLE_COL("Visible", 0, Boolean.class),
        NAME_COL("Display Name", 1, String.class),
        TYPE_COL("Type", 2, Threshold.ThresholdType.class),
        VALUE_COL("Value", 3, Double.class),
        LINE_COL("Line Style", 4, ThresholdLineStyle.class);

        private final String _displayName;
        private final int _index;
        private final Class _dataClass;

        private Column(String displayName, int index, Class dataClass) {
            this._displayName = displayName;
            this._index = index;
            this._dataClass = dataClass;
        }

        public final String toString() {
            return this._displayName;
        }

        final int getIndex() {
            return this._index;
        }

        final Class getDataClass() {
            return this._dataClass;
        }

        private static Optional<Column> getColumn(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).findFirst();
        }

        private static String getColumnString(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).map(Column::toString).findFirst().orElse("");
        }

        private static Class getColumnClass(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).map(Column::getDataClass).findFirst().orElse(String.class);
        }
    }
}

