/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import rma.util.RMAIO;

public class RoundingTool {
    public static double round(double toRound, RoundingType rt, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException();
        }
        double retVal = 0.0;
        switch (rt) {
            case DECIMALS: {
                retVal = RoundingTool.roundDecimal(toRound, precision);
                break;
            }
            case DIGITS: {
                retVal = RoundingTool.roundDigits(toRound, precision);
                break;
            }
            case SIG_FIGS: {
                retVal = RoundingTool.roundSigFigs(toRound, precision);
            }
        }
        return retVal;
    }

    private static double roundDecimal(double toRound, int precision) {
        return RMAIO.round(toRound, precision);
    }

    private static double roundDigits(double toRound, int precision) {
        MathContext mathContext = new MathContext(precision, RoundingMode.HALF_UP);
        BigDecimal bigDecimal = new BigDecimal(toRound, mathContext);
        return bigDecimal.doubleValue();
    }

    private static double roundSigFigs(double toRound, int precision) {
        if (toRound == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(toRound < 0.0 ? -toRound : toRound));
        int power = precision - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(toRound * magnitude);
        return (double)shifted / magnitude;
    }

    public static enum RoundingType {
        DECIMALS("Digits after Decimal"),
        DIGITS("Total Digits"),
        SIG_FIGS("Significant Figures");

        private String _displayName;

        private RoundingType(String displayName) {
            this._displayName = displayName;
        }

        public String toString() {
            return this._displayName;
        }
    }
}

