/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.text;

import hec.gfx2d.text.TokenReplacer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateTokenReplacer
implements TokenReplacer {
    private static final String CURDATE = "CURDATE";
    private static final String CURMON = "CURMON";
    private static final String CURDAY = "CURDAY";
    private static final String CURYEAR = "CURYEAR";
    private static final String CURTIME = "CURTIME";
    private static final String SEPERATOR = ":";
    private Map<String, String> TOKEN_MAP = new HashMap<String, String>();
    private Map<String, String> DATE_FMT_MAP = new HashMap<String, String>();

    public DateTokenReplacer() {
        this.TOKEN_MAP.put(CURDATE, CURDATE);
        this.TOKEN_MAP.put(CURMON, CURMON);
        this.TOKEN_MAP.put(CURDAY, CURDAY);
        this.TOKEN_MAP.put(CURYEAR, CURYEAR);
        this.TOKEN_MAP.put(CURTIME, CURTIME);
        this.DATE_FMT_MAP.put(CURDATE, "ddMMMyyyy");
        this.DATE_FMT_MAP.put(CURMON, "MMM");
        this.DATE_FMT_MAP.put(CURDAY, "dd");
        this.DATE_FMT_MAP.put(CURYEAR, "yyyy");
        this.DATE_FMT_MAP.put(CURTIME, "HHmm");
    }

    @Override
    public String resolveToken(String token, Object ... args) {
        String value = "";
        String dateFormat = "";
        String key = "";
        int sepIdx = -1;
        sepIdx = token.indexOf(SEPERATOR);
        if (sepIdx >= 0) {
            key = token.substring(0, sepIdx);
            if (sepIdx + 1 < token.length()) {
                dateFormat = token.substring(sepIdx + 1);
            }
        } else {
            key = token;
        }
        if (this.TOKEN_MAP.get(key) == null) {
            return null;
        }
        if (dateFormat.length() == 0) {
            dateFormat = this.DATE_FMT_MAP.get(key);
        }
        if (dateFormat == null || dateFormat.length() == 0) {
            return null;
        }
        value = this.parseFormat(dateFormat);
        return value;
    }

    public String parseFormat(String dateFormatStr) {
        return this.parseFormat(dateFormatStr, new Date());
    }

    public String parseFormat(String dateFormatStr, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr);
        return dateFormat.format(date);
    }
}

