/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.text;

import hec.gfx2d.G2dData;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.text.TokenReplacer;
import hec.heclib.dss.DSSPathname;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rma.util.RMAIO;

public class DssTokenReplacer
implements TokenReplacer {
    public static final String APART = "APART";
    public static final String BPART = "BPART";
    public static final String CPART = "CPART";
    public static final String DPART = "DPART";
    public static final String EPART = "EPART";
    public static final String FPART = "FPART";
    public static final String DSSPATH = "DSSPATH";
    public static final String DSSFILENAME = "DSSFILENAME";
    public static final String DSSFILEPATH = "DSSFILEPATH";
    public static final String DSSFILEDIR = "DSSFILEDIR";
    public static final String DSSFILEDATE = "DSSFILEDATE";
    public static final String LABEL = "LABEL";
    public static final String SEPARATOR = ":";
    public static final Map<String, String> TOKEN_MAP = new HashMap<String, String>();

    public DssTokenReplacer() {
        TOKEN_MAP.put(APART, APART);
        TOKEN_MAP.put(BPART, BPART);
        TOKEN_MAP.put(CPART, CPART);
        TOKEN_MAP.put(DPART, DPART);
        TOKEN_MAP.put(EPART, EPART);
        TOKEN_MAP.put(FPART, FPART);
        TOKEN_MAP.put(DSSPATH, DSSPATH);
        TOKEN_MAP.put(DSSFILENAME, DSSFILENAME);
        TOKEN_MAP.put(DSSFILEPATH, DSSFILEPATH);
        TOKEN_MAP.put(DSSFILEDIR, DSSFILEDIR);
        TOKEN_MAP.put(DSSFILEDATE, DSSFILEDATE);
        TOKEN_MAP.put(LABEL, LABEL);
    }

    @Override
    public String resolveToken(String token, Object ... args) {
        if (token == null) {
            return null;
        }
        String UPPER_TOKEN = token.toUpperCase();
        ArrayList<G2dData> plotObjects = new ArrayList<G2dData>();
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!(args[i] instanceof TimeSeriesDataSet) && !(args[i] instanceof PairedDataSet)) continue;
            plotObjects.add((G2dData)args[i]);
        }
        return this.resolveToken(token, plotObjects);
    }

    private String resolveToken(String token, List<G2dData> plotObjects) {
        String key;
        DataContainer dContainer = null;
        int sepIdx = -1;
        int dssIdx = 0;
        sepIdx = token.indexOf(SEPARATOR);
        if (sepIdx >= 0) {
            key = token.substring(0, sepIdx);
            if (sepIdx + 1 < token.length()) {
                dssIdx = RMAIO.parseInt(token.substring(sepIdx + 1), 0);
            }
        } else {
            key = token;
        }
        if (dssIdx < 0) {
            dssIdx = 0;
        }
        if (dssIdx >= plotObjects.size()) {
            dssIdx = plotObjects.size() - 1;
        }
        if (dssIdx < 0) {
            return null;
        }
        G2dData obj = plotObjects.get(dssIdx);
        if (obj instanceof TimeSeriesDataSet) {
            dContainer = ((TimeSeriesDataSet)obj).getData();
        } else if (obj instanceof PairedDataSet) {
            dContainer = ((PairedDataSet)obj).getData();
        }
        if (dContainer == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dContainer.fullName);
        if (APART.equalsIgnoreCase(key)) {
            return pathName.aPart();
        }
        if (BPART.equalsIgnoreCase(key)) {
            return pathName.bPart();
        }
        if (CPART.equalsIgnoreCase(key)) {
            return pathName.cPart();
        }
        if (DPART.equalsIgnoreCase(key)) {
            return pathName.dPart();
        }
        if (EPART.equalsIgnoreCase(key)) {
            return pathName.ePart();
        }
        if (FPART.equalsIgnoreCase(key)) {
            return pathName.fPart();
        }
        if (DSSPATH.equals(key)) {
            return dContainer.fullName;
        }
        if (DSSFILENAME.equals(key)) {
            String temp = RMAIO.getFileNameNoExtension(dContainer.fileName);
            temp = RMAIO.getFileFromPath(temp);
            return temp;
        }
        if (DSSFILEDIR.equals(key)) {
            return RMAIO.getDirectoryFromPath(dContainer.fileName);
        }
        if (DSSFILEPATH.equals(key)) {
            return dContainer.fileName;
        }
        if (LABEL.equals(key) && obj instanceof PairedDataSet) {
            PairedDataContainer pdc = (PairedDataContainer)dContainer;
            String[] labels = pdc.labels;
            StringBuilder sb = new StringBuilder();
            if (labels != null) {
                int i = 0;
                for (String label : labels) {
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(label);
                    ++i;
                }
            }
            return sb.toString();
        }
        return null;
    }
}

