/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.text;

import hec.gfx2d.text.DateTokenReplacer;
import hec.gfx2d.text.DssTokenReplacer;
import hec.gfx2d.text.TokenReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rma.util.lookup.Lookup;

public class TextSubstitutionManager {
    private static final String START_TOKEN = "%";
    private static final String END_TOKEN = "%";
    private List<TokenReplacer> mTokenReplacers = new ArrayList<TokenReplacer>();
    private static TextSubstitutionManager MANAGER = null;

    public static TextSubstitutionManager getTextSubstitutionManager() {
        if (MANAGER == null) {
            MANAGER = new TextSubstitutionManager();
        }
        return MANAGER;
    }

    private TextSubstitutionManager() {
        this.mTokenReplacers.add(new DateTokenReplacer());
        this.mTokenReplacers.add(new DssTokenReplacer());
        Collection tokenReplacers = Lookup.getDefault().lookupAll(TokenReplacer.class);
        this.mTokenReplacers.addAll(tokenReplacers);
    }

    public void addTokenReplacer(TokenReplacer tokenReplacer) {
        if (tokenReplacer != null) {
            this.mTokenReplacers.add(tokenReplacer);
        }
    }

    public boolean hasTokenReplacer(TokenReplacer tokenReplacer) {
        if (tokenReplacer == null) {
            return false;
        }
        return this.mTokenReplacers.contains(tokenReplacer);
    }

    public boolean hasTokenReplacer(Class<? extends TokenReplacer> clazz) {
        if (clazz == null) {
            return false;
        }
        for (TokenReplacer replacer : this.mTokenReplacers) {
            if (!clazz.equals(replacer.getClass())) continue;
            return true;
        }
        return false;
    }

    public String replaceTokens(String tokenString, Object ... args) {
        Object parsedString = tokenString;
        if (parsedString == null) {
            return null;
        }
        int startTagIndex = 0;
        while ((startTagIndex = ((String)parsedString).indexOf("%", startTagIndex)) >= 0) {
            String beforeTag = ((String)parsedString).substring(0, startTagIndex);
            int endTagIndex = ((String)parsedString).indexOf("%", startTagIndex + 1);
            if (endTagIndex < 0) break;
            String afterTag = ((String)parsedString).substring(endTagIndex + "%".length());
            String tag = ((String)parsedString).substring(startTagIndex + "%".length(), endTagIndex);
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println(tag);
            }
            boolean found = false;
            for (int z = 0; z < this.mTokenReplacers.size(); ++z) {
                String replacedToken = this.mTokenReplacers.get(z).resolveToken(tag, args);
                if (replacedToken == null) continue;
                parsedString = beforeTag + replacedToken + afterTag;
                found = true;
                break;
            }
            if (found) continue;
            ++startTagIndex;
        }
        return parsedString;
    }

    private class Token {
        String tokenName;
        int tokenStartIdx;
        int tokenEndIdx;

        private Token() {
        }
    }
}

