/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.appInterface.AppDaddy;
import hec.event.FileSelectedEvent;
import hec.event.FileSelectedListener;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.text.Document;
import rma.swing.RmaJTextField;
import rma.swing.text.PathnameDocument;

public abstract class AbstractFileChooserField
extends RmaJTextField {
    private static final String uiClassID = "RmiFileChooserFieldUI";
    protected static final int OPEN_FILE = 0;
    protected static final int OPEN_DIRECTORY = 1;
    private int _openType = 0;
    protected Toolkit toolkit;
    JButton _ellipsesButton = null;
    List _filters;
    String _defaultPath;
    protected Document _document;
    protected MouseAdapter _mouseAdapter;
    boolean _openingFile = true;
    private String _chooserTitle;
    private String _chooserApproveButtonText;

    public AbstractFileChooserField() {
        this.configure();
    }

    public AbstractFileChooserField(String fullpath) {
        this();
        this.setToolTipText("");
        this.setText(fullpath);
    }

    public AbstractFileChooserField(String fullpath, int cols) {
        this();
        this.setToolTipText("");
        this.setColumns(cols);
        this.setText(fullpath);
    }

    public void setOpenFile() {
        this._openType = 0;
    }

    public void setOpenDirectory() {
        this._openType = 1;
    }

    public int getOpenType() {
        return this._openType;
    }

    protected void configure() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this._document = this.createDefaultModel();
        this.setDocument(this._document);
        this.setMouseListener();
        this.setToolTipText("");
        this._defaultPath = AppDaddy.getWorkspace() != null ? AppDaddy.getWorkspace().getWorkspacePath() : null;
    }

    @Override
    protected Document createDefaultModel() {
        return new PathnameDocument();
    }

    public void setDefaultPath(String path) {
        this._defaultPath = path;
    }

    public String getDefaultPath() {
        return this._defaultPath;
    }

    public void setOpening() {
        this._openingFile = true;
    }

    public boolean isOpening() {
        return this._openingFile;
    }

    public void setSaving() {
        this._openingFile = false;
    }

    protected void setMouseListener() {
        this._mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AbstractFileChooserField.this.displayFileChooserDialog();
                }
            }
        };
        this.addMouseListener(this._mouseAdapter);
    }

    protected void removeMouseListener() {
        this.removeMouseListener(this._mouseAdapter);
    }

    @Override
    public void setText(String s) {
        super.setText(s);
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }

    public void setFilters(List filters) {
        this._filters = filters;
    }

    public List getFilters() {
        return this._filters;
    }

    public abstract boolean displayFileChooserDialog();

    public String getPath() {
        return this.getText();
    }

    @Override
    public String getUIClassID() {
        String className = (String)UIManager.get(uiClassID);
        return uiClassID;
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    protected void fireFileChosen() {
        EventListener[] lList = this.getListeners(FileSelectedListener.class);
        if (lList == null || lList.length == 0) {
            return;
        }
        FileSelectedEvent event = new FileSelectedEvent(this);
        for (int i = lList.length - 1; i >= 0; --i) {
            ((FileSelectedListener)lList[i]).fileSelected(event);
        }
    }

    public void addFileSelectedListener(FileSelectedListener listener) {
        this.listenerList.add(FileSelectedListener.class, listener);
    }

    public void removeFileSelectedListener(FileSelectedListener listener) {
        this.listenerList.remove(FileSelectedListener.class, listener);
    }

    public void setChooserTitle(String title) {
        this._chooserTitle = title;
    }

    public String getChooserTitle() {
        return this._chooserTitle;
    }

    public void setChooserApproveButtonText(String okButtonText) {
        this._chooserApproveButtonText = okButtonText;
    }

    public String getChooserApproveButtonText() {
        return this._chooserApproveButtonText;
    }

    static {
        UIManager.put(uiClassID, "hec.io.BasicRmiFileChooserFieldUI");
    }
}

