/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.client.FindTextJDialog;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import rma.swing.FontChooser;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJFrame;
import rma.swing.RmaJObjectMenuItem;
import rma.swing.SearchableJEditorPane;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public abstract class AbstractRmiTextFileReaderJDialog
extends RmaJFrame
implements Printable {
    public static final String FONT_PROP = "textFileReader.font";
    private static final String BACKGROUND_PROP = "textFileReader.background";
    private static final String FOREGROUND_PROP = "textFileReader.foreground";
    protected SearchableJEditorPane jTA_text = new SearchableJEditorPane();
    JScrollPane jSP_sPane;
    protected JTextArea jTxtFileName = new JTextArea();
    JLabel jLblFileName = new JLabel("Filename:");
    JMenu _searchMenu;
    JMenu _formatMenu;
    JMenuItem _printMenuItem;
    JMenuItem _refreshMenuItem;
    FindTextJDialog _findDialog = null;
    boolean _matchCase;
    boolean _initd;
    boolean _refresh = false;
    int _searchDirection;
    String _searchText = "";
    Identifier _id = null;
    boolean _remote = true;
    boolean _useHttp = false;
    ReflectMultiListener _listener;
    private String _printDateStr;
    StringTokenizer _printTokenizer;
    protected boolean _readFile;
    protected int _readAttempts;
    private RmaJObjectMenuItem _viewPreviousItem;
    private RmaJObjectMenuItem _viewCurrentItem;
    private Hashtable<Integer, Vector<String>> m_printCache = new Hashtable();

    public AbstractRmiTextFileReaderJDialog(Dialog owner, boolean modal) {
        this.buildControls();
    }

    public AbstractRmiTextFileReaderJDialog(Dialog owner, boolean modal, String sTitle) {
        this(owner, modal);
        this.setTitle(sTitle.trim());
    }

    public AbstractRmiTextFileReaderJDialog(Frame owner, boolean modal) {
        this.buildControls();
    }

    public AbstractRmiTextFileReaderJDialog(Frame owner, boolean modal, String sTitle) {
        this(owner, modal);
        this.setTitle(sTitle.trim());
    }

    protected void buildControls() {
        this.setSize(700, 400);
        this.setLocation();
        this._listener = new ReflectMultiListener();
        Insets anInset = new Insets(5, 5, 5, 5);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        this._refreshMenuItem = new JMenuItem("Refresh", 114);
        menu.add(this._refreshMenuItem);
        this._viewPreviousItem = new RmaJObjectMenuItem("Previous Version", (Object)null);
        this._viewPreviousItem.setMnemonic('V');
        this._viewPreviousItem.setVisible(false);
        menu.add(this._viewPreviousItem);
        this._viewCurrentItem = new RmaJObjectMenuItem("Current Version", (Object)null);
        this._viewCurrentItem.setMnemonic('C');
        this._viewCurrentItem.setVisible(false);
        menu.add(this._viewCurrentItem);
        this._printMenuItem = new JMenuItem("Print", 112);
        menu.add(this._printMenuItem);
        menu.addSeparator();
        JMenuItem closeMenuItem = new JMenuItem("Close", 99);
        menu.add(closeMenuItem);
        menuBar.add(menu);
        this._searchMenu = new JMenu("Search");
        this._searchMenu.setMnemonic('S');
        JMenuItem findMenuItem = new JMenuItem("Find", 70);
        findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        this._searchMenu.add(findMenuItem);
        JMenuItem findNextMenuItem = new JMenuItem("Find Next", 78);
        findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        this._searchMenu.add(findNextMenuItem);
        menuBar.add(this._searchMenu);
        this.setJMenuBar(menuBar);
        if (ClientAppCheck.haveClientApp()) {
            this.buildFormatMenu();
        }
        this.jSP_sPane = new JScrollPane(this.jTA_text, 22, 32);
        this.jTA_text.setEditable(false);
        this.jTA_text.setMargin(new Insets(5, 5, 5, 5));
        this.jTxtFileName.setEditable(false);
        this.jTxtFileName.setBackground(this.getContentPane().getBackground());
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insests2 = new Insets(anInset.top + 3, anInset.left, anInset.bottom, anInset.right);
        this.getContentPane().add((Component)this.jLblFileName, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insests2, 0, 0));
        this.getContentPane().add((Component)this.jTxtFileName, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, anInset, 0, 0));
        this.getContentPane().add((Component)this.jSP_sPane, new RmaGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, anInset, 0, 0));
        closeMenuItem.addActionListener(this._listener.add(this, closeMenuItem, "jB_Ok_actionPerformed"));
        this._refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractRmiTextFileReaderJDialog.this._refresh = true;
                AbstractRmiTextFileReaderJDialog.this.fillForm(AbstractRmiTextFileReaderJDialog.this._id, AbstractRmiTextFileReaderJDialog.this._remote);
            }
        });
        this._printMenuItem.addActionListener(this._listener.add(this, this._printMenuItem, "printFile"));
        findMenuItem.addActionListener(this._listener.add(this, findMenuItem, "displayFindDialog"));
        findNextMenuItem.addActionListener(this._listener.add(this, findNextMenuItem, "search"));
        this.jTxtFileName.getDocument().putProperty("DefaultEditorKit.EndOfLineStringProperty", "\n");
        this._viewPreviousItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRmiTextFileReaderJDialog.this.viewPreviousFileAction();
            }
        });
        this._viewCurrentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRmiTextFileReaderJDialog.this.viewCurrentFileAction();
            }
        });
    }

    private void init() {
        if (this._initd) {
            return;
        }
        Color backColor = null;
        Color foreColor = null;
        Font textFont = null;
        if (ClientAppCheck.haveClientApp()) {
            if (backColor != null) {
                this.jTA_text.setBackground(backColor);
            }
            if (foreColor != null) {
                this.jTA_text.setForeground(foreColor);
            }
            if (textFont != null) {
                this.jTA_text.setFont(textFont);
            }
        }
    }

    protected void buildFormatMenu() {
        this._formatMenu = new JMenu("Format");
        JMenuItem menuItem = new JMenuItem("Font", 70);
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectFont"));
        this._formatMenu.add(menuItem);
        JMenu menu2 = new JMenu("Colors");
        menu2.setMnemonic('C');
        this._formatMenu.add(menu2);
        menuItem = new JMenuItem("Foreground");
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectForeground"));
        menu2.add(menuItem);
        menuItem = new JMenuItem("Background");
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectBackground"));
        menu2.add(menuItem);
        this.getJMenuBar().add(this._formatMenu);
    }

    public void fillForm(String text) {
        this.jTxtFileName.setVisible(false);
        this.jLblFileName.setVisible(false);
        this._refreshMenuItem.setVisible(false);
        this.setHTTPText(false);
        this._readFile = true;
        Document doc = this.jTA_text.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException bel) {
            System.out.println(bel);
        }
    }

    public void fillForm(Identifier id) {
        this.fillForm(id, true);
    }

    public void fillForm(Identifier id, boolean remote) {
        this._readFile = false;
        if (id == null) {
            return;
        }
        this._id = id;
        this._remote = remote;
        if (!this._refresh) {
            this.setTitle(RMAIO.getFileFromPath(this._id.getPath()));
            this.jTxtFileName.setText(id.getPath());
        }
        this._refresh = false;
        BufferedReader reader = null;
        long fileSize = 1024L;
        if (remote) {
            HecFile file;
            if (this._id.getFile() == null) {
                Identifier retId = this.getFileIdentifier(id);
                if (retId == null) {
                    JOptionPane.showMessageDialog(this.getParent(), "Can't find file " + id.getPath());
                    return;
                }
                file = retId.getFile();
            } else {
                file = this._id.getFile();
            }
            if (file == null) {
                JOptionPane.showMessageDialog(this.getParent(), "Can't find file " + id.getPath());
                return;
            }
            this._viewCurrentItem.setObject(file);
            String prevFilePath = file.getPath().concat(".bak");
            this.checkPreviousFileRemote(prevFilePath);
            reader = file.getBufferedReader();
            fileSize = file.length();
        } else {
            try {
                reader = new BufferedReader(new FileReader(id.getPath()));
                File f = new File(id.getPath());
                fileSize = f.length();
            }
            catch (FileNotFoundException nfe) {
                System.out.println("fillForm: FileNotFoundException " + nfe);
                JOptionPane.showMessageDialog(this.getParent(), "Can't find file " + id.getPath());
                return;
            }
        }
        this.readFile(reader, fileSize);
    }

    protected abstract Identifier getFileIdentifier(Identifier var1);

    protected boolean readFile(BufferedReader reader, long fileSize) {
        ++this._readAttempts;
        if (reader != null) {
            this._readAttempts = 0;
            try {
                if (this._useHttp) {
                    this.jTA_text.read(reader, (Object)new HTMLDocument());
                } else {
                    String line;
                    StringBuffer buffer = new StringBuffer((int)fileSize + 20);
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                    this.jTA_text.setText(buffer.toString());
                }
                this._readFile = true;
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.getMessage());
            }
            try {
                reader.close();
            }
            catch (IOException ioe) {
                System.out.println("Failed to close reader " + ioe);
            }
            this.jTA_text.setCaretPosition(0);
            return true;
        }
        if (this._readAttempts < 2) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void viewCurrentFileAction() {
        long size;
        Object obj = this._viewCurrentItem.getObject();
        if (!(obj instanceof HecFile)) {
            this._viewCurrentItem.setVisible(false);
            return;
        }
        HecFile file = (HecFile)obj;
        BufferedReader reader = file.getBufferedReader();
        if (this.readFile(reader, size = file.length())) {
            this.setTitle(RMAIO.getFileFromPath(file.getPath()));
            this.jTxtFileName.setText(file.getPath());
            this._viewPreviousItem.setVisible(true);
            this._viewCurrentItem.setVisible(false);
        }
    }

    protected void viewPreviousFileAction() {
        long size;
        Object obj = this._viewPreviousItem.getObject();
        if (!(obj instanceof HecFile)) {
            this._viewPreviousItem.setVisible(false);
            return;
        }
        HecFile file = (HecFile)obj;
        BufferedReader reader = file.getBufferedReader();
        if (this.readFile(reader, size = file.length())) {
            this.setTitle(RMAIO.getFileFromPath(file.getPath()));
            this.jTxtFileName.setText(file.getPath());
            this._viewCurrentItem.setVisible(true);
            this._viewPreviousItem.setVisible(false);
        }
    }

    private void checkPreviousFileRemote(String prevFilePath) {
        try {
            Identifier id;
            Identifier retId;
            if (this.fileExists(prevFilePath) && (retId = this.getFileIdentifier(id = new Identifier(prevFilePath))) != null) {
                HecFile file = retId.getFile();
                this._viewPreviousItem.setObject(file);
                this._viewPreviousItem.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println("checkPreviousFileRemote:Error checking for previous file " + e);
        }
    }

    protected abstract boolean fileExists(String var1);

    public void setFileNameFieldVisible(boolean b) {
        this.jLblFileName.setVisible(b);
        this.jTxtFileName.setVisible(b);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this._readFile) {
            return;
        }
        if (b) {
            this.init();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractRmiTextFileReaderJDialog.this.jTA_text.requestFocus();
                    AbstractRmiTextFileReaderJDialog.this.jTA_text.setCaretPosition(0);
                }
            });
        }
        super.setVisible(b);
    }

    public void jB_Ok_actionPerformed() {
        this.WindowClosing();
    }

    void WindowClosing() {
        this.setVisible(false);
    }

    public void displayFindDialog() {
        this.jTA_text.displayFindDialog();
    }

    public void search() {
        this.jTA_text.search();
    }

    public void setHTTPText(boolean useHttp) {
        this._useHttp = useHttp;
        if (useHttp) {
            this.jTA_text.setContentType("text/html");
            this._searchMenu.setVisible(false);
            this._printMenuItem.setVisible(true);
            if (this._formatMenu != null) {
                this._formatMenu.setVisible(false);
            }
        } else {
            this.jTA_text.setContentType("text/plain");
            this._searchMenu.setVisible(true);
            this._printMenuItem.setVisible(true);
            if (this._formatMenu != null) {
                this._formatMenu.setVisible(true);
            }
        }
    }

    public void selectForeground() {
        Color c2 = JColorChooser.showDialog(this, "Select Foreground Color", this.jTA_text.getForeground());
        if (c2 == null) {
            return;
        }
        this.jTA_text.setForeground(c2);
    }

    public void selectBackground() {
        Color c2 = JColorChooser.showDialog(this, "Select Background Color", this.jTA_text.getForeground());
        if (c2 == null) {
            return;
        }
        this.jTA_text.setBackground(c2);
    }

    public void selectFont() {
        FontChooser chooser = new FontChooser((Frame)this, "Select Font", true, this.jTA_text.getFont());
        Font f = chooser.getSelectedFont();
        if (f == null) {
            return;
        }
        this.jTA_text.setFont(f);
    }

    public void printFile() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPrintable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            this._printDateStr = null;
            this.m_printCache.clear();
            this._printTokenizer = new StringTokenizer(this.jTA_text.getText(), "\n");
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        String fileName = RMAIO.getFileFromPath(this._id.getPath());
        if (this._printDateStr == null) {
            this._printDateStr = new Date().toString().substring(4);
        }
        if (!this._printTokenizer.hasMoreTokens()) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.setFont(new Font("Helvetica", 0, 10));
        int fontHeight = g2.getFontMetrics().getHeight();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double areaWidth = this.jTA_text.getWidth();
        double scale = 1.0;
        if (areaWidth >= pageWidth) {
            scale = pageWidth / areaWidth;
        }
        int x = (int)pageFormat.getImageableX() + 10;
        int y = (int)pageFormat.getImageableY() + 12;
        g.drawString("File: " + fileName + ", Page: " + (pageIndex + 1), x, y);
        y += 36;
        pageHeight = pageFormat.getImageableY() + pageFormat.getImageableHeight();
        Vector<String> printCacheData = this.m_printCache.get(new Integer(pageIndex));
        if (printCacheData == null) {
            printCacheData = new Vector();
            this.m_printCache.put(new Integer(pageIndex), printCacheData);
            while ((double)(y + 12) < pageHeight && this._printTokenizer.hasMoreTokens()) {
                String str = this._printTokenizer.nextToken();
                printCacheData.addElement(str);
                g.drawString(str, x, y);
                y += 12;
            }
        } else {
            for (int i = 0; i < printCacheData.size(); ++i) {
                g.drawString(printCacheData.elementAt(i), x, y);
                y += 12;
            }
        }
        return 0;
    }
}

