/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaNavigationPanel;

public abstract class AbstractSelectorPanel
extends JPanel
implements Observer {
    public static final int ONE_LINE_LAYOUT = 1;
    public static final int TWO_LINE_LAYOUT = 2;
    protected JLabel selectorLabel;
    protected JLabel descriptionLabel;
    protected RmaJDescriptionField descriptionTxt;
    protected RmaNavigationPanel navPanel;
    protected JPanel topComponentPanel;
    protected JComponent selectionList;

    public AbstractSelectorPanel(int mode) {
        this.buildControls(mode);
        this.addListeners();
    }

    public AbstractSelectorPanel() {
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.buildControls(2);
    }

    protected void buildControls(int mode) {
        this.setLayout(new GridBagLayout());
        this.topComponentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.add((Component)this.topComponentPanel, gbc);
        this.selectorLabel = new JLabel("Name:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.add((Component)this.selectorLabel, gbc);
        this.selectionList = this.createSelectorField();
        this.selectorLabel.setLabelFor(this.selectionList);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.selectionList, gbc);
        this.descriptionLabel = new JLabel("Description:", 4);
        this.descriptionLabel.setDisplayedMnemonic('d');
        gbc = new GridBagConstraints();
        if (mode == 1) {
            gbc.gridx = 2;
            gbc.gridy = 1;
        } else {
            gbc.gridx = 0;
            gbc.gridy = 3;
        }
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.add((Component)this.descriptionLabel, gbc);
        this.descriptionTxt = new RmaJDescriptionField();
        this.descriptionLabel.setLabelFor(this.descriptionTxt);
        gbc = new GridBagConstraints();
        if (mode == 1) {
            gbc.gridx = 3;
            gbc.gridy = 1;
        } else {
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
        }
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.descriptionTxt, gbc);
        this.navPanel = new RmaNavigationPanel();
        gbc = new GridBagConstraints();
        if (mode == 1) {
            gbc.gridx = 4;
            gbc.gridy = 1;
        } else {
            gbc.gridx = 2;
            gbc.gridy = 1;
        }
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.weightx = 0.0;
        this.add((Component)this.navPanel, gbc);
    }

    public RmaJDescriptionField getDescriptionField() {
        return this.descriptionTxt;
    }

    public String getDescription() {
        return this.descriptionTxt.getText();
    }

    public void setDescription(String desc) {
        this.descriptionTxt.setText(desc);
    }

    public void setDescriptionLabel(String label) {
        this.descriptionLabel.setText(label);
    }

    public void setDescriptionLabelMnemonic(char m) {
        this.descriptionLabel.setDisplayedMnemonic(m);
    }

    public void setNameLabel(String label) {
        this.selectorLabel.setText(label);
    }

    public void setNameLabelMnemonic(char m) {
        this.selectorLabel.setDisplayedMnemonic(m);
    }

    public void setDescriptionPanelVisible(boolean b) {
        this.descriptionLabel.setVisible(b);
        this.descriptionTxt.setVisible(b);
    }

    public boolean isDescriptionPanelVisible() {
        return this.descriptionTxt.isVisible();
    }

    public void setTopComponentPanelVisible(boolean b) {
        this.selectorLabel.setVisible(b);
        this.selectionList.setVisible(b);
    }

    public boolean isTopComponentPanelVisible() {
        return this.selectionList.isVisible();
    }

    public void setNavPanelVisible(boolean b) {
        this.navPanel.setVisible(b);
    }

    public boolean isNavPanelVisible() {
        return this.navPanel.isVisible();
    }

    protected void deleteObserver(List items) {
        if (items == null) {
            return;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            Object obj = items.get(i);
            if (!(obj instanceof Observable)) continue;
            Observable observable = (Observable)obj;
            observable.deleteObserver(this);
        }
    }

    protected void addObserver(Collection items) {
        if (items == null) {
            return;
        }
        for (Object obj : items) {
            if (!(obj instanceof Observable)) continue;
            Observable observable = (Observable)obj;
            observable.addObserver(this);
        }
    }

    protected abstract void addListeners();

    protected abstract JComponent createSelectorField();

    public abstract List getSelectorItems();

    public abstract Object getSelectedItem();

    public abstract int getSelectedIndex();

    public abstract void setSelectedItem(Object var1);

    public abstract void setSelectedIndex(int var1);

    public abstract void setSelectionList(Collection var1);

    public abstract void setSelectionList(Object[] var1);

    public abstract void addSelectionItem(Object var1, boolean var2);

    public abstract void removeSelectionItem(Object var1);

    public abstract void updateNavPanel();
}

