/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import rma.swing.RmaColor;
import rma.swing.RmaImage;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.util.RMAIO;

public class DSSI18n {
    public static final String DEFAULT_BUNDLE_NAME = "hec.dssgui.DssVue";
    private String _prefix;
    private String _bundle;
    private static final ResourceBundle DEFAULT_RESOURCE_BUNDLE = ResourceBundle.getBundle("hec.dssgui.DssVue");
    private ResourceBundle _resourceBundle;

    protected DSSI18n(String prefix, String bundleName) {
        this._prefix = prefix;
        this._bundle = bundleName;
        this._resourceBundle = DEFAULT_BUNDLE_NAME.equals(bundleName) || bundleName == null || bundleName.length() == 0 ? DEFAULT_RESOURCE_BUNDLE : ResourceBundle.getBundle(bundleName);
    }

    public static DSSI18n getI18n(String prefix) {
        return new DSSI18n(prefix, DEFAULT_BUNDLE_NAME);
    }

    public static DSSI18n getI18n(String prefix, String bundleName) {
        return new DSSI18n(prefix, bundleName);
    }

    @Deprecated
    public String getLabel() {
        return this.getString(this._prefix + ".label", false);
    }

    public String getText() {
        String txt = this.getString(this._prefix + ".text", true);
        if (txt == null) {
            txt = this.getString(this._prefix + ".label", false);
        }
        return txt;
    }

    protected String getText(boolean returnNull) {
        String txt = this.getString(this._prefix + ".text", true);
        if (txt == null) {
            txt = this.getString(this._prefix + ".label", returnNull);
        }
        return txt;
    }

    public String getName() {
        return this.getString(this._prefix + ".name", true);
    }

    public String getHelp() {
        return this.getString(this._prefix + ".help", true);
    }

    public Color getForeground() {
        String s = this.getString(this._prefix + ".foreground", true);
        if (s != null) {
            return RmaColor.parseColorString(s);
        }
        return null;
    }

    public Color getBackground() {
        String s = this.getString(this._prefix + ".background", true);
        if (s != null) {
            return RmaColor.parseColorString(s);
        }
        return null;
    }

    protected String getString(String key, boolean returnNull) {
        try {
            return this._resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (returnNull) {
                return null;
            }
            return "!" + key + "!";
        }
    }

    public String[] getStringArray() {
        String arrayKey = this._prefix + ".array";
        String delimiter = this.getArrayDelimiter(arrayKey);
        String arrayData = this.getString(arrayKey, true);
        if (arrayData != null) {
            StringTokenizer tokenizer = new StringTokenizer(arrayData, delimiter);
            String[] array = new String[tokenizer.countTokens()];
            int idx = 0;
            while (tokenizer.hasMoreTokens()) {
                array[idx++] = tokenizer.nextToken();
            }
            return array;
        }
        return new String[]{"!" + arrayKey + "!"};
    }

    public double[] getDoubleArray() {
        String arrayKey = this._prefix + ".array";
        String delimiter = this.getArrayDelimiter(arrayKey);
        String arrayData = this.getString(arrayKey, true);
        if (arrayData != null) {
            StringTokenizer tokenizer = new StringTokenizer(arrayData, delimiter);
            double[] array = new double[tokenizer.countTokens()];
            int idx = 0;
            while (tokenizer.hasMoreTokens()) {
                array[idx++] = RMAIO.parseDouble(tokenizer.nextToken());
            }
            return array;
        }
        return new double[0];
    }

    public int[] getIntArray() {
        String arrayKey = this._prefix + ".array";
        String delimiter = this.getArrayDelimiter(arrayKey);
        String arrayData = this.getString(arrayKey, true);
        if (arrayData != null) {
            StringTokenizer tokenizer = new StringTokenizer(arrayData, delimiter);
            int[] array = new int[tokenizer.countTokens()];
            int idx = 0;
            while (tokenizer.hasMoreTokens()) {
                array[idx++] = RMAIO.parseInt(tokenizer.nextToken());
            }
            return array;
        }
        return new int[0];
    }

    protected String getArrayDelimiter(String key) {
        String defDelimiter = this.getDefaultArrayDelimiter();
        String delimiter = this.getString(key + ".delimiter", true);
        if (delimiter != null) {
            return delimiter;
        }
        return defDelimiter;
    }

    protected String getDefaultArrayDelimiter() {
        return ",";
    }

    public KeyStroke getKeyStroke() {
        String keyStroke = this.getString(this._prefix + ".keystroke", true);
        if (keyStroke != null) {
            return KeyStroke.getKeyStroke(keyStroke);
        }
        return null;
    }

    public Icon getIcon() {
        String iconName = this.getString(this._prefix + ".icon", true);
        if (iconName != null) {
            return RmaImage.getImageIcon(iconName);
        }
        return null;
    }

    public Icon getSelectedIcon() {
        String iconName = this.getString(this._prefix + ".selectedIcon", true);
        if (iconName != null) {
            return RmaImage.getImageIcon(iconName);
        }
        return null;
    }

    public String getToolTipText() {
        return this.getString(this._prefix + ".tooltip", true);
    }

    public int getMnemonic() {
        String mnemonic = this.getString(this._prefix + ".mnemonic", true);
        if (mnemonic != null && mnemonic.length() > 0) {
            return mnemonic.charAt(0);
        }
        return -1;
    }

    private JMenu configureMenu(JMenu menu) {
        Icon icon;
        String toolTip;
        int mnemnonic = this.getMnemonic();
        if (mnemnonic > -1) {
            menu.setMnemonic(mnemnonic);
        }
        if ((toolTip = this.getToolTipText()) != null) {
            menu.setToolTipText(toolTip);
        }
        if ((icon = this.getIcon()) != null) {
            menu.setIcon(icon);
        }
        return menu;
    }

    public JButton createJButton() {
        String text = this.getText(true);
        RmaJButton button = new RmaJButton(text);
        this.configureButton(button);
        return button;
    }

    public JToggleButton createJToggleButton() {
        String text = this.getText(true);
        JToggleButton button = new JToggleButton(text);
        this.configureButton(button);
        return button;
    }

    public void configureButton(AbstractButton button) {
        String name;
        Icon icon;
        String toolTip;
        int mnemnonic = this.getMnemonic();
        if (mnemnonic > -1) {
            button.setMnemonic(mnemnonic);
        }
        if ((toolTip = this.getToolTipText()) != null) {
            button.setToolTipText(toolTip);
        }
        if ((icon = this.getIcon()) != null) {
            button.setIcon(icon);
        }
        if ((name = this.getName()) != null) {
            button.setName(name);
        }
        if ((icon = this.getSelectedIcon()) != null) {
            button.setSelectedIcon(icon);
        }
    }

    public JRadioButton createJRadioButton() {
        RmaJRadioButton button = new RmaJRadioButton(this.getText());
        this.configureButton(button);
        return button;
    }

    public JRadioButton createJRadioButton(Object[] args) {
        RmaJRadioButton button = new RmaJRadioButton(this.format(args));
        this.configureButton(button);
        return button;
    }

    public JCheckBox createJCheckBox() {
        RmaJCheckBox checkBox = new RmaJCheckBox(this.getText());
        this.configureButton(checkBox);
        return checkBox;
    }

    public JCheckBox createJCheckBox(Object[] args) {
        RmaJCheckBox checkBox = new RmaJCheckBox(this.format(args));
        this.configureButton(checkBox);
        return checkBox;
    }

    public JMenuItem createMenuItem(Object[] formatArgs) {
        JMenuItem menu = new JMenuItem(this.format(formatArgs));
        this.configureButton(menu);
        KeyStroke keystroke = this.getKeyStroke();
        if (keystroke != null) {
            menu.setAccelerator(keystroke);
        }
        return menu;
    }

    public JMenuItem createMenuItem() {
        JMenuItem menu = new JMenuItem(this.getText());
        this.configureButton(menu);
        KeyStroke keystroke = this.getKeyStroke();
        if (keystroke != null) {
            menu.setAccelerator(keystroke);
        }
        return menu;
    }

    public JLabel createJLabel(Object[] formatArgs) {
        Icon icon;
        String toolTip;
        JLabel label = new JLabel(this.format(formatArgs));
        int mnemnonic = this.getMnemonic();
        if (mnemnonic > -1) {
            label.setDisplayedMnemonic(mnemnonic);
        }
        if ((toolTip = this.formatToolTipText(formatArgs)) != null) {
            label.setToolTipText(toolTip);
        }
        if ((icon = this.getIcon()) != null) {
            label.setIcon(icon);
        }
        return label;
    }

    public JLabel createJLabel() {
        Color background;
        Color foreground;
        Icon icon;
        String name;
        String toolTip;
        RmaJLabel label = new RmaJLabel(this.getText());
        int mnemnonic = this.getMnemonic();
        if (mnemnonic > -1) {
            label.setDisplayedMnemonic(mnemnonic);
        }
        if ((toolTip = this.getToolTipText()) != null) {
            label.setToolTipText(toolTip);
        }
        if ((name = this.getName()) != null) {
            label.setName(name);
        }
        if ((icon = this.getIcon()) != null) {
            label.setIcon(icon);
        }
        if ((foreground = this.getForeground()) != null) {
            label.setForeground(foreground);
        }
        if ((background = this.getBackground()) != null) {
            label.setBackground(background);
            label.setOpaque(true);
        }
        return label;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem() {
        JCheckBoxMenuItem menu = new JCheckBoxMenuItem(this.getText());
        this.configureButton(menu);
        KeyStroke keystroke = this.getKeyStroke();
        if (keystroke != null) {
            menu.setAccelerator(keystroke);
        }
        return menu;
    }

    public String format(Object[] args) {
        return new MessageFormat(this.getText()).format(args);
    }

    public String format(Object arg) {
        return new MessageFormat(this.getText()).format(new Object[]{arg});
    }

    public String formatToolTipText(Object[] args) {
        String toolTip = this.getToolTipText();
        if (toolTip != null) {
            return new MessageFormat(toolTip).format(args);
        }
        return toolTip;
    }

    public int getIntValue() {
        String s = this.getText();
        return RMAIO.parseInt(s);
    }

    public boolean getBooleanValue() {
        String s = this.getText();
        return Boolean.valueOf(s);
    }

    public void configureAction(Action action) {
        if (action == null) {
            return;
        }
        action.putValue("SmallIcon", this.getIcon());
        action.putValue("ShortDescription", this.getToolTipText());
        action.putValue("AcceleratorKey", this.getKeyStroke());
        int mnemonic = this.getMnemonic();
        if (mnemonic > -1) {
            action.putValue("MnemonicKey", new Integer(mnemonic));
        }
        action.putValue("Name", this.getText());
    }
}

