/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.client.LookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import rma.swing.FontChooser;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class FormattedTextEditor
extends RmaJFrame
implements SearchListener {
    protected static boolean _startedFromMain;
    private static Map<String, String> SYNTAX_STYLE_MAP;
    private JLabel _fileLabel;
    private RmaJTextField _fileFld;
    private JButton _browseButton;
    private RSyntaxTextArea _textArea;
    private JPanel _accessoryPanel;
    protected JMenu _fileMenu;
    protected JMenu _viewMenu;
    protected JMenu _findMenu;
    protected String _lastFolder;
    private FindDialog _findDialog;
    private GoToDialog _gotoDialog;
    protected Action _openAction;
    protected Action _exitAction;
    private Action _findAction;
    private Action _gotoAction;
    private Action _fgColorAction;
    private Action _bgColorAction;
    private Action _fontAction;
    private RmaJTextField _statusLine;

    public FormattedTextEditor() {
        SYNTAX_STYLE_MAP.put("py", "text/python");
        SYNTAX_STYLE_MAP.put("java", "text/java");
        SYNTAX_STYLE_MAP.put("c", "text/c");
        SYNTAX_STYLE_MAP.put("cpp", "text/cpp");
        SYNTAX_STYLE_MAP.put("xml", "text/xml");
        SYNTAX_STYLE_MAP.put("html", "text/html");
        SYNTAX_STYLE_MAP.put("htm", "text/html");
        SYNTAX_STYLE_MAP.put("bat", "text/bat");
        this.buildControls();
        this.buildMenus();
        this.addListeners();
        this.pack();
        this.setSize(500, 500);
        this.setLocationRelativeTo(RmaJFrame.getTopWindow());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this._fileLabel = new JLabel("File:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._fileLabel, gbc);
        this._fileFld = new RmaJTextField();
        this._fileFld.setEditable(false);
        this._fileLabel.setLabelFor(this._fileFld);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._fileFld, gbc);
        this._browseButton = new JButton("...");
        Dimension d = this._browseButton.getSize();
        d.height = (int)this._fileFld.getSize().getHeight();
        this._browseButton.setSize(d);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._browseButton, gbc);
        this._textArea = new RSyntaxTextArea();
        this._textArea.setMarkOccurrencesColor(Color.ORANGE);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new RTextScrollPane((RTextArea)this._textArea), gbc);
        this._accessoryPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._accessoryPanel, gbc);
        this._statusLine = new RmaJTextField();
        this._statusLine.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._statusLine, gbc);
    }

    protected void addListeners() {
        this._browseButton.addActionListener(this._openAction);
        int ctrl = 2;
        KeyStroke findKs = KeyStroke.getKeyStroke(70, ctrl);
        KeyStroke gotoKs = KeyStroke.getKeyStroke(76, ctrl);
        ((JComponent)this.getContentPane()).getInputMap(2).put(findKs, "find");
        AbstractAction findAction = new AbstractAction("find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.displayFindDialog();
            }
        };
        ((JComponent)this.getContentPane()).getActionMap().put("find", findAction);
        ((JComponent)this.getContentPane()).getInputMap(2).put(gotoKs, "goto");
        AbstractAction gotoAction = new AbstractAction("goto"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.displayGotoDialog();
            }
        };
        ((JComponent)this.getContentPane()).getActionMap().put("goto", gotoAction);
        DnDFileDropListener dropListener = new DnDFileDropListener();
        new DropTarget((Component)this._textArea, dropListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FormattedTextEditor.this.exitEditor();
            }
        });
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        this.buildFileMenu(mbar);
        this.buildFindMenu(mbar);
        this.buildViewMenu(mbar);
    }

    protected void buildViewMenu(JMenuBar mbar) {
        this._viewMenu = new JMenu("View");
        this._viewMenu.setMnemonic('V');
        mbar.add(this._viewMenu);
        this._fontAction = new AbstractAction("Set Font..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.displayFontChooser();
            }
        };
        this._fontAction.putValue("SwingDisplayedMnemonicIndexKey", 0);
        this._viewMenu.add(this._fontAction);
        this._fgColorAction = new AbstractAction("Set Foreground Color..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.setFgColorAction();
            }
        };
        this._fgColorAction.putValue("SwingDisplayedMnemonicIndexKey", 4);
        this._viewMenu.add(this._fgColorAction);
        this._bgColorAction = new AbstractAction("Set Background Color..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.setBgColorAction();
            }
        };
        this._bgColorAction.putValue("SwingDisplayedMnemonicIndexKey", 4);
        this._viewMenu.add(this._bgColorAction);
    }

    public JMenu getFileMenu() {
        return this._fileMenu;
    }

    protected void setBgColorAction() {
        JColorChooser colorChooser = new JColorChooser(this._textArea.getBackground());
        ActionListener okListener = evt -> this._textArea.setBackground(colorChooser.getColor());
        ActionListener cancelListener = evt -> {};
        JDialog dialog = JColorChooser.createDialog(this, "Select Background Text Color", true, colorChooser, okListener, cancelListener);
        dialog.setVisible(true);
    }

    protected void setFgColorAction() {
        JColorChooser colorChooser = new JColorChooser(this._textArea.getForeground());
        ActionListener okListener = evt -> this._textArea.setForeground(colorChooser.getColor());
        ActionListener cancelListener = evt -> {};
        JDialog dialog = JColorChooser.createDialog(this, "Select Foreground Text Color", true, colorChooser, okListener, cancelListener);
        dialog.setVisible(true);
    }

    protected void buildFindMenu(JMenuBar mbar) {
        this._findMenu = new JMenu("Find");
        this._findMenu.setMnemonic('i');
        mbar.add(this._findMenu);
        this._findAction = new AbstractAction("Find..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.displayFindDialog();
            }
        };
        this._findAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
        this._findAction.putValue("SwingDisplayedMnemonicIndexKey", 0);
        this._findMenu.add(this._findAction);
        this._gotoAction = new AbstractAction("Goto Line..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.displayFindDialog();
            }
        };
        this._gotoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 2));
        this._gotoAction.putValue("SwingDisplayedMnemonicIndexKey", 0);
        this._findMenu.add(this._gotoAction);
    }

    protected void buildFileMenu(JMenuBar mbar) {
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        mbar.add(this._fileMenu);
        this._openAction = new AbstractAction("Open"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.browseForFile();
            }
        };
        this._openAction.putValue("SwingDisplayedMnemonicIndexKey", 0);
        this._openAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 128));
        this._fileMenu.add(this._openAction);
        this._exitAction = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormattedTextEditor.this.exitEditor();
            }
        };
        this._exitAction.putValue("SwingDisplayedMnemonicIndexKey", 1);
        this._fileMenu.add(this._exitAction);
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        SearchResult result = null;
        switch (type) {
            default: {
                result = SearchEngine.markAll((RTextArea)this._textArea, (SearchContext)context);
                break;
            }
            case FIND: {
                result = SearchEngine.find((JTextArea)this._textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this._textArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace((RTextArea)this._textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this._textArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll((RTextArea)this._textArea, (SearchContext)context);
                JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
            }
        }
        Object text = null;
        text = result.wasFound() ? context.getSearchFor() + " found " + result.getMarkedCount() + " times" : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : context.getSearchFor() + " not found");
        this.setStatus((String)text);
    }

    protected void setStatus(String text) {
        this._statusLine.setText(text);
    }

    protected void displayGotoDialog() {
        if (this._gotoDialog == null) {
            this._gotoDialog = new GoToDialog((Frame)this);
        }
        this._gotoDialog.setMaxLineNumberAllowed(this._textArea.getLineCount());
        this._gotoDialog.setVisible(true);
        int line = this._gotoDialog.getLineNumber();
        if (line > 0) {
            try {
                this.setCaretPosition(this._textArea.getLineStartOffset(line - 1));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void displayFindDialog() {
        if (this._findDialog == null) {
            this._findDialog = new FindDialog((Frame)this, (SearchListener)this);
            SearchContext searchContext = this._findDialog.getSearchContext();
        }
        this._findDialog.setVisible(true);
    }

    protected boolean displayFontChooser() {
        FontChooser chooser = new FontChooser((Frame)this, "Select Font", true, this._textArea.getFont());
        Font f = chooser.getSelectedFont();
        if (f == null) {
            return false;
        }
        this._textArea.setFont(f);
        return true;
    }

    protected void exitEditor() {
        this.setVisible(false);
        if (_startedFromMain) {
            System.exit(0);
        }
    }

    protected void browseForFile() {
        JFileChooser chooser = new JFileChooser(this._lastFolder);
        int opt = chooser.showOpenDialog(this);
        if (opt != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.loadFile(f);
    }

    protected void loadFile(File f) {
        this._lastFolder = f.getParentFile().getAbsolutePath();
        this.setSyntaxHighlighting(f.getName());
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            if (this.readText(reader)) {
                this.setTitle(f.getName());
                this.setFileName(f.getAbsolutePath());
                this.setCaretPosition(0);
                boolean canWrite = f.canWrite();
                this._textArea.setEditable(canWrite);
                if (!canWrite) {
                    String title = this.getTitle() + " - Read Only";
                    this.setTitle(title);
                }
            }
        }
        catch (IOException e) {
            System.out.println("browseForFile:error reading file " + f.getAbsolutePath() + " Error:" + e);
        }
    }

    protected void setFileName(String path) {
        this._fileFld.setText(path);
    }

    public String getFileName() {
        return this._fileFld.getText();
    }

    protected void setCaretPosition(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        try {
            this._textArea.setCaretPosition(pos);
        }
        catch (Exception ble) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)this._textArea);
            ble.printStackTrace();
        }
    }

    private void setSyntaxHighlighting(String fileName) {
        String ext = RMAIO.getFileExtension(fileName);
        if (ext == null || ext.isEmpty()) {
            this._textArea.setSyntaxEditingStyle("text/plain");
            return;
        }
        String syntax = SYNTAX_STYLE_MAP.get(ext = ext.toLowerCase());
        if (syntax == null) {
            syntax = "text/plain";
        }
        this._textArea.setSyntaxEditingStyle(syntax);
    }

    protected boolean readText(BufferedReader reader) {
        try {
            this._textArea.setCursor(Cursor.getPredefinedCursor(3));
            this._textArea.read((Reader)reader, null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this._textArea.setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    public void setText(String text) {
        this._textArea.setText(text);
    }

    public void appendText(String text) {
        this._textArea.append(text);
    }

    public static void main(String[] args) {
        _startedFromMain = true;
        EventQueue.invokeLater(() -> {
            LookAndFeel.setLookAndFeel();
            FormattedTextEditor editor = new FormattedTextEditor();
            editor.setDefaultCloseOperation(3);
            editor.setVisible(true);
        });
    }

    public String getSelectedText() {
        return this._textArea.getSelectedText();
    }

    protected RSyntaxTextArea getTextArea() {
        return this._textArea;
    }

    static {
        SYNTAX_STYLE_MAP = new HashMap<String, String>();
    }

    class DnDFileDropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            Transferable t;
            System.out.println("dragEnter:");
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && this.shouldAcceptDrag(t = dtde.getTransferable())) {
                System.out.println("dragEnter:accepting drag");
                dtde.acceptDrag(3);
                return;
            }
            dtde.rejectDrag();
        }

        protected boolean shouldAcceptDrag(Transferable t) {
            Object flav;
            try {
                flav = t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            if (flav instanceof List) {
                List files = (List)flav;
                int size = files.size();
                if (size == 0) {
                    return false;
                }
                return files.get(0) instanceof File;
            }
            return false;
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            System.out.println("drop:");
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object obj;
                Transferable t = dtde.getTransferable();
                int dropAction = dtde.getDropAction();
                dtde.acceptDrop(dropAction);
                if (!this.shouldAcceptDrag(t)) {
                    dtde.rejectDrop();
                    return;
                }
                boolean makeCopy = dropAction == 2;
                try {
                    obj = t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    dtde.rejectDrop();
                    return;
                }
                catch (IOException e) {
                    dtde.rejectDrop();
                    return;
                }
                List files = (List)obj;
                if (files.isEmpty()) {
                    dtde.rejectDrop();
                    return;
                }
                File f = (File)files.get(0);
                System.out.println("drop:loading " + f.getAbsolutePath());
                FormattedTextEditor.this.loadFile(f);
                return;
            }
            dtde.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

