/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;
import rma.util.Compare;
import rma.util.RMAIO;
import rma.util.RMASort;

public class MoverDialog
extends RmaJDialog
implements ActionListener,
ButtonCmdPanelListener {
    public static final int SELECTION_0_TO_1 = 1;
    public static final int SELECTION_0_TO_MANY = 100;
    public static final int MOVER_DIALOG = 0;
    public static final int COPY_DIALOG = 1;
    private static final int PREF_WIDTH = 350;
    private boolean _availableListAllowsDuplicates = true;
    private boolean _caseInsensitiveSort = false;
    private String _dialogName = null;
    private Component _owner = null;
    private int _dialogType = 0;
    private String _note = null;
    int _selectionType = 100;
    protected RmaListModel _availableListModel = new RmaListModel(true){

        @Override
        protected int compare(Object newObj, Object existingObj) {
            return newObj.toString().toLowerCase().compareTo(existingObj.toString().toLowerCase());
        }
    };
    protected RmaListModel _selectedListModel = new RmaListModel(true){

        @Override
        protected int compare(Object newObj, Object existingObj) {
            return newObj.toString().toLowerCase().compareTo(existingObj.toString().toLowerCase());
        }
    };
    boolean _canceled = false;
    MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == MoverDialog.this.jList_Available) {
                    int index = MoverDialog.this.jList_Available.locationToIndex(e.getPoint());
                    MoverDialog.this.action_Add();
                } else if (e.getSource() == MoverDialog.this.jList_Selected) {
                    int index = MoverDialog.this.jList_Selected.locationToIndex(e.getPoint());
                    MoverDialog.this.action_Remove();
                }
            }
        }
    };
    JPanel jPanel_Top = new JPanel(new BorderLayout());
    JPanel jPanel_TextArea = new JPanel();
    JTextField jTextField = new JTextField();
    JTextArea jTextArea1 = new JTextArea();
    JTextArea jNoteArea1 = new JTextArea();
    JPanel jPanel_Lists = new EnabledJPanel();
    JScrollPane jScrollPane_Available = new JScrollPane(){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 350;
            return d;
        }
    };
    TitledBorder availListBorder = new TitledBorder("Available");
    protected RmaJList jList_Available = new RmaJList(){

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = super.getPreferredScrollableViewportSize();
            d.width = 350;
            return d;
        }
    };
    JPanel jPanel_AddRemove = new JPanel();
    JButton jButton_Add = new JButton("Add", RmaImage.getImageIcon("Images/forwardbutton.gif"));
    JButton jButton_Remove = new JButton("Remove", RmaImage.getImageIcon("Images/backbutton.gif"));
    JButton jButton_AddAll = new JButton("Add All", RmaImage.getImageIcon("Images/forwardbutton.gif"));
    JButton jButton_RemoveAll = new JButton("Remove All", RmaImage.getImageIcon("Images/backbutton.gif"));
    JPanel jPanel_UpDown = new JPanel();
    JButton jButton_Up = new JButton("Up", RmaImage.getImageIcon("Images/spinUp.gif"));
    JButton jButton_Down = new JButton("Down", RmaImage.getImageIcon("Images/spinDown.gif"));
    JScrollPane jScrollPane_Selected = new JScrollPane(){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 350;
            return d;
        }
    };
    TitledBorder selectedListBorder = new TitledBorder("Selected");
    protected RmaJList jList_Selected = new RmaJList(){

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = super.getPreferredScrollableViewportSize();
            d.width = 350;
            return d;
        }
    };
    ButtonCmdPanel jPanel_CmdButton = new ButtonCmdPanel(12);

    public MoverDialog(JDialog owner, boolean modal) {
        super((Dialog)owner, modal);
        this._owner = owner;
        this.buildControls();
    }

    public MoverDialog(JDialog owner, boolean modal, String title) {
        this(owner, modal);
        this.setTitle(title);
    }

    public MoverDialog(Frame owner, boolean model) {
        super(owner, model);
        this._owner = owner;
        this.buildControls();
    }

    public MoverDialog(Frame owner, boolean modal, String title) {
        this(owner, modal);
        this.setTitle(title);
    }

    @Override
    public void clearForm() {
        this._availableListModel.clear();
        this._selectedListModel.clear();
    }

    public void setSelectionType(int type) {
        if (type == 1) {
            this._selectionType = type;
            this.jButton_AddAll.setEnabled(false);
            this.jButton_RemoveAll.setEnabled(false);
            if (this.getSelectedObjectsVector().size() > 0) {
                this.jButton_Add.setEnabled(false);
            } else {
                this.jButton_Add.setEnabled(true);
            }
        } else if (type == 100) {
            this._selectionType = type;
            this.jButton_AddAll.setEnabled(true);
            this.jButton_RemoveAll.setEnabled(true);
        } else {
            throw new RuntimeException("Illegal Selection Type: " + type);
        }
    }

    public void setDesc(String txt) {
        this.jTextArea1.setText(txt);
    }

    public void setNoteVisible(boolean b) {
        this.jNoteArea1.setVisible(b);
    }

    public void setNote(String txt) {
        this.jNoteArea1.setText(txt);
    }

    public void setDescVisible(boolean b) {
        this.jTextArea1.setVisible(b);
    }

    public void setMoveUpDownVisible(boolean b) {
        this.jPanel_UpDown.setVisible(b);
        if (b) {
            this._selectedListModel.setEnableSort(false);
        }
    }

    public void setData(List avail, List sele) {
        this._availableListModel.addAll(avail);
        this._selectedListModel.addAll(sele);
        this.jList_Available.setModel(this._availableListModel);
        if (this._selectionType == 1) {
            this.jList_Available.getSelectionModel().setSelectionMode(0);
        } else {
            this.jList_Available.getSelectionModel().setSelectionMode(2);
        }
        this.jList_Selected.setModel(this._selectedListModel);
        int size = sele.size();
        for (int ii = 0; ii < size; ++ii) {
            this._availableListModel.removeElement(sele.get(ii));
        }
        if (this._selectionType == 1) {
            if (this.getSelectedObjectsVector().size() > 0) {
                this.jButton_Add.setEnabled(false);
            } else {
                this.jButton_Add.setEnabled(true);
            }
        }
        this.jButton_AddAll.setEnabled(this.jList_Available.getModel().getSize() > 0);
        this.jButton_RemoveAll.setEnabled(this.jList_Selected.getModel().getSize() > 0);
    }

    public void setSelectedCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this.jList_Selected.setCellRenderer(listCellRenderer);
        }
    }

    public void setAvailableCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this.jList_Available.setCellRenderer(listCellRenderer);
        }
    }

    public void setSelectedListLabel(String label) {
        this.selectedListBorder.setTitle(label);
    }

    public void setAvailableListLabel(String label) {
        this.availListBorder.setTitle(label);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public Object[] getSelectedObjects() {
        Object[] objArray = this._selectedListModel.toArray();
        return objArray;
    }

    public Vector getSelectedObjectsVector() {
        return this._selectedListModel.getVector();
    }

    public Object[] getAvailableObjects() {
        Object[] objArray = this._availableListModel.toArray();
        return objArray;
    }

    public Vector getAvailableObjectsVector() {
        return this._availableListModel.getVector();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton_Add) {
            this.action_Add();
        } else if (e.getSource() == this.jButton_Remove) {
            this.action_Remove();
        } else if (e.getSource() == this.jButton_AddAll) {
            this.action_AddAll();
        } else if (e.getSource() == this.jButton_RemoveAll) {
            this.action_RemoveAll();
        } else if (e.getSource() == this.jButton_Up) {
            this.action_MoveUp();
        } else if (e.getSource() == this.jButton_Down) {
            this.action_MoveDown();
        }
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 8) {
            this.cmdOK_Action();
        } else if (event.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public boolean saveForm() {
        boolean valid = this.validateComponents(this.getContentPane());
        if (!valid) {
            return false;
        }
        boolean save_ok = true;
        if (save_ok) {
            this.setModified(false);
        }
        return true;
    }

    public void addTopPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        this.jPanel_Top.add(panel);
    }

    void MoverDialogJDialog_WindowClosing() {
        int retValue;
        this._canceled = true;
        if (this.isModified() && (retValue = RMAIO.postYesNoWarning(this, "Data Has Changed! Save before closing?")) == 0) {
            this.saveForm();
            this._canceled = false;
        }
        this.setVisible(false);
    }

    private void buildControls() {
        this.setTitle("Selection Editor");
        this.setSize(460, 380);
        this.setDefaultSize(470, 410);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTextArea1.setText("");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEditable(false);
        this.jNoteArea1.setText("");
        this.jNoteArea1.setLineWrap(true);
        this.jNoteArea1.setWrapStyleWord(true);
        this.jNoteArea1.setEditable(false);
        this.jTextField.setEditable(false);
        this.jPanel_TextArea.setLayout(new GridBagLayout());
        this.jPanel_Lists.setLayout(new GridBagLayout());
        this.jPanel_AddRemove.setLayout(new GridBagLayout());
        this.jPanel_UpDown.setLayout(new GridBagLayout());
        this.jPanel_UpDown.setVisible(false);
        this.jScrollPane_Available.getViewport().add(this.jList_Available);
        this.jScrollPane_Available.setOpaque(true);
        this.jScrollPane_Selected.getViewport().add(this.jList_Selected);
        this.jScrollPane_Selected.setOpaque(true);
        this.jScrollPane_Available.setBorder(this.availListBorder);
        this.jScrollPane_Selected.setBorder(this.selectedListBorder);
        this.jPanel_Top.setBackground(Color.red);
        this.getContentPane().add((Component)this.jPanel_Top, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, RmaInsets.insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.jPanel_TextArea, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_TextArea.add((Component)this.jTextArea1, new RmaGridBagConstraints(-1, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.jPanel_Lists, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Lists.add((Component)this.jScrollPane_Available, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.jPanel_Lists.add((Component)this.jPanel_AddRemove, new RmaGridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel_Lists.add((Component)this.jScrollPane_Selected, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanel_Lists.add((Component)this.jPanel_UpDown, new RmaGridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jButton_Add.setHorizontalTextPosition(2);
        this.jButton_Remove.setHorizontalTextPosition(4);
        this.jButton_AddAll.setHorizontalTextPosition(2);
        this.jButton_RemoveAll.setHorizontalTextPosition(4);
        this.jButton_Add.setHorizontalAlignment(4);
        this.jButton_Remove.setHorizontalAlignment(2);
        this.jButton_AddAll.setHorizontalAlignment(4);
        this.jButton_RemoveAll.setHorizontalAlignment(2);
        this.jPanel_AddRemove.add((Component)this.jButton_Add, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanel_AddRemove.add((Component)this.jButton_Remove, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.jPanel_AddRemove.add((Component)this.jButton_AddAll, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanel_AddRemove.add((Component)this.jButton_RemoveAll, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.jButton_Up.setHorizontalAlignment(2);
        this.jButton_Down.setHorizontalAlignment(2);
        this.jPanel_UpDown.add((Component)this.jButton_Up, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel_UpDown.add((Component)this.jButton_Down, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.jNoteArea1, new RmaGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.jNoteArea1.setVisible(false);
        this.getContentPane().add((Component)this.jPanel_CmdButton, new RmaGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 16, 2, new Insets(15, 5, 15, 5), 0, 0));
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.jButton_Add.addActionListener(this);
        this.jButton_Remove.addActionListener(this);
        this.jButton_AddAll.addActionListener(this);
        this.jButton_RemoveAll.addActionListener(this);
        this.jPanel_CmdButton.addCmdPanelListener(this);
        this.jButton_Up.addActionListener(this);
        this.jButton_Down.addActionListener(this);
        this.jList_Available.addMouseListener(this.mouseListener);
        this.jList_Selected.addMouseListener(this.mouseListener);
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource() == MoverDialog.this.jList_Available) {
                    MoverDialog.this.jButton_Add.setEnabled(MoverDialog.this.jList_Available.getSelectedIndex() != -1);
                } else if (e.getSource() == MoverDialog.this.jList_Selected) {
                    MoverDialog.this.jButton_Remove.setEnabled(MoverDialog.this.jList_Selected.getSelectedIndex() != -1);
                }
            }
        };
        this.jList_Available.addListSelectionListener(lsl);
        this.jList_Selected.addListSelectionListener(lsl);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.jButton_Add.setEnabled(false);
        this.jButton_Remove.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void action_Add() {
        Cursor oldCursor = this.getCursor();
        long debugTiming1 = System.currentTimeMillis();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object[] o = this.jList_Available.getSelectedValues();
            if (o != null && o.length > 0) {
                if (this._selectionType == 1) {
                    this.jButton_Add.setEnabled(false);
                    if (this.getSelectedObjectsVector().size() > 0) {
                        return;
                    }
                }
                this.jList_Selected.clearSelection();
                this._selectedListModel.addElements(o);
                if (this._dialogType == 0) {
                    this._availableListModel.removeElements(o);
                }
                int[] selectedIndexes = new int[o.length];
                int start = this._selectedListModel.isEnableSort() ? 0 : this._selectedListModel.size() - o.length;
                int index = 0;
                for (int ii = start; ii < this._selectedListModel.size() && index < o.length; ++ii) {
                    if (o[index] != this._selectedListModel.getElementAt(ii)) continue;
                    selectedIndexes[index] = ii;
                    ++index;
                }
                this.jList_Selected.setSelectedIndices(selectedIndexes);
                if (this._selectionType == 1 && this.getSelectedObjectsVector().size() > 0) {
                    this.jButton_Add.setSelected(false);
                }
                this.jButton_Add.setEnabled(this.jList_Available.getModel().getSize() > 0);
                this.jButton_AddAll.setEnabled(this.jList_Available.getModel().getSize() > 0);
                this.jButton_RemoveAll.setEnabled(this.jList_Selected.getModel().getSize() > 0);
            }
        }
        finally {
            if (Boolean.getBoolean("DEBUG")) {
                long t2 = System.currentTimeMillis();
                System.out.println("Time to run ADD = " + Long.toString(t2 - debugTiming1) + " ms.");
            }
            this.setCursor(oldCursor);
        }
    }

    private void action_AddAll() {
        int size = this.jList_Available.getModel().getSize();
        if (size > 0) {
            this.jList_Available.getSelectionModel().setSelectionInterval(0, size - 1);
            this.action_Add();
        }
    }

    public boolean getCaseInsensitiveSort() {
        return this._caseInsensitiveSort;
    }

    public void setCaseInsensitiveSort(boolean caseInsensitiveSort) {
        this._caseInsensitiveSort = caseInsensitiveSort;
        if (this._availableListModel != null) {
            this._availableListModel.setCaseInsensitiveSort(caseInsensitiveSort);
        }
    }

    private void sort(Object[] a) {
        if (a == null) {
            return;
        }
        boolean allComparable = true;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] instanceof Comparable) continue;
            allComparable = false;
            break;
        }
        if (allComparable) {
            if (this._caseInsensitiveSort) {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String so1 = o1.toString().toUpperCase();
                        String so2 = o2.toString().toUpperCase();
                        return so1.compareTo(so2);
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return this.toString().equalsIgnoreCase(obj.toString());
                    }
                };
                Arrays.sort(a, comparator);
            } else {
                Arrays.sort(a);
            }
        } else if (this._caseInsensitiveSort) {
            Compare compare = new Compare(){

                @Override
                public int compare(Object a, Object b, boolean ascending) {
                    String so1 = a.toString().toUpperCase();
                    String so2 = b.toString().toUpperCase();
                    return so1.compareTo(so2);
                }
            };
            RMASort.quickSort(a, true, compare);
        } else {
            RMASort.quickSort(a, true);
        }
    }

    public void setPosition(String dialogName, int defaultWidth, int defaultHeight) {
        this._dialogName = dialogName;
        if (this._dialogName == null) {
            this.setSize(defaultWidth, defaultHeight);
            if (this._owner != null) {
                this.setLocationRelativeTo(this._owner);
            }
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenSize = new Rectangle(size);
        int x = -1;
        int y = -1;
        int width = defaultWidth;
        int height = defaultHeight;
        if (this._dialogName != null) {
            x = prefs.getInt(this._dialogName + ".position.x", -1);
            y = prefs.getInt(this._dialogName + ".position.y", -1);
            int w = prefs.getInt(this._dialogName + ".size.w", -1);
            int h = prefs.getInt(this._dialogName + ".size.h", -1);
            if (w > 100 && h > 100) {
                width = w;
                height = h;
            }
        }
        if (x != -1 && y != -1 && screenSize.contains(x, y)) {
            this.setLocation(x, y);
        } else if (this._owner != null) {
            this.setLocationRelativeTo(this._owner);
        }
        this.setSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void action_Remove() {
        Cursor oldCursor = this.getCursor();
        long debugTiming1 = System.currentTimeMillis();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object[] o = this.jList_Selected.getSelectedValues();
            if (o != null && o.length > 0) {
                this._selectedListModel.removeElements(o);
                this.jList_Available.clearSelection();
                if (this._availableListAllowsDuplicates) {
                    this._availableListModel.addElements(o);
                } else {
                    for (int i = 0; i < o.length; ++i) {
                        if (this._availableListModel.contains(o[i])) continue;
                        this._availableListModel.addElement(o[i]);
                    }
                }
                int[] selectedIndexes = new int[o.length];
                this.sort(o);
                int start = 0;
                int index = 0;
                for (int ii = start; ii < this._availableListModel.size() && index < o.length; ++ii) {
                    if (o[index] != this._availableListModel.getElementAt(ii)) continue;
                    selectedIndexes[index] = ii;
                    ++index;
                }
                this.jList_Available.setSelectedIndices(selectedIndexes);
                if (this._selectionType == 1) {
                    if (this.getAvailableObjectsVector().size() > 0) {
                        this.jButton_Add.setEnabled(true);
                    } else {
                        this.jButton_Add.setEnabled(false);
                    }
                }
                this.jButton_Remove.setEnabled(this.jList_Selected.getModel().getSize() > 0);
                this.jButton_RemoveAll.setEnabled(this.jList_Selected.getModel().getSize() > 0);
                this.jButton_AddAll.setEnabled(this.jList_Available.getModel().getSize() > 0);
            }
        }
        finally {
            if (Boolean.getBoolean("DEBUG")) {
                long t2 = System.currentTimeMillis();
                System.out.println("Time to run ADD = " + Long.toString(t2 - debugTiming1) + " ms.");
            }
            this.setCursor(oldCursor);
        }
    }

    private void action_RemoveAll() {
        int size = this.jList_Selected.getModel().getSize();
        if (size > 0) {
            this.jList_Selected.getSelectionModel().setSelectionInterval(0, size - 1);
            this.action_Remove();
        }
    }

    private void action_MoveUp() {
        Object[] objs = this.jList_Selected.getSelectedValues();
        if (objs != null && objs.length > 0) {
            for (int ii = 0; ii < objs.length; ++ii) {
                int idx = this._selectedListModel.indexOf(objs[ii]);
                if (idx < 1 || ii > 0 && idx - 1 == this._selectedListModel.indexOf(objs[ii - 1])) continue;
                Object tmp = this._selectedListModel.elementAt(idx - 1);
                this._selectedListModel.setElementAt(tmp, idx);
                this._selectedListModel.setElementAt(objs[ii], idx - 1);
            }
            int[] idxs = new int[objs.length];
            for (int ii = 0; ii < objs.length; ++ii) {
                idxs[ii] = this._selectedListModel.indexOf(objs[ii]);
            }
            this.jList_Selected.setSelectedIndices(idxs);
        }
    }

    private void action_MoveDown() {
        Object[] objs = this.jList_Selected.getSelectedValues();
        if (objs != null && objs.length > 0) {
            for (int ii = objs.length - 1; ii >= 0; --ii) {
                int idx = this._selectedListModel.indexOf(objs[ii]);
                if (idx >= this._selectedListModel.size() - 1 || ii < objs.length - 1 && idx + 1 == this._selectedListModel.indexOf(objs[ii + 1])) continue;
                Object tmp = this._selectedListModel.elementAt(idx + 1);
                this._selectedListModel.setElementAt(tmp, idx);
                this._selectedListModel.setElementAt(objs[ii], idx + 1);
            }
            int[] idxs = new int[objs.length];
            for (int ii = 0; ii < objs.length; ++ii) {
                idxs[ii] = this._selectedListModel.indexOf(objs[ii]);
            }
            this.jList_Selected.setSelectedIndices(idxs);
        }
    }

    private void cmdOK_Action() {
        boolean closeForm = this.saveForm();
        if (!closeForm) {
            return;
        }
        if (this._dialogName != null) {
            Point p = this.getLocation();
            Dimension d = this.getSize();
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.putInt(this._dialogName + ".position.x", p.x);
            prefs.putInt(this._dialogName + ".position.y", p.y);
            prefs.putInt(this._dialogName + ".size.w", d.width);
            prefs.putInt(this._dialogName + ".size.h", d.height);
        }
        this.setVisible(false);
        this.dispose();
        this._canceled = false;
    }

    private void cmdCancel_Action() {
        boolean closeForm = true;
        if (this.isModified()) {
            int retValue = RMAIO.postYesNoCancelWarning(this, "Data Has Changed! Save before closing?");
            if (retValue == 2) {
                return;
            }
            if (retValue == 0) {
                closeForm = this.saveForm();
            } else if (retValue == 1) {
                // empty if block
            }
        }
        if (!closeForm) {
            return;
        }
        this.setVisible(false);
        this.dispose();
        this._canceled = true;
    }

    public void setSortEnabled(boolean sorted) {
        this._selectedListModel.setEnableSort(sorted);
        this._availableListModel.setEnableSort(sorted);
    }

    public void setDialogType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid dialog type " + type);
        }
        this._dialogType = type;
    }

    public int getDialogType() {
        return this._dialogType;
    }

    public static void main(String[] args) {
        MoverDialog mDlg = new MoverDialog(new Frame(), true);
        mDlg.setLocation(100, 100);
        mDlg.pack();
        Vector<String> v1 = new Vector<String>();
        Vector v2 = new Vector();
        Random random = new Random();
        for (int i = 0; i < 50000; ++i) {
            String value = Double.toString(random.nextDouble() * 1.0E7);
            v1.addElement(value);
            if (i % 5000 != 0) continue;
            System.out.println("Index " + i);
        }
        mDlg.setData(v1, v2);
        mDlg.setDefaultCloseOperation(2);
        mDlg.setVisible(true);
    }

    public void setListsEnabled(boolean enabled) {
        this.jPanel_Lists.setEnabled(enabled);
    }

    public void setAvailableListAllowsDuplicates(boolean allowsDuplicates) {
        this._availableListAllowsDuplicates = allowsDuplicates;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MoverDialog.this) {
                MoverDialog.this.MoverDialogJDialog_WindowClosing();
            }
        }
    }
}

