/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class NameDialog
extends RmaJDialog
implements ActionListener,
FocusListener {
    boolean _controlsCreated = false;
    protected String _description;
    protected String _label;
    protected boolean _isCanceled = true;
    protected String _mode;
    private boolean _showEmptyNameWaring = false;
    public static final String ZONE_CONFIG = "ZONE_CONFIG";
    public static final String ALTERNATIVE = "ALTERNATIVE";
    public static final String LOSS_ZONE = "LOSS_ZONE";
    public static final String BASEFLOW_ZONE = "BASEFLOW_ZONE";
    public static final int HELP = 1;
    public static final int DESCRIPTION = 2;
    protected JLabel _labelLbl;
    protected JLabel _descriptionLbl;
    protected JTextField _labelTxt;
    protected JTextArea _descriptionTxt;
    protected JScrollPane _scrollPane;
    protected JPanel panel1;
    protected JPanel buttonPanel;
    protected JButton _cmdCancel;
    protected JButton _cmdOK;
    protected JButton _cmdHelp;
    protected JPanel _compPanel;
    protected List _existingNames;

    public NameDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Name Dialog");
        this.createControls();
    }

    public NameDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Name Dialog");
        this.createControls();
    }

    public NameDialog(Dialog parent, String title, boolean modal) {
        super(parent, modal);
        this.setTitle(title);
        this.createControls();
    }

    public NameDialog(Dialog parent, String title, boolean modal, int optionalControls) {
        super(parent, modal);
        this.setTitle(title);
        this.createControls(optionalControls);
    }

    public NameDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public NameDialog(Frame parent, String title, boolean modal, int optionalControls) {
        super(parent, modal);
        this.setTitle(title);
        this.createControls(optionalControls);
    }

    public NameDialog(Frame parent) {
        this(parent, false);
    }

    public NameDialog(Dialog parent) {
        this(parent, false);
    }

    protected void createControls() {
        this.createControls(3);
    }

    protected void createControls(int optionalControls) {
        if (this._controlsCreated) {
            return;
        }
        boolean showHelp = (optionalControls & 1) > 0;
        boolean showDescription = (optionalControls & 2) > 0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 200);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultSize(400, 200);
        this._labelLbl = new JLabel("Name:");
        this._labelLbl.setDisplayedMnemonic('N');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(15, 12, 0, 0);
        this.getContentPane().add((Component)this._labelLbl, gbc);
        this._labelTxt = new RmaJTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 325;
                return d;
            }
        };
        this._labelLbl.setLabelFor(this._labelTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = showDescription ? 0.0 : 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 0, 5);
        this.getContentPane().add((Component)this._labelTxt, gbc);
        if (showDescription) {
            this._descriptionLbl = new JLabel("Description:");
            this._descriptionLbl.setDisplayedMnemonic('D');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(11, 12, 0, 0);
            this.getContentPane().add((Component)this._descriptionLbl, gbc);
            this._descriptionTxt = new JTextArea();
            this._descriptionLbl.setLabelFor(this._descriptionTxt);
            this._descriptionTxt.setLineWrap(true);
            this._descriptionTxt.setWrapStyleWord(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = new Insets(11, 5, 0, 5);
            this._scrollPane = new JScrollPane(this._descriptionTxt){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(325, 125);
                }
            };
            this.getContentPane().add((Component)this._scrollPane, gbc);
            this._scrollPane.setVerticalScrollBarPolicy(22);
            this._descriptionTxt.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    NameDialog.this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    NameDialog.this.registerEnterKey();
                }
            });
        }
        this._compPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._compPanel, gbc);
        this.buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this._cmdCancel = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 5);
        gbc.ipadx = 15;
        gbc.ipady = 0;
        this.buttonPanel.add((Component)this._cmdCancel, gbc);
        this._cmdOK = new JButton("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 5);
        gbc.ipadx = 40;
        gbc.ipady = 0;
        this.buttonPanel.add((Component)this._cmdOK, gbc);
        if (showHelp) {
            this._cmdHelp = new JButton("Help");
            this._cmdHelp.setEnabled(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 0, 5, 5);
            gbc.ipadx = 30;
            gbc.ipady = 0;
            this.buttonPanel.add((Component)this._cmdHelp, gbc);
        }
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._cmdOK.addActionListener(this);
        this._cmdCancel.addActionListener(this);
        this.addFocusListener(this);
        this.pack();
        Dimension d = this.getPreferredSize();
        this.setDefaultSize(d.width, d.height);
        this.setSize(d.width, d.height);
        this._mode = ALTERNATIVE;
        this._controlsCreated = true;
        this.getRootPane().setDefaultButton(null);
    }

    private void registerEnterKey() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NameDialog.this.enterPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._cmdOK) {
            this.cmdOk_Action(event);
        } else if (object == this._cmdCancel) {
            this.cmdCancel_Action(event);
        }
    }

    public void addAuxilaryPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        this.addAuxilaryPanel(panel, 0.0, 2);
    }

    public void addAuxilaryPanel(JPanel panel, double yweight, int fill) {
        if (panel == null) {
            return;
        }
        int ypos = this._compPanel.getComponentCount();
        this._compPanel.add((Component)panel, new GridBagConstraints(0, ypos, 1, 1, 1.0, yweight, 18, fill, new Insets(0, 0, 0, 0), 0, 0));
    }

    void Dialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    protected void cmdOk_Action(ActionEvent event) {
        if (!this.isValidData()) {
            return;
        }
        this._isCanceled = false;
        this._label = this._labelTxt.getText().trim();
        if (this._descriptionTxt != null) {
            this._description = this._descriptionTxt.getText();
        }
        this.setVisible(false);
        this.dispose();
    }

    protected boolean isValidData() {
        String name = this._labelTxt.getText().trim();
        if (name.length() == 0) {
            if (this._showEmptyNameWaring) {
                JOptionPane.showMessageDialog(this, "Please enter a name", "Empty Name", 2);
                this._labelTxt.requestFocus();
            }
            return false;
        }
        if (this._existingNames != null) {
            for (int i = 0; i < this._existingNames.size(); ++i) {
                String existingName;
                Object obj = this._existingNames.get(i);
                if (obj == null || !(existingName = obj.toString()).equalsIgnoreCase(name)) continue;
                JOptionPane.showMessageDialog(this, name + " already exists.\n Please enter a new name", "Duplicate Name", 2);
                this._labelTxt.requestFocus();
                return false;
            }
        }
        return true;
    }

    void cmdCancel_Action(ActionEvent event) {
        this._isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setNameLabel(String name) {
        this._labelLbl.setText(name);
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public String getLabel() {
        return this._label;
    }

    @Override
    public String getName() {
        return this._label;
    }

    @Override
    public void setName(String txt) {
        this._labelTxt.setText(txt);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NameDialog.this._labelTxt.selectAll();
            }
        });
    }

    public void setShowWarningForEmptyName(boolean set) {
        this._showEmptyNameWaring = set;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String txt) {
        this._descriptionTxt.setText(txt);
    }

    public void setDescriptionLablel(String txt) {
        this._descriptionLbl.setText(txt);
    }

    public void setMode(String mode) {
        this._mode = mode;
        this.updateDialog();
    }

    public void updateDialog() {
        if (this._mode.equals(LOSS_ZONE) || this._mode.equals(BASEFLOW_ZONE)) {
            this._descriptionLbl.setVisible(false);
            this._descriptionTxt.setVisible(false);
            this._scrollPane.setVisible(false);
            this.setSize(427, 150);
        } else {
            this._descriptionLbl.setVisible(true);
            this._descriptionLbl.setVisible(true);
            this._scrollPane.setVisible(true);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this._labelTxt.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    public void setAccessoryPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)panel, gbc);
        this.pack();
    }

    public static void main(String[] args) {
        NameDialog nd = new NameDialog((Frame)new JFrame(), false);
        nd.setLocation(100, 100);
        nd.setVisible(true);
    }

    public void setExistingNames(List existingNames) {
        this._existingNames = existingNames;
    }

    public void setExistingNames(String[] names) {
        if (names.length == 0) {
            return;
        }
        this._existingNames = new ArrayList();
        for (int i = 0; i < names.length; ++i) {
            this._existingNames.add(i, names[i]);
        }
    }

    public void setNameFieldDocument(Document d) {
        if (d == null) {
            return;
        }
        this._labelTxt.setDocument(d);
    }

    public void setDescriptionVisible(boolean visible) {
        this._descriptionLbl.setVisible(visible);
        this._descriptionTxt.setVisible(visible);
        this._scrollPane.setVisible(visible);
        this.pack();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == NameDialog.this) {
                NameDialog.this.Dialog1_WindowClosing(event);
            }
        }
    }
}

