/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.appInterface.AppDaddy;
import hec.event.SaveEventListener;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentIfc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;

public class PanelEditor
extends RmaJDialog
implements ClosableDialog {
    protected JPanel _panelContainer;
    protected ButtonCmdPanel cmdPanel;
    private RmaJTabbedPane tabPane;
    protected boolean _canceled = false;
    protected Vector _panelList = new Vector();
    private JMenuBar _mbar;
    private List<SaveEventListener> _saveListeners = new ArrayList<SaveEventListener>();
    boolean _saveOk = true;
    private JPanel _bottomPanel;
    private boolean _alwaysUseTabs = false;

    public PanelEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public PanelEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public PanelEditor(Window owner, boolean modal) {
        super(owner);
        this.buildControls();
        this.setModal(modal);
    }

    public PanelEditor(Frame parent) {
        super(parent);
        this.buildControls();
    }

    public PanelEditor(Dialog owner) {
        super(owner);
        this.buildControls();
    }

    public PanelEditor(Window owner) {
        super(owner);
        this.buildControls();
    }

    public PanelEditor() {
        this.buildControls();
    }

    public PanelEditor(Frame parent, boolean modal, boolean alwaysUseTabs) {
        super(parent, modal);
        this.buildControls();
        this._alwaysUseTabs = alwaysUseTabs;
    }

    public PanelEditor(Dialog parent, boolean modal, boolean alwaysUseTabs) {
        super(parent, modal);
        this.buildControls();
        this._alwaysUseTabs = alwaysUseTabs;
    }

    public PanelEditor(Window owner, boolean modal, boolean alwaysUseTabs) {
        super(owner);
        this.buildControls();
        this.setModal(modal);
        this._alwaysUseTabs = alwaysUseTabs;
    }

    public PanelEditor(boolean alwaysUseTabs) {
        this.buildControls();
        this._alwaysUseTabs = alwaysUseTabs;
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(200, 400);
        this.setLocationRelativeTo(this.getParent());
        this._mbar = new JMenuBar();
        this._panelContainer = new JPanel(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.weightx = 2.0;
        gbc.weighty = 2.0;
        this.getContentPane().add((Component)this._panelContainer, gbc);
        this._bottomPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 0, 0, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this._bottomPanel, gbc);
        this.cmdPanel = new ButtonCmdPanel(this.getButtonCmdPanelButtons());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this._bottomPanel.add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                PanelEditor.this.handleButtonCmdActionPerformed(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PanelEditor.this.windowClosing();
            }
        });
    }

    protected void handleButtonCmdActionPerformed(ActionEvent e) {
        switch (e.getID()) {
            case 8: {
                this.okButtonAction();
                break;
            }
            case 2: {
                this.applyButtonAction();
                break;
            }
            case 4: {
                this.cancelButtonAction();
            }
        }
    }

    protected int getButtonCmdPanelButtons() {
        return 14;
    }

    public void okButtonAction() {
        if (!this.applyButtonAction()) {
            return;
        }
        this._canceled = false;
        this.setVisible(false);
    }

    public boolean applyButtonAction() {
        return this.saveForm();
    }

    public void cancelButtonAction() {
        this.windowClosing();
        if (this._saveOk) {
            this.setVisible(false);
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void addPanel(AbstractEditorPanel panel) {
        if (panel == null) {
            return;
        }
        if (panel.getPanelMenus() != null && this.getJMenuBar() == null) {
            this._mbar = new JMenuBar();
            this.setJMenuBar(this._mbar);
        }
        if (this._panelContainer.getComponentCount() == 0 && !this._alwaysUseTabs) {
            this._panelContainer.add((Component)panel, "Center");
            this.buildMenus(panel);
        } else {
            if (this.tabPane == null) {
                this.tabPane = new RmaJTabbedPane();
                this.tabPane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        Component c2 = PanelEditor.this.tabPane.getSelectedComponent();
                        if (c2 instanceof AbstractEditorPanel) {
                            PanelEditor.this.buildMenus((AbstractEditorPanel)c2);
                        } else {
                            PanelEditor.this.buildMenus(null);
                        }
                    }
                });
                this._panelContainer.add((Component)this.tabPane, "Center");
                for (int i = 0; i < this._panelList.size(); ++i) {
                    AbstractEditorPanel tPanel = (AbstractEditorPanel)this._panelList.elementAt(i);
                    this.tabPane.add((Component)tPanel, tPanel.getTabname());
                }
            }
            this.tabPane.add((Component)panel, panel.getTabname());
        }
        this._panelList.add(panel);
    }

    private void buildMenus(AbstractEditorPanel panel) {
        if (this._mbar == null) {
            return;
        }
        this._mbar.removeAll();
        if (panel == null) {
            return;
        }
        Vector menus = panel.getPanelMenus();
        if (menus == null || menus.size() == 0) {
            return;
        }
        for (int i = 0; i < menus.size(); ++i) {
            Object obj = menus.get(i);
            if (!(obj instanceof JMenuItem)) continue;
            this._mbar.add((JMenuItem)obj);
        }
        this._mbar.revalidate();
        this._mbar.repaint();
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        int count = this._panelList.size();
        for (int i = 0; i < count; ++i) {
            Object obj = this._panelList.elementAt(i);
            if (!(obj instanceof AbstractEditorPanel)) continue;
            ((AbstractEditorPanel)obj).setStreamAlignment(alignment);
        }
    }

    public void fillForm(NamedType dobj) {
        this.clearForm();
        int count = this._panelList.size();
        for (int i = 0; i < count; ++i) {
            Object obj = this._panelList.elementAt(i);
            if (!(obj instanceof AbstractEditorPanel)) continue;
            ((AbstractEditorPanel)obj).fillPanel(dobj);
        }
        this.setModified(false);
    }

    public boolean saveForm() {
        return this.saveForm(null);
    }

    public boolean saveForm(NamedType dobj) {
        MapApplicationFrame frame;
        int count = this._panelList.size();
        boolean saveOk = true;
        for (int i = 0; i < count; ++i) {
            Object obj = this._panelList.elementAt(i);
            if (!(obj instanceof AbstractEditorPanel) || ((AbstractEditorPanel)obj).savePanel(dobj)) continue;
            saveOk = false;
        }
        if (saveOk) {
            this.setModified(false);
            this.fireSaveEvent();
        }
        if ((frame = (MapApplicationFrame)AppDaddy.getFrame()) != null && frame.getMapPanel() != null) {
            frame.getMapPanel().paintMap();
        }
        this._saveOk = saveOk;
        return saveOk;
    }

    public RmaJTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    public AbstractEditorPanel getCurrentPanel() {
        if (this._panelList.size() < 1) {
            return null;
        }
        if (this._panelList.size() == 1) {
            return (AbstractEditorPanel)this._panelList.get(0);
        }
        if (this.tabPane != null) {
            return (AbstractEditorPanel)this.tabPane.getSelectedComponent();
        }
        return null;
    }

    protected void windowClosing() {
        if (this.isModified() && this.isVisible()) {
            int opt = JOptionPane.showConfirmDialog(this, "Data has changed. Save/Apply Changes?", "Confirm Changes", 0);
            if (opt == 0) {
                this._saveOk = this.saveForm();
            } else {
                this._canceled = true;
                this._saveOk = true;
            }
        } else {
            this._canceled = true;
            this._saveOk = true;
        }
    }

    @Override
    public boolean closeDialog() {
        this.windowClosing();
        if (this._saveOk) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    public void addSaveListener(SaveEventListener listener) {
        if (listener == null) {
            return;
        }
        this._saveListeners.add(listener);
    }

    public void removeSaveListener(SaveEventListener listener) {
        this._saveListeners.remove(listener);
    }

    protected void fireSaveEvent() {
        for (int i = 0; i < this._saveListeners.size(); ++i) {
            this._saveListeners.get(i).saveActionPerformed(this);
        }
    }

    protected JPanel getBottomPanel() {
        return this._bottomPanel;
    }

    public void setAlwaysUseTabs(boolean alwaysUseTabs) {
        this._alwaysUseTabs = alwaysUseTabs;
    }

    public boolean shouldAlwaysUseTabs() {
        return this._alwaysUseTabs;
    }
}

