/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.model.PluginAuthor;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class PluginAuthorDialog
extends RmaJDialog {
    private PluginAuthor _authorInfo;
    private JEditorPane _authorText;
    private ButtonCmdPanel _cmdPanel;

    public PluginAuthorDialog(Window parent, PluginAuthor authorInfo, String pluginName) {
        super(parent, true);
        this._authorInfo = authorInfo;
        this.buildControls(pluginName);
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void buildControls(String pluginName) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle((pluginName != null ? pluginName : "") + " Author Information");
        this._authorText = new JEditorPane();
        this._authorText.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this._authorText.setEditable(false);
        this._authorText.setBorder(null);
        this._authorText.setBackground(this.getBackground());
        this._authorText.setText(this._authorInfo.getAuthorInfo());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._authorText, gbc);
        this._cmdPanel = new ButtonCmdPanel(256);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    private void addListeners() {
        this._authorText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String link = e.getDescription();
                    if (link == null) {
                        return;
                    }
                    PluginAuthorDialog.this.launchLink(link);
                }
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        PluginAuthorDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected void launchLink(String link) {
        URI uri;
        if (!Desktop.isDesktopSupported() || link == null || link.isEmpty()) {
            return;
        }
        try {
            uri = new URI(link);
        }
        catch (URISyntaxException e) {
            System.out.println("launchEmail:invalid email address " + link + " error:" + e);
            return;
        }
        if (link.startsWith("mailto:")) {
            try {
                Desktop.getDesktop().mail(uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

