/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class RenameDlg
extends RmaJDialog
implements ActionListener {
    RmaJTextField _nameTxt;
    RmaJDescriptionField _descriptionTxt;
    JLabel _nameLbl;
    JLabel _descriptionLbl;
    RmaJTextField _filenameTxt;
    JLabel _filenameLbl;
    JButton _okCmd;
    JButton _cancelCmd;
    JButton _helpCmd;
    private String _name = new String();
    private String _oldName = new String();
    private String _description = new String();
    private String _fileName = new String();
    private boolean _canceled = false;
    private boolean _showConfirmMsg = true;
    private List<String> _existingNames = new ArrayList<String>();

    public RenameDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.createControls();
    }

    public RenameDlg(Dialog parent, boolean modal) {
        super(parent, modal);
        this.createControls();
    }

    public RenameDlg(Frame parent, String title, boolean modal) {
        super(parent, modal);
        this.createControls();
        this.setTitle(title);
    }

    public RenameDlg(Dialog parent, String title, boolean modal) {
        super(parent, modal);
        this.createControls();
        this.setTitle(title);
    }

    private void createControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(450, 284);
        this._nameTxt = new RmaJTextField();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 10);
        this.getContentPane().add((Component)this._nameTxt, gbc);
        this._nameTxt.setTrimTrailingWhiteSpace(true);
        this._descriptionTxt = new RmaJDescriptionField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 10);
        this._descriptionTxt.setLineWrap(true);
        this._descriptionTxt.setWrapStyleWord(true);
        this.getContentPane().add((Component)this._descriptionTxt, gbc);
        this._nameLbl = new JLabel("Name:");
        this._nameLbl.setDisplayedMnemonic('N');
        this._nameLbl.setLabelFor(this._nameTxt);
        this._nameLbl.setBounds(10, 12, 48, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 0, 5);
        this.getContentPane().add((Component)this._nameLbl, gbc);
        this._descriptionLbl = new JLabel("Description:");
        this._descriptionLbl.setDisplayedMnemonic('D');
        this._descriptionLbl.setLabelFor(this._descriptionTxt);
        this._descriptionLbl.setBounds(10, 40, 77, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 0, 5);
        this.getContentPane().add((Component)this._descriptionLbl, gbc);
        this._filenameTxt = new RmaJTextField();
        this._filenameTxt.setEditable(false);
        this._filenameTxt.setBounds(87, 215, 353, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 10);
        this.getContentPane().add((Component)this._filenameTxt, gbc);
        this._filenameLbl = new JLabel("Filename:");
        this._filenameLbl.setBounds(10, 215, 66, 23);
        this._filenameLbl.setDisplayedMnemonic('F');
        this._filenameLbl.setLabelFor(this._filenameTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 0, 0);
        this.getContentPane().add((Component)this._filenameLbl, gbc);
        this._okCmd = new JButton("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.ipadx = 40;
        this.getContentPane().add((Component)this._okCmd, gbc);
        this._cancelCmd = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.ipadx = 15;
        this.getContentPane().add((Component)this._cancelCmd, gbc);
        this._helpCmd = new JButton("Help");
        this._helpCmd.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 10);
        gbc.ipadx = 30;
        this.getContentPane().add((Component)this._helpCmd, gbc);
        this.setResizable(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._cancelCmd.addActionListener(this);
        this._okCmd.addActionListener(this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this._nameTxt.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDlg.this.HandleOkCmd_Action(null);
            }
        }, KeyStroke.getKeyStroke(10, 0, false), 1);
        this._descriptionTxt.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDlg.this.HandleOkCmd_Action(null);
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
        this._nameTxt.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDlg.this.HandleCancelCmd_Action(null);
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this._descriptionTxt.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDlg.this.HandleCancelCmd_Action(null);
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.getRootPane().setDefaultButton(this._okCmd);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (RMAIO.getOSType() != 2) {
                    RenameDlg.this.toFront();
                }
                RenameDlg.this._descriptionTxt.requestFocus();
            }
        });
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.getParent());
        }
        this.fillForm();
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._cancelCmd) {
            this.HandleCancelCmd_Action(event);
        } else if (object == this._okCmd) {
            this.HandleOkCmd_Action(event);
        }
    }

    void Dialog1_WindowClosing(WindowEvent event) {
        this._canceled = true;
        this.setVisible(false);
    }

    void HandleOkCmd_Action(ActionEvent event) {
        this.validateAndSet();
        int retValue = 0;
        if (this.isEmptyNameAllowed() && this._name == null || this._name.isEmpty()) {
            if (this._showConfirmMsg) {
                RMAIO.postError(this, "The name can not be empty. Please enter a name", "Missing name");
            }
            return;
        }
        if (this._existingNames != null && this._existingNames.size() > 0 && this._existingNames.contains(this._name)) {
            RMAIO.postError(this, "The name " + this._name + " is already in use.\nPlease enter a different name.", "Duplicate Name");
            return;
        }
        if (this._showConfirmMsg) {
            retValue = RMAIO.postYesNoCancelWarning(this, "Do you really want to rename\n" + this._oldName + "?");
        }
        if (retValue == 2) {
            return;
        }
        this._canceled = retValue == 1;
        this.dispose();
    }

    void HandleCancelCmd_Action(ActionEvent event) {
        this._canceled = true;
        this.dispose();
    }

    public void validateAndSet() {
        this._name = this._nameTxt.getText();
        this._description = this._descriptionTxt.getText();
    }

    public void fillForm() {
        this._nameTxt.setText(this._name);
        this._descriptionTxt.setText(this._description);
        this._filenameTxt.setText(this._fileName);
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this._name = name;
            this._oldName = name;
        }
    }

    public void setNameFieldDocument(Document doc) {
        this._nameTxt.setDocument(doc);
    }

    public void setNameFieldVerifier(InputVerifier verifier) {
        this._nameTxt.setInputVerifier(verifier);
    }

    public void setDescription(String desc) {
        if (desc != null) {
            this._description = desc;
        }
    }

    public void setFileName(String fName) {
        if (fName != null) {
            this._fileName = fName;
        }
    }

    public void setFileNameVisible(boolean b) {
        this._filenameTxt.setVisible(b);
        this._filenameLbl.setVisible(b);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean getCanceled() {
        return this._canceled;
    }

    public void removeFileComponents() {
        this.getContentPane().remove(this._filenameLbl);
        this.getContentPane().remove(this._filenameTxt);
    }

    public void removeDescriptionComponents() {
        this.getContentPane().remove(this._descriptionLbl);
        this.getContentPane().remove(this._descriptionTxt);
    }

    public void setShowConfirmMsg(boolean b) {
        this._showConfirmMsg = b;
    }

    public void setNameEditable(boolean editable) {
        this._nameTxt.setEditable(editable);
        if (!editable) {
            this._showConfirmMsg = false;
        }
    }

    public void setEmptyNameAllowed(boolean allowed) {
        this._nameTxt.setEmptyOk(allowed);
    }

    public boolean isEmptyNameAllowed() {
        return this._nameTxt.isEmptyOk();
    }

    public void setExistingNames(List<String> existingNames) {
        if (existingNames != null) {
            this._existingNames.addAll(existingNames);
        }
    }

    public void setHelpCommandVisible(boolean visible) {
        this._helpCmd.setVisible(visible);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RenameDlg.this) {
                RenameDlg.this.Dialog1_WindowClosing(event);
            }
        }
    }
}

