/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.AbstractSelectorPanel;
import hec.lang.NamedType;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class SelectorPanel
extends AbstractSelectorPanel {
    private RmaJComboBox _selectionList;

    public SelectorPanel(int mode) {
        super(mode);
    }

    public SelectorPanel() {
    }

    @Override
    protected void buildControls(int mode) {
        super.buildControls(mode);
        this.navPanel.fillForm(this._selectionList);
    }

    @Override
    protected JComponent createSelectorField() {
        this._selectionList = new RmaJComboBox(new RmaListModel(true)){

            @Override
            public String getToolTipText(MouseEvent e) {
                Object obj;
                if (e.isAltDown() && e.isControlDown() && e.isShiftDown() && (obj = this.getSelectedItem()) != null) {
                    return "Selected Object is a " + obj.getClass().getName();
                }
                return super.getToolTipText(e);
            }
        };
        return this._selectionList;
    }

    @Override
    protected void addListeners() {
        this._selectionList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                Object obj = SelectorPanel.this._selectionList.getSelectedItem();
                if (obj instanceof NamedType) {
                    SelectorPanel.this.descriptionTxt.setText(((NamedType)obj).getDescription());
                }
            }
        });
    }

    @Override
    public List getSelectorItems() {
        RmaListModel listModel = (RmaListModel)this._selectionList.getModel();
        return listModel.getList();
    }

    public void setSortingEnabled(boolean enabled) {
        ((RmaListModel)this._selectionList.getModel()).setEnableSort(enabled);
    }

    public boolean isSortingEnabled() {
        return ((RmaListModel)this._selectionList.getModel()).isEnableSort();
    }

    public RmaJComboBox getComboBox() {
        return this._selectionList;
    }

    public void addItemListener(ItemListener listener) {
        this._selectionList.addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this._selectionList.removeItemListener(listener);
    }

    @Override
    public Object getSelectedItem() {
        return this._selectionList.getSelectedItem();
    }

    @Override
    public int getSelectedIndex() {
        return this._selectionList.getSelectedIndex();
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this._selectionList.setSelectedIndex(-1);
            return;
        }
        this._selectionList.setSelectedItem(item);
    }

    @Override
    public void setSelectedIndex(int index) {
        this._selectionList.setSelectedIndex(index);
    }

    @Override
    public void setSelectionList(Collection list) {
        RmaListModel model = (RmaListModel)this._selectionList.getModel();
        this.deleteObserver(model.getList());
        this.addObserver(list);
        model.setAll(list);
        if (list != null && list.size() > 0) {
            this.setSelectedItem(((RmaListModel)this._selectionList.getModel()).firstElement());
        } else {
            this.setSelectedIndex(-1);
        }
    }

    @Override
    public void setSelectionList(Object[] list) {
        RmaListModel model = (RmaListModel)this._selectionList.getModel();
        this.deleteObserver(model.getList());
        model.setAll(list);
        this.addObserver(model.getList());
        if (list != null && list.length > 0) {
            this.setSelectedItem(list[0]);
        }
    }

    @Override
    public void addSelectionItem(Object item, boolean select) {
        if (item == null) {
            return;
        }
        if (item instanceof Observable) {
            ((Observable)item).addObserver(this);
        }
        ((RmaListModel)this._selectionList.getModel()).addElement(item);
        this.updateNavPanel();
        if (select) {
            this.setSelectedItem(item);
        }
    }

    public void addSelectionItem(Object item, boolean select, int index) {
        if (item == null) {
            return;
        }
        if (item instanceof Observable) {
            ((Observable)item).addObserver(this);
        }
        if (index < 0) {
            ((RmaListModel)this._selectionList.getModel()).addElement(item);
        } else {
            ((RmaListModel)this._selectionList.getModel()).add(index, item);
        }
        this.updateNavPanel();
        if (select) {
            this.setSelectedItem(item);
        }
    }

    @Override
    public void removeSelectionItem(Object item) {
        if (item == null) {
            return;
        }
        if (item instanceof Observable) {
            ((Observable)item).deleteObserver(this);
        }
        ((RmaListModel)this._selectionList.getModel()).removeElement(item);
        this.updateNavPanel();
        if (this._selectionList.getItemCount() > 0) {
            this._selectionList.setSelectedIndex(0);
        } else {
            this._selectionList.setSelectedIndex(-1);
        }
    }

    @Override
    public void updateNavPanel() {
        this.navPanel.fillForm(this._selectionList);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable == null || arg == null) {
            return;
        }
        if (!"NAME_CHANGED".equals(arg)) {
            return;
        }
        RmaListModel model = (RmaListModel)this._selectionList.getModel();
        List items = model.getList();
        for (int i = 0; i < items.size(); ++i) {
            Object obj = items.get(i);
            if (obj != observable) continue;
            this.revalidate();
            return;
        }
        observable.deleteObserver(this);
    }

    public void setSelectorEditor(ComboBoxEditor editor) {
        this._selectionList.setEditor(editor);
    }

    public void setSelectorEditable(boolean editable) {
        this._selectionList.setEditable(editable);
    }

    public boolean isSelectorEditable() {
        return this._selectionList.isEditable();
    }
}

