/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.PanelEditor;
import hec.gui.SelectorPanel;
import hec.lang.NamedType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JComboBox;
import rma.swing.RmaInsets;

public class SelectorPanelEditor
extends PanelEditor {
    protected SelectorPanel selectorPanel = null;
    protected NamedType _selectedItem;
    private ItemListener _itemListener;
    private boolean _savingForm;

    public SelectorPanelEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public SelectorPanelEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public SelectorPanelEditor(Dialog parent, boolean modal, SelectorPanel panel) {
        super(parent, modal);
        this.selectorPanel = panel;
        this.buildControls();
    }

    public SelectorPanelEditor(Frame parent, boolean modal, SelectorPanel panel) {
        super(parent, modal);
        this.selectorPanel = panel;
        this.buildControls();
    }

    private void buildControls() {
        if (this.selectorPanel == null) {
            this.selectorPanel = new SelectorPanel();
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.weightx = 2.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.selectorPanel, gbc);
        this._itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    if (SelectorPanelEditor.this.isIgnoreModifiedEvents()) {
                        return;
                    }
                    Object src = e.getSource();
                    if (src instanceof JComboBox) {
                        JComboBox comboBox = (JComboBox)src;
                        comboBox.hidePopup();
                    }
                    SelectorPanelEditor.this.windowClosing();
                    return;
                }
                Object obj = SelectorPanelEditor.this.selectorPanel.getSelectedItem();
                if (obj instanceof NamedType) {
                    SelectorPanelEditor.this.fillForm((NamedType)obj);
                }
            }
        };
        this.selectorPanel.addItemListener(this._itemListener);
    }

    public void undoAllChanges() {
        Object obj = this.selectorPanel.getSelectedItem();
        if (obj instanceof NamedType) {
            this.fillForm((NamedType)obj);
        }
    }

    @Override
    public void fillForm(NamedType nt) {
        this._selectedItem = nt;
        this.selectorPanel.setSelectedItem(nt);
        super.fillForm(nt);
        if (nt != null) {
            this.selectorPanel.setDescription(nt.getDescription());
        }
    }

    public void setNavPanelVisible(boolean b) {
        this.selectorPanel.setNavPanelVisible(b);
    }

    public boolean isNavPanelVisible() {
        return this.selectorPanel.isNavPanelVisible();
    }

    public void setSelectionList(Collection list) {
        this.selectorPanel.removeItemListener(this._itemListener);
        this.selectorPanel.setSelectionList(list);
        this.selectorPanel.addItemListener(this._itemListener);
        this.selectorPanel.setSelectedIndex(-1);
    }

    public void setSelectionList(Object[] list) {
        this.selectorPanel.setSelectionList(list);
        this.selectorPanel.setSelectedIndex(-1);
    }

    public void setAutoPanelVisible(boolean b) {
        this.selectorPanel.setVisible(b);
    }

    @Override
    public boolean saveForm() {
        this._savingForm = true;
        try {
            if (!super.saveForm()) {
                boolean bl = false;
                return bl;
            }
            if (this._selectedItem != null) {
                this._selectedItem.setDescription(this.selectorPanel.getDescription());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._savingForm = false;
        }
    }

    public SelectorPanel getSelectorPanel() {
        return this.selectorPanel;
    }

    public boolean isSavingForm() {
        return this._savingForm;
    }
}

