/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.AbstractSelectorPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import rma.swing.RmaJTextField;
import rma.swing.event.RecordSelectorListener;

public class SelectorTextPanel
extends AbstractSelectorPanel
implements RecordSelectorListener {
    private RmaJTextField _selectionField;
    private List<Object> _selectionList = new ArrayList<Object>();
    private int _selectedIndex;
    private Object _selectedItem;

    public SelectorTextPanel(int mode) {
        super(mode);
    }

    public SelectorTextPanel() {
    }

    @Override
    protected void addListeners() {
        this.navPanel.addRecordSelectorListener(this);
    }

    @Override
    public void addSelectionItem(Object item, boolean select) {
        this._selectionList.add(item);
        if (select) {
            this.fillPanel(item);
        }
    }

    @Override
    protected JComponent createSelectorField() {
        this._selectionField = new RmaJTextField();
        return this._selectionField;
    }

    @Override
    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedItem;
    }

    @Override
    public List getSelectorItems() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this._selectionList);
        return l;
    }

    @Override
    public void removeSelectionItem(Object item) {
        this._selectionList.remove(item);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this._selectionList.size()) {
            return;
        }
        Object obj = this._selectionList.get(index);
        this.fillPanel(obj);
    }

    @Override
    public void setSelectedItem(Object item) {
        this.fillPanel(item);
    }

    @Override
    public void setSelectionList(Collection list) {
        this._selectionList.clear();
        if (list != null) {
            this._selectionList.addAll(list);
        }
        this.navPanel.setNumRecords(this._selectionList.size());
        if (this._selectionList.size() > 0) {
            this.fillPanel(this._selectionList.get(0));
        } else {
            this.fillPanel(null);
        }
    }

    @Override
    public void setSelectionList(Object[] list) {
        this._selectionList.clear();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this._selectionList.add(list[i]);
            }
        }
        this.navPanel.setNumRecords(this._selectionList.size());
        if (this._selectionList.size() > 0) {
            this.fillPanel(this._selectionList.get(0));
        } else {
            this.fillPanel(null);
        }
    }

    protected void fillPanel(Object object) {
        if (object == null) {
            this._selectedItem = null;
            this._selectedIndex = -1;
            this._selectionField.setText("");
            this._selectionField.setEnabled(false);
            this.navPanel.setRecordPosition(0);
            return;
        }
        String text = object.toString();
        this._selectedItem = object;
        this._selectedIndex = this._selectionList.indexOf(object);
        this._selectionField.setText(text);
        this._selectionField.setEnabled(true);
        this.navPanel.setRecordPosition(this._selectedIndex);
    }

    @Override
    public void updateNavPanel() {
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable == null || arg == null) {
            return;
        }
        if (!"NAME_CHANGED".equals(arg)) {
            return;
        }
        int size = this._selectionList.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this._selectionList.get(i);
            if (obj != observable) continue;
            this.revalidate();
            return;
        }
        observable.deleteObserver(this);
    }

    @Override
    public boolean newRecord() {
        System.out.println("RecordSelectorListener.newRecord TODO implement me");
        return false;
    }

    @Override
    public boolean selectRecord(int recordNum) {
        if (recordNum < 0 || recordNum > this._selectionList.size()) {
            return false;
        }
        Object item = this._selectionList.get(recordNum);
        if (item == null) {
            return false;
        }
        String text = item.toString();
        this._selectedItem = item;
        this._selectionField.setText(text);
        this._selectionField.setEnabled(true);
        this._selectedIndex = recordNum;
        return true;
    }
}

