/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.PanelEditor;
import hec.gui.TimeZonePanel;
import hec.gui.plaf.basic.BasicTimeZoneFieldUI;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TimeZone;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TimeZoneField
extends JTextField {
    private static final String uiClassID = "TimeZoneFieldUI";
    private TimeZone timeZone;
    private boolean enableTool = true;
    private PanelEditor chooserDialog;
    private TimeZonePanel timeZonePanel;

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public TimeZoneField() {
        this.setEditable(false);
    }

    public TimeZoneField(TimeZone timeZone) {
        this.setTimeZone(timeZone);
        this.setMouseListener();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        if (timeZone != null) {
            this.setText(timeZone.getID());
        } else {
            this.setText("");
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void enableTool(boolean enable) {
        this.enableTool = enable;
    }

    public boolean isToolEnabled() {
        return this.enableTool;
    }

    private void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (!TimeZoneField.this.enableTool) {
                        return;
                    }
                    TimeZoneField.this.displayChooserDialog();
                }
            }
        });
    }

    public void displayChooserDialog() {
        if (this.chooserDialog == null) {
            Window c2 = SwingUtilities.windowForComponent(this);
            this.chooserDialog = c2 instanceof Frame ? new PanelEditor((Frame)c2, true) : new PanelEditor((Dialog)c2, true);
            this.timeZonePanel = new TimeZonePanel();
            this.timeZonePanel.setInternationalOnly();
            this.chooserDialog.setTitle("Select a Time Zone");
            this.chooserDialog.addPanel(this.timeZonePanel);
        }
        this.timeZonePanel.setSelectedTimeZone(this.timeZone);
        this.chooserDialog.fillForm(null);
        this.chooserDialog.pack();
        this.chooserDialog.setVisible(true);
        if (this.chooserDialog.isCanceled()) {
            return;
        }
        this.setTimeZone(this.timeZonePanel.getSelectedTimeZone());
    }

    static {
        UIManager.put(uiClassID, "hec.gui.plaf.basic.BasicTimeZoneFieldUI");
        new BasicTimeZoneFieldUI();
    }
}

