/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.AbstractEditorPanel;
import hec.gui.PanelEditor;
import hec.lang.NamedType;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.swing.event.ReflectListener;

public class TimeZonePanel
extends AbstractEditorPanel {
    private final String USE_DLS = "Time Zone DOES Use Daylight Savings";
    private final String NOUSE_DLS = "Time Zone DOES NOT Use Daylight Savings";
    private final String TAB_NAME = "Time Zone";
    private static final int SCROLL_LEFT = 0;
    private static final int SCROLL_RIGHT = 1;
    private static int NUM_PIXELS_PER_TIME_ZONE = 100;
    private String[] m_timeZoneIds = null;
    private String[] m_timeZonesLabels = null;
    private static final String[] m_usTimeZones = new String[]{"(GMT -10:00) Hawaii", "(GMT -09:00) Alaska", "(GMT -08:00) Pacific Time", "(GMT -07:00) Mountain Time", "(GMT -06:00) Central Time", "(GMT -05:00) Eastern Time", "(GMT -04:00) Atlantic Time", "(GMT -00:00) Greenwich Mean Time"};
    private static final int[] m_usGmtOffsets = new int[]{-10, -9, -8, -7, -6, -5, -4, 0};
    private static final int hours2millis = 3600000;
    private static final int[] millisUSGmtOffsets = new int[]{-36000000, -32400000, -28800000, -25200000, -21600000, -18000000, -14400000, 0};
    private static final String[] m_usTimeZoneIds = new String[]{"GMT-10:00", "GMT-09:00", "GMT-08:00", "GMT-07:00", "GMT-06:00", "GMT-05:00", "GMT-04:00", "GMT-00:00"};
    private int m_defaultTimeZoneIndex = -1;
    private int _oldHoursOffset;
    protected RmaJComboBox timeZoneCombo = new RmaJComboBox();
    private JLabel useDayLightSavings = new JLabel("Time Zone DOES Use Daylight Savings");
    private JLabel globeImageLabel = null;
    private ImageIcon m_globeImage = null;
    private JRadioButton _usTzRadio = new RmaJRadioButton("U.S. Time Zones", true);
    protected JRadioButton _intTzRadio = new RmaJRadioButton("International Time Zones");
    private boolean _onlyStandardTimeZones;
    private Map<String, Integer> _stdTimeZones;
    String[] _stdTimeZonesLabels;

    public TimeZonePanel() {
        this.buildDefaultTimeZoneList();
        this.buildControls();
    }

    public static List<String> getUsTimeZoneIdentifiers() {
        return Collections.unmodifiableList(Arrays.asList(m_usTimeZoneIds));
    }

    public List<String> getStdTimeZoneIdentifiers() {
        return Collections.unmodifiableList(Arrays.asList(this._stdTimeZonesLabels));
    }

    public static TimeZone matchUsTimeZones(TimeZone dssTimeZone) {
        TimeZone timeZoneUS = null;
        if (dssTimeZone.useDaylightTime()) {
            return timeZoneUS;
        }
        int millisDssRawOffset = dssTimeZone.getRawOffset();
        for (int ii = 0; ii < millisUSGmtOffsets.length; ++ii) {
            if (millisDssRawOffset != millisUSGmtOffsets[ii]) continue;
            timeZoneUS = TimeZone.getTimeZone(m_usTimeZoneIds[ii]);
            break;
        }
        return timeZoneUS;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel settingPanel = new JPanel(new GridBagLayout());
        settingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0);
        this.add((Component)settingPanel, gbc);
        settingPanel.add((Component)this._usTzRadio, gbc);
        gbc.gridx = 1;
        settingPanel.add((Component)this._intTzRadio, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        this.timeZoneCombo.setModel(new DefaultComboBoxModel<String>(m_usTimeZones));
        settingPanel.add((Component)this.timeZoneCombo, gbc);
        this.m_globeImage = RmaImage.getImageIcon("Images/globe.gif");
        NUM_PIXELS_PER_TIME_ZONE = this.m_globeImage.getIconWidth() / 24;
        JPanel imagePanel = new JPanel(new GridBagLayout());
        this.globeImageLabel = new JLabel(this.m_globeImage);
        imagePanel.add((Component)this.globeImageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, RmaInsets.insets(0, 0, 0, 0), 0, 0));
        this.add((Component)imagePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.useDayLightSavings, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        imagePanel.setBorder(new BevelBorder(1));
        this.m_defaultTimeZoneIndex = m_usGmtOffsets.length - 1;
        if (this.m_defaultTimeZoneIndex != -1) {
            this.timeZoneCombo.setSelectedIndex(this.m_defaultTimeZoneIndex);
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            this.rotateGlobeImage(TimeZone.getTimeZone(this.m_timeZoneIds[this.m_defaultTimeZoneIndex]).getRawOffset() / 3600000);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._intTzRadio);
        bg.add(this._usTzRadio);
        ActionListener buttonAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == TimeZonePanel.this._intTzRadio) {
                    if (TimeZonePanel.this._onlyStandardTimeZones) {
                        TimeZonePanel.this.timeZoneCombo.setModel(new DefaultComboBoxModel<String>(TimeZonePanel.this._stdTimeZonesLabels));
                    } else {
                        TimeZonePanel.this.timeZoneCombo.setModel(new DefaultComboBoxModel<String>(TimeZonePanel.this.m_timeZonesLabels));
                    }
                } else if (e.getSource() == TimeZonePanel.this._usTzRadio) {
                    TimeZonePanel.this.timeZoneCombo.setModel(new DefaultComboBoxModel<String>(m_usTimeZones));
                }
                TimeZonePanel.this.timeZoneComboAction();
            }
        };
        this._intTzRadio.addActionListener(buttonAL);
        this._usTzRadio.addActionListener(buttonAL);
        this._intTzRadio.setMnemonic('I');
        this._usTzRadio.setMnemonic('U');
        this.timeZoneCombo.addActionListener(new ReflectListener(this, "timeZoneComboAction"));
        this.timeZoneCombo.setModifiable(true);
        this.timeZoneComboAction();
    }

    protected void buildDefaultTimeZoneList() {
        this.m_timeZoneIds = TimeZone.getAvailableIDs();
        this.m_timeZonesLabels = new String[this.m_timeZoneIds.length];
        this._stdTimeZones = new HashMap<String, Integer>();
        TimeZone tz = null;
        TimeZone defaultTz = TimeZone.getDefault();
        ArrayList<String> stdTimeZoneLabels = new ArrayList<String>();
        for (int i = 0; i < this.m_timeZoneIds.length; ++i) {
            tz = TimeZone.getTimeZone(this.m_timeZoneIds[i]);
            int hrOffset = tz.getRawOffset() / 3600000;
            if (defaultTz.getID().equals(this.m_timeZoneIds[i])) {
                this.m_defaultTimeZoneIndex = i;
            }
            this.m_timeZonesLabels[i] = "(GMT " + hrOffset + ") " + this.m_timeZoneIds[i];
            this.m_timeZonesLabels[i] = hrOffset < 0 ? "(GMT " + hrOffset + ":00) " + this.m_timeZoneIds[i] : "(GMT +" + hrOffset + ":00) " + this.m_timeZoneIds[i];
            if (tz.useDaylightTime()) continue;
            this._stdTimeZones.put(this.m_timeZonesLabels[i], i);
            stdTimeZoneLabels.add(this.m_timeZonesLabels[i]);
        }
        this._stdTimeZonesLabels = new String[stdTimeZoneLabels.size()];
        stdTimeZoneLabels.toArray(this._stdTimeZonesLabels);
    }

    public void timeZoneComboAction() {
        int oldHoursOffset;
        int newHoursOffset = -1;
        if (this._intTzRadio.isSelected()) {
            int index;
            if (this._onlyStandardTimeZones) {
                String tzLabel = (String)this.timeZoneCombo.getSelectedItem();
                index = this._stdTimeZones.get(tzLabel);
            } else {
                index = this.timeZoneCombo.getSelectedIndex();
            }
            if (TimeZone.getTimeZone(this.m_timeZoneIds[index]).useDaylightTime()) {
                this.useDayLightSavings.setText("Time Zone DOES Use Daylight Savings");
            } else {
                this.useDayLightSavings.setText("Time Zone DOES NOT Use Daylight Savings");
            }
            newHoursOffset = TimeZone.getTimeZone(this.m_timeZoneIds[index]).getRawOffset() / 3600000;
            oldHoursOffset = this._oldHoursOffset;
        } else {
            int index = this.timeZoneCombo.getSelectedIndex();
            this.useDayLightSavings.setText("Time Zone DOES NOT Use Daylight Savings");
            if (index > -1) {
                newHoursOffset = m_usGmtOffsets[index];
            }
            oldHoursOffset = this._oldHoursOffset;
        }
        this.useDayLightSavings.repaint();
        this._oldHoursOffset = newHoursOffset;
        final int diff = newHoursOffset - oldHoursOffset;
        final int finalNewHoursOffset = newHoursOffset;
        final int finalOldHoursOffset = oldHoursOffset;
        if (diff == 0) {
            return;
        }
        Runnable drawThread = new Runnable(){

            @Override
            public void run() {
                if (diff < 0) {
                    for (int i = finalOldHoursOffset; i != finalNewHoursOffset - 1; --i) {
                        TimeZonePanel.this.rotateGlobeImage(i);
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } else {
                    for (int i = finalOldHoursOffset; i != finalNewHoursOffset + 1; ++i) {
                        TimeZonePanel.this.rotateGlobeImage(i);
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Thread worker = new Thread(drawThread, "Globe Drawing Thread");
        worker.start();
    }

    @Override
    public void fillPanel(NamedType dobj) {
    }

    @Override
    public String getTabname() {
        return "Time Zone";
    }

    @Override
    public boolean savePanel(NamedType dobj) {
        return true;
    }

    public void fillPanel() {
    }

    public void clearPanel() {
        this.timeZoneCombo.setSelectedIndex(-1);
    }

    public TimeZone getSelectedTimeZone() {
        int index = this.timeZoneCombo.getSelectedIndex();
        if (this._intTzRadio.isSelected()) {
            if (this._onlyStandardTimeZones) {
                String tzLabel = (String)this.timeZoneCombo.getSelectedItem();
                index = this._stdTimeZones.get(tzLabel);
            }
            if (index < 0 || index >= this.m_timeZoneIds.length) {
                return null;
            }
            return TimeZone.getTimeZone(this.m_timeZoneIds[index]);
        }
        if (index < 0 || index >= m_usTimeZones.length) {
            return null;
        }
        String tzs = "GMT" + Integer.toString(m_usGmtOffsets[index]) + ":00";
        return TimeZone.getTimeZone(tzs);
    }

    public void setSelectedTimeZone(TimeZone tz) {
        this.setSelectedTimeZone(tz, false);
    }

    public void setSelectedTimeZone(TimeZone tz, boolean swapBetweenUSAndIntenational) {
        String[] secondaryIdArray;
        String[] primaryIdArray;
        if (tz == null) {
            return;
        }
        String tzid = tz.getID();
        if (tzid.contains("+00:00")) {
            tzid = tzid.replace('+', '-');
        }
        if (this._intTzRadio.isSelected()) {
            primaryIdArray = this.m_timeZoneIds;
            secondaryIdArray = m_usTimeZoneIds;
        } else {
            primaryIdArray = m_usTimeZoneIds;
            secondaryIdArray = this.m_timeZoneIds;
        }
        int primaryIdx = -1;
        for (int i = 0; i < primaryIdArray.length; ++i) {
            if (!primaryIdArray[i].equals(tzid)) continue;
            primaryIdx = i;
            break;
        }
        if (primaryIdx > -1 && primaryIdx < this.timeZoneCombo.getModel().getSize()) {
            this.timeZoneCombo.setSelectedIndex(primaryIdx);
            this.timeZoneComboAction();
        } else if (swapBetweenUSAndIntenational) {
            int secondaryIdx = -1;
            for (int i = 0; i < secondaryIdArray.length; ++i) {
                if (!secondaryIdArray[i].equals(tzid)) continue;
                secondaryIdx = i;
                break;
            }
            if (secondaryIdx > -1) {
                if (this._intTzRadio.isSelected()) {
                    this._usTzRadio.doClick();
                } else {
                    this._intTzRadio.doClick();
                }
                this.timeZoneCombo.setSelectedIndex(secondaryIdx);
                this.timeZoneComboAction();
            }
        }
    }

    public void setInternationalDefault(boolean useInternational) {
        this._intTzRadio.setSelected(useInternational);
    }

    public void setInternationalOnly() {
        this._intTzRadio.doClick(0);
        this._intTzRadio.setVisible(false);
        this._usTzRadio.setVisible(false);
        ((JComponent)this._usTzRadio.getParent()).setBorder(null);
    }

    public void setStandardTimeZonesOnly(boolean tf) {
        this._onlyStandardTimeZones = tf;
    }

    private void rotateGlobeImage(int numHours) {
        int offsetRight;
        int offsetLeft;
        int w = this.m_globeImage.getIconWidth();
        int h = this.m_globeImage.getIconHeight();
        if (w < 0 || h < 0) {
            return;
        }
        BufferedImage bImage = new BufferedImage(w, h, 1);
        if (numHours > 0) {
            offsetLeft = -1 * Math.abs(numHours) * NUM_PIXELS_PER_TIME_ZONE;
            offsetRight = (25 - Math.abs(numHours)) * NUM_PIXELS_PER_TIME_ZONE;
        } else {
            offsetRight = Math.abs(numHours) * NUM_PIXELS_PER_TIME_ZONE;
            offsetLeft = -1 * (25 - Math.abs(numHours)) * NUM_PIXELS_PER_TIME_ZONE;
        }
        Graphics2D g = (Graphics2D)bImage.getGraphics();
        Rectangle rect = new Rectangle(0, 0, this.m_globeImage.getIconWidth(), this.m_globeImage.getIconHeight());
        g.setClip(rect.x, rect.y, rect.width, rect.height);
        AffineTransform at = new AffineTransform();
        g.translate(offsetLeft, 0);
        g.drawImage(this.m_globeImage.getImage(), at, null);
        g.translate(-1 * offsetLeft, 0);
        g.translate(offsetRight, 0);
        g.drawImage(this.m_globeImage.getImage(), at, null);
        this.globeImageLabel.setIcon(new ImageIcon(bImage, ""));
        this.globeImageLabel.repaint();
    }

    public int getHoursOffset() {
        int idx = this.timeZoneCombo.getSelectedIndex();
        if (this._usTzRadio.isSelected()) {
            if (idx < 0) {
                return -1;
            }
            return m_usGmtOffsets[idx];
        }
        if (this._onlyStandardTimeZones) {
            String tzLabel = (String)this.timeZoneCombo.getSelectedItem();
            idx = this._stdTimeZones.get(tzLabel);
        }
        return TimeZone.getTimeZone(this.m_timeZoneIds[idx]).getRawOffset() / 3600000;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PanelEditor pe = new PanelEditor((Frame)null, true);
        TimeZonePanel tzp = new TimeZonePanel();
        pe.addPanel(tzp);
        pe.setTitle("Select Time Zone");
        pe.pack();
        pe.setVisible(true);
        TimeZone selectedTimeZone = tzp.getSelectedTimeZone();
        Logger logger = Logger.getLogger(TimeZonePanel.class.getName());
        logger.info(selectedTimeZone.toString());
        System.exit(0);
    }
}

