/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.data.Units;
import hec.data.UsgsRounder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class VerticalDatumOffsetPanel
extends JPanel {
    protected JTextField offset1TF;
    protected JTextField offset2TF;
    protected JTextField localDatumNameTF;
    protected JComboBox<String> unitCB;
    protected JCheckBox offset1EstimatedCKB;
    protected JCheckBox offset2EstimatedCKB;
    protected JLabel offset1Label;
    protected JLabel offset2Label;
    protected JLabel lblLocalDatumName;
    protected JComboBox<String> nativeDatumCB;
    protected double elevation;

    public VerticalDatumOffsetPanel() {
        this.setPreferredSize(new Dimension(168, 200));
        this.setBorder(new TitledBorder(null, "Vertical Datum Offsets", 4, 2, null, null));
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.unitCB = new JComboBox();
        this.unitCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toUnit = VerticalDatumOffsetPanel.this.unitCB.getItemAt(VerticalDatumOffsetPanel.this.unitCB.getSelectedIndex());
                String fromUnit = toUnit.equals("ft") ? "m" : "ft";
                try {
                    UsgsRounder rounder = new UsgsRounder("6666666669");
                    double factor = Units.convertUnits(1.0, fromUnit, toUnit);
                    if (VerticalDatumOffsetPanel.this.elevation != -3.4028234663852886E38) {
                        VerticalDatumOffsetPanel.this.elevation = rounder.round(VerticalDatumOffsetPanel.this.elevation * factor);
                    }
                    if (VerticalDatumOffsetPanel.this.offset1TF != null && VerticalDatumOffsetPanel.this.offset1TF.getText().length() > 0) {
                        VerticalDatumOffsetPanel.this.offset1TF.setText(Double.toString(rounder.round(Double.parseDouble(VerticalDatumOffsetPanel.this.offset1TF.getText()) * factor)));
                    }
                    if (VerticalDatumOffsetPanel.this.offset2TF != null && VerticalDatumOffsetPanel.this.offset2TF.getText().length() > 0) {
                        VerticalDatumOffsetPanel.this.offset2TF.setText(Double.toString(rounder.round(Double.parseDouble(VerticalDatumOffsetPanel.this.offset2TF.getText()) * factor)));
                    }
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
        this.unitCB.setModel(new DefaultComboBoxModel<String>(new String[]{"ft", "m"}));
        this.unitCB.setSelectedIndex(0);
        this.add(this.unitCB);
        JLabel lblOffsetUnit = new JLabel("Offset Unit");
        springLayout.putConstraint("North", (Component)lblOffsetUnit, 3, "North", this.unitCB);
        this.add(lblOffsetUnit);
        JLabel lblNativeDatum = new JLabel("Native Datum");
        springLayout.putConstraint("West", (Component)lblOffsetUnit, 0, "West", (Component)lblNativeDatum);
        springLayout.putConstraint("North", (Component)lblNativeDatum, 13, "North", (Component)this);
        springLayout.putConstraint("West", (Component)lblNativeDatum, 10, "West", (Component)this);
        this.add(lblNativeDatum);
        this.nativeDatumCB = new JComboBox();
        this.nativeDatumCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VerticalDatumOffsetPanel.this.setView();
            }
        });
        springLayout.putConstraint("North", this.unitCB, 6, "South", this.nativeDatumCB);
        springLayout.putConstraint("West", this.unitCB, 0, "West", this.nativeDatumCB);
        springLayout.putConstraint("North", this.nativeDatumCB, -3, "North", (Component)lblNativeDatum);
        springLayout.putConstraint("West", this.nativeDatumCB, 6, "East", (Component)lblNativeDatum);
        this.nativeDatumCB.setModel(new DefaultComboBoxModel<String>(new String[]{"NGVD 29", "NAVD 88", "OTHER"}));
        this.add(this.nativeDatumCB);
        this.offset1TF = new JTextField();
        ((PlainDocument)this.offset1TF.getDocument()).setDocumentFilter(new FloatFilter());
        springLayout.putConstraint("North", (Component)this.offset1TF, 4, "South", this.unitCB);
        springLayout.putConstraint("West", (Component)this.offset1TF, 0, "West", (Component)lblOffsetUnit);
        this.add(this.offset1TF);
        this.offset1TF.setColumns(7);
        this.offset1EstimatedCKB = new JCheckBox("Estimated");
        springLayout.putConstraint("North", (Component)this.offset1EstimatedCKB, -1, "North", (Component)this.offset1TF);
        springLayout.putConstraint("West", (Component)this.offset1EstimatedCKB, -3, "West", this.unitCB);
        this.add(this.offset1EstimatedCKB);
        this.offset1Label = new JLabel("Offset to ...");
        springLayout.putConstraint("North", (Component)this.offset1Label, 0, "South", (Component)this.offset1TF);
        springLayout.putConstraint("West", (Component)this.offset1Label, 10, "West", (Component)this);
        this.add(this.offset1Label);
        this.offset2TF = new JTextField();
        ((PlainDocument)this.offset2TF.getDocument()).setDocumentFilter(new FloatFilter());
        springLayout.putConstraint("North", (Component)this.offset2TF, 6, "South", (Component)this.offset1Label);
        springLayout.putConstraint("West", (Component)this.offset2TF, 0, "West", (Component)this.offset1Label);
        this.add(this.offset2TF);
        this.offset2TF.setColumns(7);
        this.offset2EstimatedCKB = new JCheckBox("Estimated");
        springLayout.putConstraint("North", (Component)this.offset2EstimatedCKB, -1, "North", (Component)this.offset2TF);
        springLayout.putConstraint("West", (Component)this.offset2EstimatedCKB, -3, "West", this.unitCB);
        this.add(this.offset2EstimatedCKB);
        this.offset2Label = new JLabel("Offset to ...");
        springLayout.putConstraint("North", (Component)this.offset2Label, 0, "South", (Component)this.offset2TF);
        springLayout.putConstraint("West", (Component)this.offset2Label, 10, "West", (Component)this);
        this.add(this.offset2Label);
        this.localDatumNameTF = new JTextField();
        springLayout.putConstraint("North", (Component)this.localDatumNameTF, 6, "South", (Component)this.offset2Label);
        springLayout.putConstraint("West", (Component)this.localDatumNameTF, 0, "West", (Component)lblOffsetUnit);
        this.add(this.localDatumNameTF);
        this.localDatumNameTF.setColumns(16);
        this.lblLocalDatumName = new JLabel("Local Datum Name");
        springLayout.putConstraint("North", (Component)this.lblLocalDatumName, 0, "South", (Component)this.localDatumNameTF);
        springLayout.putConstraint("West", (Component)this.lblLocalDatumName, 0, "West", (Component)lblOffsetUnit);
        this.add(this.lblLocalDatumName);
    }

    public VerticalDatumOffsetPanel(VerticalDatumContainer vdc) throws VerticalDatumException {
        this();
        this.setVerticalDatumContainer(vdc);
    }

    public VerticalDatumOffsetPanel(String xml) throws VerticalDatumException {
        this();
        this.setVerticalDatumContainer(new VerticalDatumContainer(xml));
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) throws VerticalDatumException {
        double navd88Offset = -3.4028234663852886E38;
        double ngvd29Offset = -3.4028234663852886E38;
        this.unitCB.setSelectedItem(vdc.unit);
        this.elevation = vdc.elevation;
        switch (vdc.nativeDatum) {
            case "NGVD29": {
                this.nativeDatumCB.setSelectedItem(vdc.nativeDatum.substring(0, 4) + " " + vdc.nativeDatum.substring(4));
                try {
                    navd88Offset = vdc.getNAVD88Offset();
                }
                catch (VerticalDatumException verticalDatumException) {
                    // empty catch block
                }
                if (navd88Offset != -3.4028234663852886E38) {
                    this.offset1TF.setText(Double.toString(navd88Offset));
                }
                this.offset1EstimatedCKB.setSelected(vdc.navd88OffsetIsEstimate);
                ngvd29Offset = 0.0;
                this.offset2TF.setText("0");
                this.offset2EstimatedCKB.setSelected(false);
                this.localDatumNameTF.setText("");
                break;
            }
            case "NAVD88": {
                this.nativeDatumCB.setSelectedItem(vdc.nativeDatum.substring(0, 4) + " " + vdc.nativeDatum.substring(4));
                try {
                    ngvd29Offset = vdc.getNGVD29Offset();
                }
                catch (VerticalDatumException verticalDatumException) {
                    // empty catch block
                }
                if (ngvd29Offset != -3.4028234663852886E38) {
                    this.offset1TF.setText(Double.toString(ngvd29Offset));
                }
                this.offset1EstimatedCKB.setSelected(vdc.ngvd29OffsetIsEstimate);
                navd88Offset = 0.0;
                this.offset2TF.setText("0");
                this.offset2EstimatedCKB.setSelected(false);
                this.localDatumNameTF.setText("");
                break;
            }
            default: {
                this.nativeDatumCB.setSelectedItem("OTHER");
                try {
                    ngvd29Offset = vdc.getNGVD29Offset();
                }
                catch (VerticalDatumException verticalDatumException) {
                    // empty catch block
                }
                if (ngvd29Offset != -3.4028234663852886E38) {
                    this.offset1TF.setText(Double.toString(ngvd29Offset));
                    this.offset1EstimatedCKB.setSelected(vdc.ngvd29OffsetIsEstimate);
                }
                try {
                    navd88Offset = vdc.getNAVD88Offset();
                }
                catch (VerticalDatumException verticalDatumException) {
                    // empty catch block
                }
                if (navd88Offset != -3.4028234663852886E38) {
                    this.offset2TF.setText(Double.toString(navd88Offset));
                    this.offset2EstimatedCKB.setSelected(vdc.navd88OffsetIsEstimate);
                }
                try {
                    String localDatumName = vdc.getNativeVerticalDatum();
                    if (localDatumName.equals("OTHER")) break;
                    this.localDatumNameTF.setText(localDatumName);
                    break;
                }
                catch (VerticalDatumException verticalDatumException) {
                    // empty catch block
                }
            }
        }
        this.setView();
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        VerticalDatumContainer vdc = new VerticalDatumContainer();
        vdc.unit = this.unitCB.getItemAt(this.unitCB.getSelectedIndex());
        vdc.elevation = this.elevation;
        vdc.localDatumName = this.localDatumNameTF.getText();
        vdc.nativeDatum = this.nativeDatumCB.getItemAt(this.nativeDatumCB.getSelectedIndex()).replace(" ", "").replace("OTHER", "LOCAL");
        if (vdc.nativeDatum.equals("NGVD29")) {
            vdc.ngvd29Offset = -3.4028234663852886E38;
            vdc.navd88Offset = this.offset1TF.getText().length() > 0 ? Double.parseDouble(this.offset1TF.getText()) : -3.4028234663852886E38;
            vdc.navd88OffsetIsEstimate = this.offset1EstimatedCKB.isSelected();
        } else if (vdc.nativeDatum.equals("NAVD88")) {
            vdc.navd88Offset = -3.4028234663852886E38;
            vdc.ngvd29Offset = this.offset1TF.getText().length() > 0 ? Double.parseDouble(this.offset1TF.getText()) : -3.4028234663852886E38;
            vdc.ngvd29OffsetIsEstimate = this.offset1EstimatedCKB.isSelected();
        } else {
            vdc.ngvd29Offset = this.offset1TF.getText().length() > 0 ? Double.parseDouble(this.offset1TF.getText()) : -3.4028234663852886E38;
            vdc.ngvd29OffsetIsEstimate = this.offset1EstimatedCKB.isSelected();
            vdc.navd88Offset = this.offset2TF.getText().length() > 0 ? Double.parseDouble(this.offset2TF.getText()) : -3.4028234663852886E38;
            vdc.navd88OffsetIsEstimate = this.offset2EstimatedCKB.isSelected();
        }
        return vdc;
    }

    public String toXml() {
        return this.getVerticalDatumContainer().toXml();
    }

    private void setView() {
        Component[] components = new Component[]{this.offset2TF, this.offset2EstimatedCKB, this.offset2Label, this.localDatumNameTF, this.lblLocalDatumName};
        switch ((String)this.nativeDatumCB.getSelectedItem()) {
            case "NGVD 29": {
                this.offset1Label.setText("Offset to NAVD 88");
                for (Component c2 : components) {
                    c2.setVisible(false);
                }
                break;
            }
            case "NAVD 88": {
                this.offset1Label.setText("Offset to NGVD 29");
                for (Component c3 : components) {
                    c3.setVisible(false);
                }
                break;
            }
            default: {
                this.offset1Label.setText("Offset to NGVD 29");
                this.offset2Label.setText("Offset to NAVD 88");
                for (Component c4 : components) {
                    c4.setVisible(true);
                }
            }
        }
    }

    class FloatFilter
    extends DocumentFilter {
        FloatFilter() {
        }

        boolean test(String s) {
            boolean passed = true;
            if (s != null && s.length() > 0) {
                try {
                    Float.parseFloat(s);
                    char c2 = s.charAt(s.length() - 1);
                    passed = c2 == '.' || Character.isDigit(c2);
                }
                catch (NumberFormatException e) {
                    passed = false;
                }
            }
            return passed;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }
}

