/*
 * Decompiled with CFR 0.152.
 */
package hec.gui;

import hec.gui.WizardPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;

public class WizardDialog
extends RmaJDialog
implements ActionListener {
    private JButton _backButton;
    private JButton _nextButton;
    private JButton _cancelButton;
    private JPanel _topPanel;
    int _wizardPanelCount = 0;
    private boolean _validPanelControlsNextButton = false;
    private PropertyChangeListener _validPanelChangeListener;
    private boolean _showStepCount;

    public WizardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public WizardDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public WizardDialog() {
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._topPanel = new RmaJPanel(new CardLayout());
        this._topPanel.setBorder(BorderFactory.createBevelBorder(1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._topPanel, gbc);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)sep, gbc);
        JPanel buttonPanel = this.buildButtonPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                WizardDialog.this.setButtonState();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                WizardDialog.this.dialogCanceled();
            }
        });
        this.getRootPane().setDefaultButton(this._nextButton);
    }

    protected JPanel buildButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._backButton = new JButton("< Back");
        this._backButton.setMnemonic('B');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)this._backButton, gbc);
        this._nextButton = new JButton("Next >");
        this._nextButton.setMnemonic('N');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 5);
        panel.add((Component)this._nextButton, gbc);
        this._cancelButton = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 15, 0, 0);
        panel.add((Component)this._cancelButton, gbc);
        this._backButton.addActionListener(this);
        this._nextButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        return panel;
    }

    protected WizardPanel getCurrentPanel() {
        int cnt = this._topPanel.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c2 = this._topPanel.getComponent(i);
            if (!c2.isVisible() || !(c2 instanceof WizardPanel)) continue;
            return (WizardPanel)c2;
        }
        System.out.println("no Wizard Panel found");
        return null;
    }

    public void setCurrentPanel(String panelName) {
        this.setCurrentPanel(panelName, null);
    }

    public void setCurrentPanel(String panelName, String backPanelName) {
        if (panelName != null) {
            ((CardLayout)this._topPanel.getLayout()).show(this._topPanel, panelName);
            if (backPanelName != null) {
                WizardPanel panel = this.getCurrentPanel();
                panel.setBackPanelName(backPanelName);
            }
            this.setButtonState();
        }
    }

    public void setButtonState() {
        WizardPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (this._validPanelChangeListener == null) {
            this._validPanelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    WizardDialog.this.setButtonState();
                }
            };
        }
        panel.removePropertyChangeListener("VALID_PANEL_PROPERTY", this._validPanelChangeListener);
        panel.addPropertyChangeListener("VALID_PANEL_PROPERTY", this._validPanelChangeListener);
        String nextPanelName = panel.getNextPanelName();
        String backPanelName = panel.getBackPanelName();
        this._nextButton.setActionCommand(nextPanelName);
        this._backButton.setActionCommand(backPanelName);
        String nextText = nextPanelName != null && nextPanelName.length() > 0 ? "Next >" : this.getFinishButtonString();
        this._nextButton.setText(nextText);
        this._backButton.setEnabled(backPanelName != null && backPanelName.length() > 0);
        String title = panel.getWindowTitle();
        if (title == null) {
            title = this.getTitle();
        }
        if (this._showStepCount) {
            StringBuilder sb = new StringBuilder();
            int currentIdx = this.getWizardPanelIndex(panel.getPanelName()) + 1;
            int wizardPanelCount = this.getWizardPanelCount();
            sb.append(currentIdx);
            sb.append(" out of ");
            sb.append(wizardPanelCount);
            if (title != null) {
                sb.append(" - ");
                sb.append(title);
            }
            title = sb.toString();
        }
        if (title != null) {
            this.setTitle(title);
        }
        if (this._validPanelControlsNextButton) {
            this._nextButton.setEnabled(panel.isValidPanel());
        } else {
            this._nextButton.setEnabled(true);
        }
    }

    public void setShowStepCount(boolean tf) {
        this._showStepCount = tf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        String panelName = null;
        WizardPanel panel = this.getCurrentPanel();
        String backPanelName = null;
        boolean next = false;
        if (src == this._nextButton) {
            if (!this.getCurrentPanel().isValidPanel()) {
                System.out.println("currentPanel isn't valid");
                return;
            }
            if (panel != null) {
                panelName = panel.getNextPanelName();
            }
            if (panelName == null) {
                panelName = this._nextButton.getActionCommand();
            }
            backPanelName = panel.getPanelName();
            if (this.getFinishButtonString().equals(this._nextButton.getText())) {
                this.dialogFinished();
                return;
            }
            this.getCurrentPanel().goingToNextPanel();
            next = true;
        } else if (src == this._backButton) {
            if (panel != null) {
                panelName = panel.getBackPanelName();
            }
            if (panelName == null) {
                panelName = this._backButton.getActionCommand();
            }
            this.movingBack(this.getCurrentPanel());
        } else if (src == this._cancelButton) {
            this.dialogCanceled();
            this.setVisible(false);
        }
        if (panelName != null) {
            this.getCurrentPanel().removePropertyChangeListener("VALID_PANEL_PROPERTY", this._validPanelChangeListener);
            this.changingPanels(panelName);
            this.setCurrentPanel(panelName, backPanelName);
            if (next) {
                this.movingFoward(this.getCurrentPanel());
            }
        }
    }

    protected void movingFoward(WizardPanel currentPanel) {
    }

    protected void movingBack(WizardPanel currentPanel) {
    }

    protected void changingPanels(String goingToPanelName) {
    }

    protected void dialogCanceled() {
    }

    protected void dialogFinished() {
        this.setVisible(false);
    }

    public void addWizardPanel(WizardPanel panel) {
        if (panel == null) {
            return;
        }
        this._topPanel.add(panel.getPanelName(), panel);
        ++this._wizardPanelCount;
        if (this._wizardPanelCount == 1) {
            this.movingFoward(panel);
        }
    }

    public int getWizardPanelIndex(String panelName) {
        Component[] components = this._topPanel.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            WizardPanel wizardPanel;
            if (!(components[ii] instanceof WizardPanel) || !(wizardPanel = (WizardPanel)components[ii]).getPanelName().equals(panelName)) continue;
            return ii;
        }
        return -1;
    }

    public WizardPanel getWizardPanel(String panelName) {
        Component[] components = this._topPanel.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            WizardPanel wizardPanel;
            if (!(components[ii] instanceof WizardPanel) || !(wizardPanel = (WizardPanel)components[ii]).getPanelName().equals(panelName)) continue;
            return wizardPanel;
        }
        return null;
    }

    public List<WizardPanel> getWizardPanels() {
        ArrayList<WizardPanel> wizardPanels = new ArrayList<WizardPanel>(this._wizardPanelCount);
        Component[] components = this._topPanel.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof WizardPanel)) continue;
            WizardPanel wizardPanel = (WizardPanel)components[ii];
            wizardPanels.add(wizardPanel);
        }
        return wizardPanels;
    }

    public int getWizardPanelCount() {
        return this._wizardPanelCount;
    }

    public void setCancelButtonEnabled(boolean enable) {
        this._cancelButton.setEnabled(enable);
    }

    public void setValidPanelControlsNextButton(boolean tf) {
        this._validPanelControlsNextButton = tf;
        this.setButtonState();
    }

    protected String getFinishButtonString() {
        return "Finish";
    }
}

