/*
 * Decompiled with CFR 0.152.
 */
package hec.gui.plaf.basic;

import hec.gui.TimeZoneField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class BasicTimeZoneFieldUI
extends BasicTextFieldUI {
    private JButton ellipsesButton;
    private MouseAdapter mouseListener;
    private ActionListener actionListener;
    private MouseMotionAdapter mouseMotionListener;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    private TimeZoneField timeZoneField;

    public static ComponentUI createUI(JComponent c2) {
        return new BasicTimeZoneFieldUI();
    }

    public BasicTimeZoneFieldUI() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!BasicTimeZoneFieldUI.this.timeZoneField.isEnabled()) {
                    return;
                }
                if (!BasicTimeZoneFieldUI.this.timeZoneField.isToolEnabled()) {
                    return;
                }
                Point p = e.getPoint();
                if (p.x > BasicTimeZoneFieldUI.this.timeZoneField.getWidth() - BasicTimeZoneFieldUI.this.ellipsesButton.getWidth()) {
                    BasicTimeZoneFieldUI.this.ellipsesButton.doClick();
                }
            }
        };
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getPoint().x;
                TimeZoneField comp = BasicTimeZoneFieldUI.this.timeZoneField;
                if (x > comp.getWidth() - BasicTimeZoneFieldUI.this.ellipsesButton.getWidth()) {
                    comp.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    comp.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        };
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BasicTimeZoneFieldUI.this.timeZoneField.isToolEnabled()) {
                    BasicTimeZoneFieldUI.this.timeZoneField.displayChooserDialog();
                }
            }
        };
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public void installUI(JComponent c2) {
        if (!(c2 instanceof TimeZoneField)) {
            throw new Error("TimeZoneFieldUI needs TimeZoneField");
        }
        this.timeZoneField = (TimeZoneField)c2;
        super.installUI(c2);
        if (this.ellipsesButton != null) {
            this.configureEllipsesButton();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.ellipsesButton = this.createEllipsesButton();
        TimeZoneField comp = this.timeZoneField;
        comp.add(this.ellipsesButton);
        comp.setLayout(this.createLayoutManager());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = new Rectangle(this.timeZoneField.getSize());
        Insets insets = this.timeZoneField.getInsets();
        alloc.x += insets.left;
        alloc.y += insets.top;
        alloc.width -= insets.left + insets.right;
        if (this.timeZoneField.isToolEnabled()) {
            alloc.width -= this.ellipsesButton.getBounds().width;
        }
        alloc.height -= insets.top + insets.bottom;
        return alloc;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        if (this.ellipsesButton != null && this.timeZoneField.isToolEnabled()) {
            Rectangle r = this.ellipsesButton.getBounds();
            Rectangle a = this.getVisibleEditorRect();
            g.setClip(a.x, a.y, a.width + r.width, a.height);
            g.translate(r.x, r.y);
            this.ellipsesButton.paint(g);
        }
    }

    protected JButton createEllipsesButton() {
        return new JButton("..."){

            @Override
            public void paint(Graphics g) {
                if (BasicTimeZoneFieldUI.this.timeZoneField.isToolEnabled()) {
                    super.paint(g);
                }
            }
        };
    }

    public void configureEllipsesButton() {
        if (this.ellipsesButton != null) {
            this.ellipsesButton.setEnabled(this.timeZoneField.isEnabled());
            this.ellipsesButton.setRequestFocusEnabled(false);
            this.ellipsesButton.setFocusable(false);
            this.ellipsesButton.setCursor(Cursor.getPredefinedCursor(0));
            if (this.mouseListener != null) {
                this.ellipsesButton.addActionListener(this.actionListener);
                this.timeZoneField.addMouseListener(this.mouseListener);
                this.timeZoneField.addMouseMotionListener(this.mouseMotionListener);
            }
        }
    }

    protected LayoutManager createLayoutManager() {
        return new TimeZoneFieldLayoutManager();
    }

    protected Insets getInsets() {
        return this.timeZoneField.getInsets();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = this.getMinimumSize(c2);
        size.width += 4;
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        Insets insets = this.getInsets();
        TimeZoneField comp = this.timeZoneField;
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        Dimension size = new Dimension(100, fm.getHeight());
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        Dimension size = this.getPreferredSize(c2);
        size.width = Short.MAX_VALUE;
        return size;
    }

    public class TimeZoneFieldLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent cb = (JComponent)parent;
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent cb = (JComponent)parent;
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            JComponent df = (JComponent)parent;
            int width = df.getWidth();
            int height = df.getHeight();
            Insets insets = BasicTimeZoneFieldUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicTimeZoneFieldUI.this.ellipsesButton != null) {
                if (BasicTimeZoneFieldUI.this.timeZoneField.isToolEnabled()) {
                    BasicTimeZoneFieldUI.this.ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    BasicTimeZoneFieldUI.this.ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, 0, 0);
                }
            }
        }
    }
}

