/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.dataTable.TimeSeriesDataModel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.grid.GridData;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.StreamRatingContainer;
import hec.io.StreamRatingSeriesContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Vector;
import rma.util.RMAIO;

public abstract class AbstractDssDataManager
implements DssDataManager {
    private final IHecDSSUtilities _dataManager;
    private boolean _fileExplicitlyClosed = true;
    private boolean _catalogNeedsUpdate = false;
    private String _dssFileName = "";
    private TimeZone _timeZone = null;
    private int _dssFileVersion = 0;
    private int _unitSystem = 3;

    protected AbstractDssDataManager(IHecDSSUtilities dataManager) {
        Objects.requireNonNull(dataManager, "AbstractDssDataManager: dataManager cannot be null!");
        this._dataManager = dataManager;
    }

    @Override
    public IHecDSSUtilities dataManager() {
        return this._dataManager;
    }

    @Override
    public int setDSSFileName(String dssFileName, boolean fileMustExist, int dssVersion) {
        this._dssFileName = dssFileName;
        if (this._dataManager == null) {
            return -1;
        }
        int status = this._dataManager.setDSSFileName(dssFileName, fileMustExist, dssVersion);
        this._dssFileVersion = this._dataManager.getDssFileVersion();
        if (status == 0) {
            this._fileExplicitlyClosed = false;
        }
        return status;
    }

    @Override
    public int getDssFileVersion() {
        if (this._dssFileVersion != 0) {
            return this._dssFileVersion;
        }
        return this._dataManager == null ? 0 : this._dataManager.getDssFileVersion();
    }

    @Override
    public void setForceNewCatalog(boolean newCatalog) {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.setForceNewCatalog(newCatalog);
    }

    @Override
    public void fileStats() {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.fileStats();
    }

    @Override
    public void setCatalogNeedsUpdate(boolean catalogNeedsUpdate) {
        this._catalogNeedsUpdate = catalogNeedsUpdate;
    }

    @Override
    public boolean getCatalogNeedsUpdate() {
        return this._catalogNeedsUpdate;
    }

    @Override
    public boolean checkForSevereError() {
        if (this._dataManager == null) {
            return false;
        }
        return this._dataManager.checkForSevereDssError();
    }

    @Override
    public void setDisplayUnitSystem(int unitSystem) {
        this._unitSystem = unitSystem;
    }

    protected int getDisplayUnitSystem() {
        return this._unitSystem;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        TimeSeriesDataModel.setGlobalViewTimeZone(this._timeZone);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    @Override
    public int createNewCatalog(int catalogType) {
        return this._dataManager.createNewCatalog(catalogType);
    }

    @Override
    public String getCatalogName(int catalogType) {
        return this._dataManager.getCatalogName(catalogType);
    }

    @Override
    public boolean recordExists(String pathname) {
        if (this._dataManager == null) {
            return false;
        }
        return this._dataManager.recordExists(pathname);
    }

    @Override
    public boolean[] recordsExist(List<String> pathnames) {
        boolean[] exists = new boolean[pathnames.size()];
        if (pathnames.size() > 1000 && (this.numberRecords() < 10000 || pathnames.size() > 10000)) {
            HashSet<String> hs;
            Object paths;
            if (this._dataManager.isCatalogValid()) {
                paths = this.getPathnameList(false);
                hs = new HashSet<String>(Arrays.asList(paths));
            } else {
                paths = new Vector(this.numberRecords());
                this.searchDSSPaths("", (List<String>)paths);
                hs = new HashSet(paths);
            }
            for (int i = 0; i < pathnames.size(); ++i) {
                exists[i] = hs.contains(pathnames.get(i));
            }
            return exists;
        }
        for (int i = 0; i < pathnames.size(); ++i) {
            exists[i] = this.recordExists(pathnames.get(i));
        }
        return exists;
    }

    @Override
    public void done() {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.done();
    }

    @Override
    public DSSErrorMessage lastSevereErrorMessage() {
        return this.lastErrorMessage();
    }

    @Override
    public List<DSSErrorMessage> allSevereErrorMessages() {
        return this._dataManager.allSevereErrorMessages();
    }

    @Override
    public void cancelProcess() {
        this._dataManager.cancelProcess();
    }

    @Override
    public void cancelSqueeze() {
        this._dataManager.cancelSqueeze();
    }

    @Override
    public void setInterrupt(boolean interrupt) {
        this._dataManager.setInterrupt(interrupt);
    }

    @Override
    public void clearStatus() {
        if (this._dataManager != null) {
            this._dataManager.clearStatus();
        }
    }

    @Override
    public void close() {
        this._fileExplicitlyClosed = true;
        this._dataManager.close();
    }

    @Override
    public boolean isExplicitlyClosed() {
        return this._fileExplicitlyClosed;
    }

    @Override
    public int checkAllPathnames() {
        if (this._dataManager != null) {
            return this._dataManager.checkAllPathnames();
        }
        return -1;
    }

    @Override
    public int checkLinks() {
        if (this._dataManager != null) {
            return this._dataManager.checkLinks();
        }
        return -1;
    }

    @Override
    public int checkPathnameBins() {
        if (this._dataManager != null) {
            return this._dataManager.checkPathnameBins();
        }
        return -1;
    }

    @Override
    public int duplicateRecords(List<String> pathnameList, List<String> newPathnameList) {
        return this._dataManager.duplicateRecords(pathnameList, newPathnameList);
    }

    @Override
    public String getDSSFileName() {
        return this._dssFileName;
    }

    @Override
    public String DSSFileName() {
        return this._dataManager.DSSFileName();
    }

    @Override
    public boolean isSameFile(String dssFileName) {
        String compareName1 = dssFileName.toUpperCase().replace('\\', '/');
        String compareName2 = this.DSSFileName().toUpperCase().replace('\\', '/');
        return compareName1.equals(compareName2);
    }

    @Override
    public boolean fileOpened() {
        if (this._dataManager != null) {
            return this._dataManager.fileOpened();
        }
        return false;
    }

    @Override
    public int open() {
        if (this._dataManager != null) {
            return this._dataManager.open();
        }
        return -1;
    }

    @Override
    public boolean fileAccessible() {
        if (this._dataManager != null) {
            return this._dataManager.fileAccessible();
        }
        return false;
    }

    @Override
    public int getTSRecordInfo(String pathname, HecTime start, HecTime end, stringContainer units, stringContainer type) {
        if (this._dataManager != null) {
            return this._dataManager.getTSRecordInfo(pathname, start, end, units, type);
        }
        return -1;
    }

    @Override
    public boolean getTimeSeriesExtents(String pathname, HecTime start, HecTime end) {
        if (this._dataManager != null) {
            return this._dataManager.getTimeSeriesExtents(pathname, start, end);
        }
        return false;
    }

    @Override
    public int numberRecords() {
        if (this._dataManager == null) {
            return 0;
        }
        return this._dataManager.numberRecords();
    }

    @Override
    public int readData(DataReference dataReference, GridContainer gridContainer) {
        DSSIdentifier dssId = new DSSIdentifier(dataReference.getFilename(), dataReference.getPathname());
        List v = this.readGriddedData(dssId);
        if (v == null) {
            return -1;
        }
        if (v.size() < 2) {
            return -1;
        }
        String name = dataReference.getFilename();
        if (name == null || name.length() == 0) {
            name = this.DSSFileName();
        }
        gridContainer.fileName = name;
        gridContainer.fullName = dataReference.getPathname();
        Object obj = v.get(1);
        if (obj instanceof GridData) {
            gridContainer.gridData = (GridData)obj;
            return 0;
        }
        return -1;
    }

    @Override
    public int readData(DataReference dataReference, TinContainer tinContainer) {
        Object obj;
        DSSIdentifier dssId = new DSSIdentifier(dataReference.getFilename(), dataReference.getPathname());
        List v = this.readTinData(dssId, tinContainer);
        if (v == null) {
            return -1;
        }
        if (v.size() < 2) {
            return -1;
        }
        String name = dataReference.getFilename();
        if (name == null || name.length() == 0) {
            name = this.DSSFileName();
        }
        if ((obj = v.get(0)) instanceof TinContainer) {
            return 0;
        }
        return -1;
    }

    protected abstract List readTinData(DSSIdentifier var1, TinContainer var2);

    @Override
    public int recordType(String pathname) {
        return this._dataManager.recordType(pathname);
    }

    @Override
    public Map<String, Integer> recordTypes(String[] pathname) {
        return this._dataManager.recordTypes(pathname);
    }

    @Override
    public int renameRecords(List<String> pathnameList, List<String> newPathnameList) {
        return this._dataManager.renameRecords(pathnameList, newPathnameList);
    }

    @Override
    public String[] getPathnameList(boolean forceUpdate) {
        return this._dataManager.getPathnameList(forceUpdate);
    }

    @Override
    public int searchDSSCatalog(String scanString, List<String> pathnameList) {
        return this._dataManager.searchDSSCatalog(scanString, pathnameList);
    }

    @Override
    public int searchDSSPaths(String scanString, List<String> pathnameList) {
        return this._dataManager.searchDSSPaths(scanString, pathnameList);
    }

    @Override
    public List<CondensedReference> getCondensedCatalog() {
        return this._dataManager.getCondensedCatalog();
    }

    @Override
    public int forceMultiUserAccess() {
        return this._dataManager.forceMultiUserAccess();
    }

    @Override
    public int squeeze() {
        return this._dataManager.squeeze();
    }

    @Override
    public boolean writeAccess() {
        if (this._dataManager == null) {
            return false;
        }
        return this._dataManager.writeAccess();
    }

    @Override
    public int writeData(DataContainer dataContainer) {
        if (dataContainer instanceof TimeSeriesContainer) {
            return this.writeData((TimeSeriesContainer)dataContainer);
        }
        if (dataContainer instanceof PairedDataContainer) {
            return this.writeData((PairedDataContainer)dataContainer);
        }
        if (dataContainer instanceof TextContainer) {
            return this.writeData((TextContainer)dataContainer);
        }
        if (dataContainer instanceof StreamRatingContainer) {
            return this.writeData((StreamRatingContainer)dataContainer);
        }
        if (dataContainer instanceof StreamRatingSeriesContainer) {
            return this.writeData((StreamRatingSeriesContainer)dataContainer);
        }
        if (dataContainer instanceof GridContainer) {
            return this.writeData((GridContainer)dataContainer);
        }
        return this.writeLocation(dataContainer);
    }

    @Override
    public int zinqir(String parameter) {
        if (this._dataManager == null) {
            return 0;
        }
        return this._dataManager.zinqir(parameter);
    }

    @Override
    public void zinqir(String parameter, stringContainer alpha, int[] numb) {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.zinqir(parameter, alpha, numb);
    }

    @Override
    public void zset(String parameter, String alpha, int number) {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.dss_zset(parameter, alpha, number);
    }

    @Override
    public String DSSFileName(int i) {
        return this.DSSFileName();
    }

    @Override
    public void zquery(String parameter, stringContainer alpha, int[] numb) {
        if (this._dataManager == null) {
            return;
        }
        this._dataManager.dss_zquery(parameter, alpha, numb);
    }

    @Deprecated
    public Color getColor(int i) {
        return Color.BLACK;
    }

    @Deprecated
    public Component getComponent(int index) {
        return null;
    }

    @Deprecated
    public int getTabNum() {
        return 1;
    }

    @Deprecated
    public String getTitle() {
        String fileName = this._dataManager.DSSFileName();
        fileName = RMAIO.getFileFromPath(fileName);
        return fileName;
    }
}

