/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.TimeSeriesContainer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class CondensedReference
implements Serializable {
    private static final long serialVersionUID = 5631608770443676539L;
    protected String nominalPathname = null;
    protected String[] pathnameList = null;
    protected Vector<CondensedReference> collection = null;
    protected int _julianStart = -2147483647;
    protected int _julianEnd = -2147483647;

    public CondensedReference() {
    }

    public CondensedReference(String nominalPath) {
        this.nominalPathname = nominalPath;
    }

    public CondensedReference(TimeSeriesContainer tsc) {
        this.set(tsc);
    }

    public void set(TimeSeriesContainer tsc) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        start.set(tsc.startTime, tsc.julianBaseDate);
        end.set(tsc.endTime, tsc.julianBaseDate);
        DSSPathname dssPath = new DSSPathname(tsc.fullName);
        String[] pathList = this.generatePathnameList(null, dssPath, false, start, end);
        this.complete(null, pathList, pathList.length, false);
    }

    public void setPathnameArray(String[] paths, int number) {
        if (this.pathnameList == null) {
            this.pathnameList = Arrays.copyOf(paths, number);
        } else {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(this.pathnameList));
            String[] p = Arrays.copyOf(paths, number);
            LinkedList<String> l = new LinkedList<String>(Arrays.asList(p));
            list.addAll(l);
            this.pathnameList = list.toArray(new String[0]);
        }
    }

    public void setCollection(Vector<CondensedReference> coll) {
        this.collection = (Vector)coll.clone();
        if (this.collection != null) {
            if (this.collection.size() == 1) {
                CondensedReference cr = coll.get(0);
                this.nominalPathname = cr.getNominalPathname();
                this.pathnameList = cr.getPathnameList();
                this.collection = null;
            } else {
                this.parseCollection();
            }
        }
    }

    public Vector<CondensedReference> getCollection() {
        if (this.collection == null) {
            return null;
        }
        return this.collection;
    }

    public int size() {
        if (this.pathnameList == null && this.collection != null) {
            this.pathnameList = this.getPathnameList();
        }
        if (this.pathnameList == null) {
            return 0;
        }
        return this.pathnameList.length;
    }

    public boolean isaCollection() {
        return this.collection != null;
    }

    public void complete(HecDssCatalog dataManager, String[] paths, int number, boolean querryTimes) {
        int[] jul;
        String dPart;
        int status;
        String ePart;
        int interval;
        if (number > 0) {
            this.setPathnameArray(paths, number);
        }
        if (this.pathnameList == null) {
            return;
        }
        String first = this.getFirstPathname();
        String last = this.getLastPathname();
        this.nominalPathname = first;
        int[] partPositionsFirst = new int[7];
        int[] partPositionsLast = new int[7];
        int stat = DSSPathname.parsePathname(first, partPositionsFirst);
        if (stat != 0) {
            DSSPathname.parsePathname("///////", partPositionsFirst);
        }
        if ((stat = DSSPathname.parsePathname(last, partPositionsLast)) != 0) {
            DSSPathname.parsePathname("///////", partPositionsLast);
        }
        if (partPositionsFirst[4] - partPositionsFirst[3] > 5 && partPositionsFirst[5] - partPositionsFirst[4] > 3 && (interval = HecTimeSeriesBase.zgintlFromEPart(ePart = first.substring(partPositionsFirst[4], partPositionsFirst[5] - 1))) != 0 && (status = HecTime.datjul(dPart = first.substring(partPositionsFirst[3], partPositionsFirst[4] - 1), jul = new int[1])) == 0) {
            HecTime start = new HecTime();
            HecTime end = new HecTime();
            if (querryTimes) {
                this.getDataTimes(dataManager, start, end);
            }
            if (this.size() == 1 && !start.isDefined()) {
                return;
            }
            this.nominalPathname = start.isDefined() && end.isDefined() ? first.substring(0, partPositionsFirst[3]) + start.date(4) + " - " + end.date(4) + last.substring(partPositionsLast[4] - 1, partPositionsLast[6]) : first.substring(0, partPositionsFirst[4] - 1) + " - " + last.substring(partPositionsLast[3], partPositionsLast[6]);
        }
    }

    protected void parseCollection() {
        HecTime startColl = new HecTime(3);
        HecTime endColl = new HecTime(3);
        HecTime start = new HecTime(3);
        HecTime end = new HecTime(3);
        int[] partPositions = new int[7];
        for (int i = 0; i < this.collection.size(); ++i) {
            String date;
            start.setUndefined();
            CondensedReference dr = this.collection.get(i);
            String nominal = dr.getNominalPathname();
            int stat = DSSPathname.parsePathname(nominal, partPositions);
            if (stat != 0) {
                DSSPathname.parsePathname("///////", partPositions);
            }
            if (partPositions[4] - partPositions[3] == 10) {
                date = nominal.substring(partPositions[3], partPositions[4] - 1);
                start.setDate(date);
                end.set(start);
            } else if (partPositions[4] - partPositions[3] == 22) {
                date = nominal.substring(partPositions[3], partPositions[3] + 9);
                start.setDate(date);
                date = nominal.substring(partPositions[3] + 12, partPositions[4] - 1);
                end.setDate(date);
            }
            if (start.isDateDefined() && (!startColl.isDateDefined() || start.lessThan(startColl))) {
                startColl.set(start);
            }
            if (!end.isDateDefined() || endColl.isDateDefined() && !end.greaterThan(endColl)) continue;
            endColl.set(end);
        }
        CondensedReference dr = this.collection.get(0);
        Object nominal = dr.getNominalPathname();
        String startSeq = DSSPathname.getCollectionSequence((String)nominal);
        dr = this.collection.get(this.collection.size() - 1);
        nominal = dr.getNominalPathname();
        String endSeq = DSSPathname.getCollectionSequence((String)nominal);
        DSSPathname.parsePathname((String)nominal, partPositions);
        if (start.isDateDefined() && !start.equalTo(end)) {
            nominal = ((String)nominal).substring(0, partPositions[3]) + start.date(4) + " - " + end.date(4) + ((String)nominal).substring(partPositions[4] - 1, partPositions[6]);
            DSSPathname.parsePathname((String)nominal, partPositions);
        }
        this.nominalPathname = ((String)nominal).substring(0, partPositions[5] + 2) + startSeq + " - " + endSeq + ((String)nominal).substring(partPositions[5] + 8, partPositions[6]);
    }

    public String getNominalPathname() {
        if (this.nominalPathname == null) {
            return "";
        }
        return this.nominalPathname;
    }

    public String[] getPathnameList() {
        if (this.collection != null) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.collection.size(); ++i) {
                CondensedReference cr = this.collection.get(i);
                String[] paths = cr.getPathnameList();
                v.addAll(Arrays.asList(paths));
            }
            return v.toArray(new String[0]);
        }
        if (this.pathnameList == null && this.nominalPathname != null) {
            this.pathnameList = this.generatePathnameList(null, this.nominalPathname, false);
        }
        return this.pathnameList;
    }

    public String getFirstPathname() {
        if (this.pathnameList == null) {
            return "";
        }
        return this.pathnameList[0];
    }

    public String getLastPathname() {
        if (this.pathnameList == null) {
            return "";
        }
        return this.pathnameList[this.pathnameList.length - 1];
    }

    public String getPathname(int number) {
        if (this.pathnameList == null) {
            this.pathnameList = this.getPathnameList();
        }
        if (this.pathnameList == null || number >= this.pathnameList.length || number < 0) {
            return "";
        }
        return this.pathnameList[number];
    }

    public boolean removePathname(int element) {
        if (this.pathnameList == null) {
            return false;
        }
        if (element >= this.pathnameList.length) {
            return false;
        }
        if (this.pathnameList.length == 1) {
            this.pathnameList = null;
            return true;
        }
        String[] newList = new String[this.pathnameList.length - 1];
        int count = 0;
        for (int i = 0; i < this.pathnameList.length; ++i) {
            if (i == element) continue;
            newList[count++] = this.pathnameList[i];
        }
        this.pathnameList = newList;
        return true;
    }

    public String toString() {
        return this.getNominalPathname();
    }

    public void getPathnameTimes(Object dataManager, HecTime start, HecTime end) {
        start.setUndefined();
        end.setUndefined();
        if (this.size() == 0) {
            return;
        }
        String path = this.nominalPathname;
        if (path == null) {
            return;
        }
        int[] partPositions = new int[7];
        int stat = DSSPathname.parsePathname(path, partPositions);
        if (stat != 0) {
            return;
        }
        if (dataManager == null) {
            return;
        }
        if (dataManager instanceof HecDataManager) {
            HecDataManager dm = (HecDataManager)dataManager;
        } else if (dataManager instanceof DssDataManager) {
            HecDataManager dm = (HecDataManager)((Object)((DssDataManager)dataManager).dataManager());
        } else {
            Object dm = null;
        }
        String d = path.substring(partPositions[3], partPositions[4] - 1);
        String ePart = path.substring(partPositions[4], partPositions[5] - 1);
        int interval = HecTimeSeries.getIntervalFromEPart(ePart);
        int idx = d.indexOf(" - ");
        if (idx > 0 && d.length() > 18) {
            String date = d.substring(0, idx);
            start.set(date, "0001");
            if (interval > 0) {
                start.adjustToIntervalOffset(interval, 0);
            }
            date = d.substring(idx + 3);
            end.set(date, "2400");
            char c2 = date.charAt(4);
            String s = date.substring(4, 5).toLowerCase();
            if (s.charAt(0) != c2) {
                HecTime endBlock = CondensedReference.getNextBlockDate(end, ePart);
                endBlock.subtractMinutes(1);
                end.set(endBlock);
            }
        }
        if (!end.isDateDefined()) {
            start.setDate(path.substring(partPositions[3], partPositions[4] - 1));
            int jul = start.julian();
            if (interval > 0) {
                start.setJulian(jul, interval);
                start.adjustToIntervalOffset(interval, 0);
            } else {
                start.setJulian(jul, 1);
            }
            path = DSSPathname.nextTimeSeriesPathname(this.getLastPathname());
            if (path != null && path.length() > 10 && partPositions[4] - 1 > partPositions[3]) {
                end.set(path.substring(partPositions[3], partPositions[4] - 1), "0000");
                end.cleanTime();
                if (interval > 0) {
                    end.adjustToIntervalOffset(interval, 0);
                }
            }
        }
    }

    public void getDataTimes(HecDssCatalog dataManager, HecTime start, HecTime end) {
        if (this._julianStart != -2147483647 && this._julianEnd != -2147483647) {
            start.setJulian(this._julianStart, 1);
            end.setJulian(this._julianEnd, 1440);
            return;
        }
        start.setUndefined();
        end.setUndefined();
        if (this.size() == 0) {
            return;
        }
        String path = this.pathnameList[0];
        if (path == null) {
            return;
        }
        stringContainer units = new stringContainer();
        stringContainer type = new stringContainer();
        if (dataManager != null) {
            int istat = dataManager.getTSRecordInfo(path, start, end, units, type);
            if (istat != 0) {
                return;
            }
            if (this.size() > 1) {
                path = this.getLastPathname();
                HecTime temp = new HecTime();
                dataManager.getTSRecordInfo(path, temp, end, units, type);
            }
        }
    }

    public int generatePathnameList(HecDataManager dataManager, boolean checkPathnames) {
        this.pathnameList = this.generatePathnameList(dataManager, this.getNominalPathname(), checkPathnames);
        if (this.pathnameList == null) {
            return -1;
        }
        return 0;
    }

    protected String[] generatePathnameList(HecDataManager dataManager, String condensedPath, boolean checkPathnames) {
        if (condensedPath == null) {
            return null;
        }
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        DSSPathname path = new DSSPathname(condensedPath);
        if (path.dPart().length() != 21) {
            return null;
        }
        start.set(path.dPart().substring(0, 9), "2400");
        if (!start.isDefined()) {
            return null;
        }
        end.set(path.dPart().substring(12, 21), "2400");
        if (!end.isDefined()) {
            return null;
        }
        return this.generatePathnameList(dataManager, path, checkPathnames, start, end);
    }

    protected String[] generatePathnameList(HecDataManager dataManager, DSSPathname path, boolean checkPathnames, HecTime start, HecTime end) {
        Vector<String> pathList = new Vector<String>();
        int interval = 0;
        String ePart = path.ePart();
        if (ePart.length() == 0) {
            return null;
        }
        int[] nvals = new int[1];
        int[] intl = new int[1];
        int[] istat = new int[]{1};
        Heclib.zgintl(intl, ePart, nvals, istat);
        if (istat[0] == -1) {
            return null;
        }
        if (istat[0] == 0) {
            interval = intl[0];
        }
        if (istat[0] == 1) {
            interval = 0;
        }
        int[] jul = new int[1];
        int[] iblock = new int[1];
        int[] iyr = new int[1];
        int[] imon = new int[1];
        int[] iday = new int[1];
        jul[0] = start.julian();
        int stat = CondensedReference.getBlockStartDate(interval, ePart, jul[0], iblock, iyr, imon, iday);
        if (stat != 0) {
            return null;
        }
        start.setYearMonthDay(iyr[0], imon[0], iday[0], 1440);
        do {
            path.setDPart(start.date(104));
            String pathname = path.pathname();
            if (checkPathnames && dataManager != null) {
                if (dataManager.recordExists(pathname)) {
                    pathList.add(path.pathname());
                }
            } else {
                pathList.add(path.pathname());
            }
            Heclib.zincbk(iblock, jul, iyr, imon, iday);
            start.setJulian(jul[0], 1, 0);
        } while (!start.greaterThan(end));
        return pathList.toArray(new String[0]);
    }

    @Deprecated
    public static HecTime getNextBlockDate(HecDataManager noLongerUsed, HecTime datePart, String ePart) {
        return CondensedReference.getNextBlockDate(datePart, ePart);
    }

    public static HecTime getNextBlockDate(HecTime datePart, String ePart) {
        HecTime htime = new HecTime();
        if (ePart.length() == 0) {
            return htime;
        }
        int[] nvals = new int[1];
        int[] intl = new int[1];
        int[] istat = new int[1];
        int interval = 0;
        istat[0] = 1;
        Heclib.zgintl(intl, ePart, nvals, istat);
        if (istat[0] == -1) {
            return htime;
        }
        if (istat[0] == 0) {
            interval = intl[0];
        }
        if (istat[0] == 1) {
            interval = 0;
        }
        int[] jul = new int[1];
        int[] iblock = new int[1];
        int[] iyr = new int[1];
        int[] imon = new int[1];
        int[] iday = new int[1];
        jul[0] = datePart.julian();
        int stat = CondensedReference.getBlockStartDate(interval, ePart, jul[0], iblock, iyr, imon, iday);
        if (stat != 0) {
            return htime;
        }
        Heclib.zincbk(iblock, jul, iyr, imon, iday);
        htime.setJulian(jul[0], 1, 0);
        return htime;
    }

    protected static int getBlockStartDate(int interval, String ePart, int jul, int[] block, int[] year, int[] month, int[] day) {
        if (interval <= 0) {
            return HecDataManager.getIrregBeginningDate(ePart, jul, year, month, day, block);
        }
        Heclib.zbegdt(jul, interval, year, month, day, block, 99999);
        return 0;
    }

    public Vector getPathnameVector() {
        Vector<String> v = new Vector<String>();
        if (this.collection == null) {
            if (this.pathnameList != null) {
                v.addAll(Arrays.asList(this.pathnameList));
            }
        } else {
            String[] paths = this.getPathnameList();
            v.addAll(Arrays.asList(paths));
        }
        return v;
    }

    public void setJulianStart(int julianStart) {
        this._julianStart = julianStart;
    }

    public void setJulianEnd(int julianEnd) {
        this._julianEnd = julianEnd;
    }
}

