/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSPathname;
import java.io.File;
import java.io.Serializable;
import rma.util.RMAIO;

public class DSSPathAndFilename
extends DSSPathname
implements Serializable {
    protected String _filename = new String("");
    protected boolean _filenameGiven = false;

    public DSSPathAndFilename(String pathname) {
        this.setPathname(pathname);
    }

    public DSSPathAndFilename() {
    }

    @Override
    public int setPathname(String path) {
        int fileLoc = path.toUpperCase().indexOf(".DSS:");
        if (fileLoc == -1) {
            return super.setPathname(path);
        }
        this.setFilename(path.substring(0, fileLoc + 4));
        return super.setPathname(path.substring(fileLoc + 5));
    }

    public boolean isFilenameGiven() {
        return this._filenameGiven;
    }

    public String filename() {
        if (this._filenameGiven) {
            return this._filename;
        }
        return "";
    }

    public void setFilename(String name) {
        this._filename = name.replace('\\', '/');
        this._filenameGiven = name.length() > 0;
    }

    public String combinedPathAndFilename() {
        if (this._filenameGiven) {
            return this._filename + ":" + this.pathname();
        }
        return this.pathname();
    }

    public boolean isSameName(String fullNameToCompare) {
        return this.isSameName(fullNameToCompare, true);
    }

    public boolean isSameName(String fullNameToCompare, boolean compareDpart) {
        String compareName = fullNameToCompare.toUpperCase().replace('\\', '/');
        int fileLoc = compareName.indexOf(".DSS:");
        if (fileLoc == -1) {
            return this.isSamePathname(compareName, compareDpart);
        }
        String path = compareName.substring(fileLoc + 5);
        String file = compareName.substring(0, fileLoc + 4);
        if (!this.isSamePathname(path, compareDpart)) {
            return false;
        }
        if (this._filenameGiven) {
            return this.sameFileNames(file, this._filename);
        }
        return true;
    }

    public boolean sameFileNames(String file1, String file2) {
        String fn2;
        String fn1 = file1.replace('\\', '/');
        if (fn1.equalsIgnoreCase(fn2 = file2.replace('\\', '/'))) {
            return true;
        }
        if (file1.contains("$")) {
            file1 = RMAIO.parsePathName(file1);
        }
        if (file2.contains("$")) {
            file2 = RMAIO.parsePathName(file2);
        }
        file1 = RMAIO.parsePathName(file1);
        file2 = RMAIO.parsePathName(file2);
        File f1 = new File(file1);
        File f2 = new File(file2);
        fn1 = f1.getAbsolutePath();
        return fn1.equalsIgnoreCase(fn2 = f2.getAbsolutePath());
    }
}

