/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DssIntervalUtility;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;

public class DSSPathname
implements Cloneable,
Serializable {
    static final long serialVersionUID = -900883047474057361L;
    public static final int SECONDS_FROM_E_PART = 1;
    public static final int E_PART_FROM_SECONDS = 2;
    public static final int START_ENUMERATION = 3;
    public static final int CONTINUE_ENUMERATION = 4;
    public static final int STATUS_ERROR = -1;
    public static final int STATUS_ENUMERATION_EXHAUSTED = 0;
    public static final int STATUS_REGULAR_TS = 0;
    public static final int STATUS_IRREGULAR_TS = 1;
    public static final int BLOCK_INTERVAL_1DAY = 1;
    public static final int BLOCK_INTERVAL_1MONTH = 2;
    public static final int BLOCK_INTERVAL_1YEAR = 3;
    public static final int BLOCK_INTERVAL_1DECADE = 4;
    public static final int BLOCK_INTERVAL_1CENTURY = 5;
    public static final int VALUE_INTERVAL_1WEEK = 604800;
    public static final int VALUE_INTERVAL_TRI_MONTH = 864000;
    public static final int VALUE_INTERVAL_SEMI_MONTH = 1296000;
    public static final int VALUE_INTERVAL_1MONTH = 2592000;
    public static final int VALUE_INTERVAL_1YEAR = 31536000;
    private static final long ENUM_TIMEOUT = 600000L;
    private static final int[] _secondsValues = new int[]{1, 2, 3, 4, 5, 6, 10, 15, 20, 30, 60, 120, 180, 240, 300, 360, 600, 720, 900, 1200, 1800, 3600, 7200, 10800, 14400, 21600, 28800, 43200, 86400, 604800, 864000, 1296000, 2592000, 31536000};
    private static final String[] _irrNames = new String[]{"IR-Day", "IR-Month", "IR-Year", "IR-Decade", "IR-Century", "~1Second", "~2Second", "~3Second", "~4Second", "~5Second", "~6Second", "~10Second", "~15Second", "~20Second", "~30Second", "~1Minute", "~2Minute", "~3Minute", "~4Minute", "~5Minute", "~6Minute", "~10Minute", "~12Minute", "~15Minute", "~20Minute", "~30Minute", "~1Hour", "~2Hour", "~3Hour", "~4Hour", "~6Hour", "~8Hour", "~12Hour", "~1Day", "~1Week", "~Tri-Month", "~Semi-Month", "~1Month", "~1Year"};
    private static final HashMap<Integer, Integer> _valuesPerBlock = new HashMap();
    private static final HashMap<Long, Long[]> _enumPosition;
    protected static String _defaultFPart;
    protected String _pathname = "";
    protected String _aPart = "";
    protected String _bPart = "";
    protected String _cPart = "";
    protected String _dPart = "";
    protected String _ePart = "";
    protected String _fPart = "";
    public String _delimiter = "/";
    protected boolean _dirty;
    protected boolean _empty;
    static final int MAXPATHNAMELENGTH = 392;
    static final int MAX_PART_LENGTH = 128;
    static final String VALIDPATHPART = "[ -.0-~]*";
    static final Pattern PATHNAMEPATTERN;

    public DSSPathname() {
        this._dirty = true;
        this._empty = true;
    }

    public DSSPathname(String pathname) {
        this.setPathname(pathname);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public static void setDefaultFPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        _defaultFPart = partName;
    }

    public String aPart() {
        return this._aPart;
    }

    public String bPart() {
        return this._bPart;
    }

    public String cPart() {
        return this._cPart;
    }

    public String dPart() {
        return this._dPart;
    }

    public String ePart() {
        return this._ePart;
    }

    public String fPart() {
        return this._fPart;
    }

    public String getAPart() {
        return this._aPart;
    }

    public String getBPart() {
        return this._bPart;
    }

    public String getCPart() {
        return this._cPart;
    }

    public String getDPart() {
        return this._dPart;
    }

    public String getEPart() {
        return this._ePart;
    }

    public String getFPart() {
        return this._fPart;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setCwmsTsId(boolean isCwmsTsId) {
        this._delimiter = isCwmsTsId ? "." : "/";
    }

    public boolean isCwmsTsId() {
        return this._delimiter.equals(".");
    }

    public String[] getParts() {
        String[] parts = new String[]{this._aPart, this._bPart, this._cPart, this._dPart, this._ePart, this._fPart};
        return parts;
    }

    public void setParts(String[] parts) {
        if (parts.length > 0 && parts[0] != null) {
            this._aPart = parts[0];
        }
        if (parts.length > 1 && parts[1] != null) {
            this._bPart = parts[1];
        }
        if (parts.length > 2 && parts[2] != null) {
            this._cPart = parts[2];
        }
        if (parts.length > 3 && parts[3] != null) {
            this._dPart = parts[3];
        }
        if (parts.length > 4 && parts[4] != null) {
            this._ePart = parts[4];
        }
        if (parts.length > 5 && parts[5] != null) {
            this._fPart = parts[5];
        }
        this._empty = false;
        this._dirty = true;
    }

    public String pathname() {
        if (this._dirty || this._pathname.length() == 0) {
            this.formPathname();
        }
        return this._pathname;
    }

    public String getPathname() {
        return this.pathname();
    }

    public String getPathname(boolean removeCollection) {
        boolean collection;
        if (removeCollection && this._fPart != null && this._fPart.length() > 8 && this._fPart.indexOf("|") > 0 && (collection = DSSPathname.isaCollectionPath("//" + this._fPart))) {
            String tempFPart = this._fPart;
            this._fPart = this._fPart.substring(9);
            this.formPathname();
            String path = this._pathname;
            this._fPart = tempFPart;
            this._dirty = true;
            return path;
        }
        return this.pathname();
    }

    public String getPathnameParts() {
        String aPart = this._aPart;
        String bPart = this._bPart;
        String cPart = this._cPart;
        String dPart = this._dPart;
        String ePart = this._ePart;
        String fPart = this._fPart;
        if (fPart.length() == 0) {
            fPart = _defaultFPart;
        }
        return "A=" + aPart + " B=" + bPart + " C=" + cPart + " D=" + dPart + " E=" + ePart + " F=" + fPart;
    }

    public void setAPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        this._aPart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setBPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        this._bPart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setCPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        this._cPart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setDPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        this._dPart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setRealEPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        this._ePart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setEPart(String partName) {
        int mins;
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        if (this._delimiter.equals(".") && partName.length() > 3 && (mins = HecTimeSeries.getIntervalFromEPart(partName)) > 0) {
            try {
                hec.data.Interval intl = new hec.data.Interval(mins);
                String interval = intl.getInterval();
                this.setDPart(interval);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._ePart = partName;
        this._empty = false;
        this._dirty = true;
    }

    public void setFPart(String partName) {
        if (partName.length() > 128) {
            partName = partName.substring(0, 128);
        }
        String collectionSequence = null;
        if (partName.indexOf("|") > 0 && partName.length() > 8) {
            collectionSequence = DSSPathname.getCollectionSequence("//" + partName);
        }
        if (collectionSequence == null && this._fPart != null && this._fPart.length() > 8) {
            if (this._fPart.indexOf("|") > 0 && this._fPart.length() > 8) {
                collectionSequence = DSSPathname.getCollectionSequence("//" + this._fPart);
            }
            this._fPart = collectionSequence != null ? "C:" + collectionSequence + "|" + partName : partName;
        } else {
            this._fPart = partName;
        }
        this._empty = false;
        this._dirty = true;
    }

    public void setCollectionSequence(String collectionSequence) {
        if (collectionSequence == null) {
            boolean isaCollection;
            if (this._fPart != null && (isaCollection = DSSPathname.isaCollectionPath("//" + this._fPart))) {
                this._fPart = this._fPart.substring(9);
            }
        } else if (collectionSequence.length() == 6) {
            if (this._fPart != null && this._fPart.length() > 8) {
                boolean isaCollection = DSSPathname.isaCollectionPath("//" + this._fPart);
                if (isaCollection) {
                    this._fPart = this._fPart.substring(9);
                }
            } else if (this._fPart == null) {
                this._fPart = "";
            }
            this._fPart = "C:" + collectionSequence + "|" + this._fPart;
        }
        this._dirty = true;
    }

    public String getCollectionSequence() {
        String sequence = null;
        if (this._fPart != null && this._fPart.length() > 8) {
            sequence = DSSPathname.getCollectionSequence("//" + this._fPart);
        }
        return sequence;
    }

    public void setCollectionSequence(int sequenceNumber) {
        String collectionSequence = DSSPathname.getCollectionSequence(sequenceNumber);
        this.setCollectionSequence(collectionSequence);
    }

    public static String getCollectionSequence(int sequenceNumber) {
        DecimalFormat format = new DecimalFormat("000000");
        String sequence = format.format(sequenceNumber);
        return sequence;
    }

    public static boolean isaCollectionPath(String pathname) {
        int idx = pathname.indexOf("|");
        if (idx == -1) {
            return false;
        }
        int jdx = pathname.indexOf("/C:");
        if (jdx == -1) {
            return false;
        }
        int len = idx - jdx;
        return len == 9 || len == 18;
    }

    public static boolean isSameCollection(String pathname1, String pathname2) {
        int idx = pathname1.indexOf("|");
        if (idx == -1) {
            return false;
        }
        int jdx = pathname1.indexOf("/C:");
        if (jdx == -1) {
            return false;
        }
        int len = idx - jdx;
        if (len != 9) {
            return false;
        }
        String path1 = pathname1.substring(0, jdx + 3) + pathname1.substring(idx);
        idx = pathname2.indexOf("|");
        if (idx == -1) {
            return false;
        }
        jdx = pathname2.indexOf("/C:");
        if (jdx == -1) {
            return false;
        }
        len = idx - jdx;
        if (len != 9) {
            return false;
        }
        String path2 = pathname2.substring(0, jdx + 3) + pathname2.substring(idx);
        boolean same = DSSPathname.areSamePathnames(path1, path2, false);
        return same;
    }

    public static String getCollectionSequence(String pathname) {
        int idx = pathname.indexOf("|");
        if (idx == -1) {
            return null;
        }
        int jdx = pathname.indexOf("/C:");
        if (jdx == -1) {
            return null;
        }
        int len = idx - jdx;
        if (len != 9) {
            return null;
        }
        return pathname.substring(jdx + 3, idx);
    }

    public int setPathname(String path) {
        if (path == null) {
            return -5;
        }
        if (((String)path).length() < 7) {
            return -5;
        }
        if (((String)path).startsWith("/")) {
            this._delimiter = "/";
        } else {
            if (((String)path).startsWith(" ")) {
                return -5;
            }
            int idx = ((String)path).indexOf(".");
            if (idx < 0) {
                return -5;
            }
            this._delimiter = ".";
            path = this._delimiter + (String)path;
            path = ((String)path).replace('.', '/');
        }
        String[] parts = ((String)path).split("/", 8);
        if (parts.length > 1) {
            this.setAPart(parts[1]);
        } else {
            this._aPart = "";
        }
        if (parts.length > 2) {
            this.setBPart(parts[2]);
        } else {
            this._bPart = "";
        }
        if (parts.length > 3) {
            this.setCPart(parts[3]);
        } else {
            this._cPart = "";
        }
        if (parts.length > 4) {
            this.setDPart(parts[4]);
        } else {
            this._dPart = "";
        }
        if (parts.length > 5) {
            if (this._delimiter == ".") {
                this._ePart = parts[5];
            } else {
                this.setEPart(parts[5]);
            }
        } else {
            this._ePart = "";
        }
        if (parts.length > 6) {
            this._fPart = "";
            this.setFPart(parts[6]);
        } else {
            this.setFPart("");
        }
        this._empty = false;
        this._dirty = true;
        if (parts.length < 4) {
            return -1;
        }
        return 0;
    }

    public int setPathnameParts(String pathnameParts) {
        if (pathnameParts == null) {
            return -1;
        }
        if (pathnameParts.length() < 3) {
            return 0;
        }
        stringContainer apart = new stringContainer();
        stringContainer bpart = new stringContainer();
        stringContainer cpart = new stringContainer();
        stringContainer dpart = new stringContainer();
        stringContainer epart = new stringContainer();
        stringContainer fpart = new stringContainer();
        int status = DSSPathname.getPathnamePartsFromLine(pathnameParts, apart, bpart, cpart, dpart, epart, fpart);
        if (status < 0) {
            return status;
        }
        if (apart.string != null) {
            this.setAPart(apart.string);
        }
        if (bpart.string != null) {
            this.setBPart(bpart.string);
        }
        if (cpart.string != null) {
            this.setCPart(cpart.string);
        }
        if (dpart.string != null) {
            this.setDPart(dpart.string);
        }
        if (epart.string != null) {
            this.setEPart(epart.string);
        }
        if (fpart.string != null) {
            this.setFPart(fpart.string);
        }
        this._dirty = true;
        this._empty = false;
        return status;
    }

    public static boolean isValidPathname(String pathname) {
        if ((pathname = pathname.trim()).length() > 392) {
            return false;
        }
        return PATHNAMEPATTERN.matcher(pathname).find();
    }

    public static boolean areSamePathnames(String pathname1, String pathname2, boolean compareDpart) {
        int i;
        String[] path2;
        if (!pathname1.startsWith("/") || !pathname2.startsWith("/")) {
            compareDpart = true;
        }
        if (compareDpart) {
            return pathname1.equalsIgnoreCase(pathname2);
        }
        String[] path1 = pathname1.toUpperCase().split("/");
        if (path1.length != (path2 = pathname2.toUpperCase().split("/")).length) {
            return false;
        }
        int len = 4;
        if (path1.length < 4) {
            len = path1.length;
        }
        for (i = 1; i < len; ++i) {
            if (path1[i].equals(path2[i])) continue;
            return false;
        }
        len = 7;
        if (path1.length < 7) {
            len = path1.length;
        }
        if (len < 6) {
            return true;
        }
        for (i = 5; i < len; ++i) {
            if (path1[i].equals(path2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isSamePathname(String path, boolean compareDpart) {
        return DSSPathname.areSamePathnames(path, this.pathname(), compareDpart);
    }

    public boolean isTimeSeries() {
        int interval;
        if (!this.isCwmsTsId() && (interval = HecTimeSeriesBase.getIntervalFromEPart(this.getEPart())) >= 0) {
            int len = this.getDPart().length();
            return len == 0 || len == 9 || len == 21;
        }
        return false;
    }

    public String getPairedDataX() {
        int dash = this._cPart.indexOf("-");
        if (dash == -1) {
            return this._cPart;
        }
        if (dash == 0) {
            return "";
        }
        return this._cPart.substring(0, dash);
    }

    public String getPairedDataY() {
        int dash = this._cPart.indexOf("-");
        if (dash == -1) {
            return "";
        }
        if (this._cPart.length() > dash + 1) {
            return this._cPart.substring(dash + 1, this._cPart.length());
        }
        return "";
    }

    public void formPathname() {
        if (this._delimiter.equals("/")) {
            String aPart = this._aPart;
            String bPart = this._bPart;
            String cPart = this._cPart;
            String dPart = this._dPart;
            String ePart = this._ePart;
            String fPart = this._fPart;
            if (fPart.length() == 0) {
                fPart = _defaultFPart;
            }
            this._pathname = Heclib.zpath(aPart, bPart, cPart, dPart, ePart, fPart);
        } else {
            this._pathname = this.getRetrievePath();
        }
        this._dirty = false;
    }

    public String getRetrievePath() {
        String aPart = this._aPart;
        String bPart = this._bPart;
        String cPart = this._cPart;
        String dPart = this._dPart;
        String ePart = this._ePart;
        String fPart = this._fPart;
        if (fPart.length() == 0) {
            fPart = _defaultFPart;
        }
        StringBuffer path = new StringBuffer();
        if (this._delimiter.equals("/")) {
            path.append(this._delimiter);
        }
        path.append(aPart.trim() + this._delimiter);
        path.append(bPart.trim() + this._delimiter);
        path.append(cPart.trim() + this._delimiter);
        path.append(dPart.trim() + this._delimiter);
        path.append(ePart.trim() + this._delimiter);
        path.append(fPart.trim());
        if (this._delimiter.equals("/")) {
            path.append(this._delimiter);
            return path.toString();
        }
        return path.toString();
    }

    public static int parsePathname(String path, int[] slashPositions) {
        if (path.startsWith("/")) {
            int istart = 1;
            slashPositions[0] = 1;
            for (int i = 1; i < 7; ++i) {
                int ipos = path.indexOf("/", istart);
                if (ipos < 0) {
                    int len = path.length();
                    for (int j = 6; j >= i; --j) {
                        slashPositions[i] = len--;
                    }
                    return i;
                }
                slashPositions[i] = istart = ipos + 1;
            }
        } else {
            int istart = 0;
            slashPositions[0] = 0;
            for (int i = 1; i < 7; ++i) {
                int ipos = path.indexOf(".", istart);
                if (ipos < 0) {
                    int len = path.length() + 1;
                    for (int j = 6; j >= i; --j) {
                        slashPositions[i] = len--;
                    }
                    if (i == 6) {
                        return 0;
                    }
                    return i;
                }
                slashPositions[i] = istart = ipos + 1;
            }
        }
        return 0;
    }

    public static Vector<String> parseDssPath(String pathname) {
        Vector<String> partvec = null;
        if (pathname == null || pathname.length() < 2) {
            return null;
        }
        int[] partPositions = new int[7];
        int stat = DSSPathname.parsePathname(pathname, partPositions);
        if (stat != 0) {
            return partvec;
        }
        partvec = new Vector<String>();
        for (int j = 0; j < 6; ++j) {
            int length = partPositions[j + 1] - partPositions[j];
            String part = length > 0 ? pathname.substring(partPositions[j], partPositions[j + 1] - 1) : " ";
            partvec.addElement(part);
        }
        return partvec;
    }

    public boolean dirty() {
        return this._dirty;
    }

    public String toString() {
        return this.pathname();
    }

    public boolean hasBeenSet() {
        return !this._empty;
    }

    public static String pathnameToTsId(String pathname, String type) {
        DSSPathname path = new DSSPathname(pathname);
        StringBuilder id = new StringBuilder();
        Object loc = "";
        if (!path.aPart().trim().isEmpty()) {
            String niceAPart = DSSPathname.makeNice(path.aPart());
            loc = (String)loc + niceAPart.substring(0, Math.min(24, niceAPart.length()));
        }
        if (!path.bPart().trim().isEmpty()) {
            String niceBPart = DSSPathname.makeNice(path.bPart());
            loc = (String)loc + "-" + niceBPart.substring(0, Math.min(32, niceBPart.length()));
        }
        id.append((String)loc);
        id.append(".");
        id.append(DSSPathname.makeNice(path.cPart()));
        id.append(".");
        String parameterTypeString = DSSPathname.getParameterTypeString(type);
        id.append(parameterTypeString);
        id.append(".");
        Interval defaultInterval = IntervalFactory.findAny((Predicate)IntervalFactory.equalsMinutes((int)HecTimeSeries.getIntervalFromEPart(path.ePart()))).orElse(IntervalFactory.irregular());
        String interval = IntervalFactory.findAny((Predicate)IntervalFactory.equalsName((String)path.ePart())).orElse(defaultInterval).getInterval();
        id.append(interval);
        id.append(".");
        if (type.startsWith("INS")) {
            id.append("0.");
        } else {
            id.append(interval.replace("~", "").replace("Local", ""));
            id.append(".");
        }
        id.append(DSSPathname.makeNice(path.fPart()));
        return id.toString();
    }

    public static String getParameterTypeString(String dssType) {
        String upperType = dssType.toUpperCase();
        String retval = upperType.indexOf("INST") > -1 ? "Inst" : (upperType.indexOf("AVE") > -1 ? "Ave" : (upperType.indexOf("CUM") > -1 ? "Total" : (upperType.indexOf("MAX") > -1 ? "Max" : (upperType.indexOf("MIN") > -1 ? "Min" : (upperType.indexOf("CONST") > -1 ? "Const" : "Inst")))));
        return retval;
    }

    public static String makeNice(String s) {
        StringBuffer sb = new StringBuffer();
        s = s.toLowerCase();
        boolean nextUp = true;
        char[] c2 = s.toCharArray();
        for (int i = 0; i < c2.length; ++i) {
            if (nextUp) {
                sb.append(Character.toUpperCase(c2[i]));
                nextUp = false;
            } else {
                sb.append(c2[i]);
            }
            if (c2[i] != ' ' && c2[i] != '-') continue;
            nextUp = true;
        }
        String string = sb.toString();
        string = string.replace('.', '_');
        return string;
    }

    public static String tsIdToPathname(String tsId, int minsPerValue) {
        tsId = tsId.replace('/', '-');
        tsId = tsId.replace('.', '/');
        String[] parts = tsId.split("/");
        DSSPathname path = new DSSPathname();
        path.setBPart(parts[0]);
        path.setCPart(parts[1]);
        path.setFPart(parts[5]);
        if (parts[3].equals("0")) {
            if (minsPerValue < 30) {
                path.setEPart("IR-Day");
            } else {
                path.setEPart("IR-Month");
            }
        } else {
            Object interval = null;
            if (minsPerValue > 0) {
                int[] istat = new int[1];
                interval = Heclib.getDSSEPartFromInterval(minsPerValue, istat);
                if (istat[0] != 0) {
                    interval = null;
                }
            }
            if (interval == null) {
                interval = parts[3];
                int i = ((String)interval).toUpperCase().indexOf("MINUTE");
                if (i > 0) {
                    interval = ((String)interval).substring(0, i) + "Minute";
                }
                if (((String)interval).toUpperCase().endsWith("S")) {
                    interval = ((String)interval).substring(0, ((String)interval).length() - 1);
                }
            }
            path.setEPart((String)interval);
        }
        return path.pathname();
    }

    public static String buildPathnameFromParts(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart) {
        StringBuffer pathname = new StringBuffer();
        char[][] parts = new char[7][];
        if (aPart != null) {
            parts[0] = aPart.trim().toCharArray();
        }
        if (bPart != null) {
            parts[1] = bPart.trim().toCharArray();
        }
        if (cPart != null) {
            parts[2] = cPart.trim().toCharArray();
        }
        if (dPart != null) {
            parts[3] = dPart.trim().toCharArray();
        }
        if (ePart != null) {
            parts[4] = ePart.trim().toCharArray();
        }
        if (fPart != null) {
            parts[5] = fPart.trim().toCharArray();
        }
        pathname.append('/');
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < (parts[i] == null ? 0 : parts[i].length); ++j) {
                if (parts[i][j] >= ' ' && parts[i][j] != '/') continue;
                parts[i][j] = 63;
            }
            if (parts[i] != null) {
                pathname.append(parts[i]);
            }
            pathname.append('/');
        }
        return pathname.toString();
    }

    public static int getPathnamePartPositions(String pathname, int[] startPositions, int[] endPositions, int[] lengths) {
        if (pathname == null) {
            return -1;
        }
        Pattern p = Pattern.compile("^[^/]*/([^/]*)/([^/]*)/([^/]*)/([^/]*)/([^/]*)/([^/]*)/.*$");
        Matcher m = p.matcher(pathname);
        if (!m.matches()) {
            return -1;
        }
        for (int i = 0; i < 6; ++i) {
            if (startPositions != null && startPositions.length > i) {
                startPositions[i] = m.start(i + 1);
            }
            if (endPositions != null && endPositions.length > i) {
                endPositions[i] = m.end(i + 1);
            }
            if (lengths == null || lengths.length <= i) continue;
            lengths[i] = m.end(i + 1) - m.start(i + 1);
        }
        return 0;
    }

    public static int getPathnamePartsFromLine(String inputLine, stringContainer aPart, stringContainer bPart, stringContainer cPart, stringContainer dPart, stringContainer ePart, stringContainer fPart) {
        if (aPart != null) {
            aPart.string = null;
        }
        if (bPart != null) {
            bPart.string = null;
        }
        if (cPart != null) {
            cPart.string = null;
        }
        if (dPart != null) {
            dPart.string = null;
        }
        if (ePart != null) {
            ePart.string = null;
        }
        if (fPart != null) {
            fPart.string = null;
        }
        if (inputLine.indexOf(61) == -1) {
            return -1;
        }
        Pattern p = Pattern.compile("(\\w+)\\s*=(.+?)(?=\\w+?\\s*=|$)");
        Matcher m = p.matcher(inputLine);
        if (m != null) {
            while (m.find()) {
                switch (m.group(1)) {
                    case "A": {
                        if (aPart == null) break;
                        aPart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                        break;
                    }
                    case "B": {
                        if (bPart == null) break;
                        bPart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                        break;
                    }
                    case "C": {
                        if (cPart == null) break;
                        cPart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                        break;
                    }
                    case "D": {
                        if (dPart == null) break;
                        dPart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                        break;
                    }
                    case "E": {
                        if (ePart == null) break;
                        ePart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                        break;
                    }
                    case "F": {
                        if (fPart == null) break;
                        fPart.string = m.group(2).split(",")[0].replaceAll("\\s+$", "");
                    }
                }
            }
        }
        return 0;
    }

    public static String getRegularTsEPartFromInterval(int dssVersion, int interval, int[] status) {
        Optional intvl = null;
        String ePart = null;
        if (interval > 0) {
            if (dssVersion < 7) {
                intvl = IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsMinutes((int)interval));
                if (intvl.isPresent()) {
                    ePart = ((Interval)intvl.get()).getInterval().toUpperCase().replaceAll("MINUTES?", "MIN").replaceAll("1MONTH", "1MON");
                }
            } else {
                intvl = IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsSeconds((int)interval));
                if (intvl.isPresent()) {
                    ePart = ((Interval)intvl.get()).getInterval();
                }
            }
        }
        if (ePart == null) {
            if (status != null && status.length > 0) {
                status[0] = -1;
            }
            return "";
        }
        if (status != null && status.length > 0) {
            status[0] = 0;
        }
        return ePart;
    }

    public static int getTSIntervalSeconds(String ePart, int[] block) {
        int seconds = 0;
        int blockSize = 0;
        if ((ePart = ePart.toUpperCase()) != null && ePart.length() != 0) {
            if (ePart.equals("0")) {
                seconds = -3;
                blockSize = 3;
            } else if (ePart.equals("1M")) {
                seconds = ((Interval)IntervalFactory.findAnyDss((Predicate)IntervalFactory.equalsName((String)"1Month")).get()).getSeconds();
            } else if ("IR-DECADE".startsWith(ePart) || ePart.startsWith("IR-DECADE")) {
                seconds = -4;
                blockSize = 4;
            } else if (ePart.startsWith("IR-") && ePart.length() > 3) {
                switch (ePart.substring(0, 4)) {
                    case "IR-C": {
                        seconds = -5;
                        blockSize = 5;
                        break;
                    }
                    case "IR-Y": {
                        seconds = -3;
                        blockSize = 3;
                        break;
                    }
                    case "IR-M": {
                        seconds = -2;
                        blockSize = 2;
                        break;
                    }
                    case "IR-D": {
                        seconds = -1;
                        blockSize = 1;
                    }
                }
            } else if (ePart.startsWith("~")) {
                if (ePart.startsWith("~1Y") || ePart.startsWith("~1MO")) {
                    seconds = -5;
                    blockSize = 5;
                } else if (ePart.startsWith("~SEMI-MO") || ePart.startsWith("~TRI-MO") || ePart.startsWith("~1W")) {
                    seconds = -4;
                    blockSize = 4;
                } else if (ePart.indexOf(68) == 2 || ePart.indexOf(72) == 3 || ePart.startsWith("~8H") || ePart.startsWith("~6H")) {
                    seconds = -3;
                    blockSize = 3;
                } else if (ePart.indexOf(72) == 2 || ePart.startsWith("~30M")) {
                    seconds = -2;
                    blockSize = 2;
                } else {
                    seconds = -1;
                    blockSize = 1;
                }
            } else {
                Optional any = IntervalFactory.findAnyDss(IntervalFactory.isRegular().and(IntervalFactory.equalsName((String)ePart)));
                if (!any.isPresent()) {
                    String intervalName = ePart;
                    any = IntervalFactory.findAnyDss(IntervalFactory.isRegular().and(i -> i.getInterval().toUpperCase().startsWith(intervalName) || intervalName.startsWith(i.getInterval().toUpperCase())));
                }
                if (any.isPresent()) {
                    Interval intvl = (Interval)any.get();
                    seconds = intvl.getSeconds();
                    blockSize = seconds < 900 ? 1 : (seconds < 86400 ? 2 : (seconds < 604800 ? 3 : (seconds < 31536000 ? 4 : 5)));
                }
            }
        }
        if (block != null && block.length > 0) {
            block[0] = blockSize;
        }
        return seconds;
    }

    public static int getTSBlockInfo(String ePart, int julian, int[] blockStartDate, int[] blockInterval, int[] valueInterval, int[] valuesPerBlock) {
        int[] ymd = new int[3];
        int[] _blockInterval = new int[1];
        int _valueInterval = DSSPathname.getTSIntervalSeconds(ePart, _blockInterval);
        if (valueInterval != null && valueInterval.length > 0) {
            valueInterval[0] = _valueInterval;
        }
        if (blockInterval != null && blockInterval.length > 0) {
            blockInterval[0] = _blockInterval[0];
        }
        if (valuesPerBlock != null && valuesPerBlock.length > 0) {
            valuesPerBlock[0] = _valueInterval < 0 ? 0 : _valuesPerBlock.get(_valueInterval);
        }
        HecTime.jliymd(julian, ymd);
        switch (_blockInterval[0]) {
            case 1: {
                if (blockStartDate == null || blockStartDate.length <= 2) break;
                blockStartDate[0] = ymd[0];
                blockStartDate[1] = ymd[1];
                blockStartDate[2] = ymd[2];
                break;
            }
            case 2: {
                if (blockStartDate == null || blockStartDate.length <= 2) break;
                blockStartDate[0] = ymd[0];
                blockStartDate[1] = ymd[1];
                blockStartDate[2] = 1;
                break;
            }
            case 3: {
                if (blockStartDate == null || blockStartDate.length <= 2) break;
                blockStartDate[0] = ymd[0];
                blockStartDate[1] = 1;
                blockStartDate[2] = 1;
                break;
            }
            case 4: {
                if (blockStartDate == null || blockStartDate.length <= 2) break;
                blockStartDate[0] = ymd[0] - ymd[0] % 10;
                blockStartDate[1] = 1;
                blockStartDate[2] = 1;
                break;
            }
            case 5: {
                if (blockStartDate == null || blockStartDate.length <= 2) break;
                blockStartDate[0] = ymd[0] - ymd[0] % 100;
                blockStartDate[1] = 1;
                blockStartDate[2] = 1;
                break;
            }
            default: {
                return -1;
            }
        }
        return 0;
    }

    public static void getTsIntervalInfo(int[] seconds, stringContainer ePart, int[] valuesPerBlock, int[] status) throws Exception {
        int secs = -1;
        if (seconds == null || seconds.length == 0) {
            throw new Exception("Parameter seconds is null or zero length");
        }
        if (ePart == null) {
            throw new Exception("Parameter ePart is null");
        }
        if (valuesPerBlock == null || valuesPerBlock.length == 0) {
            throw new Exception("Parameter valuesPerBlock is null or zero length");
        }
        if (status == null || status.length == 0) {
            throw new Exception("Parameter status is null or zero length");
        }
        switch (status[0]) {
            case 1: {
                secs = DSSPathname.getTSIntervalSeconds(ePart.toString(), null);
                if (secs == 0) {
                    seconds[0] = 0;
                    valuesPerBlock[0] = 0;
                    status[0] = -1;
                    break;
                }
                if (secs < 0) {
                    seconds[0] = secs;
                    valuesPerBlock[0] = 0;
                    status[0] = 1;
                    break;
                }
                seconds[0] = secs;
                valuesPerBlock[0] = _valuesPerBlock.get(secs);
                status[0] = 0;
                break;
            }
            case 2: {
                Optional intvl = IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsSeconds((int)seconds[0]));
                if (intvl.isPresent()) {
                    ePart.string = ((Interval)intvl.get()).getInterval();
                    if (((Interval)intvl.get()).isRegular()) {
                        valuesPerBlock[0] = _valuesPerBlock.get(((Interval)intvl.get()).getSeconds());
                        status[0] = 0;
                        break;
                    }
                    valuesPerBlock[0] = 0;
                    status[0] = 1;
                    break;
                }
                valuesPerBlock[0] = 0;
                status[0] = -1;
                break;
            }
            case 3: {
                long now = System.currentTimeMillis();
                for (long tid : _enumPosition.keySet()) {
                    if (_enumPosition.get(tid)[1] - now <= 600000L) continue;
                    _enumPosition.remove(tid);
                }
                _enumPosition.put(Thread.currentThread().getId(), new Long[]{(long)(-_irrNames.length) + 1L, now});
                ePart.string = _irrNames[0];
                seconds[0] = -1;
                valuesPerBlock[0] = 0;
                status[0] = 4;
                break;
            }
            case 4: {
                long tid = Thread.currentThread().getId();
                Long[] posAndTime = _enumPosition.get(tid);
                if (posAndTime == null) {
                    ePart.string = "";
                    seconds[0] = 0;
                    valuesPerBlock[0] = 0;
                    status[0] = -1;
                    break;
                }
                int pos = posAndTime[0].intValue();
                if (pos >= _secondsValues.length) {
                    ePart.string = "";
                    seconds[0] = 0;
                    valuesPerBlock[0] = 0;
                    status[0] = 0;
                    _enumPosition.remove(tid);
                    break;
                }
                if (pos < 0) {
                    ePart.string = _irrNames[_irrNames.length + pos];
                    seconds[0] = DSSPathname.getTSIntervalSeconds(ePart.string, null);
                    valuesPerBlock[0] = 0;
                    status[0] = 4;
                    _enumPosition.put(tid, new Long[]{++pos, System.currentTimeMillis()});
                    break;
                }
                secs = _secondsValues[pos];
                ePart.string = ((Interval)IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsSeconds((int)secs)).get()).getInterval();
                seconds[0] = secs;
                valuesPerBlock[0] = _valuesPerBlock.get(secs);
                status[0] = pos == _secondsValues.length - 1 ? 0 : 4;
                _enumPosition.put(tid, new Long[]{++pos, System.currentTimeMillis()});
                break;
            }
            default: {
                status[0] = -1;
            }
        }
    }

    public static HecTime incrementInterval(HecTime topOfInterval, int intervalSeconds, int incrementCount) {
        HecTime newTime = null;
        boolean showsTimeAsBeginningOfDay = topOfInterval.getShowsTimeAsBeginningOfDay();
        topOfInterval.showTimeAsBeginningOfDay(true);
        if (intervalSeconds * incrementCount == 0) {
            newTime = new HecTime(topOfInterval);
            return newTime;
        }
        if (intervalSeconds < 0) {
            if (-intervalSeconds == 1) {
                newTime = new HecTime(topOfInterval);
                newTime.addDays(incrementCount);
            } else {
                int yr = topOfInterval.year();
                int mon = topOfInterval.month();
                int day = topOfInterval.day();
                switch (-intervalSeconds) {
                    case 2: {
                        newTime = new HecTime(topOfInterval);
                        mon += incrementCount;
                        while (mon > 12) {
                            ++yr;
                            mon -= 12;
                        }
                        while (mon < 1) {
                            --yr;
                            mon += 12;
                        }
                        break;
                    }
                    case 3: {
                        newTime = new HecTime(topOfInterval);
                        yr += incrementCount;
                        break;
                    }
                    case 4: {
                        newTime = new HecTime(topOfInterval);
                        yr += incrementCount * 10;
                        break;
                    }
                    case 5: {
                        newTime = new HecTime(topOfInterval);
                        yr += incrementCount * 100;
                    }
                }
                if (newTime != null) {
                    newTime.setYearMonthDay(yr, mon, day, 0);
                }
            }
        } else if (IntervalFactory.findAnyDss7((Predicate)IntervalFactory.equalsSeconds((int)intervalSeconds)).isPresent()) {
            newTime = new HecTime(topOfInterval);
            newTime.showTimeAsBeginningOfDay(true);
            switch (intervalSeconds) {
                case 604800: {
                    if (incrementCount > 0) {
                        newTime.subtractDays(newTime.dayOfWeek() - 1);
                    } else {
                        newTime.addDays((8 - newTime.dayOfWeek()) % 7);
                    }
                    newTime.addSeconds(incrementCount * intervalSeconds);
                    newTime.subtractSeconds(newTime.secondsSinceMidnight());
                    break;
                }
                case 864000: {
                    if (incrementCount > 0) {
                        for (int i = 0; i < incrementCount; ++i) {
                            newTime.addDays(11);
                            newTime.subtractDays(newTime.day() % 10 - 1);
                        }
                    } else {
                        for (int i = 0; i > incrementCount; --i) {
                            newTime.subtractDays(11);
                            int day = newTime.day();
                            if (day % 10 == 1) continue;
                            newTime.addDays(newTime.day() % 10 + 1);
                        }
                    }
                    newTime.subtractSeconds(newTime.secondsSinceMidnight());
                    break;
                }
                case 1296000: {
                    if (incrementCount > 0) {
                        for (int i = 0; i < incrementCount; ++i) {
                            newTime.addDays(16);
                            int day = newTime.day();
                            if (day > 16) {
                                newTime.subtractDays(day - 16);
                                continue;
                            }
                            if (day <= 1) continue;
                            newTime.subtractDays(day - 1);
                        }
                    } else {
                        for (int i = 0; i > incrementCount; --i) {
                            newTime.subtractDays(16);
                            int day = newTime.day();
                            if (day < 16) {
                                newTime.addDays(16 - day);
                                continue;
                            }
                            if (day <= 16) continue;
                            newTime.addDays(HecTime.maxDay(newTime.year(), newTime.month()) - day + 1);
                        }
                    }
                    newTime.subtractSeconds(newTime.secondsSinceMidnight());
                    break;
                }
                case 2592000: {
                    int yr = topOfInterval.year();
                    int mon = topOfInterval.month();
                    if (incrementCount > 0) {
                        for (int i = 0; i < incrementCount; ++i) {
                            if (++mon != 13) continue;
                            mon = 1;
                            ++yr;
                        }
                    } else {
                        for (int i = 0; i > incrementCount; --i) {
                            if (--mon != 0) continue;
                            mon = 12;
                            --yr;
                        }
                    }
                    newTime.setYearMonthDay(yr, mon, 1, 0);
                    break;
                }
                case 31536000: {
                    int yr = topOfInterval.year() + incrementCount;
                    newTime.setYearMonthDay(yr, 1, 1, 0);
                    break;
                }
                default: {
                    if (intervalSeconds < 60) {
                        newTime = new HecTime(10);
                        newTime.setJulian(topOfInterval.julian(), topOfInterval.minutesSinceMidnight(), topOfInterval.secondsSinceMidnight() % 60);
                    }
                    newTime.addSeconds(incrementCount * intervalSeconds);
                    int minutes = newTime.minutesSinceMidnight();
                    if (intervalSeconds <= 60 || minutes % (intervalSeconds / 60) == 0) break;
                    if (incrementCount > 0) {
                        newTime.subtractMinutes(newTime.minutesSinceMidnight() % (intervalSeconds / 60));
                        break;
                    }
                    newTime.addMinutes(intervalSeconds / 60 - newTime.minutesSinceMidnight() % (intervalSeconds / 60));
                }
            }
        }
        topOfInterval.showTimeAsBeginningOfDay(showsTimeAsBeginningOfDay);
        return newTime;
    }

    public static String incrementTSPathname(String basePathname, int incrementCount, int[] status) {
        if (status != null && status.length > 0) {
            status[0] = 0;
        }
        String newPathname = null;
        CharSequence[] parts = basePathname.split("/", -1);
        parts[5] = parts[5].toUpperCase();
        HecTime t = new HecTime();
        t.showTimeAsBeginningOfDay(true);
        t.set(parts[4]);
        int julian = t.julian();
        int[] newJulian = new int[]{0};
        int[] newMinutes = new int[]{0};
        int[] block = new int[]{0};
        Interval interval = null;
        Set intervals = IntervalFactory.findAllDss((Predicate)IntervalFactory.isRegular());
        for (Interval intvl : intervals) {
            if (!intvl.getInterval().toUpperCase().equals(parts[5])) continue;
            interval = intvl;
            break;
        }
        if (interval == null) {
            intervals = IntervalFactory.findAllDss((Predicate)IntervalFactory.isIrregular());
            for (Interval intvl : intervals) {
                if (!intvl.getInterval().toUpperCase().equals(parts[5])) continue;
                interval = intvl;
                break;
            }
        }
        if (interval == null) {
            if (status != null && status.length > 0) {
                status[0] = -1;
            }
            return null;
        }
        DSSPathname.getTSIntervalSeconds(parts[5], block);
        HecTime blockStartDate = new HecTime();
        blockStartDate.set(parts[4]);
        blockStartDate = DSSPathname.incrementInterval(blockStartDate, -block[0], incrementCount);
        if (blockStartDate == null) {
            if (status != null && status.length > 0) {
                status[0] = -1;
            }
        } else {
            parts[4] = blockStartDate.date(4);
            newPathname = String.join((CharSequence)"/", parts);
        }
        return newPathname;
    }

    public static String nextTimeSeriesPathname(String basePathname) {
        int[] status = new int[1];
        String rval = DSSPathname.incrementTSPathname(basePathname, 1, status);
        if (rval == null) {
            rval = "";
        }
        return rval;
    }

    public static HecTime getTSTopOfInterval(HecTime t, int intervalSeconds, int offsetSeconds) {
        if (intervalSeconds == 0) {
            return new HecTime(t);
        }
        HecTime prev = DSSPathname.incrementInterval(t, intervalSeconds, -1);
        HecTime next = DSSPathname.incrementInterval(prev, intervalSeconds, 1);
        if (next.greaterThan(t)) {
            prev.addSeconds(offsetSeconds);
            return prev;
        }
        next.addSeconds(offsetSeconds);
        return next;
    }

    public static int getTSIntervalOffset(HecTime t, int intervalSeconds) {
        int offset = -1;
        HecTime topOfInterval = DSSPathname.getTSTopOfInterval(t, intervalSeconds, 0);
        if (topOfInterval != null) {
            offset = (int)((t.getTimeInMillis() - topOfInterval.getTimeInMillis()) / 1000L);
        }
        return offset;
    }

    public static String convertIrregularToPseudo(String pathname, String regularIntervalEpart) {
        DSSPathname p = new DSSPathname(pathname);
        String[] x = DssIntervalUtility.getPseudo(a -> a.getRegular().equalsIgnoreCase(regularIntervalEpart));
        if (x.length != 1) {
            return null;
        }
        p.setEPart(x[0]);
        return p.pathname();
    }

    public static String convertPseudoToIrregular(String pathname) {
        DSSPathname pseudo = new DSSPathname(pathname);
        String e = pseudo.getEPart();
        String[] x = DssIntervalUtility.getIrregular(a -> a.getPseudo().equalsIgnoreCase(e));
        if (x.length != 1) {
            return null;
        }
        pseudo.setEPart(x[0]);
        return pseudo.getPathname();
    }

    static {
        _valuesPerBlock.put(_secondsValues[0], 86400);
        _valuesPerBlock.put(_secondsValues[1], 43200);
        _valuesPerBlock.put(_secondsValues[2], 28800);
        _valuesPerBlock.put(_secondsValues[3], 21600);
        _valuesPerBlock.put(_secondsValues[4], 17280);
        _valuesPerBlock.put(_secondsValues[5], 14400);
        _valuesPerBlock.put(_secondsValues[6], 8640);
        _valuesPerBlock.put(_secondsValues[7], 5760);
        _valuesPerBlock.put(_secondsValues[8], 4320);
        _valuesPerBlock.put(_secondsValues[9], 2880);
        _valuesPerBlock.put(_secondsValues[10], 1440);
        _valuesPerBlock.put(_secondsValues[11], 720);
        _valuesPerBlock.put(_secondsValues[12], 480);
        _valuesPerBlock.put(_secondsValues[13], 360);
        _valuesPerBlock.put(_secondsValues[14], 288);
        _valuesPerBlock.put(_secondsValues[15], 240);
        _valuesPerBlock.put(_secondsValues[16], 144);
        _valuesPerBlock.put(_secondsValues[17], 120);
        _valuesPerBlock.put(_secondsValues[18], 2976);
        _valuesPerBlock.put(_secondsValues[19], 2232);
        _valuesPerBlock.put(_secondsValues[20], 1488);
        _valuesPerBlock.put(_secondsValues[21], 744);
        _valuesPerBlock.put(_secondsValues[22], 372);
        _valuesPerBlock.put(_secondsValues[23], 248);
        _valuesPerBlock.put(_secondsValues[24], 186);
        _valuesPerBlock.put(_secondsValues[25], 124);
        _valuesPerBlock.put(_secondsValues[26], 93);
        _valuesPerBlock.put(_secondsValues[27], 62);
        _valuesPerBlock.put(_secondsValues[28], 366);
        _valuesPerBlock.put(_secondsValues[29], 522);
        _valuesPerBlock.put(_secondsValues[30], 360);
        _valuesPerBlock.put(_secondsValues[31], 240);
        _valuesPerBlock.put(_secondsValues[32], 120);
        _valuesPerBlock.put(_secondsValues[33], 100);
        _enumPosition = new HashMap();
        _defaultFPart = "";
        PATHNAMEPATTERN = Pattern.compile("^[/][ -.0-~]*[/][ -.0-~]*[/][ -.0-~]*[/][ -.0-~]*[/][ -.0-~]*[/][ -.0-~]*[/]$");
    }
}

