/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.IDataReference;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import java.io.Serializable;
import java.util.Vector;
import rma.util.RMAIO;

public class DataReference
implements IDataReference,
Cloneable,
Serializable {
    protected String pathname = null;
    protected String filename = null;
    protected HecTime startTime = null;
    protected HecTime endTime = null;
    protected CondensedReference condensedReference = null;
    protected boolean _waterYearSet = false;
    public static boolean _showFilename = false;
    private String host = null;
    private Integer port = null;
    int m_offsetFromGmt = 0;

    public DataReference(String path, String file) {
        this.pathname = path;
        this.filename = file;
    }

    public DataReference(String path, String file, String timeWindow) {
        this.pathname = path;
        this.filename = file;
        this.startTime = new HecTime();
        this.endTime = new HecTime();
        int stat = HecTime.getTimeWindow(timeWindow, this.startTime, this.endTime);
        if (stat != 0) {
            this.startTime = null;
            this.endTime = null;
        }
    }

    public DataReference(DSSIdentifier dssId) {
        this.pathname = dssId.getDSSPath();
        this.filename = dssId.getFileName();
        String timeWindow = dssId.getTimeWindow();
        if (timeWindow.length() > 0) {
            this.startTime = new HecTime();
            this.endTime = new HecTime();
            int stat = HecTime.getTimeWindow(timeWindow, this.startTime, this.endTime);
            if (stat != 0) {
                this.startTime = null;
                this.endTime = null;
            }
        }
    }

    public DataReference(String path, String file, CondensedReference condensed) {
        this.pathname = path;
        this.filename = file;
        this.condensedReference = condensed;
    }

    public void setTimeWindow(String timeWindow) {
        if (timeWindow == null || timeWindow.length() == 0) {
            this.startTime = null;
            this.endTime = null;
        } else {
            this.startTime = new HecTime();
            this.endTime = new HecTime();
            HecTime.getTimeWindow(timeWindow, this.startTime, this.endTime);
        }
    }

    public void setTimeWindow(HecTime start, HecTime end) {
        this.startTime = start != null && start.isDefined() ? new HecTime(start) : null;
        this.endTime = end != null && end.isDefined() ? new HecTime(end) : null;
    }

    public void setWaterYear(HecTime waterYearStartDate) {
        this.startTime = (HecTime)waterYearStartDate.clone();
        this._waterYearSet = true;
    }

    public boolean isWaterYear() {
        return this._waterYearSet;
    }

    public boolean hasTimeWindow() {
        if (this.startTime == null || this.endTime == null) {
            return false;
        }
        return this.startTime != null && this.startTime.isDefined() && this.endTime != null && this.endTime.isDefined();
    }

    public boolean getTimeWindow(HecTime start, HecTime end) {
        if (this.hasTimeWindow()) {
            start.set(this.startTime);
            end.set(this.endTime);
            return true;
        }
        start.setUndefined();
        end.setUndefined();
        return false;
    }

    public boolean getTimeWindow(Object dataManager, HecTime start, HecTime end) {
        if (this.startTime != null && this.startTime.isDefined() && this.endTime != null && this.endTime.isDefined()) {
            start.set(this.startTime);
            end.set(this.endTime);
            return true;
        }
        if (this.condensedReference == null || dataManager == null) {
            DSSPathname dssPathname = new DSSPathname(this.pathname);
            if (dssPathname.dPart().length() == 21 && dssPathname.dPart().indexOf(" - ") == 9) {
                String ePart = dssPathname.ePart();
                int interval = HecTimeSeries.getIntervalFromEPart(ePart);
                if (this.startTime == null) {
                    this.startTime = new HecTime();
                }
                if (!this.startTime.isDefined()) {
                    this.startTime.setDate(dssPathname.dPart().substring(0, 9));
                    int jul = start.julian();
                    if (interval > 0) {
                        start.setJulian(jul, interval);
                        start.adjustToIntervalOffset(interval, 0);
                    } else {
                        start.setJulian(jul, 1);
                    }
                }
                if (this.endTime == null) {
                    this.endTime = new HecTime();
                }
                if (!this.endTime.isDefined()) {
                    this.endTime.setDate(dssPathname.dPart().substring(12));
                    this.endTime.setTime("2400");
                }
            }
            start.set(this.startTime);
            end.set(this.endTime);
            return start.isDefined();
        }
        this.condensedReference.getPathnameTimes(dataManager, start, end);
        return start.isDefined();
    }

    @Override
    public DSSPathname getDSSPathname() {
        return new DSSPathname(this.pathname);
    }

    public Object clone() {
        DataReference dataRef = new DataReference(this.pathname, this.filename, this.condensedReference);
        dataRef.setTimeWindow(this.startTime, this.endTime);
        dataRef.setGmtOffset(this.getGmtOffset());
        dataRef.setHost(this.host);
        dataRef.setPort(this.port);
        return dataRef;
    }

    public void setHost(String strHost) {
        this.host = strHost;
    }

    public void setPort(Integer iPort) {
        this.port = iPort != null ? new Integer(iPort) : null;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        String name = this.getNominalPathname();
        return name;
    }

    public String getNominalPathname() {
        return this.getNominalPathname(_showFilename);
    }

    public String getNominalPathname(boolean showFilename) {
        Object file = showFilename ? RMAIO.getFileFromPath(this.filename) + ":" : "";
        if (this.condensedReference != null) {
            return (String)file + this.condensedReference.getNominalPathname();
        }
        if (this.pathname != null) {
            return (String)file + this.pathname;
        }
        return "";
    }

    public String pathname() {
        return this.pathname;
    }

    public String pathname(int element) {
        if (this.condensedReference == null) {
            return this.pathname();
        }
        return this.condensedReference.getPathname(element);
    }

    public boolean removePathname(int element) {
        if (this.condensedReference == null) {
            if (element > 0) {
                return false;
            }
            this.pathname = null;
            return true;
        }
        return this.condensedReference.removePathname(element);
    }

    public void setFilename(String file) {
        this.filename = file;
    }

    public void setPath(String path) {
        this.pathname = path;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getPathname() {
        return this.pathname();
    }

    public String getPath() {
        return this.pathname();
    }

    public Vector getPathnameList() {
        Vector<String> list = new Vector<String>();
        if (this.condensedReference != null && this.condensedReference.size() > 0) {
            return this.condensedReference.getPathnameVector();
        }
        list.addElement(this.pathname());
        return list;
    }

    public DataReferenceSet getExpandedWaterYearSet() {
        DataReferenceSet drs = new DataReferenceSet();
        Vector paths = this.getPathnameList();
        DataReference previousDr = null;
        for (int i = 0; i < paths.size(); ++i) {
            DSSPathname dssPath;
            String path = (String)paths.get(i);
            DataReference dr = new DataReference(path, this.filename);
            if (this.m_offsetFromGmt != 0) {
                this.setGmtOffset(this.m_offsetFromGmt);
            }
            if (this._waterYearSet && this.startTime.isDateDefined() && (dssPath = new DSSPathname(path)).isTimeSeries()) {
                boolean same;
                dr.setWaterYearTimes(dssPath.dPart(), this.startTime);
                if (previousDr != null) {
                    HecTime start;
                    same = DSSPathname.areSamePathnames(path, previousDr.getPath(), false);
                    if (same && (start = dr.startTime).equalTo(previousDr.startTime)) {
                        continue;
                    }
                } else {
                    DSSPathname dp;
                    same = DSSPathname.areSamePathnames(path, this.pathname, false);
                    if (same && (dp = new DSSPathname(this.pathname)).dPart().length() == 21) {
                        HecTime time = new HecTime();
                        time.set(dp.dPart().substring(0, 9), "0001");
                        if (dr.endTime != null && time.greaterThanEqualTo(dr.endTime)) continue;
                    }
                }
                previousDr = dr;
            }
            drs.add(dr);
        }
        return drs;
    }

    protected void setWaterYearTimes(String datePart, HecTime wyStartTime) {
        int iyr = wyStartTime.year();
        HecTime temp = new HecTime(3);
        temp.setYearMonthDay(iyr, 12, 31, 1440);
        int wyDays = temp.julian() - wyStartTime.julian();
        temp.setDate(datePart);
        int waterYear = temp.year();
        temp.setYearMonthDay(waterYear, 12, 31, 1440);
        int julYear = temp.julian();
        temp.setDate(datePart);
        int days = julYear - temp.julian();
        int diff = days - wyDays;
        if (diff < 0) {
            ++waterYear;
        }
        this.endTime = new HecTime();
        this.endTime.setYearMonthDay(waterYear, 12, 31, 1440);
        this.endTime.subtractDays(wyDays);
        this.startTime = new HecTime();
        this.startTime.setYearMonthDay(waterYear, 1, 1, 1);
        this.startTime.subtractDays(wyDays);
    }

    public int size() {
        if (this.condensedReference != null) {
            return this.condensedReference.size();
        }
        if (this.pathname != null) {
            return 1;
        }
        return 0;
    }

    public int getGmtOffset() {
        return this.m_offsetFromGmt;
    }

    public void setGmtOffset(int offset) {
        this.m_offsetFromGmt = offset;
    }

    public void generateCondensedPathnameList(HecDataManager dataManager, boolean checkPathnames) {
        DSSPathname path;
        if (this.condensedReference == null && (path = new DSSPathname(this.getNominalPathname())).dPart().length() == 21 && path.dPart().substring(9, 12).equals(" - ")) {
            this.condensedReference = new CondensedReference(path.pathname());
        }
        if (this.condensedReference != null) {
            this.condensedReference.generatePathnameList(dataManager, checkPathnames);
        }
    }

    public boolean isaCollection() {
        if (this.condensedReference == null) {
            return false;
        }
        return this.condensedReference.isaCollection();
    }

    public Vector<CondensedReference> getCollection() {
        if (this.condensedReference == null) {
            return null;
        }
        return this.condensedReference.getCollection();
    }

    public Vector<DataReference> getDataReferenceCollection() {
        if (this.condensedReference == null) {
            return null;
        }
        Vector<CondensedReference> collection = this.condensedReference.getCollection();
        if (collection == null) {
            return null;
        }
        Vector<DataReference> drv = new Vector<DataReference>(collection.size());
        for (int i = 0; i < collection.size(); ++i) {
            CondensedReference obj = collection.get(i);
            if (!(obj instanceof CondensedReference)) continue;
            CondensedReference cr = obj;
            DataReference dr = new DataReference(cr.getNominalPathname(), this.getFilename(), cr);
            if (this.startTime != null && this.endTime != null) {
                dr.setTimeWindow(this.startTime, this.endTime);
            }
            drv.add(dr);
        }
        return drv;
    }
}

