/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DataReference;
import hec.heclib.util.HecTime;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Vector;

public class DataReferenceSet
extends Vector
implements Transferable,
Cloneable {
    public static DataFlavor dssPathnameFlavor;
    String mimeType = "application/x-java-jvm-local-objectref;class=hec.heclib.dss.DataReferenceSet";
    String _timeWindow = null;

    public DataReferenceSet() {
        try {
            dssPathnameFlavor = new DataFlavor(this.mimeType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DataReferenceSet(Vector pathnames, String dssFilename) {
        this();
        for (int i = 0; i < pathnames.size(); ++i) {
            DataReference dr = new DataReference((String)pathnames.elementAt(i), dssFilename);
            this.add(dr);
        }
    }

    public DataReferenceSet(Vector pathnames) {
        this();
        for (int i = 0; i < pathnames.size(); ++i) {
            DataReference dr = new DataReference((String)pathnames.elementAt(i), "");
            this.add(dr);
        }
    }

    @Override
    public DataReference get(int idx) {
        Object obj = super.get(idx);
        return (DataReference)obj;
    }

    public DataReference elementAt(int idx) {
        Object obj = super.elementAt(idx);
        return (DataReference)obj;
    }

    public Vector getPathnameSet() {
        return this.getPathnameSet(true);
    }

    public Vector getPathnameSet(boolean expand) {
        Vector paths = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            int size = data.size();
            if (expand) {
                Vector dr = data.getPathnameList();
                for (int j = 0; j < dr.size(); ++j) {
                    paths.addElement(dr.get(j));
                }
                continue;
            }
            paths.addElement(data.getPath());
        }
        return paths;
    }

    public int getFilesAndPathnames(Vector filenames, Vector paths) {
        int numberPaths = 0;
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            String name = data.getFilename();
            int fileElement = filenames.indexOf(name);
            if (fileElement == -1) {
                fileElement = filenames.size();
                filenames.add(name);
                paths.add(new Vector());
            }
            Vector p = (Vector)paths.elementAt(fileElement);
            int size = data.size();
            Vector dr = data.getPathnameList();
            for (int j = 0; j < dr.size(); ++j) {
                p.addElement(dr.get(j));
                ++numberPaths;
            }
        }
        return numberPaths;
    }

    public DataReferenceSet expand() {
        return this.expand(true);
    }

    public DataReferenceSet expand(boolean regardlessIfTimeSet) {
        DataReferenceSet drs = new DataReferenceSet();
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            boolean doExpand = true;
            if (!regardlessIfTimeSet && data.hasTimeWindow()) {
                doExpand = false;
            }
            int size = data.size();
            if (doExpand) {
                String name = data.getFilename();
                Vector p = data.getPathnameList();
                for (int j = 0; j < p.size(); ++j) {
                    String path = (String)p.elementAt(j);
                    DataReference dr = new DataReference(path, name);
                    if (data.hasTimeWindow()) {
                        data.getTimeWindow(start, end);
                        dr.setTimeWindow(start, end);
                    }
                    drs.add(dr);
                }
                continue;
            }
            drs.add(data);
        }
        return drs;
    }

    public int numberPathnames() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            count += data.size();
        }
        return count;
    }

    public void setWaterYear(HecTime waterYearStartDate) {
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            data.setWaterYear(waterYearStartDate);
        }
    }

    public boolean hasWaterYear() {
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            if (!data.isWaterYear()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCollections() {
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            if (!data.isaCollection()) continue;
            return true;
        }
        return false;
    }

    public DataReferenceSet expandCollections() {
        if (!this.hasCollections()) {
            return this;
        }
        DataReferenceSet drs = new DataReferenceSet();
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            if (data.isaCollection()) {
                Vector<DataReference> collection = data.getDataReferenceCollection();
                drs.addAll(collection);
                continue;
            }
            drs.add(data);
        }
        return drs;
    }

    public DataReferenceSet expandWaterYear() {
        if (!this.hasWaterYear()) {
            return this;
        }
        DataReferenceSet drs = new DataReferenceSet();
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            if (data.isWaterYear()) {
                DataReferenceSet set = data.getExpandedWaterYearSet();
                drs.addAll(set);
                continue;
            }
            drs.add(data);
        }
        return drs;
    }

    public boolean removePathname(int element) {
        int numberPaths = 0;
        for (int i = 0; i < this.size(); ++i) {
            DataReference data = this.get(i);
            if (data.size() + numberPaths > element) {
                boolean removed = data.removePathname(element - numberPaths);
                if (data.size() == 0) {
                    this.remove(i);
                }
                return removed;
            }
            numberPaths += data.size();
        }
        return false;
    }

    public void setTimeWindowString(String timeWindow) {
        this._timeWindow = timeWindow;
        for (int i = 0; i < this.size(); ++i) {
            DataReference dr = this.elementAt(i);
            dr.setTimeWindow(this._timeWindow);
        }
    }

    public void setTimeWindow(HecTime start, HecTime end) {
        for (int i = 0; i < this.size(); ++i) {
            DataReference dr = this.elementAt(i);
            dr.setTimeWindow(start, end);
        }
    }

    @Override
    public Object clone() {
        DataReferenceSet drs = new DataReferenceSet();
        drs.setTimeWindowString(this._timeWindow);
        for (int i = 0; i < this.size(); ++i) {
            DataReference obj = this.elementAt(i);
            if (!(obj instanceof DataReference)) continue;
            DataReference dataRef = obj;
            drs.add(dataRef.clone());
        }
        return drs;
    }

    public String getTimeWindow() {
        return this._timeWindow;
    }

    public boolean containsString(String string) {
        return this.indexOfString(string) >= 0;
    }

    public int indexOfString(String string) {
        int number = this.size();
        for (int i = 0; i < number; ++i) {
            DataReference data = this.get(i);
            int size = data.size();
            for (int j = 0; j < size; ++j) {
                String path = data.pathname(j);
                if (!string.equals(path)) continue;
                return i;
            }
            String path = data.getNominalPathname();
            if (!string.equals(path)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] df = new DataFlavor[]{dssPathnameFlavor};
        return df;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(dssPathnameFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (!this.isDataFlavorSupported(flavor)) {
            return null;
        }
        return this;
    }
}

