/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.io.ArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.DssFileContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import hec.util.PhotoViewerInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public interface DssDataManager {
    public static boolean isRemoteFileName(String dssFileName) {
        if (File.separator.equals("/")) {
            return false;
        }
        return dssFileName.startsWith("/") && !dssFileName.startsWith("//");
    }

    default public void setDSSFileName(String name) {
        this.setDSSFileName(name, false, 0);
    }

    default public int setDSSFileName(String dssFileName, boolean fileMustExist) {
        return this.setDSSFileName(dssFileName, fileMustExist, 0);
    }

    public int setDSSFileName(String var1, boolean var2, int var3);

    public int getDssFileVersion();

    public void setForceNewCatalog(boolean var1);

    public void setMessageLevel(int var1);

    public int getMessageLevel();

    public void setUnit(int var1);

    public void fileStats();

    public int fileAccessInfo(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public List<String> getLastDeletePathnames();

    public IHecDSSUtilities dataManager();

    public void setCatalogNeedsUpdate(boolean var1);

    public boolean getCatalogNeedsUpdate();

    public List<HecDSSFileData> DssFileManagerStatus();

    public boolean checkForSevereError();

    public int checkForError();

    public void setDisplayUnitSystem(int var1);

    public void setTimeZone(TimeZone var1);

    public TimeZone getTimeZone();

    public int createNewCatalog(int var1);

    public String getCatalogName(int var1);

    public int recordsUpdated(long var1, List<String> var3, List<Long> var4, List<Integer> var5);

    public boolean recordExists(String var1);

    public boolean[] recordsExist(List<String> var1);

    public void clearSevereError();

    public void done();

    public DSSErrorMessage lastSevereErrorMessage();

    public DSSErrorMessage lastErrorMessage();

    public List<DSSErrorMessage> allSevereErrorMessages();

    public void cancelProcess();

    public void cancelSqueeze();

    public void getProcessStatus(int[] var1, int[] var2);

    public void setInterrupt(boolean var1);

    public void clearStatus();

    public boolean cleanDSSFileName(String var1, stringContainer var2);

    public void close();

    public boolean isExplicitlyClosed();

    public int checkAllPathnames();

    public int checkLinks();

    public int checkPathnameBins();

    public int copyFile(DssDataManager var1, String var2);

    public int copyRecordsFrom(DssDataManager var1, String var2, List<String> var3);

    public int copyRecordsInto(DssDataManager var1, String var2, List<String> var3);

    public int delete(List<String> var1);

    public boolean doesDSSFileExist(String var1);

    public int duplicateRecords(List<String> var1, List<String> var2);

    public String getDSSFileName();

    public String DSSFileName();

    public boolean isSameFile(String var1);

    public boolean fileOpened();

    public int open();

    public boolean fileAccessible();

    public int getTSRecordInfo(String var1, HecTime var2, HecTime var3, stringContainer var4, stringContainer var5);

    public boolean getTimeSeriesExtents(String var1, HecTime var2, HecTime var3);

    public int numberRecords();

    default public int readData(DataReference dataReference, TimeSeriesContainer timeSeriesContainer) {
        return this.readData(dataReference, timeSeriesContainer, true);
    }

    default public int[] readData(ArrayList<DataReference> dataReferenceList, ArrayList<TimeSeriesContainer> timeSeriesContainerList, boolean trimMissing) {
        int[] status = new int[dataReferenceList.size()];
        for (int index = 0; index < dataReferenceList.size(); ++index) {
            status[index] = this.readData(dataReferenceList.get(index), timeSeriesContainerList.get(index), trimMissing);
        }
        return status;
    }

    public int readData(DataReference var1, TimeSeriesContainer var2, boolean var3);

    public int readData(DataReference var1, TimeSeriesCollectionContainer var2, boolean var3);

    public int readData(DataReference var1, PairedDataContainer var2);

    public int readData(DataReference var1, TextContainer var2);

    public int readData(DataReference var1, ArrayContainer var2);

    public int readData(DataReference var1, DssFileContainer var2);

    public int readData(DataReference var1, GridContainer var2);

    public int readData(DataReference var1, TinContainer var2);

    public boolean getRecordInfo(DataReference var1, HecDSSRecordInfo var2);

    public int writeData(TextContainer var1);

    public List readGriddedData(DSSIdentifier var1);

    public int recordType(String var1);

    public Map<String, Integer> recordTypes(String[] var1);

    public int renameRecords(List<String> var1, List<String> var2);

    public String[] getPathnameList(boolean var1);

    public String[] getCatalog(boolean var1, String var2);

    public int searchDSSCatalog(String var1, List<String> var2);

    public int searchDSSPaths(String var1, List<String> var2);

    public List<CondensedReference> getCondensedCatalog();

    public CondensedReference[] getCondensedCatalog(String var1);

    public int forceMultiUserAccess();

    public int squeeze();

    public int convertVersion(String var1);

    public int undelete(List<String> var1);

    public int undoLastDelete();

    public boolean writeAccess();

    public int writeData(PairedDataContainer var1);

    public int writeData(GridContainer var1);

    public int writeData(DataContainer var1);

    public int writeLocation(DataContainer var1);

    default public int writeData(TimeSeriesContainer timeSeriesContainer) {
        return this.writeData(timeSeriesContainer, 3, 1);
    }

    public int writeData(TimeSeriesContainer var1, int var2, int var3);

    public int writeFile(File var1, DSSPathname var2, boolean var3) throws Exception;

    public int exportFile(String var1, File var2, String var3) throws Exception;

    public int readImage(DataReference var1, PhotoViewerInfo var2) throws Exception;

    public int readLocation(DataContainer var1) throws Exception;

    public int zinqir(String var1);

    public void zinqir(String var1, stringContainer var2, int[] var3);

    public void zset(String var1, String var2, int var3);

    public String DSSFileName(int var1);

    public void zquery(String var1, stringContainer var2, int[] var3);

    default public boolean isRemote() {
        return false;
    }
}

