/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import java.io.ObjectStreamException;

public class DssDataType {
    public static final DssDataType PER_AVER = new DssDataType(0, "PER-AVER");
    public static final DssDataType PER_CUM = new DssDataType(1, "PER-CUM");
    public static final DssDataType INST_VAL = new DssDataType(2, "INST-VAL");
    public static final DssDataType INST_CUM = new DssDataType(3, "INST-CUM");
    public static final DssDataType FREQ = new DssDataType(4, "FREQ");
    public static final DssDataType INVAL = new DssDataType(5, "INVALID");
    public static final DssDataType PER_MIN = new DssDataType(6, "PER-MIN");
    public static final DssDataType PER_MAX = new DssDataType(7, "PER-MAX");
    private int _value;
    private String _string;
    private static final DssDataType[] _dataTypeTable = new DssDataType[]{PER_AVER, PER_CUM, INST_VAL, INST_CUM, FREQ, INVAL, PER_MIN, PER_MAX};

    private DssDataType(int value, String string) {
        this._value = value;
        this._string = string;
    }

    public Object clone() {
        return this;
    }

    public static DssDataType[] getDataTypeArray() {
        DssDataType[] dataTypeArray = new DssDataType[_dataTypeTable.length];
        for (int i = 0; i < _dataTypeTable.length; ++i) {
            dataTypeArray[i] = _dataTypeTable[i];
        }
        return dataTypeArray;
    }

    public int value() {
        return this._value;
    }

    public boolean equals(DssDataType dataType) {
        return this._value == dataType._value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            DssDataType other = (DssDataType)obj;
            if (this._value == other._value) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this._value;
    }

    public String toString() {
        return this._string;
    }

    public static DssDataType fromString(String dataType) {
        for (int i = 0; i < _dataTypeTable.length; ++i) {
            if (dataType.compareToIgnoreCase(DssDataType._dataTypeTable[i]._string) != 0) continue;
            return _dataTypeTable[i];
        }
        return INVAL;
    }

    public static DssDataType fromInt(int dataType) {
        for (int i = 0; i < _dataTypeTable.length; ++i) {
            if (dataType != DssDataType._dataTypeTable[i]._value) continue;
            return _dataTypeTable[i];
        }
        return INVAL;
    }

    public static boolean isValid(String type) {
        for (int i = 0; i < _dataTypeTable.length; ++i) {
            if (!DssDataType._dataTypeTable[i]._string.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static String[] getTimeSeriesTypes() {
        String[] types = new String[4];
        for (int i = 0; i < 4; ++i) {
            types[i] = DssDataType._dataTypeTable[i]._string;
        }
        return types;
    }

    private Object readResolve() throws ObjectStreamException {
        return DssDataType.fromInt(this._value);
    }
}

