/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;

public class DssIntervalUtility {
    private static final List<DssInterval> intervals = IntervalFactory.findAllDss7(Interval::isRegular).stream().map(DssIntervalUtility::toDssInterval).sorted(Comparator.comparingInt(DssInterval::getSeconds)).collect(Collectors.toList());

    private static DssInterval toDssInterval(Interval fi) {
        String regular = fi.toString();
        int secs = fi.getSeconds();
        double minutes = (double)secs / 60.0;
        String pseudo = "~" + regular;
        String irregular = DssIntervalUtility.classifyIrregular(secs);
        return new DssInterval(regular, secs, minutes, pseudo, irregular);
    }

    private static String classifyIrregular(int secs) {
        if (secs <= 720) {
            return "IR-Day";
        }
        if (secs <= 43200) {
            return "IR-Month";
        }
        if (secs <= 86400) {
            return "IR-Year";
        }
        if (secs <= 2592000) {
            return "IR-Decade";
        }
        return "IR-Century";
    }

    public static String[] getRegular(Predicate<DssInterval> filter) {
        return (String[])intervals.stream().filter(filter).map(DssInterval::getRegular).toArray(String[]::new);
    }

    public static String[] getIrregular(Predicate<DssInterval> filter) {
        return (String[])intervals.stream().filter(filter).map(DssInterval::getIrregular).toArray(String[]::new);
    }

    public static String[] getPseudo(Predicate<DssInterval> filter) {
        return (String[])intervals.stream().filter(filter).map(DssInterval::getPseudo).toArray(String[]::new);
    }

    public static String lookupRegularInterval(int seconds, String defaultValue) {
        return intervals.stream().filter(a -> a.getSeconds() <= seconds).max(Comparator.comparingDouble(DssInterval::getSeconds)).map(DssInterval::getRegular).orElse(defaultValue);
    }

    public static String lookupIrregularInterval(int seconds, String defaultValue) {
        return intervals.stream().filter(a -> a.getSeconds() <= seconds).max(Comparator.comparingDouble(DssInterval::getSeconds)).map(DssInterval::getIrregular).orElse(defaultValue);
    }

    public static int lookupSeconds(String regularInterval) {
        if (regularInterval == null) {
            return -1;
        }
        return intervals.stream().filter(iv -> iv.getRegular().equalsIgnoreCase(regularInterval.trim())).map(DssInterval::getSeconds).findFirst().orElse(-1);
    }

    public static List<DssInterval> getAllIntervals() {
        return Collections.unmodifiableList(intervals);
    }

    public static class DssInterval {
        private final String regular;
        private final int seconds;
        private final double minutes;
        private final String pseudo;
        private final String irregular;

        private DssInterval(String regular, int seconds, double minutes, String pseudo, String irregular) {
            this.regular = regular;
            this.seconds = seconds;
            this.minutes = minutes;
            this.pseudo = pseudo;
            this.irregular = irregular;
        }

        public String getRegular() {
            return this.regular;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public double getMinutes() {
            return this.minutes;
        }

        public String getPseudo() {
            return this.pseudo;
        }

        public String getIrregular() {
            return this.irregular;
        }

        public String toString() {
            return "DssInterval[regular=" + this.regular + ", seconds=" + this.seconds + ", minutes=" + this.minutes + ", pseudo=" + this.pseudo + ", irregular=" + this.irregular + "]";
        }
    }
}

