/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DssPathnameMatcherException;
import hec.util.TextUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class DssPathnameMatcher
implements Serializable {
    private static final Pattern PART_SPEC_PATTERN = Pattern.compile("[ABCDEF]\\s*=");
    private static final String INVALID_MATCHER_TYPE_MSG = "Invalid matcher type: ";
    static final int MATCHER_TYPE_GLOB = 1;
    static final int MATCHER_TYPE_REGEX = 2;
    private static final long serialVersionUID = 2637819141170653866L;
    private String _matcherString = null;
    private int _matcherType = 0;
    private boolean _caseInsensitive = false;
    private Pattern _pattern = null;

    private DssPathnameMatcher() {
    }

    DssPathnameMatcher(DssPathnameMatcher m) {
        this._matcherType = m._matcherType;
        this._matcherString = m._matcherString;
        this._pattern = m._pattern;
    }

    DssPathnameMatcher(String matcherString, int matcherType, boolean caseInsensitive) throws DssPathnameMatcherException {
        if (matcherType != 1 && matcherType != 2) {
            throw new DssPathnameMatcherException(INVALID_MATCHER_TYPE_MSG + matcherType);
        }
        matcherString = matcherString.trim().length() == 0 ? null : matcherString.trim();
        this._matcherType = matcherType;
        this._matcherString = matcherString;
        this._caseInsensitive = caseInsensitive;
        if ((matcherString = DssPathnameMatcher.buildMatcherStringFromPartsSpec(matcherString, matcherType)) == null) {
            this._pattern = Pattern.compile("^.*$", caseInsensitive ? 2 : 0);
        } else {
            if (matcherType == 1) {
                matcherString = TextUtil.glob2Regex(matcherString);
            }
            this._pattern = Pattern.compile(DssPathnameMatcher.ensureRegexHasAnchors(matcherString), caseInsensitive ? 2 : 0);
        }
    }

    static String buildMatcherStringFromPartsSpec(String inputString, int matcherType) throws DssPathnameMatcherException {
        if (matcherType != 1 && matcherType != 2) {
            throw new DssPathnameMatcherException(INVALID_MATCHER_TYPE_MSG + matcherType);
        }
        if (inputString == null || inputString.trim().length() == 0) {
            return null;
        }
        Matcher m = PART_SPEC_PATTERN.matcher(inputString);
        if (!m.find() || m.start() != 0) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder("/");
        for (String partFilter : DssPathnameMatcher.mapPartSpecs(inputString)) {
            if (partFilter == null) {
                sb.append(matcherType == 1 ? "*/" : ".*/");
                continue;
            }
            sb.append(partFilter).append("/");
        }
        return sb.toString();
    }

    private static String ensureRegexHasAnchors(String regex) {
        if (regex.length() == 0) {
            return "^$";
        }
        StringBuilder sb = new StringBuilder();
        if (regex.charAt(0) != '^') {
            sb.append('^');
        }
        sb.append(regex);
        if (regex.charAt(regex.length() - 1) != '$') {
            sb.append('$');
        }
        return sb.toString();
    }

    private static String[] mapPartSpecs(String inputString) {
        HashMap<String, int[]> matchPositions = new HashMap<String, int[]>();
        Matcher m = PART_SPEC_PATTERN.matcher(inputString.trim());
        while (m.find()) {
            matchPositions.put(m.group().substring(0, 1), new int[]{m.start(), m.end()});
        }
        String[] partFilters = new String[6];
        String[] keys = new String[]{"A", "B", "C", "D", "E", "F"};
        for (int i = 0; i < keys.length; ++i) {
            if (!matchPositions.containsKey(keys[i])) continue;
            int endPos = inputString.length();
            for (int j = i + 1; j < keys.length; ++j) {
                if (!matchPositions.containsKey(keys[j])) continue;
                endPos = Math.min(endPos, ((int[])matchPositions.get(keys[j]))[0]);
            }
            partFilters[i] = inputString.substring(((int[])matchPositions.get(keys[i]))[1], endPos).trim();
            if (partFilters[i].charAt(0) != '\"' || partFilters[i].charAt(partFilters[i].length() - 1) != '\"') continue;
            partFilters[i] = partFilters[i].substring(1, partFilters[i].length() - 1);
        }
        return partFilters;
    }

    int getMatcherType() {
        return this._matcherType;
    }

    String getMatcherString() {
        return this._matcherString;
    }

    Pattern getPattern() {
        return this._pattern;
    }

    boolean matches(String dssPathname) {
        return this._pattern.matcher(dssPathname).matches();
    }

    Predicate<String> asPredicate() {
        return this._pattern.asPredicate();
    }

    String[] getMatching(String[] dssPathnames) {
        return Arrays.asList(dssPathnames).stream().filter(this._pattern.asPredicate()).collect(Collectors.toList()).toArray(new String[0]);
    }

    String[] getNonMatching(String[] dssPathnames) {
        return Arrays.asList(dssPathnames).stream().filter(this._pattern.asPredicate().negate()).collect(Collectors.toList()).toArray(new String[0]);
    }

    List<String> getMatching(List<String> dssPathnames) {
        return dssPathnames.stream().filter(this._pattern.asPredicate()).collect(Collectors.toList());
    }

    List<String> getNonMatching(List<String> dssPathnames) {
        return dssPathnames.stream().filter(this._pattern.asPredicate().negate()).collect(Collectors.toList());
    }

    Set<String> getMatching(Set<String> dssPathnames) {
        return dssPathnames.stream().filter(this._pattern.asPredicate()).collect(Collectors.toSet());
    }

    Set<String> getNonMatching(Set<String> dssPathnames) {
        return dssPathnames.stream().filter(this._pattern.asPredicate().negate()).collect(Collectors.toSet());
    }

    public int hashCode() {
        return this.getClass().getCanonicalName().hashCode() + this._matcherType * 3 + this._matcherString.hashCode() + (this._caseInsensitive ? 5 : 7) + this._pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DssPathnameMatcher)) {
            return false;
        }
        DssPathnameMatcher m = (DssPathnameMatcher)obj;
        return m._matcherType == this._matcherType && m._caseInsensitive == this._caseInsensitive && m._matcherString.equals(this._matcherString) && m._pattern.toString().equals(this._pattern.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('[').append(this.getClass().getCanonicalName()).append(": pattern=\"").append(this._matcherString).append("\", type=").append(this._matcherType == 1 ? "glob" : "regex").append(", ignoreCase=").append(this._caseInsensitive).append(']');
        return sb.toString();
    }
}

