/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;

public class Group
implements Serializable {
    private DataReferenceSet _dataReferenceSet = new DataReferenceSet();
    private String _groupName = "";
    private String _timeWindow = null;

    public Group(String groupName, DataReferenceSet dataReferenceSet, String timeWindow) {
        this._groupName = groupName;
        this._dataReferenceSet = (DataReferenceSet)dataReferenceSet.clone();
        this.setTimeWindow(timeWindow);
    }

    public Group(String groupName) {
        this._groupName = groupName;
        this._dataReferenceSet = new DataReferenceSet();
    }

    public Group(String groupName, Vector dataReferenceList) {
        this._groupName = groupName;
        this.setList(dataReferenceList);
    }

    public Group(String groupName, Vector dataReferenceList, String timeWindow) {
        this._groupName = groupName;
        this.setList(dataReferenceList);
        this.setTimeWindow(timeWindow);
    }

    public Group() {
    }

    private void setList(Vector dataReferenceList) {
        this._dataReferenceSet.clear();
        this._dataReferenceSet.addAll(dataReferenceList);
    }

    public Vector getList() {
        if (this._dataReferenceSet != null) {
            this._dataReferenceSet.setTimeWindowString(this._timeWindow);
        }
        return this._dataReferenceSet;
    }

    private void setDataReferenceSet(DataReferenceSet dataReferenceSet) {
        this._dataReferenceSet = dataReferenceSet;
    }

    public void setName(String name) {
        this._groupName = name;
    }

    public String getName() {
        return this._groupName;
    }

    public DataReferenceSet getDataReferenceSet() {
        if (this._dataReferenceSet != null) {
            this._dataReferenceSet.setTimeWindowString(this._timeWindow);
        }
        return this._dataReferenceSet;
    }

    public void generateCondensedPathnameList(HecDataManager dataManager, boolean checkPathnames) {
        if (this._dataReferenceSet != null) {
            for (int i = 0; i < this._dataReferenceSet.size(); ++i) {
                DataReference obj = this._dataReferenceSet.elementAt(i);
                if (!(obj instanceof DataReference)) continue;
                obj.generateCondensedPathnameList(dataManager, checkPathnames);
            }
        }
    }

    public int size() {
        if (this._dataReferenceSet != null) {
            return this._dataReferenceSet.size();
        }
        return 0;
    }

    public void add(DataReference dr) {
        if (this._dataReferenceSet != null) {
            this._dataReferenceSet.add(dr);
        }
    }

    public void setTimeWindow(String timeWindow) {
        this._timeWindow = timeWindow;
    }

    public String getTimeWindow() {
        return this._timeWindow;
    }

    protected String getTimeWindow(int elementNumber) {
        DataReference dataRef = this.getElement(elementNumber);
        if (dataRef == null) {
            return "";
        }
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        dataRef.getTimeWindow(start, end);
        return start.date(104) + " " + start.hourMinutes() + " " + end.date(104) + " " + end.hourMinutes();
    }

    public DataReference getElement(int number) {
        if (number < this._dataReferenceSet.size()) {
            DataReference dr = this._dataReferenceSet.elementAt(number);
            dr.setTimeWindow(this._timeWindow);
            return dr;
        }
        return null;
    }

    public void read(BufferedReader reader) throws Exception {
        String line;
        this._dataReferenceSet.clear();
        String nominalPath = null;
        DataReference dr = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Name")) {
                nominalPath = line.substring(6);
                continue;
            }
            if (line.startsWith("File")) {
                String file = line.substring(6);
                dr = new DataReference(nominalPath, file);
                this._dataReferenceSet.addElement(dr);
                continue;
            }
            if (line.startsWith("TimeWindow")) {
                this._timeWindow = line.substring(11).trim();
                continue;
            }
            if (!line.startsWith("End")) continue;
            return;
        }
    }

    public void save(PrintWriter writer) throws Exception {
        writer.println();
        writer.println("Group: " + this._groupName);
        if (this._timeWindow != null && this._timeWindow.length() > 0) {
            writer.println("TimeWindow: " + this._timeWindow);
        }
        for (int i = 0; i < this.size(); ++i) {
            DataReference dr = this._dataReferenceSet.elementAt(i);
            writer.println("Name: " + dr.getNominalPathname(false));
            writer.println("File: " + dr.getFilename());
        }
        writer.println("End");
    }
}

