/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSRecordBasics;
import hec.heclib.dss.HecDataConversion;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssArray;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.dss.HecDssText;
import hec.heclib.dss.HecPairedData;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class HecDSSDataAttributes
extends HecDssCatalog {
    public static final int ERROR = -1;
    public static final int UNKNOWN = 0;
    public static final int INT_ARRAY = 90;
    public static final int FLOAT_ARRAY = 91;
    public static final int DOUBLE_ARRAY = 92;
    public static final int LOCATION_LEVEL = 95;
    public static final int REGULAR_TIME_SERIES = 100;
    public static final int REGULAR_TIME_PATTERN = 101;
    public static final int REGULAR_TIME_SERIES_DOUBLES = 105;
    public static final int IRREGULAR_TIME_SERIES = 110;
    public static final int IRREGULAR_TIME_PATTERN = 111;
    public static final int IRREGULAR_TIME_SERIES_DOUBLES = 115;
    public static final int PAIRED = 200;
    public static final int PAIRED_DOUBLES = 205;
    public static final int TEXT = 300;
    public static final int SINGLE_VALUE = 1;
    public static final int UNDEFINED_GRID_WITH_TIME = 400;
    public static final int UNDEFINED_GRID = 401;
    public static final int UNDEFINED_GRID_TYPE = 400;
    public static final int HRAP_GRID_WITH_TIME = 410;
    public static final int HRAP_GRID = 411;
    public static final int HRAP = 410;
    public static final int ALBERS_GRID_WITH_TIME = 420;
    public static final int ALBERS_GRID = 421;
    public static final int ALBERS = 420;
    public static final int SPECIFIED_GRID_WITH_TIME = 430;
    public static final int SPECIFIED_GRID = 431;
    public static final int SPECIFIED_GRID_TYPE = 430;
    public static final int FILE = 600;
    public static final int IMAGE = 610;
    public static final int UNDEFINED_UNITS = 0;
    public static final int ENGLISH_UNITS = 1;
    public static final int SI_UNITS = 2;
    protected static HecTime _defaultStartTime = new HecTime();
    protected static HecTime _defaultEndTime = new HecTime();
    protected DSSPathname _dssPathname = new DSSPathname();
    protected boolean _dirty = true;
    protected int[] _slashPosition = new int[7];
    protected HecTime _startTime;
    protected HecTime _endTime;
    protected HecTime _arrayStartTime;
    protected HecTime _arrayEndTime;
    protected boolean _timeWindowSet = false;
    protected int _arraySize = 0;
    protected int _desiredArraySize = -1;
    protected int _recordType = 0;
    protected int _checkedNumber = 0;
    protected int _dataLengthInts = 0;
    protected int _dataType = 0;
    protected int _localUnitSystem = 0;
    protected boolean _recordExists = false;
    protected boolean _timeSeries = false;
    protected String _unitsX = new String("");
    protected String _typeX = new String("");

    public HecDSSDataAttributes() {
        this._startTime = new HecTime();
        this._endTime = new HecTime();
        this._arrayStartTime = new HecTime();
        this._arrayEndTime = new HecTime();
    }

    public HecDataManager createObject(String pathname) {
        int dataType = this.recordType(pathname);
        if (dataType >= 100 && dataType < 200) {
            return this.createTimeSeriesObject(pathname);
        }
        if (dataType == 200) {
            return this.createPairedDataObject(pathname);
        }
        if (dataType == 300) {
            return this.createTextObject(pathname);
        }
        if (dataType == -1) {
            System.out.printf("Error encountered while determining the record type for: %s in file: %s, dirty:%s, accessible:%s, opened:%s\n", pathname, this.DSSFileName(), this.dirty(), this.fileAccessible(), this.fileOpened());
            return null;
        }
        if (dataType == 0) {
            System.out.println("Error, UNKNOWN record type found for: " + pathname + " in file: " + this.DSSFileName());
            return null;
        }
        System.out.printf("Unable to create object for: %s, in file: %s, recordType: %d\n", pathname, this.DSSFileName(), dataType);
        return null;
    }

    public HecTimeSeries createTimeSeriesObject(String pathname) {
        HecTimeSeries timeSeries = new HecTimeSeries();
        timeSeries.setDSSFileName(this.DSSFileName());
        timeSeries.setPathname(pathname);
        return timeSeries;
    }

    public HecPairedData createPairedDataObject(String pathname) {
        HecPairedData pairedData = new HecPairedData();
        pairedData.setDSSFileName(this.DSSFileName());
        pairedData.setPathname(pathname);
        return pairedData;
    }

    public HecDssText createTextObject(String pathname) {
        HecDssText textData = new HecDssText();
        textData.setDSSFileName(this.DSSFileName());
        textData.setPathname(pathname);
        return textData;
    }

    public HecDssArray createArrayObject(String pathname) {
        HecDssArray dssArray = new HecDssArray();
        dssArray.setDSSFileName(this.DSSFileName());
        dssArray.setPathname(pathname);
        return dssArray;
    }

    @Override
    public synchronized int setDSSFileName(String dssFileName, boolean fileMustExist) {
        this._dirty = true;
        String c2 = this._dssPathname.cPart();
        this._dssPathname.setCPart(c2);
        return super.setDSSFileName(dssFileName, fileMustExist);
    }

    public String aPart() {
        return this._dssPathname.aPart();
    }

    public String bPart() {
        return this._dssPathname.bPart();
    }

    public String cPart() {
        return this._dssPathname.cPart();
    }

    public String dPart() {
        return this._dssPathname.dPart();
    }

    public String ePart() {
        return this._dssPathname.ePart();
    }

    public String fPart() {
        return this._dssPathname.fPart();
    }

    @Override
    public String pathname() {
        return this._dssPathname.pathname();
    }

    public void setAPart(String partName) {
        this._dssPathname.setAPart(partName);
    }

    public void setBPart(String partName) {
        this._dssPathname.setBPart(partName);
    }

    public void setCPart(String partName) {
        this._dssPathname.setCPart(partName);
    }

    public void setDPart(String partName) {
        this._dssPathname.setDPart(partName);
    }

    public int setEPart(String partName) {
        this._dssPathname.setEPart(partName);
        return 0;
    }

    public void setFPart(String partName) {
        this._dssPathname.setFPart(partName);
    }

    public int setPathname(String path) {
        return this._dssPathname.setPathname(path);
    }

    public int setPathnameParts(String pathnameParts) {
        return this._dssPathname.setPathnameParts(pathnameParts);
    }

    public boolean dirty() {
        return this._dssPathname.dirty() || this._dirty;
    }

    public static int pathnameDataType(String pathname) {
        int[] slashPosition = new int[7];
        int stat = DSSPathname.parsePathname(pathname, slashPosition);
        if (stat == 0) {
            String dPart;
            int lenEPart;
            int lenDPart = slashPosition[4] - slashPosition[3] - 1;
            if (lenDPart >= 9) {
                String ePart = pathname.substring(slashPosition[4], slashPosition[5] - 1).toUpperCase();
                if (ePart.startsWith("IR-")) {
                    return 110;
                }
                if (ePart.startsWith("~")) {
                    return 110;
                }
                int[] n = new int[1];
                int[] interval = new int[1];
                int[] istat = new int[]{1};
                Heclib.zgintl(interval, ePart, n, istat);
                if (istat[0] == 0) {
                    return 100;
                }
            }
            if (lenDPart == 14 && (lenEPart = slashPosition[5] - slashPosition[4] - 1) == 14 && pathname.indexOf(":", slashPosition[3]) > 7) {
                return 401;
            }
            String cPart = pathname.substring(slashPosition[2], slashPosition[3] - 1);
            if (cPart.indexOf("-") > 0) {
                return 200;
            }
            if (lenDPart == 5 && (dPart = pathname.substring(slashPosition[3], slashPosition[4] - 1)).equals("IMAGE")) {
                return 610;
            }
            if (lenDPart == 4 && (dPart = pathname.substring(slashPosition[3], slashPosition[4] - 1)).equals("FILE")) {
                return 600;
            }
        }
        return 0;
    }

    private <T> Vector<T> ensureVector(List<T> list) {
        if (list instanceof Vector) {
            return (Vector)list;
        }
        if (list != null) {
            return new Vector<T>(list);
        }
        return null;
    }

    private <T> void returnToOriginalList(List<T> original, Vector<T> vector) {
        if (original != null && vector != null && original != vector) {
            original.clear();
            original.addAll(vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recordsUpdated(long startTime, List<String> pathnames, List<Long> updateTimes, List<Integer> recordTypes) {
        int status = -1;
        intContainer lockThreadToken = new intContainer();
        if (this.getDssFileVersion() == 6) {
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return status;
            }
            try {
                Vector<String> nativePathnames = this.ensureVector(pathnames);
                Vector<Long> nativeUpdateTimes = this.ensureVector(updateTimes);
                Vector<Integer> nativeRecordTypes = this.ensureVector(recordTypes);
                status = Heclib.zndata(dssTable, startTime, nativePathnames, nativeUpdateTimes, nativeRecordTypes);
                this.returnToOriginalList(pathnames, nativePathnames);
                this.returnToOriginalList(updateTimes, nativeUpdateTimes);
                this.returnToOriginalList(recordTypes, nativeRecordTypes);
            }
            finally {
                this._fileData.releaseAccess(lockThreadToken);
            }
        } else {
            HecDssCatalog catalog = new HecDssCatalog(this.DSSFileName());
            catalog.whatChangedSetStart();
            catalog.lastWriteTimeFile = startTime;
            String[] paths = catalog.whatChanged();
            pathnames.clear();
            if (paths == null || paths.length == 0) {
                return 0;
            }
            if (updateTimes != null) {
                updateTimes.clear();
            }
            if (recordTypes != null) {
                recordTypes.clear();
            }
            for (int i = 0; i < paths.length; ++i) {
                pathnames.add(catalog.pathnameList[i]);
                if (updateTimes != null) {
                    updateTimes.add(catalog.lastWriteTimeRecord[i]);
                }
                if (recordTypes == null) continue;
                recordTypes.add(this.recordType(catalog.pathnameList[i]));
            }
            status = 0;
        }
        return status;
    }

    public Map<String, Integer> recordTypes(String[] pathnames) {
        HashMap<String, Integer> recordMap = new HashMap<String, Integer>();
        for (String pathname : pathnames) {
            int recordType = this.recordType(pathname);
            recordMap.put(pathname, recordType);
        }
        return recordMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recordType(String pathname) {
        if (pathname == null || pathname.trim().length() == 0) {
            return -1;
        }
        this._timeSeries = false;
        if (!this.fileAccessible()) {
            String filename = this.DSSFileName();
            this.setDSSFileName(filename);
            int status = this.open();
            if (status != 0) {
                System.out.printf("HecDataManager: Cannot determine record type for: %s.  The DSS file %s failed to open: %d.\n", pathname, filename, status);
            }
        }
        int[] checkedNumber = new int[]{0};
        int[] exists = new int[]{0};
        int[] dataType = new int[]{0};
        stringContainer type = new stringContainer();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        try {
            Heclib.zdtype(dssTable, pathname, checkedNumber, exists, type, dataType);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        this._checkedNumber = checkedNumber[0];
        this._recordExists = exists[0] != 0;
        if (dataType[0] == 0) {
            if (!this._recordExists) {
                int len;
                int stat = DSSPathname.parsePathname(pathname, this._slashPosition);
                if (stat != 0) {
                    return 0;
                }
                if (pathname.length() < 7) {
                    return 0;
                }
                if (this._slashPosition[3] < 1 || this._slashPosition[3] >= pathname.length() - 1) {
                    return 0;
                }
                String c2 = pathname.substring(this._slashPosition[2], this._slashPosition[3] - 1);
                if (c2.indexOf("-") > 0 && this._slashPosition[4] - this._slashPosition[3] == 1) {
                    DSSPathname pathnameObj = new DSSPathname(pathname);
                    pathnameObj.setDPart("seriesinfo");
                    dssTable = this._fileData.requestAccess(lockThreadToken);
                    if (dssTable == null) {
                        return -1;
                    }
                    try {
                        Heclib.zdtype(dssTable, pathnameObj.pathname(), checkedNumber, exists, type, dataType);
                    }
                    finally {
                        this._fileData.releaseAccess(lockThreadToken);
                    }
                    boolean bl = this._recordExists = exists[0] != 0;
                    if (!this._recordExists) {
                        return 0;
                    }
                    if (dataType[0] == 0) {
                        return 0;
                    }
                }
                if ((len = this._slashPosition[5] - this._slashPosition[4] - 1) > 3 && len < 20) {
                    String e = pathname.substring(this._slashPosition[4], this._slashPosition[5] - 1);
                    int intl = HecTimeSeriesBase.getIntervalFromEPart(e);
                    if (intl == -1) {
                        return 110;
                    }
                    if (intl > 0) {
                        return 100;
                    }
                }
                return 0;
            }
            return 0;
        }
        switch (dataType[0]) {
            case 100: 
            case 101: 
            case 110: 
            case 111: {
                this._timeSeries = true;
            }
            case 200: 
            case 300: 
            case 400: 
            case 401: 
            case 410: 
            case 411: 
            case 420: 
            case 421: 
            case 430: 
            case 431: {
                break;
            }
            case 105: 
            case 115: {
                this._timeSeries = true;
            }
            case 205: {
                dataType[0] = dataType[0] - 5;
                break;
            }
            default: {
                return dataType[0];
            }
        }
        return dataType[0];
    }

    public int recordType() {
        if (this._recordType != 0 && !this._dssPathname.dirty()) {
            return this._recordType;
        }
        this._recordType = this.recordType(this._dssPathname.pathname());
        int stat = DSSPathname.parsePathname(this._dssPathname.pathname(), this._slashPosition);
        if (stat != 0) {
            DSSPathname.parsePathname("///////", this._slashPosition);
        }
        if (this._recordType == 0) {
            this._dirty = true;
        }
        return this._recordType;
    }

    public boolean isGridRecord(String pathname) {
        switch (this.recordType(pathname)) {
            case 400: 
            case 401: 
            case 410: 
            case 411: 
            case 420: 
            case 421: 
            case 430: 
            case 431: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordExists(String pathname) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        int[] numberHeader = new int[]{0};
        int[] numberData = new int[]{0};
        int[] exists = new int[]{0};
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return false;
        }
        try {
            Heclib.zcheck(dssTable, pathname, numberHeader, numberData, exists);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (exists[0] != 0) {
            this._recordExists = true;
            this._dataLengthInts = numberData[0];
        } else {
            this._recordExists = false;
        }
        return this._recordExists;
    }

    public long getLastWriteTimeMillis() {
        return this.getLastWriteTimeMillis(this.pathname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastWriteTimeMillis(String pathname) {
        long timeMillis;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return 0L;
        }
        try {
            timeMillis = Heclib.zlastWriteTime(dssTable, pathname);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return timeMillis;
    }

    public HecTime getLastWriteTime() {
        return this.getLastWriteTime(this.pathname());
    }

    public HecTime getLastWriteTime(String pathname) {
        long timeMillis = this.getLastWriteTimeMillis(pathname);
        HecTime lastWrite = new HecTime(10);
        if (timeMillis > 0L) {
            long secs = timeMillis / 1000L;
            lastWrite.setSeconds(secs);
        }
        return lastWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HecDSSRecordBasics getRecordBasics() {
        HecDSSRecordBasics recordBasics = new HecDSSRecordBasics(this.pathname());
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        try {
            Heclib.zgetRecordBasics(dssTable, recordBasics);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return recordBasics;
    }

    public void setStartTime(HecTime startTime) {
        this._startTime.set(startTime);
        this._startTime.setTimeIncrement(1);
        this._dirty = true;
        this._timeWindowSet = this._startTime.isDefined();
    }

    public void setEndTime(HecTime endTime) {
        this._endTime.set(endTime);
        this._endTime.setTimeIncrement(1);
        this._dirty = true;
        this._timeWindowSet = this._endTime.isDefined();
    }

    public void setTimeWindow(HecTime startTime, HecTime endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public int setTimeWindow(String userLine) {
        int stat = HecTime.getTimeWindow(userLine, this._startTime, this._endTime);
        this._timeWindowSet = stat == 0;
        this._dirty = true;
        return stat;
    }

    public void setDefaultTimeWindow(HecTime startTime, HecTime endTime) {
        _defaultStartTime.set(startTime);
        _defaultEndTime.set(endTime);
        this._dirty = true;
    }

    public int setDefaultTimeWindow(String userLine) {
        this._dirty = true;
        return HecTime.getTimeWindow(userLine, _defaultStartTime, _defaultEndTime);
    }

    public HecTime startTime() {
        if (this._startTime.isDefined()) {
            return this._startTime;
        }
        return _defaultStartTime;
    }

    public HecTime arrayStartTime() {
        return this._arrayStartTime;
    }

    public HecTime endTime() {
        if (this._endTime.isDefined()) {
            return this._endTime;
        }
        return _defaultEndTime;
    }

    public HecTime arrayEndTime() {
        return this._arrayEndTime;
    }

    public boolean isTimeWindowSet() {
        if (this._timeWindowSet) {
            return true;
        }
        return _defaultStartTime.isDefined() && _defaultEndTime.isDefined();
    }

    public void setLocalUnitSystem(int localUnitSystem) {
        if (this._localUnitSystem != localUnitSystem) {
            this._unitsX = "";
        }
        this._localUnitSystem = localUnitSystem;
        this._dirty = true;
    }

    public int localUnitSystem() {
        this._localUnitSystem = HecDataConversion.getUnitSystem(this._unitsX);
        return this._localUnitSystem;
    }

    public static int convertUnits(double[] data, int number, int fromUnitSyst, int toUnitSyst, stringContainer units) {
        int stat = HecDataConversion.convertUnits(data, number, fromUnitSyst, toUnitSyst, units);
        return stat;
    }

    public static int convertDoubleUnits(double[] data, int number, int fromUnits, int toUnits) {
        int stat = HecDataConversion.convertDoubleUnits(data, number, fromUnits, toUnits);
        return stat;
    }

    public void status() {
        System.out.println("A part: " + this._dssPathname.aPart());
        System.out.println("B part: " + this._dssPathname.bPart());
        System.out.println("C part: " + this._dssPathname.cPart());
        System.out.println("D part: " + this._dssPathname.dPart());
        System.out.println("E part: " + this._dssPathname.ePart());
        System.out.println("F part: " + this._dssPathname.fPart());
        System.out.println("Start date / time: " + this._startTime.dateAndTime());
        System.out.println("End   date / time: " + this._endTime.dateAndTime());
    }
}

