/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDss;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class HecDSSFileAccess
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(HecDSSFileAccess.class.getName());
    public static final int MESS_LEVEL_NONE = 0;
    public static final int MESS_LEVEL_CRITICAL = 1;
    public static final int MESS_LEVEL_TERSE = 2;
    public static final int MESS_LEVEL_GENERAL = 3;
    public static final int MESS_LEVEL_USER_DIAG = 4;
    public static final int MESS_LEVEL_INTERNAL_DIAG_1 = 5;
    public static final int MESS_LEVEL_INTERNAL_DIAG_2 = 6;
    public static final int MESS_METHOD_GENERAL = 0;
    public static final int MESS_METHOD_GLOBAL = 1;
    public static final int MESS_METHOD_GET = 2;
    public static final int MESS_METHOD_PUT = 3;
    public static final int MESS_METHOD_READ = 4;
    public static final int MESS_METHOD_WRITE = 5;
    public static final int MESS_METHOD_PERM = 6;
    public static final int MESS_METHOD_OPEN = 7;
    public static final int MESS_METHOD_CHECK = 8;
    public static final int MESS_METHOD_LOCKING = 9;
    public static final int MESS_METHOD_TS_READ = 10;
    public static final int MESS_METHOD_TS_WRITE = 11;
    public static final int MESS_METHOD_ALIAS = 12;
    public static final int MESS_METHOD_COPY = 13;
    public static final int MESS_METHOD_UTILITY = 14;
    public static final int MESS_METHOD_CATALOG = 15;
    public static final int MESS_METHOD_FILE_CHECK = 16;
    public static final int MESS_METHOD_JNI = 17;
    public static final int CONDENSED_CATALOG = 0;
    public static final int ABBREVIATED_CATALOG = 1;
    public static final int FULL_CATALOG = 2;
    protected static String _defaultDSSFileName = "";
    protected static String _defaultDirectory = "";
    protected static int _severeErrorIndex = 0;
    protected static boolean _severeErrorRaised = false;
    protected static Vector<DSSErrorMessage> _severeErrorMessages = new Vector();
    public static int _maxNumberReopensForError = 50;
    public static int _numberReopensForError = 0;
    protected HecDSSFileDataManager _fileData = new HecDSSFileDataManager();
    int _currentRec = 0;
    int _numberRecs = 0;
    boolean _interrupt = false;

    public HecDSSFileAccess(String DssFileName) {
        this.setDSSFileName(DssFileName);
    }

    public HecDSSFileAccess() {
    }

    public static void catchSevereErrors() {
        HecDSSFileAccess.zset("ABORT", "OFF", 0);
    }

    public void done() {
        this._fileData.releaseFile(false);
    }

    public static void setDefaultDSSFileName(String dssFileName) {
        stringContainer cleanName = new stringContainer();
        HecDSSFileAccess.cleanDSSFileName(dssFileName, cleanName);
        _defaultDSSFileName = cleanName.string;
    }

    public static void setDefaultDirectory(String directoryName) {
        _defaultDirectory = directoryName;
    }

    public static String defaultDSSFileName() {
        return _defaultDSSFileName;
    }

    @Deprecated
    public static String defaultDirectory() {
        return _defaultDirectory;
    }

    public String DSSFileName() {
        String filename = this._fileData.dssFilename();
        if (filename.length() == 0) {
            filename = _defaultDSSFileName;
        }
        return filename;
    }

    public boolean fileOpened() {
        return this._fileData.fileOpened();
    }

    public boolean fileAccessible() {
        return this._fileData.fileAccessible();
    }

    public int getDssFileVersion() {
        int version;
        if (this._fileData != null) {
            String name;
            version = this._fileData.getDssFileVersion();
            if (version == 0 && (name = this.DSSFileName()) != null && name.length() > 0) {
                version = HecDSSFileAccess.getDssFileVersion(name);
            }
        } else {
            String name = this.DSSFileName();
            if (name != null && name.length() > 0) {
                version = HecDSSFileAccess.getDssFileVersion(name);
            }
            version = 0;
        }
        return version;
    }

    public static int getDssFileVersion(String dssFileName) {
        return Heclib.zgetFileVersion(dssFileName);
    }

    public static boolean doesDSSFileExist(String dssFileName) {
        stringContainer name = new stringContainer();
        return HecDSSFileAccess.cleanDSSFileName(dssFileName, name);
    }

    public static void setUnit(int unitNumber) {
        HecDSSFileAccess.zset("UNIT", "", unitNumber);
    }

    public int setDSSFileName(String dssFileName) {
        return this.setDSSFileName(dssFileName, false);
    }

    public int setDSSFileName(String dssFileName, int version) {
        return this.setDSSFileName(dssFileName, false, version);
    }

    public int forceMultiUserAccess() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        String parameter = "MULT";
        String alpha = " ";
        int number = 2;
        int[] status = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.zsetfi(dssTable, parameter, alpha, number, status);
        this._fileData.releaseAccess(lockThreadToken);
        return status[0];
    }

    public synchronized int setDSSFileName(String dssFileName, boolean fileMustExist) {
        return this.setDSSFileName(dssFileName, fileMustExist, 0);
    }

    public synchronized int setDSSFileName(String dssFileName, boolean fileMustExist, int dssVersion) {
        if (dssFileName == null) {
            LOGGER.log(Level.WARNING, "No DSS File given, name is null");
            LOGGER.log(Level.FINE, "Caused by: ", new Exception());
            return -4;
        }
        if (dssFileName.isEmpty()) {
            LOGGER.log(Level.WARNING, "No DSS File given, name is empty");
            LOGGER.log(Level.FINE, "Caused by: ", new Exception());
            return -4;
        }
        stringContainer name = new stringContainer();
        boolean exists = HecDSSFileAccess.cleanDSSFileName(dssFileName, name);
        if (fileMustExist && !exists) {
            LOGGER.log(Level.WARNING, "The DSS file given does not exist, but is required to exist.");
            LOGGER.log(Level.WARNING, "DSS file name given: {0}", dssFileName);
            LOGGER.log(Level.WARNING, "Absolute DSS file name: {0}", name.string);
            return -3;
        }
        String fileName = name.string;
        File f = new File(fileName);
        fileName = f.getAbsolutePath();
        if (!exists) {
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "\n\n*****  Cannot access DSS file  *****\n");
                    LOGGER.log(Level.WARNING, "DSS file name given: {0}", dssFileName);
                    LOGGER.log(Level.WARNING, "Absolute DSS file name: {0}", f.getAbsolutePath());
                    LOGGER.log(Level.FINE, "Caused by: ", e);
                    return -5;
                }
                f.delete();
                this._fileData.unmapFile(fileName);
            } else {
                LOGGER.log(Level.WARNING, "Questionable access for file: {0}", f.getAbsolutePath());
            }
        }
        if (this._fileData.isFileAccessed()) {
            this._fileData.releaseFile(false);
        }
        int status = this._fileData.setFile(fileName, fileMustExist, dssVersion);
        return status;
    }

    public synchronized int open(String dssFileName, boolean fileMustExist, int dssVersion) {
        int status = this.setDSSFileName(dssFileName, fileMustExist, dssVersion);
        if (status != 0) {
            return status;
        }
        return this.open();
    }

    public int open() {
        int status = -5;
        if (!this._fileData.fileOpened()) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return status;
            }
            if (this._fileData.fileOpened()) {
                status = 0;
            }
            this._fileData.releaseAccess(lockThreadToken);
        } else {
            status = 0;
        }
        return status;
    }

    public void close() {
        if (this._fileData != null) {
            this._fileData.closeFile();
        }
    }

    @Deprecated
    public void closeDSSFile() {
        this.close();
    }

    @Deprecated
    public void closeAll() {
        this.close();
    }

    @Deprecated
    public void closeAndClear() {
        this.close();
    }

    public static void close(String fileName, boolean ignoreCasePath) {
        HecDSSFileDataManager dm = new HecDSSFileDataManager();
        Vector<String> v = dm.getOpenedFiles();
        if (ignoreCasePath) {
            String fn = fileName.toLowerCase();
            fn = RMAIO.replace(fn, "\\", "/");
            for (int i = 0; i < v.size(); ++i) {
                String f = v.elementAt(i).toLowerCase();
                if (!(f = RMAIO.replace(f, "\\", "/")).equals(fn)) continue;
                dm.closeFile(v.elementAt(i));
            }
        } else {
            String name = RMAIO.replace(fileName, "\\", "/");
            for (int i = 0; i < v.size(); ++i) {
                String f = v.elementAt(i);
                if (!(f = RMAIO.replace(f, "\\", "/")).equals(name)) continue;
                dm.closeFile(v.elementAt(i));
            }
        }
        dm = null;
    }

    public static void closeAllFiles() {
        String s = System.getProperty("CWMS_HOME");
        if (s == null || s.length() == 0) {
            HecDSSFileDataManager dm = new HecDSSFileDataManager();
            dm.closeAllFiles();
            Object var1_1 = null;
        }
    }

    protected int[] requestSecondAccess() {
        return this._fileData.requestSecondAccess();
    }

    public void fileStatus() {
        HecDSSFileAccess hecDSSFileAccess = this;
        hecDSSFileAccess._fileData.status();
    }

    public boolean checkForSevereFileError() {
        boolean error = true;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable != null) {
            error = this.checkForSevereError(dssTable);
            this._fileData.releaseAccess(lockThreadToken);
        }
        return error;
    }

    public boolean checkForSevereError(int[] dssTable) {
        if (dssTable[0] == 6) {
            if (_severeErrorIndex == 0) {
                stringContainer container = new stringContainer();
                int[] returnInt = new int[1];
                Heclib.zinqir(dssTable, "KSTA", container, returnInt);
                if (returnInt[0] > 1) {
                    _severeErrorIndex = returnInt[0] - 1;
                } else {
                    return false;
                }
            }
            if (dssTable[_severeErrorIndex] == 0) {
                return false;
            }
            if (_severeErrorMessages.size() < 200) {
                DSSErrorMessage errorMessage = new DSSErrorMessage();
                stringContainer container = new stringContainer();
                int[] returnInt = new int[1];
                Heclib.zinqir(dssTable, "ERROR", container, returnInt);
                errorMessage.errorCode = returnInt[0];
                if (0 == errorMessage.errorCode) {
                    return false;
                }
                errorMessage.errorMessage = container.string;
                Heclib.zinqir(dssTable, "NAME", container, returnInt);
                errorMessage.dssFileName = container.string;
                _severeErrorMessages.addElement(errorMessage);
                LOGGER.log(Level.WARNING, "DSS File error, code: {0}, File: {1}\n{2}", new Object[]{errorMessage.errorCode, errorMessage.dssFileName, errorMessage.errorMessage});
                _severeErrorRaised = true;
            }
            return _severeErrorRaised;
        }
        if (Heclib.zerrorCheck() > 2) {
            if (_severeErrorMessages.size() < 200) {
                DSSErrorMessage errorMessage = new DSSErrorMessage();
                stringContainer container = new stringContainer();
                int[] returnInt = new int[1];
                Heclib.zinqir(dssTable, "ERROR", container, returnInt);
                errorMessage.errorCode = returnInt[0];
                if (0 == errorMessage.errorCode) {
                    return false;
                }
                errorMessage.errorMessage = container.string;
                Heclib.zinqir(dssTable, "NAME", container, returnInt);
                errorMessage.dssFileName = container.string;
                _severeErrorMessages.addElement(errorMessage);
                LOGGER.log(Level.WARNING, "DSS error, severity: {0}, HEC-DSS File: {1}\n{2}", new Object[]{errorMessage.errorCode, errorMessage.dssFileName, errorMessage.errorMessage});
                _severeErrorRaised = true;
            }
            return _severeErrorRaised;
        }
        return _severeErrorRaised;
    }

    public static boolean checkForSevereError() {
        if (_severeErrorRaised) {
            return _severeErrorRaised;
        }
        return HecDSSFileDataManager.checkForError();
    }

    public int checkForError() {
        if (this.getDssFileVersion() == 7) {
            int[] errorCode = new int[1];
            return Heclib.zerrorCheck();
        }
        if (_severeErrorRaised) {
            return 5;
        }
        if (HecDSSFileDataManager.checkForError()) {
            return 5;
        }
        return 0;
    }

    public void clearError() {
        if (this.getDssFileVersion() == 7) {
            Heclib.zerrorClear();
        } else {
            this.clearSevereError(false);
        }
    }

    public void clearSevereError() {
        this.clearSevereError(false);
    }

    public void clearSevereError(boolean reopenFile) {
        _severeErrorRaised = false;
        stringContainer container = new stringContainer();
        int[] intArray = new int[]{0};
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable != null) {
            Heclib.zinqir(dssTable, "CLEA", container, intArray);
            this._fileData.releaseAccess(lockThreadToken);
        }
        Heclib.zset("clear", "", 0);
        _severeErrorIndex = 0;
        _severeErrorRaised = false;
        _severeErrorMessages.removeAllElements();
        if (reopenFile) {
            if (++_numberReopensForError < _maxNumberReopensForError) {
                LOGGER.log(Level.WARNING, "Attempting to clear error condition by re-opening file: {0}", this.DSSFileName());
                this.close();
                this.open();
            } else {
                LOGGER.log(Level.WARNING, "Reached maximum attempts to clear error condition by re-opening file: {0}", this.DSSFileName());
                LOGGER.log(Level.WARNING, "Number of attemps: {0}, Maximum allowed: {1}", new Object[]{_numberReopensForError, _maxNumberReopensForError});
            }
        }
    }

    public DSSErrorMessage getLastError() {
        DSSErrorMessage errorMessage = new DSSErrorMessage();
        Heclib.zerrorGet(errorMessage);
        return errorMessage;
    }

    public DSSErrorMessage lastSevereErrorMessage() {
        DSSErrorMessage errorMessage = null;
        if (_severeErrorMessages.size() == 0) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable != null) {
                this.checkForSevereError(dssTable);
                this._fileData.releaseAccess(lockThreadToken);
            } else {
                errorMessage = new DSSErrorMessage();
                stringContainer container = new stringContainer();
                int[] returnInt = new int[1];
                Heclib.zquery("ERROR", container, returnInt);
                errorMessage.errorCode = returnInt[0];
                errorMessage.errorMessage = container.toString();
                return errorMessage;
            }
        }
        if (_severeErrorMessages.size() > 0) {
            errorMessage = _severeErrorMessages.lastElement();
        } else {
            errorMessage = new DSSErrorMessage();
            Heclib.zerrorGet(errorMessage);
        }
        return errorMessage;
    }

    public List<DSSErrorMessage> allSevereErrorMessages() {
        if (_severeErrorMessages.size() == 0) {
            this.lastSevereErrorMessage();
        }
        return _severeErrorMessages;
    }

    public int numberRecords() {
        return this.zinqir("NREC");
    }

    public int getNumberRecords() {
        return this.zinqir("NREC");
    }

    public int checkSystemError() {
        return 0;
    }

    public int checkPathnameBins() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        int[] numberErrors = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.zckpnb(dssTable, numberErrors);
        this._fileData.releaseAccess(lockThreadToken);
        return numberErrors[0];
    }

    public int checkLinks() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
        }
        int[] numberErrors = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.zcklnk(dssTable, numberErrors);
        this._fileData.releaseAccess(lockThreadToken);
        return numberErrors[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAllPathnames() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        int[] numberErrors = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        try {
            Heclib.zckpat(dssTable, numberErrors);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return numberErrors[0];
    }

    public HecTime getFileLastWriteTime() {
        HecTime lastWriteTime = new HecTime(10);
        if (this.getDssFileVersion() == 6) {
            stringContainer dssVersion = new stringContainer();
            intContainer numberRecords = new intContainer();
            intContainer numberDeletedRecords = new intContainer();
            HecDouble pointerEfficiency = new HecDouble();
            HecDouble fileSizeKbytes = new HecDouble();
            HecDouble deadSpaceKbytes = new HecDouble();
            HecTime creationDate = new HecTime();
            this.getFileInfo(dssVersion, numberRecords, numberDeletedRecords, pointerEfficiency, fileSizeKbytes, deadSpaceKbytes, creationDate, lastWriteTime);
        } else {
            long timeMillis = this.getFileLastWriteTimeMillis();
            if (timeMillis > 0L) {
                long secs = timeMillis / 1000L;
                lastWriteTime.setSeconds(secs);
            }
        }
        return lastWriteTime;
    }

    public long getFileLastWriteTimeMillis() {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return 0L;
        }
        long timeMillis = Heclib.zlastWriteTimeFile(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        return timeMillis;
    }

    public void getFileInfo(stringContainer dssVersion, intContainer numberRecords, intContainer numberDeletedRecords, HecDouble pointerEfficiency, HecDouble fileSizeKbytes, HecDouble deadSpaceKbytes, HecTime creationDate, HecTime lastWriteTime) {
        int[] number = new int[1];
        stringContainer alpha = new stringContainer();
        this.zinqir("FVER", dssVersion, number);
        this.zinqir("NREC", alpha, number);
        numberRecords.value = number[0];
        this.zinqir("DELE", alpha, number);
        numberDeletedRecords.value = number[0];
        this.zinqir("POINT", alpha, number);
        pointerEfficiency.set((double)number[0] / 100.0);
        this.zinqir("SIZE", alpha, number);
        fileSizeKbytes.set(number[0]);
        this.zinqir("DEAD", alpha, number);
        double size = (double)number[0] * 0.01 * fileSizeKbytes.value();
        deadSpaceKbytes.set(size);
        this.zinqir("FDATE", alpha, number);
        creationDate.setTimeGranularity(3);
        creationDate.setDate(alpha.string);
        this.zinqir("LWDATE", alpha, number);
        lastWriteTime.setTimeGranularity(0);
        lastWriteTime.setDate(alpha.string);
        this.zinqir("LWTIME", alpha, number);
        lastWriteTime.setTime(alpha.string);
    }

    public void getProcessStatus(int[] numberRecs, int[] currentRec) {
        numberRecs[0] = this._numberRecs;
        currentRec[0] = this._currentRec;
    }

    public void setInterrupt(boolean interrupt) {
        this._interrupt = interrupt;
    }

    public void clearStatus() {
        this._interrupt = false;
        this._numberRecs = 0;
        this._currentRec = 0;
        Heclib.zset("TOTA", "", 0);
        Heclib.zset("CURR", "", 0);
        Heclib.zset("NERR", "", 0);
        Heclib.zset("MAXE", "", 0);
        Heclib.zset("INTE", "", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getCollectionList(String seedPathname) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (this.getDssFileVersion() == 6) {
            int[] filePos = new int[]{0};
            stringContainer pathnameContainer = new stringContainer();
            pathnameContainer.string = seedPathname;
            HecDSSFileAccess.zset("PSEUDO", "ON", 0);
            Vector<String> pathnameList = new Vector<String>();
            intContainer lockThreadToken = new intContainer();
            try {
                int[] dssTable = this._fileData.requestAccess(lockThreadToken);
                if (dssTable == null) {
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
                while (true) {
                    String path = Heclib.zcolist(dssTable, filePos, seedPathname);
                    if (filePos[0] > 0 && path.length() > 1) {
                        pathnameList.add(path);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this._fileData.releaseAccess(lockThreadToken);
            }
            return pathnameList.toArray(new String[0]);
        }
        HecDssCatalog cat = new HecDssCatalog();
        cat.setDSSFileName(this.DSSFileName());
        cat.setPathWithWildChars(seedPathname, true);
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return new String[0];
        }
        Heclib.zcatalog(dssTable, cat);
        this._fileData.releaseAccess(lockThreadToken);
        return cat.getPathnames();
    }

    public synchronized String[] getCollectionSequenceList(String seedPathname) {
        String[] paths = this.getCollectionList(seedPathname);
        if (paths == null) {
            return null;
        }
        String[] sequences = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            sequences[i] = DSSPathname.getCollectionSequence(paths[i]);
        }
        return sequences;
    }

    public int getCollectionSize(String seedPathname) {
        String[] paths = this.getCollectionList(seedPathname);
        if (paths == null) {
            return 0;
        }
        return paths.length;
    }

    public static boolean cleanDSSFileName(String inName, stringContainer outName) {
        if (inName == null || inName.length() == 0) {
            return false;
        }
        boolean exists = false;
        try {
            exists = HecDss.getDssFilename(inName, outName, true);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Unable to cleanup/canonize the DSS filename", e);
        }
        outName.string = RMAIO.replace(outName.string, "\\", "/");
        return exists;
    }

    public static String appendNameToDirectory(String directory, String name) {
        if (directory == null || name == null) {
            return name;
        }
        if (directory.length() == 0) {
            return name;
        }
        if (name.length() == 0) {
            return name;
        }
        File tempFile = new File(name);
        if (tempFile.isAbsolute()) {
            return name;
        }
        String separator = System.getProperty("file.separator");
        Object completePath = "";
        if (directory.endsWith(separator) && name.startsWith(separator)) {
            int end = directory.length() - separator.length();
            directory = directory.substring(0, end);
            completePath = directory + name;
        } else {
            completePath = directory.endsWith(separator) || name.startsWith(separator) ? directory + name : directory + separator + name;
        }
        Object retPath = completePath;
        try {
            tempFile = new File((String)completePath);
            retPath = tempFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retPath;
    }

    public static void zsetMessageLevel(int methodID, int levelID) {
        if (Heclib.getLibraryVersion() >= 70211) {
            Heclib.zsetMessageLevel(methodID, levelID);
        } else if (methodID == 0 || methodID == 0) {
            int level;
            switch (levelID) {
                case 0: {
                    level = 0;
                    break;
                }
                case 1: {
                    level = 2;
                    break;
                }
                case 2: {
                    level = 3;
                    break;
                }
                case 3: {
                    level = 4;
                    break;
                }
                case 4: {
                    level = 9;
                    break;
                }
                case 5: {
                    level = 12;
                    break;
                }
                case 6: {
                    level = 15;
                    break;
                }
                default: {
                    level = 4;
                }
            }
            HecDataManager.setMessageLevel(level);
        } else {
            LOGGER.log(Level.WARNING, "javaHeclib needs to be updated for this command.");
        }
    }

    public static int zgetMessageLevel(int methodID) {
        if (Heclib.getLibraryVersion() >= 70211) {
            return Heclib.zgetMessageLevel(methodID);
        }
        if (methodID == 0 || methodID == 0) {
            return HecDataManager.getMessageLevel();
        }
        LOGGER.log(Level.WARNING, "javaHeclib needs to be updated for this command.");
        return -1;
    }

    public static void zset(String parameter, String alpha, int number) {
        Heclib.zset(parameter, alpha, number);
    }

    public int zsetFile(String parameter, String alpha, int number) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        int[] status = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.zsetfi(dssTable, parameter, alpha, number, status);
        this._fileData.releaseAccess(lockThreadToken);
        return status[0];
    }

    public static void processStatus(int[] numberRecs, int[] currentRec, int[] numberErrors) {
        stringContainer alpha = new stringContainer();
        Heclib.zquery("TOTAL", alpha, numberRecs);
        Heclib.zquery("CURRENT", alpha, currentRec);
        Heclib.zquery("NERR", alpha, numberErrors);
    }

    public static void setMessageLevel(int level) {
        Heclib.zset("MLEVEL", "", level);
    }

    public int flushMessages() {
        return this.zsetFile("mflush", "", 0);
    }

    public static void setDss(String settings) {
        StringTokenizer parser = new StringTokenizer(settings, ",");
        String parameter = parser.nextToken();
        String alpha = parser.nextToken();
        int number = Integer.parseInt(parser.nextToken());
        if (parameter != null && alpha != null) {
            Heclib.zset(parameter, alpha, number);
        } else {
            LOGGER.log(Level.WARNING, "Invalid DSS set call: {0}", settings);
        }
    }

    public int zinqir(String parameter) {
        stringContainer alpha = new stringContainer();
        int[] number = new int[1];
        this.zinqir(parameter, alpha, number);
        return number[0];
    }

    public long zinquire(String parameter) {
        intContainer lockThreadToken;
        int[] dssTable;
        if (!this.fileAccessible()) {
            String name = this.DSSFileName();
            if (name == null || name.trim().length() == 0) {
                return -1L;
            }
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            return -1L;
        }
        long answer = Heclib.zinquire(dssTable, parameter);
        this._fileData.releaseAccess(lockThreadToken);
        return answer;
    }

    public void zinqir(String parameter, stringContainer alpha, int[] number) {
        intContainer lockThreadToken;
        int[] dssTable;
        if (!this.fileAccessible()) {
            String name = this.DSSFileName();
            if (name == null || name.trim().length() == 0) {
                return;
            }
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            return;
        }
        Heclib.zinqir(dssTable, parameter, alpha, number);
        this._fileData.releaseAccess(lockThreadToken);
    }

    public static void zquery(String parameter, stringContainer alpha, int[] number) {
        Heclib.zquery(parameter, alpha, number);
    }

    public static int getMessageLevel() {
        int[] level = new int[1];
        stringContainer alpha = new stringContainer();
        Heclib.zquery("MLVL", alpha, level);
        return level[0];
    }

    public static int zquery(String parameter, stringContainer alpha) {
        int[] item = new int[1];
        Heclib.zquery(parameter, alpha, item);
        return item[0];
    }

    public boolean writeAccess() {
        if (!this.fileAccessible()) {
            this.open();
        }
        if (!this.fileAccessible()) {
            return false;
        }
        stringContainer flag = new stringContainer();
        int[] numb = new int[1];
        this.zinqir("READ", flag, numb);
        return flag.string.equals("OFF");
    }

    public int[] debugLook(long address, int numberWords) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (this.zinqir("VERS") == 7) {
            numberWords *= 2;
        }
        int[] array = new int[numberWords];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        Heclib.zgtrec(dssTable, address, numberWords, array);
        this._fileData.releaseAccess(lockThreadToken);
        return array;
    }

    public long[] debugLook7(long address, int numberWords) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (this.getDssFileVersion() == 7 && Heclib.getLibraryVersion() >= 70213) {
            long[] array = new long[numberWords];
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return null;
            }
            Heclib.zget(dssTable, address, numberWords, array);
            this._fileData.releaseAccess(lockThreadToken);
            return array;
        }
        int[] iarray = this.debugLook(address, numberWords);
        long[] array = new long[iarray.length];
        for (int i = 0; i < iarray.length; ++i) {
            array[i] = iarray[i];
        }
        return array;
    }

    public void debugModify(long address, long value) {
        intContainer lockThreadToken;
        int[] dssTable;
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            return;
        }
        Heclib.zdbmod(dssTable, address, value, "", 0);
        this._fileData.releaseAccess(lockThreadToken);
    }

    public static int getIrregBeginningDate(String ePart, int jul, int[] year, int[] month, int[] day, int[] block) {
        int[] minblk = new int[1];
        int[] incblk = new int[1];
        int[] dssTable = new int[400];
        for (int i = 0; i < 400; ++i) {
            dssTable[i] = 0;
        }
        Heclib.zirbeg(dssTable, jul, ePart, year, month, day, block, minblk, incblk);
        return 0;
    }

    @Deprecated
    public String[] getPathnameList(boolean forceUpdate) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
        }
        if (!this.fileOpened()) {
            LOGGER.log(Level.WARNING, "HecDataManager:  DSS file not opened!");
            return null;
        }
        int numberPaths = this.numberRecords();
        String[] pathnames = new String[numberPaths];
        int[] startDates = new int[numberPaths];
        int[] endDates = new int[numberPaths];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        int number = Heclib.zpathnameListJava(dssTable, pathnames, 0, 0, 0, startDates, endDates, numberPaths);
        this._fileData.releaseAccess(lockThreadToken);
        if (number <= 0) {
            return null;
        }
        if (number != numberPaths) {
            // empty if block
        }
        return pathnames;
    }

    public Object clone() {
        HecDSSFileAccess fileAccess;
        try {
            fileAccess = (HecDSSFileAccess)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            return null;
        }
        fileAccess._fileData = (HecDSSFileDataManager)this._fileData.clone();
        fileAccess._currentRec = this._currentRec;
        fileAccess._numberRecs = this._numberRecs;
        fileAccess._interrupt = this._interrupt;
        return fileAccess;
    }

    public int getTSRecordInfo(String pathname, HecTime start, HecTime end, stringContainer units, stringContainer type) {
        DSSPathname path = new DSSPathname(pathname);
        if (!path.isTimeSeries()) {
            return -1;
        }
        int[] startJulian = new int[1];
        int[] startMinutes = new int[1];
        int[] endJulian = new int[1];
        int[] endMinutes = new int[1];
        int[] lqual = new int[1];
        int[] ldouble = new int[1];
        int[] found = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.ztsinfo(dssTable, pathname, startJulian, startMinutes, endJulian, endMinutes, units, type, lqual, ldouble, found);
        this._fileData.releaseAccess(lockThreadToken);
        if (found[0] == 0) {
            start.setUndefined();
            end.setUndefined();
            return -1;
        }
        start.setJulian(startJulian[0], startMinutes[0]);
        end.setJulian(endJulian[0], endMinutes[0]);
        return 0;
    }

    public boolean getTimeSeriesExtents(String pathname, HecTime start, HecTime end) {
        int[] startJulian = new int[1];
        int[] startMinutes = new int[1];
        int[] endJulian = new int[1];
        int[] endMinutes = new int[1];
        int[] lfound = new int[1];
        startJulian[0] = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return false;
        }
        Heclib.ztsends(dssTable, pathname, 0, startJulian, startMinutes, endJulian, endMinutes, lfound);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDSSFileAccess.checkForSevereError()) {
            return false;
        }
        if (lfound[0] != 0 && startJulian[0] != 0) {
            start.setJulian(startJulian[0], startMinutes[0]);
            end.setJulian(endJulian[0], endMinutes[0]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zmessage(String message) {
        boolean opened = true;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null || dssTable.length < 1) {
            opened = false;
            dssTable = new int[]{0};
        }
        try {
            Heclib.zmessage(dssTable, message);
        }
        finally {
            if (opened) {
                this._fileData.releaseAccess(lockThreadToken);
            }
        }
    }
}

