/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.util.Heclib;
import java.io.Serializable;

public class HecDSSFileData
implements Serializable {
    public String dssFileName;
    public boolean dssFileOpened = false;
    public boolean dssFileHasBeenOpened = false;
    public int[] DSSTable = new int[1];
    public int dssVersion;
    public int objectCount = 0;
    public int localAccessNumber;
    public int firstAccessTime;
    public int lastAccessTime;
    public int numberAccesses = 0;
    public boolean inactive = false;
    public boolean done;

    public HecDSSFileData(String fileName, int accessNumber) {
        this.DSSTable[0] = 0;
        this.done = false;
        this.dssFileName = new String(fileName);
        this.localAccessNumber = accessNumber;
        if (this.localAccessNumber < 0) {
            this.localAccessNumber = 0;
        }
        HecDSSFileDataManager.hecTime.setCurrent();
        this.lastAccessTime = this.firstAccessTime = HecDSSFileDataManager.hecTime.value();
        this.dssVersion = 0;
    }

    public HecDSSFileData() {
    }

    public boolean isSameFileAccess(int accessNumber) {
        return this.localAccessNumber == accessNumber && accessNumber >= 0;
    }

    public int addFileAccess() {
        ++this.objectCount;
        return this.localAccessNumber;
    }

    public boolean removeFileAccess() {
        --this.objectCount;
        return this.objectCount <= 0;
    }

    public int open(boolean fileMustExist) {
        return this.open(fileMustExist, 0);
    }

    public int open(boolean fileMustExist, int dssVersion) {
        int[] status = new int[1];
        this.DSSTable = new int[800];
        for (int i = 0; i < 100; ++i) {
            this.DSSTable[i] = 0;
        }
        status[0] = dssVersion;
        Heclib.zopen(this.DSSTable, this.dssFileName, status);
        if (status[0] != 0) {
            System.out.println("Cannot open data base file: " + this.dssFileName);
            this.dssFileOpened = false;
            this.DSSTable = new int[1];
            this.DSSTable[0] = 0;
            return -3;
        }
        this.dssVersion = Heclib.zgetDssFileVersion(this.DSSTable);
        this.dssFileOpened = true;
        this.dssFileHasBeenOpened = true;
        this.inactive = false;
        this.done = false;
        return 0;
    }

    public void close() {
        if (this.dssFileOpened) {
            Heclib.zclose(this.DSSTable);
            this.dssFileOpened = false;
            this.done = false;
            this.DSSTable = new int[1];
            this.DSSTable[0] = 0;
        }
    }

    public void status() {
        System.out.println("File: " + this.dssFileName + ", Open: " + this.dssFileOpened + ", Objects accessing file: " + this.objectCount);
    }

    protected boolean isValid() {
        if (this.DSSTable == null || this.DSSTable.length < 2) {
            return false;
        }
        return this.DSSTable[0] != 0 || this.DSSTable[1] != 0;
    }

    protected int lookupVersion() {
        if (!this.isValid()) {
            return 0;
        }
        if (this.DSSTable[0] > 0) {
            return this.DSSTable[0];
        }
        if (this.DSSTable[1] > 0) {
            return this.DSSTable[1];
        }
        return 0;
    }
}

