/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import com.google.common.flogger.FluentLogger;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.booleanContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HecDSSFileDataManager
implements Cloneable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static ConcurrentMap<Integer, HecDSSFileData> _fileDataMap = new ConcurrentHashMap<Integer, HecDSSFileData>();
    private static final booleanContainer _DSSLocked = new booleanContainer(false);
    private static int _lockThreadToken = 0;
    private static int _totalLockThreadTokens = 1;
    private static int _threadsWaiting = 0;
    private static int _totalFileAccesses = -1;
    private static int _errorIndex6 = 0;
    private static int _callsSinceFlush = 0;
    static Timer timer = null;
    public static HecTime hecTime = new HecTime(0);
    private static Throwable _acquiredBy = null;
    private static long _lockedAt = Long.MIN_VALUE;
    private String _DSSFileName = "";
    private int _fileAccessNumber = -1;
    private int _myLockThreadToken = 0;

    public HecDSSFileDataManager() {
        if (timer == null) {
            timer = new Timer("HecDSSFileDataManager closeUnused timer thread", true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    HecDSSFileDataManager.checkAllMultipleAccess();
                    HecDSSFileDataManager.this.closeUnusedFiles();
                    HecDSSFileDataManager.flushDss();
                }
            };
            long delay = 6000L;
            long period = 6000L;
            timer.scheduleAtFixedRate(task, delay, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setFile(String DSSFileName, boolean fileMustExist, int dssVersion) {
        int status = 0;
        this._DSSFileName = DSSFileName;
        if (DSSFileName == null || DSSFileName.isEmpty()) {
            return -1;
        }
        int lockThreadToken = this.getLockThreadToken();
        boolean success = this.lockDSS(true, lockThreadToken);
        if (!success) {
            ((FluentLogger.Api)LOGGER.atSevere()).log("Failed to lock thread for open DSS file %s", (Object)this._DSSFileName);
            return -1;
        }
        try {
            HecDSSFileData fileDataSet = this.getFileDataSet(this._DSSFileName);
            if (fileDataSet != null) {
                this._fileAccessNumber = fileDataSet.addFileAccess();
            } else {
                fileDataSet = new HecDSSFileData(this._DSSFileName, ++_totalFileAccesses);
                this._fileAccessNumber = fileDataSet.addFileAccess();
                int version = HecDSSFileAccess.getDssFileVersion(this._DSSFileName);
                if (version == 0) {
                    status = fileDataSet.open(fileMustExist, dssVersion);
                    if (status == 0 && fileDataSet.localAccessNumber >= 0) {
                        _fileDataMap.put(fileDataSet.localAccessNumber, fileDataSet);
                    } else {
                        this._fileAccessNumber = -2;
                        ((FluentLogger.Api)LOGGER.atSevere()).log("Failed to open DSS file %s", (Object)this._DSSFileName);
                    }
                } else {
                    _fileDataMap.put(fileDataSet.localAccessNumber, fileDataSet);
                }
            }
        }
        finally {
            this.lockDSS(false, lockThreadToken);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFile(boolean closeIfUnused) {
        boolean itsLocked = false;
        int lockThreadToken = this.getLockThreadToken();
        try {
            itsLocked = this.lockDSS(true, lockThreadToken);
            if (itsLocked) {
                boolean fileNotUsed;
                HecDSSFileData fileDataSet = this.getFileDataSet();
                if (fileDataSet != null && (fileNotUsed = fileDataSet.removeFileAccess())) {
                    if (closeIfUnused) {
                        fileDataSet.close();
                    } else {
                        fileDataSet.done = true;
                    }
                }
            } else {
                ((FluentLogger.Api)LOGGER.atSevere()).log("\n\n****  Unable to obtain thread lock to release file *****\n");
            }
        }
        catch (Throwable t) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(t)).log("Error in releaseFile(boolean)");
        }
        finally {
            if (itsLocked) {
                this.lockDSS(false, lockThreadToken);
            }
        }
    }

    public void closeFile() {
        HecDSSFileData fileDataSet = this.getFileDataSet(this._DSSFileName);
        this.closeFile(fileDataSet);
    }

    public void closeFile(String fileName) {
        HecDSSFileData fileDataSet = this.getFileDataSet(fileName);
        this.closeFile(fileDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(HecDSSFileData fileDataSet) {
        boolean itsLocked = false;
        int lockThreadToken = this.getLockThreadToken();
        try {
            itsLocked = this.lockDSS(true, lockThreadToken);
            if (itsLocked && fileDataSet != null && fileDataSet.dssFileOpened) {
                fileDataSet.close();
                hecTime.setCurrent();
                fileDataSet.lastAccessTime = hecTime.value();
                ++fileDataSet.numberAccesses;
            }
        }
        catch (Throwable t) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(t)).log("Error closing dss file ");
        }
        finally {
            if (itsLocked) {
                this.lockDSS(false, lockThreadToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeFileOptional(HecDSSFileData fileDataSet) {
        if (_lockThreadToken > 0) {
            return false;
        }
        boolean itsLocked = false;
        int lockThreadToken = this.getLockThreadToken();
        try {
            itsLocked = this.lockDSS(true, lockThreadToken);
            if (itsLocked && fileDataSet != null && fileDataSet.dssFileOpened) {
                fileDataSet.close();
                hecTime.setCurrent();
                fileDataSet.lastAccessTime = hecTime.value();
                ++fileDataSet.numberAccesses;
            }
        }
        catch (Throwable t) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(t)).log("Error in closeFileOptional ", (Object)t);
        }
        finally {
            if (itsLocked) {
                this.lockDSS(false, lockThreadToken);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllFiles() {
        boolean itsLocked = false;
        int lockThreadToken = this.getLockThreadToken();
        try {
            itsLocked = this.lockDSS(true, lockThreadToken);
            if (itsLocked) {
                HashSet entries = new HashSet(_fileDataMap.entrySet());
                for (Map.Entry entry : entries) {
                    HecDSSFileData fileDataSet = (HecDSSFileData)entry.getValue();
                    fileDataSet.close();
                    Integer n = (Integer)entry.getKey();
                }
            }
        }
        catch (Throwable t) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(t)).log("Error in closeAllFiles() ", (Object)t);
        }
        finally {
            if (itsLocked) {
                this.lockDSS(false, lockThreadToken);
            }
        }
    }

    public boolean isFileAccessed() {
        return this._fileAccessNumber >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] requestAccess(intContainer lockThreadToken) {
        int lockThreadTokenID;
        int status;
        if (this._fileAccessNumber < 0 && (status = this.setFile(this.dssFileName(), false, 0)) < 0) {
            return null;
        }
        HecDSSFileData fileDataSet = null;
        lockThreadToken.value = lockThreadTokenID = this.getLockThreadToken();
        boolean success = this.lockDSS(true, lockThreadTokenID);
        if (!success) {
            System.out.println("Failed to lock synchronization thread for open DSS file " + this.dssFilename());
            return null;
        }
        try {
            fileDataSet = this.getFileDataSet();
            if (fileDataSet == null) {
                File f;
                if (this.dssFilename() == null || this.dssFileName().trim().length() < 1) {
                    ((FluentLogger.Api)LOGGER.atSevere()).log("*** No DSS file name supplied; HecDSSFileDataManager.requestAccess()");
                }
                if (!(f = new File(this.dssFileName())).exists()) {
                    ((FluentLogger.Api)LOGGER.atSevere()).log("*** Either file does not exist, or it cannot be accessed");
                    ((FluentLogger.Api)LOGGER.atSevere()).log("File name: %s", (Object)f.getAbsolutePath());
                    ((FluentLogger.Api)LOGGER.atSevere()).log("In function HecDSSFileDataManager.requestAccess()");
                }
            }
        }
        catch (Throwable t) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(t)).log("*** Error attempting to lock thread to access DSS file %s", (Object)this.dssFilename());
        }
        finally {
            if (fileDataSet == null) {
                this.lockDSS(false, lockThreadTokenID);
                int status2 = this.setFile(this.dssFileName(), false, 0);
                if (status2 != 0) {
                    return null;
                }
            }
        }
        if (fileDataSet == null) {
            success = this.lockDSS(true, lockThreadTokenID);
            if (!success) {
                ((FluentLogger.Api)LOGGER.atSevere()).log("Failed to lock thread for open DSS file %s ", (Object)this.dssFilename());
                return null;
            }
            fileDataSet = this.getFileDataSet();
        }
        if (fileDataSet != null) {
            if (!fileDataSet.isValid()) {
                int stat;
                try {
                    stat = fileDataSet.open(true);
                }
                catch (Exception ex) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)ex)).log("Error opening DSS file %s", (Object)this.dssFilename());
                    this.lockDSS(false, lockThreadTokenID);
                    return null;
                }
                if (stat == 0) {
                    this._fileAccessNumber = fileDataSet.localAccessNumber;
                    fileDataSet.dssVersion = fileDataSet.lookupVersion();
                }
            }
            if (!fileDataSet.isValid()) {
                ((FluentLogger.Api)LOGGER.atSevere()).log("\n\n******* Error - Unable to access HEC-DSS file: %s", (Object)this.dssFilename());
                this.lockDSS(false, lockThreadTokenID);
                return null;
            }
            hecTime.setCurrent();
            fileDataSet.lastAccessTime = hecTime.value();
            ++fileDataSet.numberAccesses;
            return fileDataSet.DSSTable;
        }
        ((FluentLogger.Api)LOGGER.atSevere()).log("\n\n******* Error - Unable to access HEC-DSS file: %s", (Object)this.dssFilename());
        this.lockDSS(false, lockThreadTokenID);
        return null;
    }

    public void releaseAccess(intContainer lockThreadToken) {
        this.lockDSS(false, lockThreadToken.value);
    }

    public int[] requestSecondAccess() {
        if (!HecDSSFileDataManager._DSSLocked.value) {
            return null;
        }
        HecDSSFileData fileDataSet = this.getFileDataSet();
        if (fileDataSet == null) {
            fileDataSet = this.getFileDataSet(this._DSSFileName);
        }
        if (fileDataSet != null) {
            if (!fileDataSet.dssFileOpened) {
                int stat = fileDataSet.open(true);
                if (stat == 0) {
                    this._fileAccessNumber = fileDataSet.localAccessNumber;
                    fileDataSet.dssVersion = fileDataSet.lookupVersion();
                }
                if (!fileDataSet.isValid()) {
                    ((FluentLogger.Api)LOGGER.atSevere()).log("\n\n******* Error - Unable to access HEC-DSS file: %s", (Object)this._DSSFileName);
                    return null;
                }
            }
            hecTime.setCurrent();
            fileDataSet.lastAccessTime = hecTime.value();
            ++fileDataSet.numberAccesses;
            return fileDataSet.DSSTable;
        }
        return null;
    }

    public String dssFilename() {
        if (this._DSSFileName != null && this._DSSFileName.length() > 0) {
            return this._DSSFileName;
        }
        return HecDSSFileAccess.defaultDSSFileName();
    }

    public String dssFileName() {
        return this.dssFilename();
    }

    public boolean fileAccessible() {
        if (this.fileOpened()) {
            return true;
        }
        String name = this.dssFilename();
        if (name == null || name.length() < 1) {
            return false;
        }
        HecDSSFileData fileDataSet = this.getFileDataSet();
        if (fileDataSet != null) {
            return true;
        }
        int status = this.setFile(this.dssFileName(), false, 0);
        return status == 0;
    }

    public boolean fileOpened() {
        HecDSSFileData fileDataSet = this.getFileDataSet();
        if (fileDataSet != null) {
            if (fileDataSet.dssFileOpened) {
                this._fileAccessNumber = fileDataSet.localAccessNumber;
            }
            return fileDataSet.dssFileOpened;
        }
        fileDataSet = this.getFileDataSet(this.dssFileName());
        if (fileDataSet != null) {
            if (fileDataSet.dssFileOpened) {
                this._fileAccessNumber = fileDataSet.localAccessNumber;
            }
            return fileDataSet.dssFileOpened;
        }
        return false;
    }

    public int getDssFileVersion() {
        HecDSSFileData fileDataSet = this.getFileDataSet();
        if (fileDataSet != null) {
            if (fileDataSet.dssVersion == 0 && fileDataSet.dssFileOpened) {
                fileDataSet.dssVersion = Heclib.zgetDssFileVersion(fileDataSet.DSSTable);
            }
            return fileDataSet.dssVersion;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAllMultipleAccess() {
        if (!_fileDataMap.isEmpty()) {
            booleanContainer booleanContainer2 = _DSSLocked;
            synchronized (booleanContainer2) {
                if (!HecDSSFileDataManager._DSSLocked.value) {
                    HecDSSFileDataManager._DSSLocked.value = true;
                    _acquiredBy = new Throwable();
                    for (Map.Entry entrySet : _fileDataMap.entrySet()) {
                        Integer key = (Integer)entrySet.getKey();
                        HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
                        if (!fileDataSet.dssFileOpened || !fileDataSet.isValid()) continue;
                        Heclib.zckmul(fileDataSet.DSSTable);
                        Heclib.zcheckAccessReset(fileDataSet.DSSTable, false, 10000);
                    }
                    HecDSSFileDataManager._DSSLocked.value = false;
                    _acquiredBy = null;
                }
            }
        }
    }

    public static String getStackTrace(Throwable throwable) {
        String retval = "null";
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter((Writer)sw, true);){
                throwable.printStackTrace(pw);
            }
            retval = sw.getBuffer().toString();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushDss() {
        if (!_fileDataMap.isEmpty() && ++_callsSinceFlush >= 5) {
            booleanContainer booleanContainer2 = _DSSLocked;
            synchronized (booleanContainer2) {
                if (!HecDSSFileDataManager._DSSLocked.value) {
                    HecDSSFileDataManager._DSSLocked.value = true;
                    _acquiredBy = new Throwable();
                    for (Map.Entry entrySet : _fileDataMap.entrySet()) {
                        HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
                        if (!fileDataSet.dssFileOpened || !fileDataSet.isValid() || Heclib.zgetDssFileVersion(fileDataSet.DSSTable) < 7) continue;
                        Heclib.zflush(fileDataSet.DSSTable, 0);
                    }
                    HecDSSFileDataManager._DSSLocked.value = false;
                    _acquiredBy = null;
                    _callsSinceFlush = 0;
                }
            }
        }
    }

    public static void DssFileManagerStatus(Collection<HecDSSFileData> output) {
        HecDSSFileDataManager.status(output);
    }

    public static void status() {
        ArrayList<HecDSSFileData> output = new ArrayList<HecDSSFileData>();
        HecDSSFileDataManager.status(output);
        hecTime.setCurrent();
        System.out.println(" ");
        System.out.println("DSS Trace for " + hecTime.dateAndTime());
        System.out.println("Number of files accessed: " + _fileDataMap.size());
        HecTime htime = new HecTime(0);
        for (HecDSSFileData fileDataSet : output) {
            System.out.println(" ");
            System.out.println("File: " + fileDataSet.dssFileName);
            System.out.println(" Open: " + fileDataSet.dssFileOpened + ", Objects accessing file: " + fileDataSet.objectCount);
            System.out.println("DSS Version: " + fileDataSet.dssVersion);
            htime.set(fileDataSet.firstAccessTime);
            System.out.println("First Access: " + htime.dateAndTime());
            htime.set(fileDataSet.lastAccessTime);
            System.out.println("Last Access:  " + htime.dateAndTime());
            System.out.println("Number of Accesses: " + fileDataSet.numberAccesses);
        }
    }

    public static void status(Collection<HecDSSFileData> output) {
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            Integer key = (Integer)entrySet.getKey();
            HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
            HecDSSFileData copyDataSet = new HecDSSFileData();
            copyDataSet.dssFileName = fileDataSet.dssFileName;
            copyDataSet.dssFileOpened = fileDataSet.dssFileOpened;
            copyDataSet.objectCount = fileDataSet.objectCount;
            copyDataSet.localAccessNumber = fileDataSet.localAccessNumber;
            copyDataSet.firstAccessTime = fileDataSet.firstAccessTime;
            copyDataSet.lastAccessTime = fileDataSet.lastAccessTime;
            copyDataSet.numberAccesses = fileDataSet.numberAccesses;
            output.add(copyDataSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockDSS(boolean lock, int lockThreadToken) {
        booleanContainer booleanContainer2 = _DSSLocked;
        synchronized (booleanContainer2) {
            if (lock) {
                int count = 0;
                while (HecDSSFileDataManager._DSSLocked.value) {
                    try {
                        ++_threadsWaiting;
                        _DSSLocked.wait(1L);
                        ++count;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        --_threadsWaiting;
                    }
                    if (count == 200000) {
                        ((FluentLogger.Api)LOGGER.atWarning()).log("\n****  WARNING - Excessive wait to lock thread for DSS access ****\n");
                        this.printDiagnostics();
                    }
                    if (count <= 500000) continue;
                    ((FluentLogger.Api)LOGGER.atWarning()).log("\n****  WARNING - Unable to lock thread for DSS access ****\n");
                    ((FluentLogger.Api)LOGGER.atWarning()).log("In HecDSSFileDataManager.lockDSS");
                    this.printDiagnostics();
                    return false;
                }
                HecDSSFileDataManager._DSSLocked.value = true;
                _acquiredBy = new Throwable();
                _lockedAt = System.currentTimeMillis();
                _lockThreadToken = lockThreadToken;
            } else if (_lockThreadToken == lockThreadToken) {
                _lockThreadToken = 0;
                HecDSSFileDataManager._DSSLocked.value = false;
                _acquiredBy = null;
                _lockedAt = Long.MIN_VALUE;
                _DSSLocked.notifyAll();
            } else {
                String mess = "Synchronous thread lock for DSS miss-match.\nlocked token: " + _lockThreadToken + ",  calling token: " + lockThreadToken;
                ((FluentLogger.Api)LOGGER.atSevere()).log(mess);
                this.printDiagnostics();
                throw new RuntimeException(mess);
            }
        }
        return true;
    }

    private void printDiagnostics() {
        System.out.println("Issue occurring for file: " + this._DSSFileName);
        System.out.println("fileAccessNumber: " + this._fileAccessNumber);
        System.out.println("totalFileAccesses: " + _totalFileAccesses);
        System.out.println("myLockThreadToken: " + this._myLockThreadToken);
        System.out.println("lockThreadToken: " + _lockThreadToken);
        System.out.println("totalLockThreadTokens: " + _totalLockThreadTokens);
        System.out.println("threadsWaiting: " + _threadsWaiting);
        System.out.println("lockedAt: " + _lockedAt);
        System.out.println("lockedBy: " + HecDSSFileDataManager.getStackTrace(_acquiredBy));
        System.out.println("current stack: " + HecDSSFileDataManager.getStackTrace(new Throwable()));
        System.out.println("Last access time: " + hecTime.toString());
        System.out.println("System status:\n");
        HecDSSFileDataManager.status();
    }

    protected synchronized int getLockThreadToken() {
        this._myLockThreadToken = ++_totalLockThreadTokens;
        return this._myLockThreadToken;
    }

    protected HecDSSFileData getFileDataSet() {
        HecDSSFileData found;
        HecDSSFileData fileDataSet = null;
        if (this._fileAccessNumber >= 0 && (found = (HecDSSFileData)_fileDataMap.get(this._fileAccessNumber)) != null && found.isSameFileAccess(this._fileAccessNumber)) {
            fileDataSet = found;
        }
        if (fileDataSet == null) {
            for (Map.Entry entrySet : _fileDataMap.entrySet()) {
                Integer key = (Integer)entrySet.getKey();
                HecDSSFileData value = (HecDSSFileData)entrySet.getValue();
                if (value == null || !value.isSameFileAccess(this._fileAccessNumber)) continue;
                ((FluentLogger.Api)LOGGER.atInfo()).log("Expected HecDSSFileData at location %d but found at %d", this._fileAccessNumber, (Object)key);
                fileDataSet = value;
            }
        } else {
            if (fileDataSet.dssFileName == null) {
                return null;
            }
            if (fileDataSet.dssFileName.length() == 0) {
                return null;
            }
        }
        return fileDataSet;
    }

    protected HecDSSFileData getFileDataSet(String DSSFilename) {
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
            if (!Paths.get(fileDataSet.dssFileName, new String[0]).equals(Paths.get(DSSFilename, new String[0]))) continue;
            return fileDataSet;
        }
        return null;
    }

    protected Vector<String> getOpenedFiles() {
        Vector<String> files = new Vector<String>();
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            Integer key = (Integer)entrySet.getKey();
            HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
            if (!fileDataSet.dssFileOpened) continue;
            files.add(fileDataSet.dssFileName);
        }
        return files;
    }

    protected Vector<String> getAccessedFiles() {
        Vector<String> files = new Vector<String>();
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
            files.add(fileDataSet.dssFileName);
        }
        return files;
    }

    public static boolean checkForError() {
        if (_errorIndex6 <= 0) {
            stringContainer container = new stringContainer();
            int[] ift = new int[]{6};
            int[] returnInt = new int[1];
            Heclib.zinqir(ift, "KSTA", container, returnInt);
            if (returnInt[0] > 1) {
                _errorIndex6 = returnInt[0] - 1;
            }
        }
        if (_errorIndex6 <= 0) {
            return false;
        }
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            HecDSSFileData fileDataSet = (HecDSSFileData)entrySet.getValue();
            if (!fileDataSet.dssFileOpened || !(Heclib.zgetDssFileVersion(fileDataSet.DSSTable) == 7 ? Heclib.zerrorCheck() != 0 : fileDataSet.DSSTable[_errorIndex6] != 0)) continue;
            return true;
        }
        return false;
    }

    public synchronized void unmapFile(String DSSFilename) {
        HecDSSFileData fileDataSet;
        Map.Entry theEntrySet = null;
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            fileDataSet = (HecDSSFileData)entrySet.getValue();
            if (!Paths.get(fileDataSet.dssFileName, new String[0]).equals(Paths.get(DSSFilename, new String[0]))) continue;
            theEntrySet = entrySet;
            break;
        }
        if (theEntrySet != null) {
            boolean locked = false;
            int lockThreadToken = 0;
            fileDataSet = (HecDSSFileData)theEntrySet.getValue();
            if (!fileDataSet.dssFileOpened) {
                if (!locked) {
                    lockThreadToken = this.getLockThreadToken();
                    locked = this.lockDSS(true, lockThreadToken);
                }
                _fileDataMap.remove(theEntrySet.getKey());
            }
            if (locked) {
                this.lockDSS(false, lockThreadToken);
            }
        }
    }

    protected synchronized void closeUnusedFiles() {
        int elapsed;
        HecDSSFileData fileDataSet;
        Integer key;
        int numberUnused = 0;
        boolean locked = false;
        int lockThreadToken = 0;
        HecTime currentTime = new HecTime(0);
        currentTime.setCurrent();
        int currentSecs = currentTime.value();
        for (Map.Entry entrySet : _fileDataMap.entrySet()) {
            key = (Integer)entrySet.getKey();
            fileDataSet = (HecDSSFileData)entrySet.getValue();
            elapsed = currentSecs - fileDataSet.lastAccessTime;
            if (fileDataSet.dssFileOpened) {
                if (fileDataSet.objectCount <= 0) {
                    if (elapsed > 40) {
                        if (HecDSSFileAccess.getMessageLevel() > 1) {
                            System.out.println("DSS un-accessed file released " + fileDataSet.dssFileName);
                        }
                        if (!this.closeFileOptional(fileDataSet)) continue;
                        fileDataSet.inactive = true;
                        continue;
                    }
                    if (!fileDataSet.done || elapsed <= 5 || !this.closeFileOptional(fileDataSet)) continue;
                    fileDataSet.inactive = true;
                    continue;
                }
                if (elapsed <= 300) continue;
                if (HecDSSFileAccess.getMessageLevel() > 1) {
                    System.out.println("DSS File inactivity time out; file released " + fileDataSet.dssFileName);
                }
                if (!this.closeFileOptional(fileDataSet)) continue;
                fileDataSet.inactive = true;
                continue;
            }
            if (elapsed > 7200) {
                if (!locked) {
                    lockThreadToken = this.getLockThreadToken();
                    locked = this.lockDSS(true, lockThreadToken);
                }
                _fileDataMap.remove(key, fileDataSet);
                continue;
            }
            ++numberUnused;
        }
        if (numberUnused > 500) {
            for (Map.Entry entrySet : _fileDataMap.entrySet()) {
                key = (Integer)entrySet.getKey();
                fileDataSet = (HecDSSFileData)entrySet.getValue();
                if (!fileDataSet.inactive || fileDataSet.dssFileOpened || (elapsed = currentSecs - fileDataSet.lastAccessTime) <= 3600) continue;
                if (!locked) {
                    lockThreadToken = this.getLockThreadToken();
                    locked = this.lockDSS(true, lockThreadToken);
                }
                _fileDataMap.remove(key, fileDataSet);
            }
        }
        if (locked) {
            this.lockDSS(false, lockThreadToken);
        }
    }

    public Object clone() {
        HecDSSFileDataManager fileManager;
        try {
            fileManager = (HecDSSFileDataManager)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            return null;
        }
        fileManager._DSSFileName = this._DSSFileName;
        fileManager._fileAccessNumber = this._fileAccessNumber;
        return fileManager;
    }
}

