/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;

public class HecDSSRecordData {
    public HecDataManager myThis;
    public int accessNumber;
    public String pathname;
    public int recordType;
    public int startTime;
    public int endTime;
    public int julianBaseDate;
    public double[] arrayX;
    public double[][] arrayY;
    public int[] times;
    public int[] flags;
    public int arraySize;
    public int numberCurves;
    public String[] curveLabels;
    public boolean labelsUsed;
    public double[] ratingInfo;
    public int horizontalAxis;
    public int timeOffset;
    public String unitsX;
    public String typeX;
    public String unitsY;
    public String typeY;
    public int precision;
    public int plan;
    public String supplementalInfo;
    public double[] ordinates;
    public int[] ordinateDescription;
    public boolean containsData;
    public boolean storeDoubles;
    public boolean dataSavedToDisk;

    public HecDSSRecordData() {
        this.accessNumber = 0;
        this.arraySize = 0;
        this.numberCurves = 0;
        this.horizontalAxis = 0;
        this.recordType = 0;
        this.plan = 0;
        this.precision = -3;
        this.containsData = false;
        this.storeDoubles = true;
        this.dataSavedToDisk = false;
        this.labelsUsed = false;
        this.arrayX = null;
        this.arrayY = null;
        this.times = null;
        this.flags = null;
        this.ratingInfo = null;
        this.supplementalInfo = null;
        this.ordinates = null;
        this.ordinateDescription = null;
        this.startTime = 0;
        this.endTime = 0;
        this.timeOffset = 0;
        this.julianBaseDate = 0;
        this.unitsX = new String();
        this.typeX = new String();
        this.unitsY = new String();
        this.typeY = new String();
    }

    public HecDSSRecordData(String path) {
        this.pathname = new String(path);
    }

    public HecDSSRecordData(HecDSSRecordData recordData) {
        this.copy(recordData);
    }

    public boolean sameDataSet(String inPathname, int inRecordType, boolean timeSeries, HecTime inStartTime, HecTime inEndTime, int slashPosition4, int slashPosition5) {
        if (inRecordType != this.recordType) {
            return false;
        }
        if (timeSeries) {
            boolean matches = false;
            if (!this.pathname.regionMatches(true, 0, inPathname, 0, slashPosition4)) {
                return false;
            }
            int len = inPathname.length() - slashPosition5;
            int start = this.pathname.length() - len;
            if (!inPathname.regionMatches(true, slashPosition5, this.pathname, start, len)) {
                return false;
            }
            if (this.startTime != inStartTime.value()) {
                return false;
            }
            if (this.endTime != inEndTime.value()) {
                return false;
            }
        } else if (!this.pathname.equalsIgnoreCase(inPathname)) {
            return false;
        }
        return true;
    }

    public void copy(HecDSSRecordData recordData) {
        int i;
        int length;
        this.pathname = recordData.pathname != null ? new String(recordData.pathname) : null;
        this.accessNumber = 0;
        this.arraySize = recordData.arraySize;
        this.numberCurves = recordData.numberCurves;
        this.plan = recordData.plan;
        if (recordData.arrayX != null) {
            length = recordData.arrayX.length;
            this.arrayX = new double[length];
            for (i = 0; i < length; ++i) {
                this.arrayX[i] = recordData.arrayX[i];
            }
        } else {
            length = 0;
            this.arrayX = null;
        }
        if (recordData.arrayY != null) {
            length = recordData.arrayY.length;
            this.arrayY = new double[this.numberCurves][length];
            for (i = 0; i < length; ++i) {
                this.arrayY[i] = recordData.arrayY[i];
            }
        } else {
            this.arrayY = null;
        }
        if (recordData.times != null) {
            length = recordData.times.length;
            this.times = new int[length];
            for (i = 0; i < length; ++i) {
                this.times[i] = recordData.times[i];
            }
        } else {
            this.times = null;
        }
        if (recordData.flags != null) {
            length = recordData.flags.length;
            this.flags = new int[length];
            for (i = 0; i < length; ++i) {
                this.flags[i] = recordData.flags[i];
            }
        } else {
            this.flags = null;
        }
        this.startTime = recordData.startTime;
        this.endTime = recordData.endTime;
        this.timeOffset = recordData.timeOffset;
        this.julianBaseDate = recordData.julianBaseDate;
        this.unitsX = recordData.unitsX;
        this.typeX = recordData.typeX;
        this.unitsY = recordData.unitsY;
        this.typeY = recordData.typeY;
        this.supplementalInfo = recordData.supplementalInfo;
        if (recordData.ordinates != null) {
            this.ordinates = new double[recordData.ordinates.length];
            for (i = 0; i < this.ordinates.length; ++i) {
                this.ordinates[i] = recordData.ordinates[i];
            }
        }
        if (recordData.ordinateDescription != null) {
            this.ordinateDescription = new int[recordData.ordinateDescription.length];
            for (i = 0; i < this.ordinateDescription.length; ++i) {
                this.ordinateDescription[i] = recordData.ordinateDescription[i];
            }
        }
        this.labelsUsed = recordData.labelsUsed;
        this.precision = recordData.precision;
        this.recordType = recordData.recordType;
        this.containsData = recordData.containsData;
        this.dataSavedToDisk = recordData.dataSavedToDisk;
        if (this.labelsUsed && recordData.curveLabels != null) {
            this.curveLabels = new String[this.numberCurves];
            for (i = 0; i < this.numberCurves; ++i) {
                if (i >= recordData.curveLabels.length) continue;
                this.curveLabels[i] = recordData.curveLabels[i];
            }
        }
        if (recordData.ratingInfo != null) {
            this.ratingInfo = new double[recordData.ratingInfo.length];
            for (i = 0; i < recordData.ratingInfo.length; ++i) {
                this.ratingInfo[i] = recordData.ratingInfo[i];
            }
        }
    }

    public void status() {
        HecTime hecTime = new HecTime();
        System.out.println("myThis          " + this.myThis);
        System.out.println("pathname        " + this.pathname);
        System.out.println("accessNumber    " + this.accessNumber);
        System.out.println("arrayX          " + this.arrayX);
        System.out.println("arrayY          " + this.arrayY);
        System.out.println("times           " + this.times);
        System.out.println("flags           " + this.flags);
        System.out.println("arraySize       " + this.arraySize);
        System.out.println("numberCurves    " + this.numberCurves);
        System.out.println("plan            " + this.plan);
        if (this.startTime != 0) {
            hecTime.setMinutes(this.startTime);
            System.out.println("startTime  " + hecTime.dateAndTime() + "  value = " + this.startTime);
        } else {
            System.out.println("startTime not set ");
        }
        if (this.endTime != 0) {
            hecTime.setMinutes(this.endTime);
            System.out.println("endTime  " + hecTime.dateAndTime() + "  value = " + this.endTime);
        } else {
            System.out.println("endTime not set ");
        }
        System.out.println("timeOffset      " + this.timeOffset);
        System.out.println("unitsX          " + this.unitsX);
        System.out.println("typeX           " + this.typeX);
        System.out.println("unitsY          " + this.unitsY);
        System.out.println("typeY           " + this.typeY);
        System.out.println("precision       " + this.precision);
        System.out.println("recordType      " + this.recordType);
        System.out.println("containsData    " + this.containsData);
        System.out.println("dataSavedToDisk " + this.dataSavedToDisk);
    }
}

