/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HecDSSUtilities
extends HecDataManager
implements IHecDSSUtilities {
    private static final Logger logger = Logger.getLogger(HecDSSUtilities.class.getName());
    Vector _lastDeletedList = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fileAccessInfo(int[] accessMode, int[] numberAccesses, int[] numberWrites, int[] pidsArray, int[] modesArray, int[] numberPids) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        int status = -1;
        try {
            status = Heclib.zfileAccessInfo(dssTable, accessMode, numberAccesses, numberWrites, pidsArray, modesArray, pidsArray.length, numberPids);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fileStats() {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        try {
            Heclib.zfilst(dssTable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkFile() {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        try {
            status = Heclib.zcheckFile(dssTable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(List<String> pathnameList) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        try {
            this._lastDeletedList.removeAllElements();
            int found = 0;
            for (int i = 0; i < pathnameList.size(); ++i) {
                String pathname = pathnameList.get(i);
                found = Heclib.zdelet(dssTable, pathname);
                if (found == 0) continue;
                this._lastDeletedList.addElement(pathname);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (this._lastDeletedList.size() == pathnameList.size()) {
            return 0;
        }
        return -1;
    }

    public List<String> getDeletedRecords() {
        ArrayList<String> deletedRecords = new ArrayList<String>();
        this.searchDSSPaths("DELETE", deletedRecords);
        return deletedRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int undelete(List<String> pathnames) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        int status = 0;
        try {
            for (int i = 0; i < pathnames.size(); ++i) {
                String pathname = pathnames.get(i);
                status = Heclib.zundel(dssTable, pathname);
                if (status == 0) continue;
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int undoLastDelete() {
        if (this._lastDeletedList.size() == 0) {
            return -1;
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        int status = 0;
        try {
            for (int i = 0; i < this._lastDeletedList.size(); ++i) {
                String pathname = (String)this._lastDeletedList.elementAt(i);
                status = Heclib.zundel(dssTable, pathname);
            }
            this._lastDeletedList.removeAllElements();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    private int copyRecords(HecDataManager src, HecDataManager dest, List<String> pathnameList) {
        return this.copyRecords(src, dest, pathnameList, pathnameList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyRecords(HecDataManager src, HecDataManager dest, List<String> pathnameListFrom, List<String> pathnameListTo) {
        int vdest;
        Vector<String> pathSrc = new Vector<String>();
        Vector<String> pathDest = new Vector<String>();
        int vsrc = src.getDssFileVersion();
        boolean sameVersion = vsrc == (vdest = dest.getDssFileVersion());
        for (int i = 0; i < pathnameListFrom.size(); ++i) {
            String path1 = pathnameListFrom.get(i);
            String path2 = pathnameListTo.get(i);
            if (!sameVersion && HecDSSUtilities.isGridPath(src, path1)) {
                HecDSSUtilities.copyGrid(src.DSSFileName(), dest.DSSFileName(), path1, path2);
                continue;
            }
            pathSrc.add(path1);
            pathDest.add(path2);
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = dest._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        int status = 0;
        try {
            int[] dssTableFrom = src.requestSecondAccess();
            if (dssTableFrom == null) {
                int n = -1;
                return n;
            }
            status = this.copyRecords(dssTableFrom, dssTable, pathSrc, pathDest);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            dest._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    public int copyRecordsInto(HecDataManager fromDataManager, List<String> pathnameList) {
        return this.copyRecords(fromDataManager, this, pathnameList);
    }

    @Override
    public int copyRecordsInto(String fromDSSFilename, List<String> pathnameList) {
        HecDataManager fromDataManager = new HecDataManager();
        int status = fromDataManager.setDSSFileName(fromDSSFilename);
        if (status != 0) {
            fromDataManager.done();
            return status;
        }
        status = this.copyRecordsInto(fromDataManager, pathnameList);
        fromDataManager.done();
        return status;
    }

    public int copyRecordsFrom(HecDataManager toDataManager, List<String> pathnameList) {
        return this.copyRecords(this, toDataManager, pathnameList);
    }

    public int copyRecordsFrom(HecDataManager toDataManager, List<String> pathnameListFrom, List<String> pathnameListTo) {
        return this.copyRecords(this, toDataManager, pathnameListFrom, pathnameListTo);
    }

    @Override
    public int copyRecordsFrom(String toDSSFilename, List<String> pathnameList) {
        HecDataManager toDataManager = new HecDataManager();
        int status = toDataManager.setDSSFileName(toDSSFilename);
        if (status != 0) {
            toDataManager.done();
            return status;
        }
        status = this.copyRecordsFrom(toDataManager, pathnameList);
        toDataManager.done();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyFile(HecDataManager toDataManager) {
        int vto;
        int verfrom = this.getDssFileVersion();
        if (verfrom != (vto = toDataManager.getDssFileVersion()) && HecDSSUtilities.anyGridsInFile(this)) {
            String[] catalog = this.getCatalog(false, "");
            Vector<String> pathList = new Vector<String>();
            pathList.addAll(Arrays.asList(catalog));
            return this.copyRecordsFrom(toDataManager, pathList);
        }
        int buffer1Size = 10000;
        int buffer2Size = 2000;
        int[] buffer1 = new int[buffer1Size];
        int[] buffer2 = new int[buffer2Size];
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        try {
            int[] dssTableTo = toDataManager.requestSecondAccess();
            if (dssTableTo == null) {
                int n = -1;
                return n;
            }
            status = Heclib.zcofil(dssTable, dssTableTo, buffer1, buffer1Size, buffer2, buffer2Size);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        buffer1 = null;
        buffer2 = null;
        return status;
    }

    @Override
    public int copyFile(String toDSSFilename) {
        HecDataManager toDataManager = new HecDataManager();
        int status = 0;
        int fromVers = this.getDssFileVersion();
        int toVers = HecDSSUtilities.getDssFileVersion(toDSSFilename);
        if (fromVers == 6 && toVers == 0) {
            HecDataManager.zset("DSSV", "", 6);
            status = toDataManager.setDSSFileName(toDSSFilename);
            toDataManager.open();
            HecDataManager.zset("DSSV", "", 0);
        } else {
            status = toDataManager.setDSSFileName(toDSSFilename);
            toDataManager.open();
        }
        if (status != 0) {
            toDataManager.done();
            return status;
        }
        status = this.copyFile(toDataManager);
        toDataManager.done();
        return status;
    }

    public Vector getLastDeletePathnames() {
        return (Vector)this._lastDeletedList.clone();
    }

    protected int copyRecords(int[] fromDSSTable, int[] toDSSTable, Vector pathnameList) {
        return this.copyRecords(fromDSSTable, toDSSTable, pathnameList, pathnameList);
    }

    protected int copyRecords(int[] fromDSSTable, int[] toDSSTable, Vector pathnameListfrom, Vector pathnameListTo) {
        int vto;
        int vfrom = Heclib.zgetDssFileVersion(fromDSSTable);
        boolean sameVersion = vfrom == (vto = Heclib.zgetDssFileVersion(toDSSTable));
        this._interrupt = false;
        this._currentRec = 0;
        this._numberRecs = pathnameListfrom.size();
        int buffer1Size = 10000;
        int buffer2Size = 2000;
        int[] buffer1 = new int[buffer1Size];
        int[] buffer2 = new int[buffer2Size];
        for (int i = 0; i < this._numberRecs; ++i) {
            String pathnameFrom = (String)pathnameListfrom.elementAt(i);
            String pathnameTo = (String)pathnameListTo.elementAt(i);
            if (!sameVersion && HecDSSUtilities.isGridType(this.getRecordType(fromDSSTable, pathnameFrom))) {
                logger.warning("Warning: grid not copied: " + pathnameFrom);
                continue;
            }
            int status = Heclib.zcorec(fromDSSTable, toDSSTable, pathnameFrom, pathnameTo, buffer1, buffer1Size, buffer2, buffer2Size);
            if (status == -1) {
                logger.severe("Record does not exist: " + pathnameFrom);
            } else {
                if (status < 0) {
                    logger.warning(Heclib.getErrorInfo(status));
                    int[] hiFunc = new int[]{0};
                    int[] loFunc = new int[]{0};
                    int[] error = new int[]{0};
                    int[] _status = new int[]{0};
                    try {
                        int severity = Heclib.zerrorDecode(status, hiFunc, loFunc, error, _status);
                        if (severity < 3) {
                            logger.warning("Record not copied:" + pathnameFrom);
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    logger.severe("Error in record copy: " + pathnameFrom + " status = " + status);
                    buffer1 = null;
                    buffer2 = null;
                    return status;
                }
                ++this._currentRec;
            }
            if (this._interrupt) break;
        }
        buffer1 = null;
        buffer2 = null;
        return this._currentRec;
    }

    private int getRecordType(int[] fromDSSTable, String pathnameFrom) {
        int[] dataSize = new int[1];
        int[] exist = new int[1];
        stringContainer type = new stringContainer();
        int[] dataType = new int[1];
        Heclib.zdtype(fromDSSTable, pathnameFrom, dataSize, exist, type, dataType);
        return dataType[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int duplicateRecords(List<String> pathnameList, List<String> newPathnameList) {
        this._interrupt = false;
        this._currentRec = 0;
        this._numberRecs = pathnameList.size();
        if (this._numberRecs != newPathnameList.size()) {
            return -1;
        }
        int buffer1Size = 10000;
        int buffer2Size = 2000;
        int[] buffer1 = new int[buffer1Size];
        int[] buffer2 = new int[buffer2Size];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        try {
            int i;
            int[] dtable = new int[120];
            for (i = 0; i < 120; ++i) {
                dtable[i] = dssTable[i];
            }
            for (i = 0; i < this._numberRecs; ++i) {
                String newPathname;
                String pathname = pathnameList.get(i);
                int status = Heclib.zcorec(dssTable, dtable, pathname, newPathname = newPathnameList.get(i), buffer1, buffer1Size, buffer2, buffer2Size);
                if (status == 1) {
                    System.out.println("Record does not exist: " + pathname);
                } else if (status == 2) {
                    System.out.println("Existing record is write protected: " + newPathname);
                } else {
                    ++this._currentRec;
                }
                if (!this._interrupt) continue;
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.checkForSevereError(dssTable);
            this._fileData.releaseAccess(lockThreadToken);
        }
        buffer1 = null;
        buffer2 = null;
        return this._currentRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renameRecords(List<String> pathnameList, List<String> newPathnameList) {
        this._interrupt = false;
        this._currentRec = 0;
        this._numberRecs = pathnameList.size();
        if (this._numberRecs != newPathnameList.size()) {
            return -1;
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -2;
        }
        try {
            for (int i = 0; i < this._numberRecs; ++i) {
                String newPathname;
                String pathname = pathnameList.get(i);
                int status = Heclib.zrenam(dssTable, pathname, newPathname = newPathnameList.get(i));
                if (status != 0) {
                    System.out.println("Record does not exist: " + pathname);
                } else {
                    ++this._currentRec;
                }
                if (!this._interrupt) continue;
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return this._currentRec;
    }

    public int convertVersion(String convertFileName) {
        int mlevel = HecDSSUtilities.getMessageLevel();
        if (mlevel > 1 && mlevel < 5) {
            HecDSSUtilities.setMessageLevel(2);
        }
        String fromFileName = this.DSSFileName();
        int vFrom = this.getDssFileVersion();
        if (vFrom < 6) {
            HecDSSUtilities.setMessageLevel(mlevel);
            return -2;
        }
        HecDSSFileAccess dfm = new HecDSSFileAccess();
        int toVersion = vFrom == 7 ? 6 : 7;
        int status = dfm.setDSSFileName(convertFileName, false, toVersion);
        if (status != 0) {
            HecDSSUtilities.setMessageLevel(mlevel);
            return status;
        }
        dfm.closeDSSFile();
        this.closeDSSFile();
        status = HecDSSUtilities.convertRecords(fromFileName, convertFileName);
        HecDSSUtilities.setMessageLevel(mlevel);
        this.open();
        return status;
    }

    private static boolean containsNonAscii(String str) {
        return !Pattern.matches("\\A\\p{ASCII}*\\z", str);
    }

    private static int convertRecords(String srcDssFileName, String destDssFileName) {
        HecDSSUtilities dss = new HecDSSUtilities();
        dss.setDSSFileName(srcDssFileName, true);
        int status = 0;
        try {
            Vector<String> pathList = new Vector<String>();
            String[] catalog = dss.getCatalog(false, "");
            for (int i = 0; i < catalog.length; ++i) {
                String path = catalog[i];
                if (HecDSSUtilities.containsNonAscii(path)) {
                    logger.warning("convertRecords - Skipping invalid pathname:'" + path + "'");
                    continue;
                }
                dss.setPathname(path);
                int rt = dss.recordType(path);
                if (!HecDSSUtilities.isGridType(rt)) {
                    pathList.add(path);
                    continue;
                }
                status = HecDSSUtilities.copyGrid(srcDssFileName, destDssFileName, path, path);
            }
            dss.copyRecordsFrom(destDssFileName, pathList);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return -1;
        }
        return status;
    }

    private static boolean anyGridsInFile(HecDataManager dm) {
        String[] catalog = dm.getCatalog(false, "");
        for (int i = 0; i < catalog.length; ++i) {
            String path = catalog[i];
            dm.setPathname(path);
            int rt = dm.recordType(path);
            if (!HecDSSUtilities.isGridType(rt)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGridType(int recordType) {
        return recordType >= 400 && recordType < 450;
    }

    private static boolean isGridPath(HecDataManager dss, String path) {
        dss.setPathname(path);
        int rt = dss.recordType(path);
        return HecDSSUtilities.isGridType(rt);
    }

    private static int copyGrid(String srcDssFileName, String destDssFileName, String pathSource, String pathDestination) {
        GriddedData src = new GriddedData();
        GridData data = new GridData();
        src.setDSSFileName(srcDssFileName);
        src.setPathname(pathSource);
        int[] status = new int[1];
        GridInfo gi = src.retrieveGriddedData(true, data, status);
        if (status == null || status[0] != 0) {
            src.zmessage("Error converting Grid: " + pathSource);
            return -1;
        }
        GriddedData dest = new GriddedData();
        dest.setDSSFileName(destDssFileName);
        dest.setPathname(pathDestination);
        status[0] = dest.storeGriddedData(data.getGridInfo(), data);
        return status[0];
    }

    @Override
    public int squeeze() {
        return this.squeeze(false);
    }

    public int squeeze(boolean onlyIfNeeded) {
        boolean needed;
        if (onlyIfNeeded && !(needed = this.squeezeNeeded())) {
            return 1;
        }
        String filename = this._fileData.dssFilename();
        if (filename.length() == 0) {
            return -1;
        }
        this.close();
        int status = Heclib.squeezeDSS(filename);
        this.setDSSFileName(filename);
        this.open();
        return status;
    }

    @Override
    public int cancelSqueeze() {
        String filename = this._fileData.dssFilename();
        if (filename.length() == 0) {
            return -1;
        }
        Heclib.zset("INTERRUPT", "", 1);
        this.close();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Heclib.zset("INTERRUPT", "", 1);
        HecDSSUtilities.setMessageLevel(4);
        int status = this.open();
        return status;
    }

    public boolean squeezeNeeded() {
        int status = this.zinqir("squeeze");
        return status != 0;
    }

    @Override
    public void cancelProcess() {
        Heclib.zset("INTERRUPT", "", 1);
        this._interrupt = true;
    }

    public Vector<CondensedReference> getCondensedCatalog() {
        CondensedReference[] cr = this.getCondensedCatalog(null);
        if (cr != null) {
            Vector<CondensedReference> condensedList = new Vector<CondensedReference>(cr.length);
            for (int i = 0; i < cr.length; ++i) {
                condensedList.add(cr[i]);
            }
            return condensedList;
        }
        return new Vector<CondensedReference>();
    }

    public Vector<CondensedReference> getCondensedCatalog(String[] sortedPathnames, boolean querryTimes) {
        int number = sortedPathnames.length;
        Vector<CondensedReference> condensedList = new Vector<CondensedReference>();
        String lastPathname = new String(" ");
        CondensedReference condensedPathname = null;
        String[] paths = new String[2000];
        int count = 0;
        for (int i = 0; i < number; ++i) {
            String currentPathname = sortedPathnames[i];
            if (!HecDSSUtilities.compareCondensedPaths(lastPathname, currentPathname)) {
                if (condensedPathname != null) {
                    condensedPathname.complete(this, paths, count, querryTimes);
                    count = 0;
                }
                condensedPathname = new CondensedReference();
                condensedList.addElement(condensedPathname);
            }
            if (condensedPathname != null) {
                paths[count++] = currentPathname;
                if (count >= paths.length) {
                    condensedPathname.setPathnameArray(paths, count);
                    count = 0;
                }
            }
            lastPathname = currentPathname;
        }
        if (condensedPathname != null) {
            condensedPathname.complete(this, paths, count, querryTimes);
        }
        return condensedList;
    }

    @Override
    public boolean checkForSevereDssError() {
        return HecDSSUtilities.checkForSevereError();
    }

    @Override
    public void dss_zset(String parameter, String alpha, int number) {
        HecDSSUtilities.zset(parameter, alpha, number);
    }

    @Override
    public void dss_zquery(String parameter, stringContainer alpha, int[] numb) {
        HecDSSUtilities.zquery(parameter, alpha, numb);
    }
}

