/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.util.stringContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import java.util.Vector;

public class HecDataConversion {
    public static final int UNDEFINED_UNITS = 0;
    public static final int ENGLISH_UNITS = 1;
    public static final int SI_UNITS = 2;
    public static final int METERS = 100;
    @Deprecated
    public static final int MILIMETERS = 101;
    public static final int MILLIMETERS = 101;
    public static final int CENTIMETERS = 102;
    public static final int KILOMETERS = 103;
    public static final int SQUARE_METERS = 110;
    public static final int HECTARES = 111;
    public static final int SQUARE_KILOMETERS = 112;
    public static final int CUBIC_METERS = 120;
    public static final int CUBIC_CENTIMETERS = 121;
    public static final int THOUSAND_CUBIC_METERS = 122;
    public static final int LITERS = 123;
    public static final int CENTIGRADE = 130;
    public static final int KILOWATT = 140;
    public static final int WATT_PER_SQ_METERS = 150;
    public static final int MM_PER_DEGC_DAY = 160;
    public static final int DEGC_DAY = 161;
    public static final int KILOGRAMS = 170;
    public static final int METRIC_TONS = 171;
    public static final int KILOPASCALS = 180;
    public static final int KILOMETERS_PER_HOUR = 190;
    public static final int METERS_PER_SECOND = 191;
    public static final int JOULES_PER_SQUARE_METER = 192;
    public static final int FEET = 200;
    public static final int INCHES = 201;
    public static final int MILES = 203;
    public static final int SQUARE_FEET = 210;
    public static final int ACRES = 211;
    public static final int SQUARE_MILES = 212;
    public static final int CUBIC_FEET = 220;
    public static final int ACRE_FEET = 222;
    @Deprecated
    public static final int FARENHIGHT = 230;
    public static final int FAHRENHEIT = 230;
    public static final int HORSE_POWER = 240;
    public static final int LANGLEY_PER_MIN = 250;
    public static final int IN_PER_DEGF_DAY = 260;
    public static final int DEGF_DAY = 261;
    public static final int POUNDS = 270;
    public static final int TONS_US = 271;
    public static final int INCHES_HG = 280;
    public static final int MILES_PER_HOUR = 290;
    public static final int FEET_PER_SECOND = 291;
    public static final int BTU_PER_SQUARE_FOOT = 292;

    public static int getUnitSystem(String unitString) {
        int unitSystem = 0;
        if (unitString == null) {
            return 0;
        }
        String units = unitString.toLowerCase().trim();
        if (units.length() == 0) {
            return 0;
        }
        if (units.startsWith("in")) {
            unitSystem = 1;
        } else if (units.startsWith("mm")) {
            unitSystem = 2;
        } else if (units.startsWith("feet")) {
            unitSystem = 1;
        } else if (units.startsWith("meter")) {
            unitSystem = 2;
        } else if (units.startsWith("ft")) {
            unitSystem = 1;
        } else if (units.startsWith("sqft")) {
            unitSystem = 1;
        } else if (units.startsWith("m2")) {
            unitSystem = 2;
        } else if (units.startsWith("thou m2")) {
            unitSystem = 2;
        } else if (units.startsWith("hect")) {
            unitSystem = 2;
        } else if (units.startsWith("acre")) {
            unitSystem = 1;
        } else if (units.startsWith("cfs")) {
            unitSystem = 1;
        } else if (units.startsWith("cms")) {
            unitSystem = 2;
        } else if (units.startsWith("acft")) {
            unitSystem = 1;
        } else if (units.startsWith("ac-ft")) {
            unitSystem = 1;
        } else if (units.startsWith("deg f")) {
            unitSystem = 1;
        } else if (units.startsWith("degf")) {
            unitSystem = 1;
        } else if (units.equals("f")) {
            unitSystem = 1;
        } else if (units.startsWith("farenh") || units.startsWith("fahr")) {
            unitSystem = 1;
        } else if (units.startsWith("mph")) {
            unitSystem = 1;
        } else if (units.startsWith("kph")) {
            unitSystem = 2;
        } else if (units.startsWith("centig")) {
            unitSystem = 2;
        } else if (units.startsWith("deg c")) {
            unitSystem = 2;
        } else if (units.startsWith("degc")) {
            unitSystem = 2;
        } else if (units.equals("c")) {
            unitSystem = 2;
        } else if (units.startsWith("m3")) {
            unitSystem = 2;
        } else if (units.startsWith("thou m3")) {
            unitSystem = 2;
        } else if (units.startsWith("1000 m3")) {
            unitSystem = 2;
        } else if (units.startsWith("cu m")) {
            unitSystem = 2;
        } else if (units.startsWith("sq m")) {
            unitSystem = 2;
        } else if (units.startsWith("mile")) {
            unitSystem = 1;
        } else if (units.startsWith("km")) {
            unitSystem = 2;
        } else if (units.startsWith("metric")) {
            unitSystem = 2;
        } else if (units.equals("tonnes")) {
            unitSystem = 2;
        } else if (units.equals("tonne")) {
            unitSystem = 2;
        } else if (units.startsWith("tons")) {
            unitSystem = 1;
        } else if (units.equalsIgnoreCase("j/m2") || units.equalsIgnoreCase("joule/m2") || units.equalsIgnoreCase("joules/m2")) {
            unitSystem = 2;
        } else if (units.startsWith("btu")) {
            unitSystem = 1;
        } else if (units.equals("ton")) {
            unitSystem = 1;
        } else if (units.equals("m")) {
            unitSystem = 2;
        } else if (units.indexOf("ft/s") >= 0) {
            unitSystem = 1;
        } else if (units.indexOf("m/s") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("sq m") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("sq ft") >= 0) {
            unitSystem = 1;
        } else if (units.indexOf("watt") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("w/m2") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("lang") >= 0) {
            unitSystem = 1;
        } else if (units.indexOf("mm/deg-d") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("in/deg-d") >= 0) {
            unitSystem = 1;
        } else if (units.indexOf("degc-d") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("degf-d") >= 0) {
            unitSystem = 1;
        } else if (units.indexOf("mbar") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("kpa") >= 0) {
            unitSystem = 2;
        } else if (units.indexOf("mg/l") >= 0) {
            unitSystem = 2;
        }
        return unitSystem;
    }

    public static int convertUnits(double[] data, int number, int fromUnitSyst, int toUnitSyst, stringContainer units) {
        int stat;
        units.string = units.string.toLowerCase().trim();
        if (fromUnitSyst == 1 && toUnitSyst == 2) {
            if (units.string.startsWith("feet") || units.string.equals("ft")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 200, 100);
                units.string = new String("METERS");
            } else if (units.string.equals("in/deg-d")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 260, 160);
                units.string = new String("MM/DEG-D");
            } else if (units.string.indexOf("degf-day") >= 0) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 261, 161);
                units.string = new String("DEGC-DAY");
            } else if (units.string.indexOf("degf-d") >= 0) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 261, 161);
                units.string = new String("DEGC-D");
            } else if (units.string.equals("inhg") || units.string.equals("in hg") || units.string.equals("in-hg")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 280, 180);
                units.string = "KPA";
            } else if (units.string.startsWith("in")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 201, 101);
                units.string = new String("MM");
            } else if (units.string.startsWith("sqft")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 210, 110);
                units.string = new String("M2");
            } else if (units.string.startsWith("ft2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 210, 110);
                units.string = new String("M2");
            } else if (units.string.startsWith("acre")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 211, 110);
                units.string = new String("M2");
            } else if (units.string.startsWith("acre-ft")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 222, 120);
                units.string = new String("M3");
            } else if (units.string.startsWith("acft")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 222, 120);
                units.string = new String("M3");
            } else if (units.string.startsWith("ac-ft")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 222, 120);
                units.string = new String("M3");
            } else if (units.string.startsWith("cfs")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 220, 120);
                units.string = new String("M3/S");
            } else if (units.string.startsWith("ft3/s")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 220, 120);
                units.string = new String("M3/S");
            } else if (units.string.startsWith("mile")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 203, 103);
                units.string = new String("KM");
            } else if (units.string.startsWith("deg f")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 230, 130);
                units.string = new String("DEG C");
            } else if (units.string.startsWith("degf")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 230, 130);
                units.string = new String("DEG C");
            } else if (units.string.startsWith("farenh") || units.string.startsWith("fahr")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 230, 130);
                units.string = new String("DEG C");
            } else if (units.string.equals("f")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 230, 130);
                units.string = new String("C");
            } else if (units.string.startsWith("mph")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 290, 190);
                units.string = new String("KPH");
            } else if (units.string.equals("ft/s")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 291, 191);
                units.string = new String("M/S");
            } else if (units.string.equals("lang/min")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 250, 150);
                units.string = new String("WATT/M2");
            } else if (units.string.equals("tons")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 271, 171);
                units.string = new String("TONNES");
            } else if (units.string.equalsIgnoreCase("btu/ft2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 292, 192);
                units.string = "J/M2";
            } else {
                stat = -1;
            }
        } else if (fromUnitSyst == 2 && toUnitSyst == 1) {
            if (units.string.startsWith("meters") || units.string.equals("m")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 100, 200);
                units.string = new String("FEET");
            } else if (units.string.equals("mm/deg-d")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 160, 260);
                units.string = new String("IN/DEG-D");
            } else if (units.string.indexOf("degc-day") >= 0) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 161, 261);
                units.string = new String("DEGF-DAY");
            } else if (units.string.indexOf("degc-d") >= 0) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 161, 261);
                units.string = new String("DEGF-D");
            } else if (units.string.startsWith("mm")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 101, 201);
                units.string = new String("INCHES");
            } else if (units.string.startsWith("m2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 110, 210);
                units.string = new String("FT2");
            } else if (units.string.startsWith("deg c")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 130, 230);
                units.string = new String("DEG F");
            } else if (units.string.startsWith("degc")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 130, 230);
                units.string = new String("DEG F");
            } else if (units.string.startsWith("centig")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 130, 230);
                units.string = new String("DEG F");
            } else if (units.string.equals("c")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 130, 230);
                units.string = new String("F");
            } else if (units.string.startsWith("sq_m")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 110, 210);
                units.string = new String("FT2");
            } else if (units.string.equalsIgnoreCase("thou m2")) {
                int i = 0;
                while (i < number) {
                    int n = i++;
                    data[n] = data[n] * 1000.0;
                }
                stat = HecDataConversion.convertDoubleUnits(data, number, 110, 211);
                units.string = new String("ACRES");
            } else if (units.string.startsWith("hect")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 111, 211);
                units.string = new String("ACRES");
            } else if (units.string.startsWith("m3/s")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 120, 220);
                units.string = new String("CFS");
            } else if (units.string.startsWith("cms")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 120, 220);
                units.string = new String("CFS");
            } else if (units.string.startsWith("cu m")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 120, 220);
                units.string = new String("CFS");
            } else if (units.toString().equalsIgnoreCase("m3")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 120, 222);
                units.string = new String("ac-ft");
            } else if (units.toString().equalsIgnoreCase("thou m3")) {
                int i = 0;
                while (i < number) {
                    int n = i++;
                    data[n] = data[n] * 1000.0;
                }
                stat = HecDataConversion.convertDoubleUnits(data, number, 120, 222);
                units.string = new String("ac-ft");
            } else if (units.string.startsWith("km")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 103, 203);
                units.string = new String("MILES");
            } else if (units.string.startsWith("kph")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 190, 290);
                units.string = new String("MPH");
            } else if (units.string.equals("m/s")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 191, 291);
                units.string = new String("FT/S");
            } else if (units.string.equals("watt/m2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 150, 250);
                units.string = new String("LANG/MIN");
            } else if (units.string.equals("w/m2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 150, 250);
                units.string = new String("LANG/MIN");
            } else if (units.string.equals("tonnes")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 171, 271);
                units.string = new String("TONS");
            } else if (units.string.equals("kpa")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 180, 280);
                units.string = "INHG";
            } else if (units.string.equals("j/m2") || units.string.equals("joules/m2") || units.string.equals("joule/m2")) {
                stat = HecDataConversion.convertDoubleUnits(data, number, 192, 292);
                units.string = "BTU/FT2";
            } else {
                stat = -1;
            }
        } else {
            stat = -2;
        }
        return stat;
    }

    public static int convertUnits(float[] data, int number, int fromUnits, int toUnits) {
        if (fromUnits == 230 && toUnits == 130) {
            for (int i = 0; i < number; ++i) {
                if ((double)data[i] == -3.4028234663852886E38) continue;
                data[i] = (float)(0.5555555555555556 * ((double)data[i] - 32.0));
            }
            return 1;
        }
        if (fromUnits == 130 && toUnits == 230) {
            for (int i = 0; i < number; ++i) {
                if ((double)data[i] == -3.4028234663852886E38) continue;
                data[i] = (float)(1.8 * (double)data[i] + 32.0);
            }
            return 1;
        }
        double conv = HecDataConversion.conversionFactor(fromUnits, toUnits);
        if (conv > 0.0) {
            for (int i = 0; i < number; ++i) {
                if ((double)data[i] == -3.4028234663852886E38) continue;
                data[i] = (float)((double)data[i] * conv);
            }
            return 0;
        }
        return -1;
    }

    public static int convertDoubleUnits(double[] data, int number, int fromUnits, int toUnits) {
        if (fromUnits == 230 && toUnits == 130) {
            for (int i = 0; i < number; ++i) {
                if (data[i] == -3.4028234663852886E38) continue;
                data[i] = 0.5555555555555556 * (data[i] - 32.0);
            }
            return 1;
        }
        if (fromUnits == 130 && toUnits == 230) {
            for (int i = 0; i < number; ++i) {
                if (data[i] == -3.4028234663852886E38) continue;
                data[i] = 1.8 * data[i] + 32.0;
            }
            return 1;
        }
        double conv = HecDataConversion.conversionFactor(fromUnits, toUnits);
        if (conv > 0.0) {
            for (int i = 0; i < number; ++i) {
                if (data[i] == -3.4028234663852886E38) continue;
                data[i] = data[i] * conv;
            }
            return 0;
        }
        return -1;
    }

    public static double conversionFactor(int fromUnits, int toUnits) {
        double conv = 0.0;
        switch (fromUnits) {
            case 200: {
                switch (toUnits) {
                    case 100: {
                        conv = 0.3048;
                    }
                }
                break;
            }
            case 201: {
                switch (toUnits) {
                    case 101: {
                        conv = 25.4;
                        break;
                    }
                    case 102: {
                        conv = 2.54;
                    }
                }
                break;
            }
            case 203: {
                switch (toUnits) {
                    case 103: {
                        conv = 1.609344;
                    }
                }
                break;
            }
            case 210: {
                switch (toUnits) {
                    case 110: {
                        conv = 0.09290304;
                    }
                }
                break;
            }
            case 211: {
                switch (toUnits) {
                    case 111: {
                        conv = 0.4046856422400001;
                        break;
                    }
                    case 110: {
                        conv = 4046.8564224000006;
                    }
                }
                break;
            }
            case 212: {
                switch (toUnits) {
                    case 111: {
                        conv = 2589.9881103360003;
                        break;
                    }
                    case 112: {
                        conv = 2.5899881103360003;
                    }
                }
                break;
            }
            case 220: {
                switch (toUnits) {
                    case 120: {
                        conv = 0.028316846592000004;
                        break;
                    }
                    case 122: {
                        conv = 2.8316846592000003E-5;
                        break;
                    }
                    case 222: {
                        conv = 2.295684113865932E-5;
                        break;
                    }
                    case 123: {
                        conv = 28.316846592;
                    }
                }
                break;
            }
            case 222: {
                switch (toUnits) {
                    case 120: {
                        conv = 1233.4818375475202;
                        break;
                    }
                    case 122: {
                        conv = 1.23348183754752;
                        break;
                    }
                    case 220: {
                        conv = 43560.0;
                        break;
                    }
                    case 123: {
                        conv = 1233481.83754752;
                    }
                }
                break;
            }
            case 100: {
                switch (toUnits) {
                    case 200: {
                        conv = 3.280839895013123;
                        break;
                    }
                    case 201: {
                        conv = 39.37007874015748;
                    }
                }
                break;
            }
            case 101: {
                switch (toUnits) {
                    case 201: {
                        conv = 0.03937007874015748;
                    }
                }
                break;
            }
            case 102: {
                switch (toUnits) {
                    case 201: {
                        conv = 0.39370078740157477;
                    }
                }
                break;
            }
            case 103: {
                switch (toUnits) {
                    case 203: {
                        conv = 0.621371192237334;
                    }
                }
                break;
            }
            case 110: {
                switch (toUnits) {
                    case 210: {
                        conv = 10.763910416709722;
                        break;
                    }
                    case 211: {
                        conv = 2.471053814671653E-4;
                    }
                }
                break;
            }
            case 111: {
                switch (toUnits) {
                    case 211: {
                        conv = 2.471053814671653;
                        break;
                    }
                    case 212: {
                        conv = 0.003861021585424458;
                        break;
                    }
                    case 112: {
                        conv = 0.01;
                    }
                }
                break;
            }
            case 120: {
                switch (toUnits) {
                    case 220: {
                        conv = 35.314666721488585;
                        break;
                    }
                    case 222: {
                        conv = 8.107131937899124E-4;
                        break;
                    }
                    case 122: {
                        conv = 0.001;
                        break;
                    }
                    case 123: {
                        conv = 1000.0;
                    }
                }
                break;
            }
            case 121: {
                switch (toUnits) {
                    case 220: {
                        conv = 3.531466672148859E7;
                        break;
                    }
                    case 123: {
                        conv = 0.001;
                    }
                }
                break;
            }
            case 122: {
                switch (toUnits) {
                    case 222: {
                        conv = 0.8107131937899125;
                        break;
                    }
                    case 120: {
                        conv = 1000.0;
                        break;
                    }
                    case 220: {
                        conv = 35314.66672148858;
                        break;
                    }
                    case 123: {
                        conv = 1000000.0;
                    }
                }
                break;
            }
            case 123: {
                switch (toUnits) {
                    case 220: {
                        conv = 0.035314666721488586;
                        break;
                    }
                    case 222: {
                        conv = 8.107131937899126E-7;
                        break;
                    }
                    case 121: {
                        conv = 1000.0;
                        break;
                    }
                    case 120: {
                        conv = 0.001;
                        break;
                    }
                    case 122: {
                        conv = 1.0E-6;
                    }
                }
                break;
            }
            case 260: {
                switch (toUnits) {
                    case 160: {
                        conv = 45.72;
                    }
                }
                break;
            }
            case 160: {
                switch (toUnits) {
                    case 260: {
                        conv = 0.021872265966754158;
                    }
                }
                break;
            }
            case 161: {
                switch (toUnits) {
                    case 261: {
                        conv = 1.8;
                    }
                }
                break;
            }
            case 261: {
                switch (toUnits) {
                    case 161: {
                        conv = 0.5555555555555556;
                    }
                }
                break;
            }
            case 250: {
                switch (toUnits) {
                    case 150: {
                        conv = 697.3333333;
                    }
                }
                break;
            }
            case 150: {
                switch (toUnits) {
                    case 250: {
                        conv = 0.001434034417;
                    }
                }
                break;
            }
            case 270: {
                switch (toUnits) {
                    case 170: {
                        conv = 0.45359237;
                        break;
                    }
                    case 271: {
                        conv = 5.0E-4;
                        break;
                    }
                    case 171: {
                        conv = 4.5359237E-4;
                    }
                }
                break;
            }
            case 271: {
                switch (toUnits) {
                    case 270: {
                        conv = 2000.0;
                        break;
                    }
                    case 170: {
                        conv = 907.18474;
                        break;
                    }
                    case 171: {
                        conv = 0.90718474;
                    }
                }
                break;
            }
            case 170: {
                switch (toUnits) {
                    case 270: {
                        conv = 2.2046226218487757;
                        break;
                    }
                    case 271: {
                        conv = 0.001102311310924388;
                        break;
                    }
                    case 171: {
                        conv = 0.001;
                    }
                }
                break;
            }
            case 171: {
                switch (toUnits) {
                    case 270: {
                        conv = 2204.622621848776;
                        break;
                    }
                    case 271: {
                        conv = 1.1023113109243878;
                        break;
                    }
                    case 170: {
                        conv = 1000.0;
                    }
                }
                break;
            }
            case 280: {
                switch (toUnits) {
                    case 180: {
                        conv = 3.386389;
                    }
                }
                break;
            }
            case 180: {
                switch (toUnits) {
                    case 280: {
                        conv = 0.2952998016471233;
                    }
                }
                break;
            }
            case 290: {
                switch (toUnits) {
                    case 291: {
                        conv = 1.4666666666666666;
                        break;
                    }
                    case 190: {
                        conv = 1.609344;
                        break;
                    }
                    case 191: {
                        conv = 0.44704;
                    }
                }
                break;
            }
            case 291: {
                switch (toUnits) {
                    case 290: {
                        conv = 0.6818181818181818;
                        break;
                    }
                    case 190: {
                        conv = 1.09728;
                        break;
                    }
                    case 191: {
                        conv = 0.3048;
                    }
                }
                break;
            }
            case 190: {
                switch (toUnits) {
                    case 191: {
                        conv = 0.2777777777777778;
                        break;
                    }
                    case 290: {
                        conv = 0.621371192237334;
                        break;
                    }
                    case 291: {
                        conv = 0.9113444152814232;
                    }
                }
                break;
            }
            case 191: {
                switch (toUnits) {
                    case 190: {
                        conv = 3.6;
                        break;
                    }
                    case 290: {
                        conv = 2.236936292054402;
                        break;
                    }
                    case 291: {
                        conv = 3.280839895013123;
                    }
                }
                break;
            }
            case 292: {
                if (toUnits != 192) break;
                conv = 11356.5;
                break;
            }
            case 192: {
                if (toUnits != 292) break;
                conv = 8.805529872760093E-5;
                break;
            }
            default: {
                conv = -1.0;
            }
        }
        if (conv == 0.0) {
            conv = -1.0;
        }
        return conv;
    }

    public static void convertUnits(Vector containers, int toUnitSyst) {
        for (int i = 0; i < containers.size(); ++i) {
            Object obj = containers.elementAt(i);
            if (!(obj instanceof DataContainer)) continue;
            HecDataConversion.convertUnits((DataContainer)obj, toUnitSyst);
        }
    }

    public static int convertUnits(DataContainer container, int toUnitSyst) {
        if (container instanceof TimeSeriesContainer) {
            return HecDataConversion.convertUnits((TimeSeriesContainer)container, toUnitSyst);
        }
        if (container instanceof PairedDataContainer) {
            return HecDataConversion.convertUnits((PairedDataContainer)container, toUnitSyst);
        }
        return -5;
    }

    public static int convertUnits(TimeSeriesCollectionContainer container, int toUnitSyst) {
        int status = 0;
        for (TimeSeriesContainer tsCont : container.get()) {
            if (tsCont.values == null) {
                return -1;
            }
            int unitSystem = HecDataConversion.getUnitSystem(tsCont.units);
            if (unitSystem == 0) {
                return -1;
            }
            if (unitSystem == toUnitSyst) continue;
            stringContainer newUnits = new stringContainer();
            newUnits.string = tsCont.units;
            status = HecDataConversion.convertUnits(tsCont.values, tsCont.numberValues, unitSystem, toUnitSyst, newUnits);
            if (status >= 0) {
                tsCont.units = newUnits.string;
                continue;
            }
            return status;
        }
        return status;
    }

    public static int convertUnits(TimeSeriesContainer container, int toUnitSyst) {
        if (container.values == null) {
            return -1;
        }
        int unitSystem = HecDataConversion.getUnitSystem(container.units);
        if (unitSystem == 0) {
            return -1;
        }
        if (unitSystem == toUnitSyst) {
            return 0;
        }
        stringContainer newUnits = new stringContainer();
        newUnits.string = container.units;
        int status = HecDataConversion.convertUnits(container.values, container.numberValues, unitSystem, toUnitSyst, newUnits);
        if (status >= 0) {
            container.units = newUnits.string;
        }
        return status;
    }

    public static int convertUnits(PairedDataContainer container, int toUnitSyst) {
        stringContainer newUnits;
        if (container.xOrdinates == null || container.yOrdinates == null) {
            return -1;
        }
        int status = 0;
        int unitSystem = HecDataConversion.getUnitSystem(container.xunits);
        if (unitSystem == 0) {
            status = -1;
        } else if (unitSystem != toUnitSyst) {
            newUnits = new stringContainer();
            newUnits.string = container.xunits;
            status = HecDataConversion.convertUnits(container.xOrdinates, container.numberOrdinates, unitSystem, toUnitSyst, newUnits);
            if (status >= 0) {
                container.xunits = newUnits.string;
            }
        }
        unitSystem = HecDataConversion.getUnitSystem(container.yunits);
        if (unitSystem == 0) {
            status = -1;
        } else if (unitSystem != toUnitSyst) {
            newUnits = new stringContainer();
            newUnits.string = container.yunits;
            for (int i = 0; i < container.numberCurves; ++i) {
                status = HecDataConversion.convertUnits(container.yOrdinates[i], container.numberOrdinates, unitSystem, toUnitSyst, newUnits);
                if (status < 0) continue;
                container.yunits = newUnits.string;
            }
        }
        return status;
    }
}

